/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.toolkit.client.base.util.text;

import com.huawei.dc.common.util.DCDebugTracer;
import com.huawei.dc.toolkit.client.base.util.TKDebug;
import com.huawei.dc.toolkit.client.base.util.text.TKPasswordRule;
import java.util.ArrayList;
import java.util.Vector;

public class TKCommandLine {
    String command;
    Vector rules = new Vector();

    public TKCommandLine(String defineLine) {
        this.command = TKCommandLine.parse(defineLine.trim(), this.rules);
    }

    private static String parse(String defileLine, Vector rules) {
        rules.clear();
        if (defileLine.startsWith("#")) {
            return "";
        }
        int clnPos = defileLine.indexOf(":");
        if (clnPos < 0) {
            return null;
        }
        String keyCmd = defileLine.substring(0, clnPos);
        String ruleText = defileLine.substring(clnPos + 1).trim();
        String[] ruleStrings = TKCommandLine.split(ruleText, ';');
        for (int i = 0; i < ruleStrings.length; ++i) {
            String ruleDefine = ruleStrings[i];
            if (ruleDefine.startsWith("#")) continue;
            int keyPos = ruleDefine.indexOf("Key");
            boolean isByKeyword = keyPos >= 0;
            String keyWord = TKCommandLine.getDefineValue(ruleDefine, "Key");
            int colonNum = 0;
            int commaNum = 0;
            try {
                if (ruleDefine.indexOf("Cln") >= 0) {
                    colonNum = Integer.parseInt(TKCommandLine.getDefineValue(ruleDefine, "Cln"));
                }
            }
            catch (Exception ex) {
                TKDebug.inmAssert(false, "Error while read configuration file pwdCfg.ini:" + ex.toString());
            }
            try {
                commaNum = ruleDefine.indexOf("Cma") >= 0 ? Integer.parseInt(TKCommandLine.getDefineValue(ruleDefine, "Cma")) : -1;
            }
            catch (Exception ex) {
                TKDebug.inmAssert(false, "Error while read configuration file pwdCfg.ini:" + ex.toString());
            }
            TKPasswordRule pwdRule = new TKPasswordRule(keyCmd, colonNum, commaNum, keyWord, isByKeyword);
            rules.add(pwdRule);
        }
        return keyCmd;
    }

    public boolean isPwdPosition(String text, int offset) {
        TKPasswordRule rule;
        boolean isPwdPosition = false;
        for (int i = 0; i < this.rules.size() && !(isPwdPosition = (rule = (TKPasswordRule)this.rules.get(i)).isPwdPosition(text, offset)); ++i) {
        }
        return isPwdPosition;
    }

    public static int getCharNumber(String text, char included) {
        char[] chars = text.toCharArray();
        int number = 0;
        for (int i = 0; i < chars.length; ++i) {
            if (chars[i] != included) continue;
            ++number;
        }
        return number;
    }

    public static int getWordNumber(String text, String included) {
        char[] chars = text.toCharArray();
        int number = 0;
        int len = included.length();
        for (int i = 0; i < chars.length - len; ++i) {
            String compString = text.substring(i, i + len);
            if (!compString.equals(included)) continue;
            ++number;
        }
        return number;
    }

    public static String getDefineValue(String defineText, String key) {
        int pos = defineText.toLowerCase().indexOf(key.toLowerCase());
        if (pos < 0) {
            return null;
        }
        int nextCmaPos = defineText.indexOf(",", pos);
        if (nextCmaPos < 0) {
            return defineText.substring(pos + key.length() + 1);
        }
        return defineText.substring(pos + key.length() + 1, nextCmaPos);
    }

    public static int getWholeWordIndex(String text, String keyWord) {
        int keyWordPosition = text.toUpperCase().lastIndexOf(keyWord.toUpperCase());
        if (keyWordPosition < 0) {
            return -1;
        }
        if (keyWordPosition > 0) {
            try {
                char preCh = text.charAt(keyWordPosition - 1);
                char nxtCh = text.charAt(keyWordPosition + keyWord.length());
                if (!TKCommandLine.isCommandChar(preCh) || !TKCommandLine.isCommandChar(nxtCh)) {
                    String textCut = text;
                    int _position = keyWordPosition;
                    while ((_position = (textCut = textCut.substring(0, _position)).toUpperCase().lastIndexOf(keyWord.toUpperCase())) != -1) {
                        preCh = _position == 0 ? (char)' ' : (char)textCut.charAt(_position - 1);
                        nxtCh = textCut.charAt(_position + keyWord.length());
                        if (!TKCommandLine.isCommandChar(preCh) || !TKCommandLine.isCommandChar(nxtCh)) continue;
                    }
                    keyWordPosition = _position;
                }
            }
            catch (IndexOutOfBoundsException iobe) {
                DCDebugTracer.trace(iobe);
            }
            catch (Exception exc) {
                DCDebugTracer.trace(exc);
            }
        }
        return keyWordPosition;
    }

    public static int getLeftWordIndex(String text, String keyWord) {
        int keyWordPosition = text.toUpperCase().lastIndexOf(keyWord.toUpperCase());
        if (keyWordPosition < 0) {
            return -1;
        }
        if (keyWordPosition > 0) {
            try {
                char preCh = text.charAt(keyWordPosition - 1);
                if (!TKCommandLine.isCommandChar(preCh)) {
                    String textCut = text;
                    int _position = keyWordPosition;
                    while ((_position = (textCut = textCut.substring(0, _position)).toUpperCase().lastIndexOf(keyWord.toUpperCase())) != -1 && !TKCommandLine.isCommandChar(preCh = _position == 0 ? (char)' ' : textCut.charAt(_position - 1))) {
                    }
                    keyWordPosition = _position;
                }
            }
            catch (IndexOutOfBoundsException iobe) {
                DCDebugTracer.trace(iobe);
            }
            catch (Exception exc) {
                DCDebugTracer.trace(exc);
            }
        }
        return keyWordPosition;
    }

    public static boolean isCommandChar(char c) {
        return c == ',' || c == ';' || c == ' ' || c == ':' || c == '\t' || c == '\r' || c == '\n';
    }

    public static String[] split(String s, char c) {
        ArrayList<String> strings = new ArrayList<String>();
        char[] cs = s.toCharArray();
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < cs.length; ++i) {
            if (cs[i] == c) {
                strings.add(sb.toString());
                sb.delete(0, sb.length());
                continue;
            }
            sb.append(cs[i]);
            if (i != cs.length - 1) continue;
            strings.add(sb.toString());
        }
        String[] rets = new String[strings.size()];
        for (int i = 0; i < strings.size(); ++i) {
            rets[i] = strings.get(i).toString();
        }
        return rets;
    }
}

