/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.toolkit.client.base.util.text;

import com.huawei.dc.common.util.DCDebugTracer;
import com.huawei.dc.toolkit.client.base.util.text.TKCodeArea;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Vector;
import javax.swing.text.AbstractDocument;
import javax.swing.text.BadLocationException;
import javax.swing.text.Position;
import javax.swing.text.Segment;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoableEdit;

public class TKCodeContent
implements AbstractDocument.Content,
Serializable {
    private static final char[] empty = new char[0];
    private static final String LINE_SEP = "\r";
    private static final long serialVersionUID = 3002502144087974060L;
    private static final char shieldChar = '*';
    private int count;
    private char[] data;
    private char[] dataself;
    transient Vector marks;
    boolean shield = true;

    public static String formatFtpPath(String ftpPath) {
        char[] chars = ftpPath.toCharArray();
        char[] retTexts = new char[chars.length];
        for (int i = 0; i < chars.length; ++i) {
            String tempText = new String(retTexts);
            retTexts[i] = TKCodeArea.isPwdInPosition(i, tempText, chars[i]) && chars[i] != '\n' && chars[i] != '\r' ? 42 : chars[i];
        }
        String temRetTexts = new String(retTexts);
        int begin = temRetTexts.indexOf(42);
        int last = temRetTexts.lastIndexOf(42);
        if (begin > 0 && last > 0) {
            String tem = temRetTexts.substring(begin, last + 1);
            temRetTexts = temRetTexts.replace(tem, "******");
        }
        return temRetTexts;
    }

    public static String formatFtpPath(String ftpPath, char shieldChar) {
        char[] chars = ftpPath.toCharArray();
        char[] retTexts = new char[chars.length];
        for (int i = 0; i < chars.length; ++i) {
            String tempText = new String(retTexts);
            retTexts[i] = TKCodeArea.isPwdInPosition(i, tempText, chars[i]) && chars[i] != '\n' && chars[i] != '\r' ? shieldChar : chars[i];
        }
        return new String(retTexts);
    }

    public static char[] formatLine(char[] chars, char shieldChar) {
        char[] retTexts = new char[chars.length];
        for (int i = 0; i < chars.length; ++i) {
            String tempText = new String(retTexts);
            retTexts[i] = TKCodeArea.isPwdInPosition(i, tempText, chars[i]) && chars[i] != '\n' && chars[i] != '\r' ? shieldChar : chars[i];
        }
        return retTexts;
    }

    public static String[] toLines(String text) {
        int tempIndex;
        ArrayList<String> lines = new ArrayList<String>();
        int index = text.indexOf("\n");
        if (index <= 0 || index == text.length()) {
            return new String[]{text};
        }
        lines.add(text.substring(0, index));
        lines.add("\n");
        while (true) {
            tempIndex = index;
            if ((index = text.indexOf("\n", index + 1)) < 0) break;
            lines.add(text.substring(tempIndex + 1, index));
            lines.add("\n");
        }
        lines.add(text.substring(tempIndex + 1));
        String[] ret = new String[lines.size()];
        for (int i = 0; i < lines.size(); ++i) {
            ret[i] = lines.get(i).toString();
        }
        return ret;
    }

    public TKCodeContent() {
        this(10);
    }

    public TKCodeContent(int initialLength) {
        initialLength = initialLength < 1 ? 1 : initialLength;
        this.data = new char[initialLength];
        this.data[0] = 10;
        this.count = 1;
        this.dataself = new char[initialLength];
        this.dataself[0] = 10;
    }

    public boolean checkChange() {
        String data_ = new String(this.data);
        String self_ = new String(this.dataself);
        return data_.trim().equals(self_.trim());
    }

    @Override
    public Position createPosition(int offset) throws BadLocationException {
        if (this.marks == null) {
            this.marks = new Vector();
        }
        return new StickyPosition(offset);
    }

    @Override
    public void getChars(int where, int len, Segment chars) throws BadLocationException {
        if (where + len > this.count) {
            throw new BadLocationException("Invalid location", this.count);
        }
        chars.array = this.data;
        chars.offset = where;
        chars.count = len;
    }

    private int getPositionOfNextLineMark(char[] cs, int start, int endPos) {
        int pos = start;
        for (int i = start; i <= endPos; ++i) {
            pos = i;
            if (cs[i] == '\n') break;
        }
        return pos;
    }

    private int getPositionOfPreLineMark(char[] cs, int start) {
        int pos = start;
        for (int i = start - 1; i >= 0; --i) {
            pos = i;
            if (cs[i] == '\n') break;
        }
        return pos;
    }

    protected Vector getPositionsInRange(Vector v, int offset, int length) {
        int n = this.marks.size();
        int end = offset + length;
        Vector placeIn = v == null ? new Vector() : v;
        for (int i = 0; i < n; ++i) {
            PositionsData mark = (PositionsData)this.marks.elementAt(i);
            if (mark.isUsed()) {
                this.marks.removeElementAt(i);
                --i;
                --n;
                continue;
            }
            if (mark.offset < offset || mark.offset > end) continue;
            placeIn.addElement(new UndoPositionData(mark));
        }
        return placeIn;
    }

    public String getString() {
        return new String(this.dataself, 0, this.length());
    }

    @Override
    public String getString(int where, int len) throws BadLocationException {
        if (where + len > this.count || len < 0) {
            throw new BadLocationException("Invalid range", this.count);
        }
        return new String(this.dataself, where, len);
    }

    public String getStringCur(int where, int len) throws BadLocationException {
        if (where + len > this.count) {
            throw new BadLocationException("Invalid range", this.count);
        }
        return new String(this.dataself, where, len);
    }

    public String getText(int where, int len) {
        if (where + len > this.count || len < 0) {
            return null;
        }
        return new String(this.data, where, len);
    }

    @Override
    public UndoableEdit insertString(int where, String str) throws BadLocationException {
        if (where >= this.count || where < 0) {
            throw new BadLocationException("Invalid location", this.count);
        }
        ArrayList<String> elements = new ArrayList<String>();
        boolean isUnixSys = false;
        int index = str.indexOf(LINE_SEP);
        if (index >= 0) {
            int tempIndex;
            elements.add(str.substring(0, index));
            elements.add(LINE_SEP);
            while (true) {
                tempIndex = index;
                if ((index = str.indexOf(LINE_SEP, index + 1)) < 0) break;
                elements.add(str.substring(tempIndex + 1, index));
                elements.add(LINE_SEP);
            }
            elements.add(str.substring(tempIndex + 1));
            for (int i = 1; i < elements.size() - 1; ++i) {
                if (!elements.get(i).toString().equals(LINE_SEP) || elements.get(i + 1).toString().startsWith("\n")) continue;
                isUnixSys = true;
                break;
            }
        }
        if (!isUnixSys) {
            char[] charArray = str.toCharArray();
            this.replace(where, 0, charArray, 0, charArray.length);
            if (this.marks != null) {
                this.updateMarksForInsert(where, str.length());
            }
            return new Undo(where, str.length());
        }
        String strTemp = str.replaceAll(LINE_SEP, "\n");
        char[] charArray = strTemp.toCharArray();
        this.replace(where, 0, charArray, 0, charArray.length);
        if (this.marks != null) {
            this.updateMarksForInsert(where, strTemp.length());
        }
        return new Undo(where, strTemp.length());
    }

    @Override
    public int length() {
        return this.count;
    }

    @Override
    public UndoableEdit remove(int where, int nitems) throws BadLocationException {
        if (where + nitems >= this.count) {
            DCDebugTracer.trace("TKCondeContent::remove::where + nitems >= count");
            throw new BadLocationException("Invalid range", this.count);
        }
        String strTemp = this.getString(where, nitems);
        Undo oUndoableEdit = new Undo(where, strTemp);
        this.replace(where, nitems, empty, 0, 0);
        if (this.marks != null) {
            this.updateMarksForRemove(where, nitems);
        }
        return oUndoableEdit;
    }

    void replace(int deviation, int longness, char[] source, int srcDeviation, int srclongness) {
        int delLoc = srclongness - longness;
        int srcLoc = deviation + longness;
        int num = this.count - srcLoc;
        int dstLoc = srcLoc + delLoc;
        if (this.count + delLoc >= this.data.length) {
            int freshLen = Math.max(2 * this.data.length, this.count + delLoc);
            char[] freshResult = new char[freshLen];
            System.arraycopy(this.data, 0, freshResult, 0, deviation);
            System.arraycopy(source, srcDeviation, freshResult, deviation, srclongness);
            System.arraycopy(this.data, srcLoc, freshResult, dstLoc, num);
            this.data = freshResult;
            int freshLenSel = Math.max(2 * this.dataself.length, this.count + delLoc);
            char[] freshResultSel = new char[freshLenSel];
            System.arraycopy(this.dataself, 0, freshResultSel, 0, deviation);
            System.arraycopy(source, srcDeviation, freshResultSel, deviation, srclongness);
            System.arraycopy(this.dataself, srcLoc, freshResultSel, dstLoc, num);
            this.dataself = freshResultSel;
        } else {
            System.arraycopy(this.data, srcLoc, this.data, dstLoc, num);
            System.arraycopy(source, srcDeviation, this.data, deviation, srclongness);
            System.arraycopy(this.dataself, srcLoc, this.dataself, dstLoc, num);
            System.arraycopy(source, srcDeviation, this.dataself, deviation, srclongness);
        }
        this.count += delLoc;
        int preLinePos = this.getPositionOfPreLineMark(this.data, deviation);
        int nexLinePos = this.getPositionOfNextLineMark(this.data, deviation + srclongness, this.count);
        if (preLinePos > 0) {
            ++preLinePos;
        }
        int copyLength = nexLinePos - preLinePos;
        char[] subLine1 = new char[copyLength];
        System.arraycopy(this.dataself, preLinePos, subLine1, 0, copyLength);
        String subLine2 = String.copyValueOf(subLine1);
        String[] subLine3 = TKCodeContent.toLines(subLine2);
        int chaLen = preLinePos;
        for (int i = 0; i < subLine3.length; ++i) {
            char[] fmtChars = TKCodeContent.formatLine(subLine3[i].toCharArray(), '*');
            System.arraycopy(fmtChars, 0, this.data, chaLen, fmtChars.length);
            chaLen += fmtChars.length;
        }
    }

    void resize(int ncount) {
        char[] dataTemp = new char[ncount];
        System.arraycopy(this.data, 0, dataTemp, 0, Math.min(ncount, this.count));
        this.data = dataTemp;
        char[] ndataSelTemp = new char[ncount];
        System.arraycopy(this.dataself, 0, ndataSelTemp, 0, Math.min(ncount, this.count));
        this.dataself = dataTemp;
    }

    public void setEnabled(boolean e) {
        this.shield = e;
    }

    synchronized void updateMarksForInsert(int offset, int length) {
        if (offset == 0) {
            offset = 1;
        }
        int n = this.marks.size();
        for (int i = 0; i < n; ++i) {
            PositionsData mark = (PositionsData)this.marks.elementAt(i);
            if (mark.isUsed()) {
                this.marks.removeElementAt(i);
                --i;
                --n;
                continue;
            }
            if (mark.offset < offset) continue;
            mark.offset += length;
        }
    }

    synchronized void updateMarksForRemove(int station, int length) {
        int size = this.marks.size();
        for (int i = 0; i < size; ++i) {
            PositionsData oPositionsData = (PositionsData)this.marks.elementAt(i);
            if (oPositionsData.unused) {
                this.marks.removeElementAt(i);
                --size;
                --i;
                continue;
            }
            if (oPositionsData.offset >= station + length) {
                oPositionsData.offset -= length;
                continue;
            }
            if (oPositionsData.offset < station) continue;
            oPositionsData.offset = station;
        }
    }

    protected void updateUndoPositions(Vector positions) {
        for (int counter = positions.size() - 1; counter >= 0; --counter) {
            UndoPositionData ref = (UndoPositionData)positions.elementAt(counter);
            if (ref.rec.isUsed()) {
                positions.removeElementAt(counter);
                continue;
            }
            ref.resetLocation();
        }
    }

    final class UndoPositionData {
        private PositionsData rec;
        private int undoLocation;

        UndoPositionData(PositionsData rec) {
            this.rec = rec;
            this.undoLocation = rec.offset;
        }

        protected void resetLocation() {
            this.rec.offset = this.undoLocation;
        }
    }

    final class StickyPosition
    implements Position {
        PositionsData rec;

        StickyPosition(int offset) {
            this.rec = new PositionsData(offset);
            TKCodeContent.this.marks.addElement(this.rec);
        }

        protected void finalize() throws Throwable {
            this.rec.unused = true;
            super.finalize();
        }

        @Override
        public int getOffset() {
            return this.rec.offset;
        }

        public String toString() {
            return Integer.toString(this.getOffset());
        }
    }

    final class PositionsData {
        private int offset;
        private boolean unused;

        PositionsData(int offset) {
            this.offset = offset;
        }

        private boolean isUsed() {
            return this.unused;
        }
    }

    class Undo
    extends AbstractUndoableEdit {
        private static final long serialVersionUID = -5367077317342495280L;
        private int length;
        private int offset;
        private Vector posRefs;
        private String string;

        protected Undo(int offset, int length) {
            this.offset = offset;
            this.length = length;
        }

        protected Undo(int offset, String string) {
            this.offset = offset;
            this.string = string;
            this.length = string.length();
            if (TKCodeContent.this.marks != null) {
                this.posRefs = TKCodeContent.this.getPositionsInRange(null, offset, this.length);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void redo() throws CannotRedoException {
            super.redo();
            try {
                TKCodeContent tKCodeContent = TKCodeContent.this;
                synchronized (tKCodeContent) {
                    TKCodeContent.this.insertString(this.offset, this.string);
                    this.string = null;
                    if (this.posRefs != null) {
                        TKCodeContent.this.updateUndoPositions(this.posRefs);
                        this.posRefs = null;
                    }
                }
            }
            catch (BadLocationException bl) {
                throw new CannotRedoException();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void undo() throws CannotUndoException {
            super.undo();
            try {
                TKCodeContent tKCodeContent = TKCodeContent.this;
                synchronized (tKCodeContent) {
                    this.string = TKCodeContent.this.getString(this.offset, this.length);
                    if (TKCodeContent.this.marks != null) {
                        this.posRefs = TKCodeContent.this.getPositionsInRange(null, this.offset, this.length);
                    }
                    TKCodeContent.this.remove(this.offset, this.length);
                }
            }
            catch (BadLocationException bl) {
                throw new CannotUndoException();
            }
        }
    }
}

