/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.toolkit.client.base.util.text;

import com.huawei.dc.common.util.DCDebugTracer;
import com.huawei.dc.toolkit.client.base.util.text.TKCommandLine;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Vector;

public class TKCodeArea {
    public static final int TYPE_OF_TL1_CMD = 0;
    public static final int TYPE_OF_FTP_PATH = 1;
    public static final int TYPE_OF_CON_SONET = 2;
    public static final Vector commandLines = new Vector();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TKCodeArea() {
        commandLines.clear();
        String filePath = File.separator + "client" + File.separator + "tkconfig" + File.separator + "common" + File.separator + "pwdCfg.ini";
        ClassLoader Loader = this.getClass().getClassLoader();
        if (null != Loader) {
            InputStream oInputStream = Loader.getResourceAsStream(filePath);
            InputStreamReader oInputStreamReader = null;
            BufferedReader reader = null;
            try {
                oInputStreamReader = new InputStreamReader(oInputStream);
                reader = new BufferedReader(oInputStreamReader);
                String str = reader.readLine();
                while (null != str) {
                    TKCommandLine cmdL = new TKCommandLine(str);
                    commandLines.add(cmdL);
                    str = reader.readLine();
                }
            }
            catch (IOException ioe) {
                DCDebugTracer.trace(ioe);
            }
            finally {
                try {
                    if (null != reader) {
                        reader.close();
                    }
                    if (null != oInputStreamReader) {
                        oInputStreamReader.close();
                    }
                    if (null != oInputStream) {
                        oInputStream.close();
                    }
                }
                catch (IOException e) {
                    DCDebugTracer.trace("DC::TKCodeArea#TKCodeArea ::throw exception::");
                    DCDebugTracer.trace(e);
                }
            }
        }
    }

    public static boolean isPwdPostionForTL1Cmd(int offset, String lineText) {
        TKCommandLine cmdL;
        boolean isPwdPostionForTL1Cmd = false;
        for (int i = 0; i < commandLines.size() && !(isPwdPostionForTL1Cmd = (cmdL = (TKCommandLine)commandLines.get(i)).isPwdPosition(lineText, offset)); ++i) {
        }
        return isPwdPostionForTL1Cmd;
    }

    public static boolean isPwdPostionForFtpOrSftp(int offset, String lineText, String strKeyWord) {
        String cmdText;
        char preCh;
        String forwText = lineText.substring(0, offset);
        String keyWord = strKeyWord + "://";
        int keyWordPosition = forwText.toLowerCase().lastIndexOf(keyWord.toLowerCase());
        if (keyWordPosition < 0) {
            keyWord = strKeyWord + ":\\";
            keyWordPosition = forwText.toLowerCase().lastIndexOf(keyWord.toLowerCase());
            if (keyWordPosition < 0) {
                return false;
            }
        } else if (keyWordPosition > 0 && (Character.isLetter(preCh = forwText.charAt(keyWordPosition - 1)) || Character.isDigit(preCh))) {
            return false;
        }
        if (TKCommandLine.getCharNumber(cmdText = forwText.substring(keyWordPosition, offset), '@') > 0) {
            return false;
        }
        return TKCommandLine.getCharNumber(cmdText, ':') >= 2;
    }

    public static boolean isPwdPostionForConSonet(int offset, String lineText) {
        int i;
        char preCh;
        String forwText = lineText.substring(0, offset);
        String keyWord = "consonet";
        int keyWordPosition = forwText.toUpperCase().lastIndexOf(keyWord.toUpperCase());
        if (keyWordPosition < 0) {
            return false;
        }
        if (keyWordPosition > 0 && (Character.isLetter(preCh = forwText.charAt(keyWordPosition - 1)) || Character.isDigit(preCh))) {
            return false;
        }
        String cmdText = forwText.substring(keyWordPosition, offset);
        int blacks = 0;
        char[] chars = cmdText.toCharArray();
        int[] blackIndexs = new int[chars.length];
        int j = 0;
        for (i = 0; i < chars.length; ++i) {
            if (chars[i] != ' ') continue;
            blackIndexs[j] = i;
            ++j;
        }
        for (i = 0; i < blackIndexs.length - 1 && blackIndexs[i] != 0; ++i) {
            if (blackIndexs[i + 1] - blackIndexs[i] < 2) continue;
            ++blacks;
        }
        return blacks == 2;
    }

    public static boolean isPwdInPosition(int offset, String lineText, char c) {
        boolean isCode = TKCodeArea.isPwdPostionForTL1Cmd(offset, lineText) && !TKCodeArea.isPasswordEnder(c, 0) || (TKCodeArea.isPwdPostionForFtpOrSftp(offset, lineText, "FTP") || TKCodeArea.isPwdPostionForFtpOrSftp(offset, lineText, "SFTP") || TKCodeArea.isPwdPostionForFtpOrSftp(offset, lineText, "SFTP_KEY")) && !TKCodeArea.isPasswordEnder(c, 1);
        return isCode;
    }

    private static boolean isPasswordEnder(char ch, int format) {
        boolean end = false;
        switch (format) {
            case 0: {
                end = ch == ':' || ch == ';' || ch == ',' || ch == '&' || ch == '\t';
                break;
            }
            case 2: {
                end = ch == ' ';
                break;
            }
            case 1: {
                end = ch == '@';
                break;
            }
        }
        return end;
    }
}

