/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.toolkit.client.base.util.sorttable;

import com.huawei.dc.toolkit.client.base.util.sorttable.TKAbstractEntry;
import com.huawei.dc.toolkit.client.base.util.sorttable.TKEntry;
import com.huawei.dc.toolkit.client.base.util.sorttable.TKSortTableModel;
import com.huawei.dc.toolkit.client.base.util.sorttable.TKSorterInterface;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;

public class TKTableSorter {
    TKSorterInterface DelegateSorter;
    private transient Entry[] table;
    private Comparator delegateComp = null;
    private int oldCol = -1;
    private static final int TRUE = 1;
    private static final int FALSE = -1;

    public TKTableSorter(TKSortTableModel model) {
        this.DelegateSorter = model;
    }

    private int rehash(int initLen) {
        if (this.table == null) {
            this.table = new Entry[initLen];
            return 1;
        }
        if (this.table.length != initLen) {
            this.table = null;
            this.table = new Entry[initLen];
            return 1;
        }
        return -1;
    }

    public void sort(int column, boolean isAscent) {
        int[] indexes = this.DelegateSorter.getIndexes();
        int len = indexes.length;
        if (this.rehash(len) == 1) {
            for (int i = 0; i < len; ++i) {
                this.table[i] = new Entry();
            }
        }
        int index = 0;
        Iterator it = this.DelegateSorter.getDataVector().iterator();
        while (it.hasNext()) {
            this.table[index].key = index;
            this.table[index].value = ((Vector)it.next()).elementAt(column);
            ++index;
        }
        this.initComp(column);
        Object[] aux = new Entry[len];
        System.arraycopy(this.table, 0, aux, 0, len);
        this.mergeSort((Entry[])aux, this.table, 0, len);
        Arrays.fill(aux, null);
        aux = null;
        if (isAscent) {
            for (int i = 0; i < len; ++i) {
                indexes[i] = this.table[i].key;
            }
        } else {
            for (int i = 0; i < len; ++i) {
                indexes[i] = this.table[len - i - 1].key;
            }
        }
    }

    private void mergeSort(Entry[] src, Entry[] dest, int low, int high) {
        int length = high - low;
        if (length < 7) {
            for (int i = 0; i < high; ++i) {
                if (low > i) continue;
                for (int j = i; j > low && this.compare1(dest[j - 1].value, dest[j].value) > 0; --j) {
                    TKTableSorter.swap(dest, j, j - 1);
                }
            }
            return;
        }
        int mid = low / 2 + high / 2;
        this.mergeSort(dest, src, low, mid);
        this.mergeSort(dest, src, mid, high);
        if (this.compare1(src[mid - 1].value, src[mid].value) <= 0) {
            System.arraycopy(src, low, dest, low, length);
            return;
        }
        int p = low;
        int q = mid;
        for (int i = 0; i < high; ++i) {
            if (low > i) continue;
            dest[i] = q >= high || p < mid && this.compare1(src[p].value, src[q].value) <= 0 ? src[p++] : src[q++];
        }
    }

    private static void swap(Entry[] x, int a, int b) {
        int key = x[a].key;
        Object value = x[a].value;
        x[a].key = x[b].key;
        x[a].value = x[b].value;
        x[b].key = key;
        x[b].value = value;
    }

    private void initComp(int col) {
        if (this.oldCol != col || this.delegateComp == null) {
            this.oldCol = col;
            this.delegateComp = null;
            Class type = this.DelegateSorter.getColumnClass(col);
            this.delegateComp = type.getSuperclass() == Number.class ? new Comparator(){

                public int compare(Object a, Object b) {
                    return TKTableSorter.this.compare((Number)a, (Number)b);
                }
            } : (type == String.class ? new Comparator(){

                public int compare(Object a, Object b) {
                    return ((String)a).compareTo((String)b);
                }
            } : (type.getSuperclass() == TKAbstractEntry.class || this.isTKEntryClass(type) ? new Comparator(){

                public int compare(Object a, Object b) {
                    return TKTableSorter.this.compare((TKEntry)a, (TKEntry)b);
                }
            } : (type == Date.class ? new Comparator(){

                public int compare(Object a, Object b) {
                    return TKTableSorter.this.compare((Date)a, (Date)b);
                }
            } : (type == Boolean.class ? new Comparator(){

                public int compare(Object a, Object b) {
                    return TKTableSorter.this.compare((Boolean)a, (Boolean)b);
                }
            } : new Comparator(){

                public int compare(Object a, Object b) {
                    return TKTableSorter.this.compare(a, b);
                }
            }))));
        }
    }

    private boolean isTKEntryClass(Class type) {
        Class<?>[] c = type.getInterfaces();
        List<Class<?>> list = Arrays.asList(c);
        return list.contains(TKEntry.class);
    }

    public int compare1(Object o1, Object o2) {
        if (o1 == null && o2 == null) {
            return 0;
        }
        if (o1 == null) {
            return -1;
        }
        if (o2 == null) {
            return 1;
        }
        return this.delegateComp.compare(o1, o2);
    }

    public int compare(Number o1, Number o2) {
        double n2;
        double n1 = o1.doubleValue();
        if (n1 < (n2 = o2.doubleValue())) {
            return -1;
        }
        if (n1 > n2) {
            return 1;
        }
        return 0;
    }

    public int compare(Date o1, Date o2) {
        long n2;
        long n1 = o1.getTime();
        if (n1 < (n2 = o2.getTime())) {
            return -1;
        }
        if (n1 > n2) {
            return 1;
        }
        return 0;
    }

    public int compare(Boolean o1, Boolean o2) {
        boolean b2;
        boolean b1 = o1;
        if (b1 == (b2 = o2.booleanValue())) {
            return 0;
        }
        if (b1) {
            return 1;
        }
        return -1;
    }

    public int compare(TKEntry o1, TKEntry o2) {
        return o1.compare(o2);
    }

    public int compare(Object o1, Object o2) {
        if (o1.toString() == null) {
            return -1;
        }
        if (o2.toString() == null) {
            return 1;
        }
        return o1.toString().compareTo(o2.toString());
    }

    public int compare(String o1, String o2) {
        int n1 = Integer.parseInt(o1);
        int n2 = Integer.parseInt(o2);
        return n2 - n1;
    }

    private static class Entry
    implements TKEntry {
        int key;
        Object value;

        public Entry() {
        }

        protected Entry(int _key, Object _value) {
            this.key = _key;
            this.value = _value;
        }

        @Override
        public int compare(Object o) {
            if (!(o instanceof Entry)) {
                return -1;
            }
            Entry data = (Entry)o;
            return this.key - data.key;
        }
    }
}

