/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.toolkit.client.base.util.sorttable;

import com.huawei.dc.common.util.DCDebugTracer;
import com.huawei.dc.toolkit.client.base.util.sorttable.TKDataSort;
import com.huawei.dc.toolkit.client.base.util.sorttable.TKSorterInterface;
import com.huawei.dc.toolkit.client.base.util.sorttable.TKTableSortInterface;
import com.huawei.dc.toolkit.client.base.util.sorttable.TKTableSorter;
import java.util.Vector;
import javax.swing.table.DefaultTableModel;

public class TKSortTableModel
extends DefaultTableModel
implements TKTableSortInterface,
TKSorterInterface {
    private static final int TRUE = 1;
    private static final int FALSE = 0;
    public int[] indexes;
    TKTableSorter sorter;
    int dirty = 0;

    public TKSortTableModel() {
    }

    public TKSortTableModel(Object[] data, int count) {
        super(data, count);
    }

    public TKSortTableModel(Object[][] data, Object[] columnNames) {
        super(data, columnNames);
    }

    @Override
    public Object getValueAt(int row, int col) {
        this.getIndexes();
        int rowIndex = row;
        Object value = new Object();
        try {
            if (this.indexes != null && row < this.indexes.length) {
                rowIndex = this.indexes[row];
            }
            value = super.getValueAt(rowIndex, col);
        }
        catch (Exception ex) {
            DCDebugTracer.trace(ex);
        }
        return value;
    }

    @Override
    public void setValueAt(Object value, int row, int col) {
        int rowIndex = row;
        if (this.indexes != null) {
            rowIndex = this.indexes[row];
        }
        super.setValueAt(value, rowIndex, col);
        this.dirty = 0;
    }

    public void setValueAt(Object value, int row, int col, boolean isAutoSort) {
        this.setValueAt(value, row, col);
        this.dirty = isAutoSort ? 1 : 0;
    }

    public void setValueAt(Object value, int row, int col, boolean isAutoSort, boolean bfireTableCellUpdated) {
        int rowIndex = row;
        if (this.indexes != null) {
            rowIndex = this.indexes[row];
        }
        Vector rowVector = (Vector)this.dataVector.elementAt(rowIndex);
        rowVector.setElementAt(value, col);
        if (bfireTableCellUpdated) {
            this.fireTableCellUpdated(rowIndex, col);
        }
        this.dirty = isAutoSort ? 1 : 0;
    }

    @Override
    public void moveRow(int startIndex, int endIndex, int toIndex) {
        super.moveRow(startIndex, endIndex, toIndex);
        this.dirty = 1;
    }

    @Override
    public void setRowCount(int rowCount) {
        super.setRowCount(rowCount);
        this.dirty = 1;
    }

    @Override
    public void sortByColumn(int column, boolean isAscent) {
        int sortState = -1;
        if (!isAscent) {
            sortState = 1;
        }
        TKDataSort.sortTable(this.getDataVector(), column, sortState);
        this.fireTableDataChanged();
    }

    @Override
    public int[] getIndexes() {
        if (this.dirty == 1) {
            this.dirty = 0;
            this.indexes = null;
        }
        int n = this.getRowCount();
        if (this.indexes != null && this.indexes.length == n) {
            return this.indexes;
        }
        this.indexes = null;
        this.indexes = new int[n];
        for (int i = 0; i < n; ++i) {
            this.indexes[i] = i;
        }
        return this.indexes;
    }
}

