/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.toolkit.client.base.util.sorttable;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import javax.swing.Icon;
import javax.swing.UIManager;

public class TKSortIcon
implements Icon {
    private int width = 10;
    private int height = 12;
    private int yTop = (this.height - 2) / 2;
    private int yBottom = (this.height + 2) / 2;
    private int[] xPoints = new int[]{0, this.width / 2, this.width};
    private int[] yPointsTop = new int[]{this.yTop, 0, this.yTop};
    private int[] yPointsBottom = new int[]{this.yBottom, this.height, this.yBottom};
    public static final Icon ICON_DOWN = new TKSortIcon(-1);
    public static final Icon ICON_UP = new TKSortIcon(1);
    public static final Icon ICON_NONE = new TKSortIcon(0);
    int sortState = 0;

    public TKSortIcon(int sortState) {
        this.sortState = sortState;
    }

    @Override
    public void paintIcon(Component c, Graphics g, int x, int y) {
        this.xPoints = new int[]{x, x + this.width / 2, x + this.width};
        this.yPointsTop = new int[]{y + this.yTop, y, y + this.yTop};
        this.yPointsBottom = new int[]{y + this.yBottom, y + this.height, y + this.yBottom};
        switch (this.sortState) {
            case 0: {
                this.drawNone(g, x, y);
                break;
            }
            case 1: {
                this.drawUp(g, x, y);
                break;
            }
            case -1: {
                this.drawDown(g, x, y);
                break;
            }
        }
    }

    private void drawDown(Graphics g, int xo, int yo) {
        g.setColor(UIManager.getColor("controlDkShadow"));
        g.drawPolygon(this.xPoints, this.yPointsTop, 3);
        g.setColor(Color.BLUE);
        g.fillPolygon(this.xPoints, this.yPointsBottom, 3);
        g.drawPolygon(this.xPoints, this.yPointsBottom, 3);
    }

    private void drawUp(Graphics g, int xo, int yo) {
        g.setColor(Color.BLUE);
        g.drawPolygon(this.xPoints, this.yPointsTop, 3);
        g.fillPolygon(this.xPoints, this.yPointsTop, 3);
        g.setColor(UIManager.getColor("controlDkShadow"));
        g.drawPolygon(this.xPoints, this.yPointsBottom, 3);
    }

    private void drawNone(Graphics g, int xo, int yo) {
        g.setColor(UIManager.getColor("controlDkShadow"));
        g.drawPolygon(this.xPoints, this.yPointsTop, 3);
        g.drawPolygon(this.xPoints, this.yPointsBottom, 3);
    }

    @Override
    public int getIconWidth() {
        return this.width;
    }

    @Override
    public int getIconHeight() {
        return this.height;
    }
}

