/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.toolkit.client.base.util.sorttable;

import com.huawei.dc.toolkit.client.base.util.sorttable.TKBlankIcon;
import com.huawei.dc.toolkit.client.base.util.sorttable.TKSortIcon;
import java.awt.Component;
import java.awt.Insets;
import java.util.Hashtable;
import javax.swing.JButton;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.table.TableCellRenderer;

public class TKSortButtonRenderer
extends JButton
implements TableCellRenderer {
    public static final int NONE = 0;
    public static final int DOWN = -1;
    public static final int UP = 1;
    int pushedColumn = -1;
    Hashtable state = new Hashtable();

    public TKSortButtonRenderer() {
        this.setMargin(new Insets(0, 0, 0, 0));
        this.setHorizontalTextPosition(2);
        this.setIcon(TKSortIcon.ICON_NONE);
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        TKSortButtonRenderer button = this;
        button.setIcon(TKSortIcon.ICON_NONE);
        Object obj = this.state.get(column);
        if (obj != null) {
            if ((Integer)obj == -1) {
                button.setIcon(TKSortIcon.ICON_DOWN);
            } else if ((Integer)obj == 1) {
                button.setIcon(TKSortIcon.ICON_UP);
            }
        }
        button.setText(value == null ? "" : value.toString());
        boolean isPressed = column == this.pushedColumn;
        button.getModel().setPressed(isPressed);
        button.getModel().setArmed(isPressed);
        button.setBorder(UIManager.getBorder("TableHeader.cellBorder"));
        return button;
    }

    public void setPressedColumn(int col) {
        this.pushedColumn = col;
    }

    public void setSelectedColumn(int col) {
        if (col < 0) {
            return;
        }
        Integer value = null;
        Object obj = this.state.get(col);
        value = obj == null ? Integer.valueOf(-1) : ((Integer)obj == -1 ? new Integer(1) : new Integer(-1));
        this.state.clear();
        this.state.put(new Integer(col), value);
    }

    public int getState(int col) {
        Object obj = this.state.get(col);
        int retValue = obj == null ? 0 : ((Integer)obj == -1 ? -1 : 1);
        return retValue;
    }

    public int getStateEx(int col) {
        Object obj = this.state.get(col);
        int retValue = obj == null ? 0 : ((Integer)obj == -1 ? 1 : -1);
        return retValue;
    }

    public void clearSortFlag() {
        this.setPressedColumn(-1);
        this.state.clear();
    }

    public void clearSortRender() {
        this.setMargin(new Insets(0, 0, 0, 0));
        this.setHorizontalTextPosition(2);
        this.setIcon(new TKBlankIcon());
    }

    int getSortState(int col) {
        Integer I = (Integer)this.state.get(col);
        return I == null ? 0 : I;
    }
}

