/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.toolkit.client.base.util.sorttable;

import com.huawei.dc.toolkit.client.base.util.TKDebug;
import com.huawei.dc.toolkit.client.base.util.sorttable.TKSortButtonRenderer;
import com.huawei.dc.toolkit.client.base.util.sorttable.TKTableSortInterface;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;

public class TKHeaderListener
extends MouseAdapter {
    protected JTableHeader header;
    protected TKSortButtonRenderer renderer;
    private TKTableSortInterface sortInterface;
    private int col = -1;

    public TKHeaderListener(JTableHeader header, TKSortButtonRenderer renderer) {
        this.header = header;
        this.renderer = renderer;
    }

    public TKHeaderListener(JTableHeader header, TKSortButtonRenderer renderer, int col) {
        this.header = header;
        this.renderer = renderer;
        this.col = col;
    }

    public TKHeaderListener(JTableHeader header, TKSortButtonRenderer renderer, TKTableSortInterface sortI) {
        this.header = header;
        this.renderer = renderer;
        this.sortInterface = sortI;
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (!this.renderer.isEnabled()) {
            return;
        }
        int column = this.header.columnAtPoint(e.getPoint());
        TableCellRenderer rend = this.header.getTable().getColumnModel().getColumn(column).getHeaderRenderer();
        if (!(rend instanceof TKSortButtonRenderer)) {
            return;
        }
        int count = this.header.getTable().getColumnCount();
        for (int i = 0; i < count; ++i) {
            TableCellRenderer ren;
            if (column == i || !((ren = this.header.getTable().getColumnModel().getColumn(i).getHeaderRenderer()) instanceof TKSortButtonRenderer)) continue;
            ((TKSortButtonRenderer)ren).clearSortFlag();
        }
        TKDebug.trace(this.header.getCursor());
        int type = this.header.getCursor().getType();
        if (type != 10 && type != 11 && (e.getModifiers() & 0x10) != 0) {
            this.header.getTable().clearSelection();
            int col = this.header.columnAtPoint(e.getPoint());
            if (this.col != col) {
                return;
            }
            int sortCol = this.header.getTable().convertColumnIndexToModel(col);
            this.renderer.setPressedColumn(col);
            this.renderer.setSelectedColumn(col);
            this.header.repaint();
            if (this.header.getTable().isEditing()) {
                this.header.getTable().getCellEditor().stopCellEditing();
            }
            boolean isAscent = -1 == this.renderer.getState(col);
            if (this.sortInterface != null) {
                this.sortInterface.sortByColumn(sortCol, isAscent);
            } else {
                ((TKTableSortInterface)((Object)this.header.getTable().getModel())).sortByColumn(sortCol, isAscent);
            }
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        this.renderer.setPressedColumn(-1);
        this.header.repaint();
    }
}

