/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.toolkit.client.base.util.operresult;

import com.huawei.dc.common.util.DCDebugTracer;
import com.huawei.dc.toolkit.client.base.util.TKResourceManager;
import com.huawei.dc.toolkit.client.base.util.TKScreenToolKit;
import com.huawei.dc.toolkit.client.base.util.component.TKButton;
import com.huawei.dc.toolkit.client.base.util.component.TKComponentToolkit;
import com.huawei.dc.toolkit.client.base.util.component.TKTable;
import com.huawei.dc.toolkit.client.base.util.operresult.TKOperationShowMgr;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.font.FontRenderContext;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;

public class TKOperationShowDlg
extends JDialog {
    private CustomTableCellRender cellRender = new CustomTableCellRender();
    private JPanel parentPnl = new JPanel();
    private JPanel tablePnl = new JPanel();
    private JScrollPane operScrollPane = new JScrollPane();
    private JPanel topPnl = new JPanel();
    private JPanel btnPnl = new JPanel();
    private JPanel infoPnl = new JPanel();
    private JLabel iconLbl = new JLabel();
    private JScrollPane infoScrllPn = new JScrollPane();
    private JTextArea infoTextArea = new JTextArea();
    private GridBagLayout gridBagLayout1 = new GridBagLayout();
    private TKButton detailBtn = new TKButton();
    private TKButton closeBtn = new TKButton();
    private TKButton noDetailBtn = new TKButton();
    private JTable table = new TKTable();
    private Vector vcColumn = null;
    private Vector vcData = null;
    private DefaultTableModel tableModel = null;
    private final String colOperObj = TKResourceManager.getString(TKOperationShowMgr.resourceFile, "OPER_OBJ");
    private final String colOperResult = TKResourceManager.getString(TKOperationShowMgr.resourceFile, "OPER_RES");
    private final String colReason = TKResourceManager.getString(TKOperationShowMgr.resourceFile, "REASON");
    private static final int WindowWidth = 450;
    private static final int WindowHeightCollapse = 180;
    private static final int WindowHeightExtend = 360;
    private final Icon iconError = TKResourceManager.getIcon("error.gif");
    private final Icon iconInfo = TKResourceManager.getIcon("inform.gif");
    public String infoStr = null;
    public static TKOperationShowDlg instance = null;

    public TKOperationShowDlg(Frame parentFrame, String title, String infoStr, Vector vcData, boolean isModal) {
        super(parentFrame, title, isModal);
        this.infoStr = infoStr;
        this.vcData = vcData;
        try {
            this.jbInit();
            this.extraInit();
            instance = this;
            if (vcData.size() > 0) {
                this.detailBtn_actionPerformed(null);
            }
            this.setDefaultCloseOperation(2);
        }
        catch (Exception ex) {
            instance = null;
            DCDebugTracer.trace(ex);
        }
    }

    private void jbInit() throws Exception {
        this.detailBtn.setText(TKResourceManager.getString(TKOperationShowMgr.resourceFile, "DETAIL_1"));
        this.closeBtn.setText(TKResourceManager.getString(TKOperationShowMgr.resourceFile, "CLOSE"));
        this.noDetailBtn.setText(TKResourceManager.getString(TKOperationShowMgr.resourceFile, "DETAIL_2"));
        ButtonGroup group = new ButtonGroup();
        group.add(this.detailBtn);
        group.add(this.closeBtn);
        group.add(this.noDetailBtn);
        this.iconLbl.setIcon(this.iconInfo);
        this.table.getTableHeader().setReorderingAllowed(false);
        this.infoTextArea.setWrapStyleWord(true);
        this.infoTextArea.setLineWrap(true);
        this.infoTextArea.setBorder(BorderFactory.createEmptyBorder());
        this.infoTextArea.setEditable(false);
        this.infoTextArea.setBackground(UIManager.getColor("Label.background"));
        this.infoTextArea.setRequestFocusEnabled(false);
        this.infoScrllPn.setBorder(null);
        this.infoScrllPn.setPreferredSize(new Dimension(300, 80));
        this.setModal(true);
        this.setDefaultCloseOperation(2);
        this.getContentPane().add(this.parentPnl);
        this.parentPnl.setLayout(new BorderLayout(20, 20));
        this.parentPnl.add((Component)this.topPnl, "North");
        this.parentPnl.add((Component)this.tablePnl, "Center");
        this.topPnl.setLayout(this.gridBagLayout1);
        this.topPnl.add((Component)this.iconLbl, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(5, 10, 5, 5), 0, 0));
        this.topPnl.add((Component)this.infoScrllPn, new GridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 17, 1, new Insets(20, 10, 5, 5), 0, 0));
        this.topPnl.add((Component)this.btnPnl, new GridBagConstraints(0, 1, 2, 1, 1.0, 0.0, 13, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.infoScrllPn.getViewport().add(this.infoTextArea);
        this.btnPnl.setLayout(new FlowLayout(2, 8, 0));
        this.btnPnl.add(this.detailBtn);
        this.btnPnl.add(this.noDetailBtn);
        this.btnPnl.add(this.closeBtn);
        this.tablePnl.setLayout(new BorderLayout());
        this.tablePnl.add((Component)this.operScrollPane, "Center");
        this.operScrollPane.getViewport().add(this.table);
        this.detailBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TKOperationShowDlg.this.detailBtn_actionPerformed(e);
            }
        });
        this.noDetailBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TKOperationShowDlg.this.noDetailBtn_actionPerformed(e);
            }
        });
        this.closeBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TKOperationShowDlg.this.closeBtn_actionPerformed(e);
            }
        });
        KeyAdapter escKa = new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                if (e.getKeyCode() == 27) {
                    TKOperationShowDlg.this.dispose();
                }
            }
        };
        TKComponentToolkit.addAllKeyListener(this, "javax.swing.JComponent", escKa);
        this.closeBtn.requestFocus();
        this.closeBtn.setSelected(true);
        this.tablePnl.setVisible(false);
        this.noDetailBtn.setVisible(false);
        this.setSize(450, 180);
        TKComponentToolkit.addAllButtonEnterKeyAdp(this);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowActivated(WindowEvent e) {
                TKOperationShowDlg.this.closeBtn.requestFocusInWindow();
            }
        });
    }

    protected void expandDetail() {
        this.detailBtn_actionPerformed(null);
    }

    public int getRowCount() {
        return this.tableModel.getRowCount();
    }

    public void clearData() {
        this.tableModel.setRowCount(0);
        this.tableModel.getDataVector().removeAllElements();
    }

    public void addTableData(Vector data) {
        if (this.tableModel == null || data == null) {
            return;
        }
        for (int i = 0; i < data.size(); ++i) {
            this.tableModel.addRow((Vector)data.elementAt(i));
            this.setRowHeight();
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                TKOperationShowDlg.this.table.repaint();
                TKOperationShowDlg.this.detailBtn.setEnabled(TKOperationShowDlg.this.tableModel.getRowCount() > 0);
            }
        });
    }

    private void extraInit() {
        this.vcColumn = new Vector();
        this.vcColumn.addElement(this.colOperObj);
        this.vcColumn.addElement(this.colOperResult);
        this.vcColumn.addElement(this.colReason);
        if (this.vcData == null) {
            this.vcData = new Vector();
        }
        this.tableModel = new DefaultTableModel(this.vcData, this.vcColumn){

            @Override
            public boolean isCellEditable(int row, int col) {
                return false;
            }
        };
        this.table.setModel(this.tableModel);
        if (this.infoStr == null) {
            this.infoTextArea.setText(TKResourceManager.getString(TKOperationShowMgr.resourceFile, "OPER_OVER"));
        } else {
            this.infoTextArea.setText(this.infoStr);
        }
        this.infoTextArea.setCaretPosition(0);
        TableColumn objTC = this.table.getColumn(this.colOperObj);
        TableColumn resultTC = this.table.getColumn(this.colOperResult);
        TableColumn reasonTC = this.table.getColumn(this.colReason);
        this.table.updateUI();
        objTC.setMaxWidth(1000);
        objTC.setMinWidth(60);
        objTC.setPreferredWidth(110);
        objTC.setCellRenderer(this.cellRender);
        resultTC.setMaxWidth(1000);
        resultTC.setMinWidth(50);
        resultTC.setPreferredWidth(120);
        resultTC.setCellRenderer(this.cellRender);
        reasonTC.setMaxWidth(1500);
        reasonTC.setMinWidth(100);
        reasonTC.setPreferredWidth(220);
        reasonTC.setCellRenderer(this.cellRender);
        this.detailBtn.setEnabled(this.tableModel.getRowCount() > 0);
    }

    private void closeBtn_actionPerformed(ActionEvent e) {
        this.dispose();
    }

    @Override
    public void dispose() {
        instance = null;
        if (this.vcData != null) {
            this.vcData.clear();
        }
        this.clearData();
        super.dispose();
    }

    public void detailBtn_actionPerformed(ActionEvent e) {
        this.setSize(450, 360);
        this.tablePnl.setVisible(true);
        this.noDetailBtn.setVisible(true);
        this.detailBtn.setVisible(false);
        this.validate();
        this.repaint();
    }

    private void noDetailBtn_actionPerformed(ActionEvent e) {
        this.setSize(450, 180);
        this.tablePnl.setVisible(false);
        this.noDetailBtn.setVisible(false);
        this.detailBtn.setVisible(true);
        this.validate();
        this.repaint();
    }

    public void setRowHeight() {
        int row = this.table.getRowCount();
        int columnCount = this.table.getColumnCount();
        JTextArea textArea = new JTextArea();
        Font font = textArea.getFont();
        if (row < 0) {
            return;
        }
        for (int i = 0; i < row; ++i) {
            int maxRowHeight;
            int tempRowHeight = maxRowHeight = 20;
            for (int j = 0; j < columnCount; ++j) {
                int cellWidth;
                int height = 20;
                Object tem = this.table.getValueAt(i, j);
                String temp = tem.toString();
                Rectangle2D r2d = font.getStringBounds(temp, new FontRenderContext(new AffineTransform(), true, true));
                int width = (int)r2d.getWidth();
                tempRowHeight = height * (width / (cellWidth = this.table.getColumnModel().getColumn(j).getPreferredWidth()) + 3);
                if (tempRowHeight <= maxRowHeight) continue;
                maxRowHeight = tempRowHeight;
            }
            this.table.setRowHeight(i, maxRowHeight);
        }
    }

    public void setAlterStyle() {
        Font font = this.infoTextArea.getFont();
        this.infoTextArea.setFont(new Font(font.getFontName(), 1, font.getSize()));
    }

    public void dlgShow() {
        this.setRowHeight();
        TKScreenToolKit.centerLocateToScreen(this);
        if (!this.isShowing()) {
            this.show();
        }
    }

    @Override
    public Component getMostRecentFocusOwner() {
        this.toFront();
        this.closeBtn.requestFocus();
        return this.closeBtn;
    }

    class CustomTableCellRender
    extends JTextArea
    implements TableCellRenderer {
        public CustomTableCellRender() {
            this.setLineWrap(true);
            this.setWrapStyleWord(true);
            this.setOpaque(true);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            this.setText(value == null ? "" : value.toString());
            return this;
        }
    }
}

