/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.toolkit.client.base.util.help;

import com.huawei.dc.common.framework.utility.DCFrameWorkUtil;
import com.huawei.dc.common.util.DCDebugTracer;
import com.huawei.dc.toolkit.client.base.util.TKDebug;
import com.huawei.dc.toolkit.client.base.util.TKProfileFactory;
import com.huawei.dc.toolkit.client.base.util.TKResourceManager;
import com.huawei.dc.toolkit.client.base.util.help.TKHelpRes;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.Locale;
import javax.help.CSH;
import javax.help.DefaultHelpBroker;
import javax.help.HelpBroker;
import javax.help.HelpSet;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.RootPaneContainer;

public class TKHelpMgr {
    private static TKHelpMgr _instance = null;
    private TKHelpRes res = TKHelpRes.getInstance();
    String hsFileName;
    HelpSet hSet = null;
    ActionListener helpMenuItemActionlistener = null;
    ActionListener helpOnItemActionlistener = null;
    myBroker mybroker = new myBroker();
    ImageIcon helpIcon = null;

    private TKHelpMgr() {
        this.init();
    }

    public static TKHelpMgr instance() {
        if (_instance == null) {
            _instance = new TKHelpMgr();
        }
        return _instance;
    }

    private void init() {
        this.hsFileName = DCFrameWorkUtil.getIsSingleClient() ? TKResourceManager.getPath() + File.separator + "help" + File.separator : TKResourceManager.getPath() + File.separator + "client" + File.separator + "help" + File.separator;
        String supportType = TKResourceManager.getDevType();
        String oemType = TKResourceManager.getOEMType();
        if (!TKResourceManager.isHuawei()) {
            supportType = oemType;
        }
        this.hsFileName = DCFrameWorkUtil.getIsSingleClient() ? this.hsFileName + TKProfileFactory.getLanguageID() + File.separator + "t2k.hs" : this.hsFileName + supportType + File.separator + TKProfileFactory.getLanguageID() + File.separator + "t2k.hs";
        this.setHelpSetFile(this.hsFileName);
        this.getFramework();
        this.helpMenuItemActionlistener = new CSH.DisplayHelpFromSource((HelpBroker)this.mybroker);
        this.helpOnItemActionlistener = new CSH.DisplayHelpAfterTracking((HelpBroker)this.mybroker);
    }

    private void setHelpSetFile(String hsFileName) {
        try {
            File hsFile = new File(hsFileName);
            this.hSet = new HelpSet(null, hsFile.toURL());
        }
        catch (Exception ee) {
            DCDebugTracer.trace(ee);
        }
    }

    private void getFramework() {
        if (this.mybroker != null) {
            try {
                this.mybroker.setHelpSet(this.hSet);
                this.mybroker.setLocale(Locale.getDefault());
            }
            catch (Exception ee) {
                DCDebugTracer.trace(ee);
            }
        }
    }

    public String getHelpID(String strInterface) {
        return this.res.getString(strInterface);
    }

    public String getCurHelpID() {
        return this.mybroker.getCurrentID().toString();
    }

    public void helpRootPane(JRootPane jrootpane) {
        this.mybroker.enableHelpKey(jrootpane, this.getHelpID("mainframe"), this.hSet);
    }

    public void helpRootPane(JRootPane jrootpane, String strHelpId) {
        this.mybroker.enableHelpKey(jrootpane, this.getHelpID(strHelpId), this.hSet);
    }

    public void helpMenuItem(ActionEvent e) {
        try {
            this.mybroker.setCurrentID(this.getHelpID("mainframe"));
        }
        catch (Exception ee) {
            TKDebug.trace("Can't make the first page!");
        }
        this.helpMenuItemActionlistener.actionPerformed(e);
    }

    public void helpOnItem(ActionEvent e) {
        this.helpOnItemActionlistener.actionPerformed(e);
    }

    public void helpComponent(Component comp, String strHelpId) {
        if (comp instanceof JPanel) {
            ((JPanel)comp).requestFocus();
        }
        Component c = comp;
        if (comp instanceof RootPaneContainer) {
            c = ((RootPaneContainer)((Object)comp)).getRootPane();
        }
        this.mybroker.enableHelpKey(c, this.getHelpID(strHelpId), this.hSet);
    }

    public void helpParentComponent(Component parent, String parentHelpId, Component comp, String strHelpId) {
        if (parent instanceof JPanel) {
            ((JPanel)parent).requestFocus();
        }
        this.mybroker.enableHelpKey(parent, this.getHelpID(parentHelpId), this.hSet);
        CSH.setHelpIDString((Component)comp, (String)this.getHelpID(strHelpId));
    }

    public void helpButton(JButton helpbutton, String strHelpId) {
        this.mybroker.enableHelpOnButton(helpbutton, this.getHelpID(strHelpId), this.hSet);
    }

    public void helpFrame(Component comp, String strHelpId) {
        this.mybroker.enableHelp(comp, this.getHelpID(strHelpId), this.hSet);
    }

    public static void main(String[] arg) {
        TKHelpMgr.instance().mybroker.initPresentation();
        TKHelpMgr.instance().mybroker.setDisplayed(true);
    }

    public class myBroker
    extends DefaultHelpBroker {
        myBroker() {
        }
    }
}

