/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.toolkit.client.base.util.filtertable;

import com.huawei.dc.toolkit.client.base.util.filtertable.TKFilterCellRenderer;
import com.huawei.dc.toolkit.client.base.util.sorttable.TKDataSort;
import com.huawei.dc.toolkit.client.base.util.treetable.TKDefaultTreeRow;
import com.huawei.dc.toolkit.client.base.util.treetable.TKTreeRowEntry;
import com.huawei.dc.toolkit.client.base.util.treetable.TKTreeTableModel;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Vector;

public class TKFilterTableModel
extends TKTreeTableModel {
    protected TKFilterCellRenderer cellRender;
    private Object[] filters;
    protected Vector filterDataVector = new Vector();
    protected int sortColumn = -1;
    protected int sortState = 0;

    public TKFilterTableModel(Object[] columns) {
        super(columns);
        this.filters = new String[columns.length];
    }

    @Override
    public Vector getDatas() {
        return this.filterDataVector;
    }

    @Override
    public void removeRow(int row) {
        this.removeFilterRow(this.getRow(row));
        super.removeRow(row);
    }

    private void removeFilterRow(TKTreeRowEntry rowData) {
        this.removeRowWithChildren(rowData);
    }

    protected void removeFilterRowWithChildren(TKTreeRowEntry rowData) {
        rowData.setRowState(2);
        int index1 = this.filterDataVector.indexOf(rowData);
        if (index1 < 0) {
            return;
        }
        this.filterDataVector.removeElement(rowData);
        Vector children = rowData.children();
        for (int i = 0; i < children.size(); ++i) {
            TKTreeRowEntry child = (TKTreeRowEntry)children.get(i);
            this.removeFilterRowWithChildren(child);
        }
    }

    @Override
    protected void removeRowWithChildren(TKTreeRowEntry rowData) {
        this.removeFilterRowWithChildren(rowData);
        super.removeRowWithChildren(rowData);
        if (this.filterDataVector != null && this.cellRender != null && this.filterDataVector.size() == 0) {
            this.clearFilterSort();
        }
    }

    protected void clearFilterSort() {
        for (int i = 0; i < this.filters.length; ++i) {
            this.filters[i] = null;
        }
        this.cellRender.clearFilterFlag();
        this.cellRender.clearSortFlag();
    }

    @Override
    public void addRow(TKTreeRowEntry rowData) {
        this.insertRow(this.getRowCount(), rowData);
    }

    @Override
    public void insertRow(int row, TKTreeRowEntry rowData) {
        this.filterDataVector.insertElementAt(rowData, row);
        this.justifyRows(row, row + 1);
        super.insertRow(row, rowData);
    }

    @Override
    public void insertRow(int row, Object[] rowData) {
        this.filterDataVector.insertElementAt(new TKDefaultTreeRow(rowData), row);
        this.justifyRows(row, row + 1);
        super.insertRow(row, rowData);
    }

    @Override
    public void fireTableDataChanged() {
        if (this.filterDataVector != null && this.cellRender != null && this.filterDataVector.size() == 0) {
            this.clearFilterSort();
        }
        super.fireTableDataChanged();
    }

    @Override
    public void fireTableRowsDeleted(int firstRow, int lastRow) {
        if (this.filterDataVector != null && this.cellRender != null && this.filterDataVector.size() == 0) {
            this.clearFilterSort();
        }
        super.fireTableRowsDeleted(firstRow, lastRow);
    }

    @Override
    public void insertRow(int row, Vector rowData) {
        this.filterDataVector.insertElementAt(new TKDefaultTreeRow(rowData), row);
        this.justifyRows(row, row + 1);
        super.insertRow(row, rowData);
    }

    @Override
    public void expandRow(int row) {
        if (this.sortColumn >= 0 && this.sortState != 0) {
            TKTreeRowEntry rowData = this.getRow(row);
            if (rowData == null || rowData.getChildCount() == 0 || (rowData.getRowState() & 2) == 0) {
                return;
            }
            Vector vChildren = rowData.children();
            TKFilterTableModel.sortTable(vChildren, this.sortColumn, this.sortState);
        }
        super.expandRow(row);
    }

    public void sortByColumn(int column, int sortState) {
        this.sortColumn = column;
        this.sortState = sortState;
        this.filter();
        this.fireTableDataChanged();
    }

    public void filter(int column, Object filter) {
        if (column >= this.filters.length || column < 0) {
            return;
        }
        this.filters[column] = filter;
        this.filter();
    }

    protected void filter() {
        Vector datas = this.getDataVecotr();
        this.justifyDatas(datas);
        this.setRowCount(0);
        this.myDataVector.clear();
        this.dataVector.clear();
        for (int i = 0; i < datas.size(); ++i) {
            super.insertRow(i, (TKTreeRowEntry)datas.get(i));
        }
        datas.clear();
        datas = null;
        this.fireTableDataChanged();
    }

    public int getRowCountX() {
        return this.filterDataVector.size();
    }

    public TKTreeRowEntry getRowX(int row) {
        if (row >= this.filterDataVector.size() || row < 0) {
            return null;
        }
        return (TKTreeRowEntry)this.filterDataVector.get(row);
    }

    public Vector getDataVecotr() {
        Vector<TKTreeRowEntry> datas = new Vector<TKTreeRowEntry>();
        if (this.filterDataVector == null) {
            return datas;
        }
        boolean isFit = true;
        for (int j = 0; j < this.filterDataVector.size(); ++j) {
            TKTreeRowEntry rowData = (TKTreeRowEntry)this.filterDataVector.get(j);
            isFit = true;
            for (int i = 0; i < this.filters.length; ++i) {
                Object value;
                Object filter = this.filters[i];
                if (filter == null || filter.toString().trim().length() == 0 || (value = rowData.getValueAt(i)).toString().equals(filter)) continue;
                isFit = false;
            }
            if (!isFit || datas.contains(rowData)) continue;
            datas.addElement(rowData);
        }
        return datas;
    }

    public static void sortTable(Vector dataVector, final int nCol, final int sortState) {
        Collections.sort(dataVector, new Comparator(){

            public int compare(Object o1, Object o2) {
                TKTreeRowEntry v1 = (TKTreeRowEntry)o1;
                TKTreeRowEntry v2 = (TKTreeRowEntry)o2;
                if (sortState == 0) {
                    return TKDataSort.comp(v1, v2, sortState);
                }
                return TKDataSort.comp(v1.getValueAt(nCol), v2.getValueAt(nCol), sortState);
            }
        });
    }

    private void justifyRows(int from, int to) {
        for (int i = 0; i < to; ++i) {
            if (from > i || this.filterDataVector.elementAt(i) != null) continue;
            this.filterDataVector.setElementAt(new TKDefaultTreeRow(), i);
        }
    }

    protected void justifyDatas(Vector justifyDatas) {
        if (justifyDatas.size() <= 1) {
            return;
        }
        Vector tempData = new Vector(justifyDatas);
        Vector saveData = new Vector();
        HashMap vectors = new HashMap();
        Object nullParent = new Object();
        while (tempData.size() > 0) {
            Vector<TKTreeRowEntry> vc;
            Object parentVector;
            TKTreeRowEntry rowData = (TKTreeRowEntry)tempData.remove(0);
            TKTreeRowEntry parent = rowData.getParent();
            if (parent != null && justifyDatas.contains(parent)) {
                parentVector = vectors.get(rowData.getParent());
                if (parentVector == null) {
                    vc = new Vector<TKTreeRowEntry>();
                    vc.add(rowData);
                    vectors.put(rowData.getParent(), vc);
                    continue;
                }
                vc = (Vector<TKTreeRowEntry>)parentVector;
                vc.add(rowData);
                continue;
            }
            parentVector = vectors.get(nullParent);
            if (parentVector == null) {
                vc = new Vector<TKTreeRowEntry>();
                vc.add(rowData);
                vectors.put(nullParent, vc);
                continue;
            }
            vc = (Vector<TKTreeRowEntry>)parentVector;
            vc.add(rowData);
        }
        justifyDatas.clear();
        Vector topVc = (Vector)vectors.get(nullParent);
        this.fillVector(justifyDatas, topVc, vectors);
        saveData.clear();
        tempData.clear();
    }

    private void fillVector(Vector filled, Vector datas, HashMap vectors) {
        if (this.sortColumn >= 0 && this.sortState != 0) {
            TKFilterTableModel.sortTable(datas, this.sortColumn, this.sortState);
        }
        for (Object obj : datas) {
            filled.add(obj);
            Object nextTarget = vectors.get(obj);
            if (nextTarget == null) continue;
            this.fillVector(filled, (Vector)nextTarget, vectors);
        }
    }
}

