/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.toolkit.client.base.util.filtertable;

import com.huawei.dc.common.util.DCDebugTracer;
import com.huawei.dc.toolkit.client.base.util.TKRes;
import com.huawei.dc.toolkit.client.base.util.filtertable.TKFilterCellRenderer;
import com.huawei.dc.toolkit.client.base.util.filtertable.TKFilterHeaderListener;
import com.huawei.dc.toolkit.client.base.util.filtertable.TKFilterMenuItem;
import com.huawei.dc.toolkit.client.base.util.filtertable.TKFilterTableModel;
import com.huawei.dc.toolkit.client.base.util.treetable.TKTreeRowEntry;
import com.huawei.dc.toolkit.client.base.util.treetable.TKTreeTable;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableColumnModel;

public class TKFilterTable
extends TKTreeTable {
    private HashMap popupMenuList = new HashMap();
    private static final String PREFIX_MARK_MENU = "MARK_MENU";
    private String strColumnsReg = "";
    private FilterAction filterAction = new FilterAction();
    private AscendAction ascendAction = new AscendAction();
    private DescendAction descendAction = new DescendAction();
    protected TKFilterCellRenderer cellRender = new TKFilterCellRenderer();
    private static final String mark = "AA";

    public TKFilterTable(Object[] columns) {
        this(new TKFilterTableModel(columns));
    }

    public TKFilterTable(TKFilterTableModel model) {
        super(model);
        this.getTableHeader().addMouseListener(new TKFilterHeaderListener(this));
        this.getModel().addTableModelListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent e) {
                TKFilterTable.this.popupMenuList.clear();
            }
        });
        model.cellRender = this.cellRender;
    }

    public void removeColumnFilterAction(int column) {
        this.strColumnsReg = this.strColumnsReg.replaceAll(mark + column + mark, "");
        TableColumnModel columnModel = this.getColumnModel();
        columnModel.getColumn(column).setHeaderRenderer(null);
    }

    public void removeColumnFilterAction() {
        this.strColumnsReg = "";
        TableColumnModel columnModel = this.getColumnModel();
        int columnNum = columnModel.getColumnCount();
        for (int i = 0; i < columnNum; ++i) {
            columnModel.getColumn(i).setHeaderRenderer(null);
        }
    }

    public void addColumnFilterAction(int column) {
        this.strColumnsReg = this.strColumnsReg + mark + column + mark;
        TableColumnModel columnModel = this.getColumnModel();
        columnModel.getColumn(column).setHeaderRenderer(this.cellRender);
    }

    public int getRowCountX() {
        return ((TKFilterTableModel)this.getModel()).getRowCountX();
    }

    public TKTreeRowEntry getRowX(int row) {
        return ((TKFilterTableModel)this.getModel()).getRowX(row);
    }

    public void addColumnFilterAction() {
        this.strColumnsReg = this.strColumnsReg + mark + "-1" + mark;
        this.getTableHeader().setDefaultRenderer(this.cellRender);
    }

    protected boolean isColumnRegister(int column) {
        return this.strColumnsReg.indexOf("AA-1AA") >= 0 || this.strColumnsReg.indexOf(mark + column + mark) >= 0;
    }

    private void processHeaderCellText(int column, String filter) {
        this.cellRender.setShowText(column, filter);
        this.getTableHeader().repaint();
    }

    private void processHeaderCellDownup(int column, int sortState) {
        this.cellRender.setSortColumnState(column, sortState);
        this.getTableHeader().repaint();
    }

    public JPopupMenu createPopupMenu(int column) {
        JPopupMenu pMenu = (JPopupMenu)this.popupMenuList.get(PREFIX_MARK_MENU + column);
        pMenu = this.createFilterPopupMenu(column);
        this.popupMenuList.put(PREFIX_MARK_MENU + column, pMenu);
        return pMenu;
    }

    private JPopupMenu createFilterPopupMenu(int column) {
        JPopupMenu pMenu = new JPopupMenu();
        StringBuffer sb = new StringBuffer();
        TKFilterMenuItem topItem = new TKFilterMenuItem("topItem");
        pMenu.add(topItem);
        topItem.setVisible(false);
        pMenu.add(this.createAscendMenuItem(column));
        pMenu.add(this.createDescendMenuItem(column));
        pMenu.addSeparator();
        Vector filterDataVector = ((TKFilterTableModel)this.getModel()).filterDataVector;
        int rowCount = filterDataVector.size();
        for (int i = 0; i < rowCount; ++i) {
            try {
                TKTreeRowEntry rowData = (TKTreeRowEntry)filterDataVector.get(i);
                String value = rowData.getValueAt(column).toString();
                if (value.trim().length() <= 0 || sb.indexOf("**" + value + "**") >= 0) continue;
                TKFilterMenuItem menuItem = new TKFilterMenuItem(value);
                menuItem.column = column;
                menuItem.addActionListener(this.filterAction);
                pMenu.add(menuItem);
                sb.append("**" + value + "**");
                continue;
            }
            catch (Exception ex) {
                DCDebugTracer.trace(ex);
            }
        }
        if (sb.length() == 0) {
            pMenu.add(this.createShowAllMenuItem(column));
            pMenu.setBorder(BorderFactory.createLineBorder(Color.black));
            return pMenu;
        }
        sb = null;
        pMenu.addSeparator();
        pMenu.add(this.createShowAllMenuItem(column));
        pMenu.setBorder(BorderFactory.createLineBorder(Color.black));
        return pMenu;
    }

    private JMenuItem createShowAllMenuItem(int column) {
        TKFilterMenuItem menuItem = new TKFilterMenuItem(TKRes.instance().getString("ShowAll"));
        menuItem.filterText = "";
        menuItem.column = column;
        menuItem.addActionListener(this.filterAction);
        return menuItem;
    }

    private JMenuItem createAscendMenuItem(int column) {
        TKFilterMenuItem menuItem = new TKFilterMenuItem(TKRes.instance().getString("Ascend"));
        menuItem.filterText = "";
        menuItem.column = column;
        menuItem.addActionListener(this.ascendAction);
        return menuItem;
    }

    private JMenuItem createDescendMenuItem(int column) {
        TKFilterMenuItem menuItem = new TKFilterMenuItem(TKRes.instance().getString("Descend"));
        menuItem.filterText = "";
        menuItem.column = column;
        menuItem.addActionListener(this.descendAction);
        return menuItem;
    }

    private class FilterAction
    implements ActionListener {
        private FilterAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (null != TKFilterTable.this.getCellEditor()) {
                TKFilterTable.this.getCellEditor().stopCellEditing();
            }
            TKFilterMenuItem menuItem = null;
            try {
                menuItem = (TKFilterMenuItem)e.getSource();
            }
            catch (Exception ex) {
                return;
            }
            int column = menuItem.column;
            String filterText = menuItem.filterText;
            if (column < 0) {
                return;
            }
            TKFilterTable.this.processHeaderCellText(column, filterText);
            ((TKFilterTableModel)TKFilterTable.this.getModel()).filter(column, filterText);
        }
    }

    private class DescendAction
    implements ActionListener {
        private DescendAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (null != TKFilterTable.this.getCellEditor()) {
                TKFilterTable.this.getCellEditor().stopCellEditing();
            }
            TKFilterMenuItem menuItem = null;
            try {
                menuItem = (TKFilterMenuItem)e.getSource();
            }
            catch (Exception ex) {
                return;
            }
            int column = menuItem.column;
            TKFilterTable.this.processHeaderCellDownup(column, -1);
            ((TKFilterTableModel)TKFilterTable.this.getModel()).sortByColumn(column, -1);
        }
    }

    private class AscendAction
    implements ActionListener {
        private AscendAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (null != TKFilterTable.this.getCellEditor()) {
                TKFilterTable.this.getCellEditor().stopCellEditing();
            }
            TKFilterMenuItem menuItem = null;
            try {
                menuItem = (TKFilterMenuItem)e.getSource();
            }
            catch (Exception ex) {
                return;
            }
            int column = menuItem.column;
            TKFilterTable.this.processHeaderCellDownup(column, 1);
            ((TKFilterTableModel)TKFilterTable.this.getModel()).sortByColumn(column, 1);
        }
    }
}

