/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.toolkit.client.base.util.filtertable;

import com.huawei.dc.common.util.DCDebugTracer;
import com.huawei.dc.toolkit.client.base.util.filtertable.TKFilterCellRenderer;
import com.huawei.dc.toolkit.client.base.util.filtertable.TKFilterTable;
import com.huawei.dc.toolkit.client.base.util.filtertable.TKFilterTableModel;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JPopupMenu;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;

public class TKFilterHeaderListener
extends MouseAdapter {
    protected JTableHeader header;
    protected TKFilterTable table;

    public TKFilterHeaderListener(TKFilterTable table) {
        this.table = table;
        this.header = table.getTableHeader();
    }

    private int columnShowX(int column) {
        int width = 0;
        TableColumnModel cm = this.header.getColumnModel();
        for (int i = 0; i < column; ++i) {
            width += cm.getColumn(i).getWidth();
        }
        return width;
    }

    @Override
    public void mousePressed(MouseEvent e) {
        int column = this.header.columnAtPoint(e.getPoint());
        if (!this.table.isColumnRegister(column)) {
            return;
        }
        int type = this.header.getCursor().getType();
        if (type == 10 || type == 11 || (e.getModifiers() & 0x10) == 0) {
            return;
        }
        TableCellRenderer rend = this.header.getTable().getColumnModel().getColumn(column).getHeaderRenderer();
        if (!(rend instanceof TKFilterCellRenderer)) {
            return;
        }
        TKFilterCellRenderer filterRend = (TKFilterCellRenderer)rend;
        filterRend.setPressedColumn(column);
        if (!this.table.isShowControlIcon()) {
            filterRend.setSelectedColumn(column);
        }
        this.header.repaint();
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        int column = this.header.columnAtPoint(e.getPoint());
        if (!this.table.isColumnRegister(column)) {
            this.table.cellRender.setPressedColumn(-1);
            this.header.repaint();
            return;
        }
        TableCellRenderer rend = this.header.getTable().getColumnModel().getColumn(column).getHeaderRenderer();
        TKFilterCellRenderer filterRend = (TKFilterCellRenderer)rend;
        filterRend.setPressedColumn(column);
        filterRend.setPressedColumn(-1);
        this.header.repaint();
        int type = this.header.getCursor().getType();
        if (type == 10 || type == 11 || (e.getModifiers() & 0x10) == 0) {
            return;
        }
        if (!this.table.isShowControlIcon()) {
            if (this.header.getTable().isEditing()) {
                this.header.getTable().getCellEditor().stopCellEditing();
            }
            int sortState = filterRend.getState(column);
            ((TKFilterTableModel)this.table.getModel()).sortByColumn(column, sortState);
            return;
        }
        try {
            JPopupMenu m = this.table.createPopupMenu(column);
            if (m == null) {
                return;
            }
            int xShow = 0;
            if (column > 0) {
                xShow = this.columnShowX(column);
            }
            m.show(this.header, xShow, this.header.getHeight());
            this.table.repaint();
        }
        catch (Exception ex) {
            DCDebugTracer.trace(ex);
        }
    }
}

