/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.toolkit.client.base.util.filtertable;

import com.huawei.dc.toolkit.client.base.util.sorttable.TKSortIcon;
import java.awt.Color;
import java.awt.Component;
import java.awt.Insets;
import java.util.Hashtable;
import javax.swing.JButton;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.table.TableCellRenderer;

public class TKFilterCellRenderer
extends JButton
implements TableCellRenderer {
    private Hashtable showTexts = new Hashtable();
    Hashtable state = new Hashtable();
    private int pressedColumn = -1;
    private int sortColumn = -1;

    private JButton createButton() {
        JButton button = new JButton();
        button.setMargin(new Insets(0, 0, 0, 0));
        button.setHorizontalTextPosition(2);
        button.setBorder(UIManager.getBorder("TableHeader.cellBorder"));
        return button;
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        JButton button = this.createButton();
        Object obj = this.showTexts.get(column);
        if (obj != null && obj.toString().trim().length() > 0) {
            button.setText(obj.toString());
            button.setForeground(Color.BLUE);
        } else {
            button.setText(value == null ? "" : value.toString());
            button.setForeground(UIManager.getColor("Button.foreground"));
        }
        button.setIcon(TKSortIcon.ICON_NONE);
        Object objSate = this.state.get(column);
        if (objSate != null) {
            if ((Integer)objSate == -1) {
                button.setIcon(TKSortIcon.ICON_DOWN);
            } else if ((Integer)objSate == 1) {
                button.setIcon(TKSortIcon.ICON_UP);
            }
        }
        button.getModel().setPressed(column == this.pressedColumn);
        button.getModel().setArmed(column == this.pressedColumn);
        return button;
    }

    public void setShowText(int column, String text) {
        this.showTexts.put(column, text);
    }

    public void setSortColumnState(int column, int sortState) {
        this.state.clear();
        this.sortColumn = column;
        if (sortState == 0) {
            this.sortColumn = -1;
        } else {
            this.state.put(column, sortState);
        }
    }

    public int getSortColumn() {
        return this.sortColumn;
    }

    public int getState(int col) {
        Object obj = this.state.get(col);
        int retValue = obj == null ? 0 : ((Integer)obj == -1 ? -1 : 1);
        return retValue;
    }

    public void setPressedColumn(int col) {
        this.pressedColumn = col;
    }

    public void setSelectedColumn(int col) {
        if (col < 0) {
            return;
        }
        Integer value = null;
        Object obj = this.state.get(col);
        value = obj == null ? new Integer(-1) : ((Integer)obj == -1 ? new Integer(1) : new Integer(-1));
        this.state.clear();
        this.state.put(new Integer(col), value);
    }

    public void clearSortFlag() {
        this.state.clear();
    }

    public void clearFilterFlag() {
        this.showTexts.clear();
    }
}

