/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.toolkit.client.base.util.filechooser;

import com.huawei.dc.common.util.DCDebugTracer;
import com.huawei.dc.toolkit.client.base.communicate.TKCommUtility;
import com.huawei.dc.toolkit.client.base.communicate.TKCommandResult;
import com.huawei.dc.toolkit.client.base.util.TKFile;
import com.huawei.dc.toolkit.client.base.util.TKRes;
import com.huawei.dc.toolkit.client.base.util.TKResourceManager;
import com.huawei.dc.toolkit.client.base.util.TKScreenToolKit;
import com.huawei.dc.toolkit.client.base.util.filechooser.TKDefaultFileModel;
import com.huawei.dc.toolkit.client.base.util.operresult.TKOperationShowMgr;
import com.huawei.dc.toolkit.client.base.util.resource.TKErrorCodeRes;
import com.huawei.te.toolkit.AsnSingleReturn;
import com.huawei.te.toolkit.AsnToolkitFileBrowseReq;
import com.huawei.te.toolkit.AsnToolkitFileBrowseRsp;
import com.huawei.te.toolkit.AsnToolkitFileBrowseRspSeqOf;
import com.huawei.te.toolkit.AsnToolkitFileBrowseRspSeqOf1;
import com.huawei.te.toolkit.AsnToolkitFileCreateReq;
import com.huawei.te.toolkit.AsnToolkitFileInfo;
import java.awt.Component;
import java.io.File;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.Vector;
import net.commustru.fstru.FStruct;

public class TKToolkitFileModel
extends TKDefaultFileModel {
    private TKErrorCodeRes errorRes = TKErrorCodeRes.instance();
    private TKRes res = TKRes.instance();
    int fileBrowseType = 102;
    private String ftpServer = "";
    private int ftpPort = 0;
    private String ftpUser = "";
    private String ftpPass = "";
    public static final String PROPERTY_SERVER = "1";
    public static final String PROPERTY_PORT = "2";
    public static final String PROPERTY_USER = "3";
    public static final String PROPERTY_PASSWD = "4";

    public TKToolkitFileModel(int fileBrowseType) {
        this.fileBrowseType = fileBrowseType;
    }

    public boolean firePropertyChange(String property, String newValue) {
        if (property.equals(PROPERTY_SERVER)) {
            this.ftpServer = newValue;
        } else if (property.equals(PROPERTY_PORT)) {
            try {
                this.ftpPort = Integer.parseInt(newValue);
            }
            catch (Exception ex) {
                return false;
            }
        } else if (property.equals(PROPERTY_USER)) {
            this.ftpUser = newValue;
        } else if (property.equals(PROPERTY_PASSWD)) {
            this.ftpPass = newValue;
        } else {
            return false;
        }
        return true;
    }

    public String getProperty(String property) {
        if (property.equals(PROPERTY_SERVER)) {
            return this.ftpServer;
        }
        if (property.equals(PROPERTY_PORT)) {
            return String.valueOf(this.ftpPort);
        }
        if (property.equals(PROPERTY_USER)) {
            return this.ftpUser;
        }
        if (property.equals(PROPERTY_PASSWD)) {
            return this.ftpPass;
        }
        return "";
    }

    public void setBrowseType(int fileBrowseType) {
        this.fileBrowseType = fileBrowseType;
    }

    public int getBrowseType() {
        return this.fileBrowseType;
    }

    @Override
    public TKFile[] listRoot(TKFile tkFile) {
        if (this.fileBrowseType == 102) {
            return super.listRoot(tkFile);
        }
        return this.listToolkitRoot(tkFile);
    }

    @Override
    public TKFile[] listFiles(TKFile tkFile, boolean isIgnoreError) {
        if (this.fileBrowseType == 102) {
            return super.listFiles(tkFile, isIgnoreError);
        }
        return this.listToolkitFiles(tkFile, isIgnoreError);
    }

    public TKFile[] listToolkitFiles(TKFile tkFile, boolean isIgnoreError) {
        Object[] files = null;
        AsnToolkitFileBrowseReq req = new AsnToolkitFileBrowseReq();
        req.dir = tkFile.getPath().getBytes();
        req.ftpInfo.ip = this.ftpServer.getBytes();
        req.ftpInfo.userName = this.ftpUser.getBytes();
        req.ftpInfo.userPwd = this.ftpPass.getBytes();
        req.ftpInfo.port = BigInteger.valueOf(this.ftpPort);
        char cmdCode = '\u1701';
        if (this.fileBrowseType == 100) {
            cmdCode = '\u1702';
        }
        AsnToolkitFileBrowseRsp rsp = new AsnToolkitFileBrowseRsp();
        byte receiveModule1 = 23;
        TKScreenToolKit.setComponentCursorBusy(TKResourceManager.getMainFrame(), true);
        TKCommandResult ret = TKCommUtility.sendCommand((FStruct)req, (FStruct)rsp, cmdCode, receiveModule1, 120);
        TKScreenToolKit.setComponentCursorBusy(TKResourceManager.getMainFrame(), false);
        if (!ret.isSuccess) {
            TKOperationShowMgr.showOperationDlg((Component)TKResourceManager.getMainFrame(), ret.resultInfo, false);
            return null;
        }
        if (!rsp.ret.isSuccess && !isIgnoreError) {
            TKOperationShowMgr.showOperationDlg((Component)TKResourceManager.getMainFrame(), TKRes.getErrorInfo(rsp.ret), false);
            return null;
        }
        String directory = new String(rsp.dir);
        directory = (directory = directory.replace(File.separator.toCharArray()[0], "/".toCharArray()[0])).endsWith("/") ? directory : directory + "/";
        AsnToolkitFileBrowseRspSeqOf fileSeq = rsp.fileList;
        if (null == fileSeq || fileSeq.size() == 0) {
            if (rsp.ret.isSuccess) {
                files = new TKFile[]{new TKFile(directory + "tkfile")};
                ((TKFile)files[0]).isHidden(true);
            }
            return files;
        }
        files = new TKFile[rsp.fileList.size()];
        for (int i = 0; i < fileSeq.size(); ++i) {
            AsnToolkitFileInfo file = (AsnToolkitFileInfo)fileSeq.get(i);
            TKFile tkfile = new TKFile(directory + new String(file.fileName), file.type.intValue());
            try {
                tkfile.size = Long.parseLong(new String(file.length));
            }
            catch (Exception ex) {
                DCDebugTracer.trace(ex);
            }
            tkfile.modified = new String(file.time);
            if (null == files) continue;
            files[i] = tkfile;
        }
        if (files != null) {
            Arrays.sort(files);
        }
        return files;
    }

    public TKFile[] listToolkitRoot(TKFile tkFile) {
        AsnToolkitFileBrowseReq req = new AsnToolkitFileBrowseReq();
        req.dir = tkFile != null ? tkFile.getPath().getBytes() : "".getBytes();
        req.ftpInfo.ip = this.ftpServer.getBytes();
        req.ftpInfo.userName = this.ftpUser.getBytes();
        req.ftpInfo.userPwd = this.ftpPass.getBytes();
        req.ftpInfo.port = BigInteger.valueOf(this.ftpPort);
        char cmdCode = '\u1701';
        if (this.fileBrowseType == 100) {
            cmdCode = '\u1702';
        }
        AsnToolkitFileBrowseRsp rsp = new AsnToolkitFileBrowseRsp();
        byte receiveModule1 = 23;
        TKScreenToolKit.setComponentCursorBusy(TKResourceManager.getMainFrame(), true);
        TKCommandResult ret = TKCommUtility.sendCommand((FStruct)req, (FStruct)rsp, cmdCode, receiveModule1, 120);
        TKScreenToolKit.setComponentCursorBusy(TKResourceManager.getMainFrame(), false);
        if (!ret.isSuccess) {
            TKOperationShowMgr.showOperationDlg((Component)TKResourceManager.getMainFrame(), ret.resultInfo, false);
            return null;
        }
        AsnToolkitFileBrowseRspSeqOf1 rootSeq = rsp.rootList;
        AsnToolkitFileBrowseRspSeqOf fileSeq = rsp.fileList;
        if (null == rootSeq) {
            return null;
        }
        Object[] roots = new TKFile[rsp.rootList.size()];
        for (int i = 0; i < rootSeq.size(); ++i) {
            String root = new String((byte[])rootSeq.get(i));
            root = root.replace(File.separator.toCharArray()[0], "/".toCharArray()[0]);
            TKFile tkfile = new TKFile(root, 1, true, "Drive");
            tkfile.size = 0L;
            tkfile.modified = "";
            if (null == roots) continue;
            roots[i] = tkfile;
        }
        String directory = new String(rsp.dir);
        directory = (directory = directory.replace(File.separator.toCharArray()[0], "/".toCharArray()[0])).endsWith("/") ? directory : directory + "/";
        Object[] files = null;
        if (null == fileSeq || fileSeq.size() == 0) {
            if (rsp.ret.isSuccess) {
                files = new TKFile[]{new TKFile(directory + "tkfile")};
                ((TKFile)files[0]).isHidden(true);
            }
        } else {
            files = new TKFile[fileSeq.size()];
            for (int i = 0; i < fileSeq.size(); ++i) {
                AsnToolkitFileInfo file = (AsnToolkitFileInfo)fileSeq.get(i);
                TKFile tkfile = new TKFile(directory + new String(file.fileName), file.type.intValue());
                try {
                    tkfile.size = Long.parseLong(new String(file.length));
                }
                catch (Exception ex) {
                    DCDebugTracer.trace(ex);
                }
                tkfile.modified = new String(file.time);
                files[i] = tkfile;
            }
        }
        Vector<Object> all = new Vector<Object>();
        if (roots != null) {
            Arrays.sort(roots);
            all.addAll(Arrays.asList(roots));
        }
        if (files != null) {
            Arrays.sort(files);
            all.addAll(Arrays.asList(files));
        }
        TKFile[] allFiles = new TKFile[all.size()];
        all.toArray(allFiles);
        return allFiles;
    }

    @Override
    public boolean mkDir(String path, String newDir) {
        String createPath;
        if (this.fileBrowseType == 102) {
            return super.mkDir(path, newDir);
        }
        String string = createPath = path.endsWith("/") ? path : path + "/";
        if (this.fileBrowseType == 102) {
            return super.mkDir(createPath, newDir);
        }
        AsnToolkitFileCreateReq req = new AsnToolkitFileCreateReq();
        req.dir = createPath.getBytes();
        req.newDir = (createPath + newDir).getBytes();
        req.ftpInfo.ip = this.ftpServer.getBytes();
        req.ftpInfo.userName = this.ftpUser.getBytes();
        req.ftpInfo.userPwd = this.ftpPass.getBytes();
        req.ftpInfo.port = BigInteger.valueOf(this.ftpPort);
        char cmdCode = '\u1704';
        if (this.fileBrowseType == 100) {
            cmdCode = '\u1703';
        }
        AsnSingleReturn rsp = new AsnSingleReturn();
        byte receiveModule1 = 23;
        TKScreenToolKit.setComponentCursorBusy(TKResourceManager.getMainFrame(), true);
        TKCommandResult ret = TKCommUtility.sendCommand((FStruct)req, (FStruct)rsp, cmdCode, receiveModule1, 120);
        TKScreenToolKit.setComponentCursorBusy(TKResourceManager.getMainFrame(), false);
        if (!ret.isSuccess) {
            TKOperationShowMgr.showOperationDlg((Component)TKResourceManager.getMainFrame(), ret.resultInfo, false);
            return false;
        }
        if (!rsp.isSuccess) {
            TKOperationShowMgr.showOperationDlg((Component)TKResourceManager.getMainFrame(), TKRes.getErrorInfo(rsp), false);
        }
        return rsp.isSuccess;
    }
}

