/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.toolkit.client.base.util.filechooser;

import com.huawei.dc.common.framework.system.SystemManager;
import com.huawei.dc.common.util.DCDebugTracer;
import com.huawei.dc.toolkit.client.base.communicate.TKCommUtility;
import com.huawei.dc.toolkit.client.base.util.TKCommonUtil;
import com.huawei.dc.toolkit.client.base.util.TKFile;
import com.huawei.dc.toolkit.client.base.util.TKFileUtilities;
import com.huawei.dc.toolkit.client.base.util.TKResourceManager;
import com.huawei.dc.toolkit.client.base.util.TKScreenToolKit;
import com.huawei.dc.toolkit.client.base.util.TKTextChangeAdapter;
import com.huawei.dc.toolkit.client.base.util.component.TKButton;
import com.huawei.dc.toolkit.client.base.util.component.TKComboBoxUI;
import com.huawei.dc.toolkit.client.base.util.component.TKComponentToolkit;
import com.huawei.dc.toolkit.client.base.util.component.TKInputDialog;
import com.huawei.dc.toolkit.client.base.util.component.TKTextField;
import com.huawei.dc.toolkit.client.base.util.filechooser.TKDefaultFileModel;
import com.huawei.dc.toolkit.client.base.util.filechooser.TKFileChooseUIDef;
import com.huawei.dc.toolkit.client.base.util.filechooser.TKFileChooser;
import com.huawei.dc.toolkit.client.base.util.filechooser.TKFileFilter;
import com.huawei.dc.toolkit.client.base.util.filechooser.TKFileModel;
import com.huawei.dc.toolkit.client.base.util.operresult.TKConfirmDialog;
import com.huawei.dc.toolkit.client.base.util.operresult.TKOperationShowMgr;
import com.huawei.dc.toolkit.client.base.util.sorttable.TKDataSort;
import com.huawei.dc.toolkit.client.base.util.sorttable.TKSortTable;
import com.huawei.dc.toolkit.client.base.util.sorttable.TKTableSortInterface;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Stack;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.AbstractListModel;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.ListModel;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.text.Position;

public class TKFileChooserUI
extends TKFileChooseUIDef {
    private Dialog parentWin;
    private UpFolderAction upFolderAction = new UpFolderAction();
    private ApproveSelectionAction approveSelectionAction = new ApproveSelectionAction();
    private DirectoryComboBoxAction directoryComboBoxAction = new DirectoryComboBoxAction();
    private FilterComboBoxAction filterComboBoxAction = new FilterComboBoxAction();
    private NewFolderAction newFolderAction = new NewFolderAction();
    private DoubleClickListener doubleClickListener = new DoubleClickListener();
    private FileSelectionListener fileSelectionListener = new FileSelectionListener();
    private GoHomeAction goHomeAction = new GoHomeAction();
    private RefreshAction refreshAction = new RefreshAction();
    private BackAction backAction = new BackAction();
    private ViewButtonListener viewButtonListener = new ViewButtonListener();
    boolean isFileNameChg = false;
    boolean isFtpConnected = false;
    private Stack directoriesFtp = new Stack();
    private Stack directoriesNormal = new Stack();
    private boolean isSaveAsOpr = false;
    private TKTextChangeAdapter tkTextChangeAdapter = new TKTextChangeAdapter(){

        @Override
        public void onChanged() {
            TKFileChooserUI.this.isFileNameChg = true;
        }
    };
    TKFile currentTlkDir = new TKFile("");
    TKFile currentFtpDir = new TKFile("/");
    TKFile currentNorDir = new TKFile("");
    TKFile[] rootDirs;
    TKFile[] allFiles;
    TKFile[] selectedFiles;
    boolean isDirectorySelected = false;
    private TKFileChooser tkFileChooser;
    private TKFileModel fileModel;
    TKFileFilter curFileFilter;
    TKFileFilter[] filters;
    boolean isShowDetail = false;
    boolean isSave = false;
    private Hashtable iconCache = new Hashtable();
    private KeyAdapter listKeyAdp = new KeyAdapter(){

        @Override
        public void keyPressed(KeyEvent e) {
            this.keyTyped(e);
        }

        @Override
        public void keyTyped(KeyEvent e) {
            int i;
            int size;
            if (e.getKeyCode() == 0) {
                return;
            }
            String typeChar = String.valueOf(e.getKeyChar());
            int selectIndex = TKFileChooserUI.this.jList.getSelectedIndex();
            if (selectIndex == (size = TKFileChooserUI.this.jList.getModel().getSize()) - 1) {
                selectIndex = -1;
            }
            boolean hasCatch = false;
            TKFile aimFile = null;
            for (i = selectIndex + 1; i < size; ++i) {
                aimFile = (TKFile)TKFileChooserUI.this.jList.getModel().getElementAt(i);
                if (!aimFile.getName().toLowerCase().startsWith(typeChar.toLowerCase())) continue;
                TKFileChooserUI.this.jList.setSelectionInterval(i, i);
                TKFileChooserUI.this.jList.scrollRectToVisible(TKFileChooserUI.this.jList.getCellBounds(i, i));
                hasCatch = true;
                break;
            }
            if (!hasCatch) {
                for (i = 0; i < selectIndex; ++i) {
                    aimFile = (TKFile)TKFileChooserUI.this.jList.getModel().getElementAt(i);
                    if (!aimFile.getName().toLowerCase().startsWith(typeChar.toLowerCase())) continue;
                    TKFileChooserUI.this.jList.setSelectionInterval(i, i);
                    TKFileChooserUI.this.jList.scrollRectToVisible(TKFileChooserUI.this.jList.getCellBounds(i, i));
                    break;
                }
            }
        }
    };
    private KeyAdapter detailKeyAdp = new KeyAdapter(){

        @Override
        public void keyPressed(KeyEvent e) {
            this.keyTyped(e);
        }

        @Override
        public void keyTyped(KeyEvent e) {
            int i;
            int size;
            if (e.getKeyCode() == 0) {
                return;
            }
            String typeChar = String.valueOf(e.getKeyChar());
            int selectIndex = TKFileChooserUI.this.detailTable.getSelectedRow();
            if (selectIndex == (size = TKFileChooserUI.this.detailTable.getRowCount()) - 1) {
                selectIndex = -1;
            }
            boolean hasCatch = false;
            TKFile aimFile = null;
            for (i = selectIndex + 1; i < size; ++i) {
                aimFile = (TKFile)TKFileChooserUI.this.detailTable.getValueAt(i, 0);
                if (!aimFile.getName().toLowerCase().startsWith(typeChar.toLowerCase())) continue;
                TKFileChooserUI.this.detailTable.setRowSelectionInterval(i, i);
                TKFileChooserUI.this.detailTable.scrollRectToVisible(TKFileChooserUI.this.detailTable.getCellRect(i, 0, true));
                hasCatch = true;
                break;
            }
            if (!hasCatch) {
                for (i = 0; i < selectIndex; ++i) {
                    aimFile = (TKFile)TKFileChooserUI.this.detailTable.getValueAt(i, 0);
                    if (!aimFile.getName().toLowerCase().startsWith(typeChar.toLowerCase())) continue;
                    TKFileChooserUI.this.detailTable.setRowSelectionInterval(i, i);
                    TKFileChooserUI.this.detailTable.scrollRectToVisible(TKFileChooserUI.this.detailTable.getCellRect(i, 0, true));
                    break;
                }
            }
        }
    };

    public TKFileChooserUI() {
        this.fileModel = new TKDefaultFileModel();
    }

    public TKFileChooserUI(TKFileModel fileModel) {
        this.fileModel = fileModel;
    }

    private boolean isReadyDo(boolean notice) {
        if (!this.isFtpConnected && this.tkFileChooser.getBrowseType() == 100) {
            if (notice) {
                TKOperationShowMgr.showOperationDlg((Component)TKResourceManager.getMainFrame(), this.res.getString("PleaseConnectFTPFirst"), false);
            }
            return false;
        }
        return true;
    }

    public void saveFile() {
        this.isSave = true;
    }

    public void setSaveAsOpr(boolean bvalue) {
        this.isSaveAsOpr = bvalue;
    }

    public TKFile[] fileList() {
        return this.allFiles;
    }

    public TKFile[] rootList() {
        return this.rootDirs;
    }

    public void clear() {
        this.listModel.clear();
        this.rootDirs = null;
        this.dirComboxModel.removeAllItems();
        this.detailTableModel.setRowCount(0);
        this.detailTableModel.clear();
        this.backButton.setEnabled(false);
        this.fileNameTextField.setText("");
        this.dirCombox.updateUI();
        this.detailTable.repaint();
    }

    public void updateRootList(TKFile[] roots) {
        this.rootDirs = roots;
    }

    public void notifyFtpConnected(boolean isFtpConnected) {
        this.isFtpConnected = isFtpConnected;
    }

    public void updateFileList(TKFile[] files, TKFile path) {
        this.listModel.clear();
        this.dirComboxModel.removeAllItems();
        this.detailTableModel.setRowCount(0);
        this.detailTableModel.clear();
        this.backButton.setEnabled(false);
        if (path != null) {
            this.dirComboxModel.addItem(path);
            this.setCurrentDirectory(path);
        }
        this.listDirectory(files);
    }

    public void setFileChooser(TKFileChooser fc) {
        this.tkFileChooser = fc;
    }

    public void setCurrentDirectory(TKFile curDir, int browseType) {
        TKFile _curDir = curDir;
        String strRootPath = null;
        if (null != TKCommonUtil.getRootPath()) {
            strRootPath = TKCommonUtil.getRootPath();
        } else {
            SystemManager oSystemManager = new SystemManager();
            strRootPath = oSystemManager.getSystemRootDirectory();
        }
        if (!TKFileUtilities.lastToolkitPath.toString().contains(strRootPath) && browseType == 100) {
            _curDir = new TKFile(strRootPath, 1, true, "Drive");
        }
        if (_curDir.isFile() && !this.isCurpathSameWithRootpath(_curDir.getPath(), strRootPath)) {
            _curDir = TKFileUtilities.getParent(curDir);
        }
        if (browseType == 100) {
            this.currentFtpDir = curDir;
        } else if (browseType == 101) {
            this.currentTlkDir = _curDir;
        } else {
            this.currentNorDir = _curDir;
        }
    }

    public boolean isCurpathSameWithRootpath(String curPath, String rootPath) {
        if ('/' != curPath.charAt(curPath.length() - 1)) {
            curPath = curPath + "/";
        }
        if (curPath.contains("\\")) {
            curPath.replace('/', '\\');
        }
        if ('/' != rootPath.charAt(rootPath.length() - 1)) {
            rootPath = rootPath + "/";
        }
        if (rootPath.contains("\\")) {
            rootPath.replace('/', '\\');
        }
        return rootPath.equals(curPath);
    }

    public void setCurrentDirectory(TKFile curDir) {
        int brwType = this.tkFileChooser.getBrowseType();
        this.pushDirectory(curDir);
        this.setCurrentDirectory(curDir, brwType);
    }

    public TKFile getCurrentDirectory() {
        int brwType = this.tkFileChooser.getBrowseType();
        if (brwType == 100) {
            return this.currentFtpDir;
        }
        if (brwType == 101) {
            return this.currentTlkDir;
        }
        return this.currentNorDir;
    }

    public TKFile containsFile(String fileName) {
        for (int i = 0; i < this.allFiles.length; ++i) {
            TKFile f = this.allFiles[i];
            if (!f.getName().equalsIgnoreCase(fileName.trim())) continue;
            return f;
        }
        return null;
    }

    public TKFile containsDirectory(String dirName) {
        for (int i = 0; i < this.listModel.getSize(); ++i) {
            TKFile f = (TKFile)this.listModel.getElementAt(i);
            if (f.isFile() || !f.getName().equalsIgnoreCase(dirName.trim())) continue;
            return f;
        }
        return null;
    }

    private TKFile[] parseRootDirectory(TKFile[] files, Vector outFiles) {
        if (files == null || files.length == 0) {
            return null;
        }
        Vector<TKFile> root = new Vector<TKFile>();
        for (int i = 0; i < files.length; ++i) {
            if (files[i].isRoot()) {
                root.add(files[i]);
                continue;
            }
            outFiles.add(files[i]);
        }
        Object[] roots = new TKFile[root.size()];
        root.copyInto(roots);
        return roots;
    }

    public void setFileModel(TKFileModel fileModel) {
        this.fileModel = fileModel;
    }

    public TKFileModel getFileModel() {
        return this.fileModel;
    }

    public JPanel getFileChooserUI() {
        this.mainPanel.setPreferredSize(new Dimension(100, 30));
        return this.mainPanel;
    }

    public boolean setup(TKFileChooser tkFileChooser) {
        this.tkFileChooser = tkFileChooser;
        TKFile curFile = this.getCurrentDirectory();
        if (curFile == null) {
            curFile = new TKFile("");
        }
        TKFile[] files = this.fileModel.listRoot(curFile);
        Vector fileList = new Vector();
        if (files == null || files.length <= 0) {
            return false;
        }
        this.rootDirs = this.parseRootDirectory(files, fileList);
        this.filters = tkFileChooser.getFilters();
        int iSize = 0;
        if (null != this.filters) {
            iSize = this.filters.length;
        }
        if (this.filters != null && iSize > 0) {
            this.curFileFilter = null == this.filters[0] ? this.filters[iSize - 1] : this.filters[0];
        }
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            DCDebugTracer.trace(ex);
        }
        if (this.rootDirs != null && this.rootDirs.length > 0) {
            int brwType = tkFileChooser.getBrowseType();
            if (brwType == 101) {
                this.dirCombox.setEnabled(false);
            } else if (brwType == 100) {
                this.dirCombox.setEnabled(false);
                this.dirComboxModel.addItem(this.rootDirs[0]);
                this.setCurrentDirectory(this.rootDirs[0]);
            } else {
                if (brwType == 102 || this.isSaveAsOpr) {
                    this.dirCombox.setEnabled(true);
                    this.isSaveAsOpr = false;
                } else {
                    this.dirCombox.setEnabled(false);
                }
                this.dirComboxModel.addItem(this.rootDirs[0]);
                this.setCurrentDirectory(this.rootDirs[0]);
            }
        }
        if (fileList.size() > 0) {
            TKFile upPath;
            if (tkFileChooser.getBrowseType() == 100) {
                this.notifyFtpConnected(true);
            }
            Object[] tfs = new TKFile[fileList.size()];
            fileList.copyInto(tfs);
            if (tfs != null && tfs.length > 0 && (upPath = TKFileUtilities.getParent((TKFile)tfs[0])) != null) {
                this.setCurrentDirectory(upPath);
                this.dirComboxModel.addItem(upPath);
            }
            this.listDirectory((TKFile[])tfs);
        }
        this.grabFocus();
        this.directoriesFtp.clear();
        this.directoriesNormal.clear();
        this.pushDirectory(this.getCurrentDirectory());
        this.backButton.setEnabled(false);
        return true;
    }

    public void update() {
        this.listModel.clear();
        this.dirComboxModel.removeAllItems();
        this.detailTableModel.setRowCount(0);
        this.detailTableModel.clear();
        this.directoriesFtp.clear();
        this.directoriesNormal.clear();
        this.backButton.setEnabled(false);
        TKFile curFile = this.getCurrentDirectory();
        TKFile[] files = this.fileModel.listRoot(curFile);
        if (files != null && files.length > 0) {
            Vector fileList = new Vector();
            this.rootDirs = this.parseRootDirectory(files, fileList);
            if (this.rootDirs != null && this.rootDirs.length > 0) {
                this.dirComboxModel.addItem(this.rootDirs[0]);
                this.setCurrentDirectory(this.rootDirs[0]);
            }
            if (fileList.size() > 0) {
                if (this.tkFileChooser.getBrowseType() == 100) {
                    this.notifyFtpConnected(true);
                }
                Object[] tfs = new TKFile[fileList.size()];
                fileList.copyInto(tfs);
                if (tfs != null && tfs.length > 0 && !TKFileUtilities.getParent((TKFile)tfs[0]).equals(this.getCurrentDirectory())) {
                    this.setCurrentDirectory(TKFileUtilities.getParent((TKFile)tfs[0]));
                    this.dirComboxModel.addItem(this.getCurrentDirectory());
                }
                this.listDirectory((TKFile[])tfs);
            }
        }
        this.fileNameTextField.setText("");
    }

    private void grabFocus() {
        if (this.isShowDetail) {
            if (this.detailTable != null) {
                this.detailTable.requestFocus();
            }
        } else if (this.jList != null) {
            this.jList.getLeadSelectionIndex();
            if (this.listModel.size() > 0) {
                this.jList.requestFocus();
            }
        }
    }

    private void jbInit() throws Exception {
        this.installIcons();
        this.installStrings();
        this.installComponents();
        this.installPopupMenu();
        this.detailTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                TKFileChooserUI.this.checkMouseOnDetailTable(e);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                TKFileChooserUI.this.checkMouseOnDetailTable(e);
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                TKFileChooserUI.this.checkMouseOnDetailTable(e);
            }
        });
        this.jList.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                TKFileChooserUI.this.checkMouseOnList(e);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                TKFileChooserUI.this.checkMouseOnList(e);
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                TKFileChooserUI.this.checkMouseOnList(e);
            }
        });
        this.tkTextChangeAdapter.addTextComponent(this.fileNameTextField);
    }

    private void checkMenuEnable() {
        this.backAction.setEnabled(this.backButton.isEnabled());
        this.goHomeAction.setEnabled(this.homeFolderButton.isEnabled());
        this.upFolderAction.setEnabled(this.upFolderButton.isEnabled());
        this.refreshAction.setEnabled(this.refreshBotton.isEnabled());
        this.newFolderAction.setEnabled(this.newdirButton.isEnabled());
    }

    private void checkMouseOnDetailTable(MouseEvent e) {
        Point p = e.getPoint();
        if (e.isPopupTrigger()) {
            this.checkMenuEnable();
            Point point = TKScreenToolKit.getPopupMenuShowupPosition(this.detailTable, this.popupMenu, p.x, p.y);
            this.popupMenu.show(this.detailTable, point.x, point.y);
        }
    }

    private void checkMouseOnList(MouseEvent e) {
        Point p = e.getPoint();
        if (e.isPopupTrigger()) {
            this.checkMenuEnable();
            Point point = TKScreenToolKit.getPopupMenuShowupPosition(this.jList, this.popupMenu, p.x, p.y);
            this.popupMenu.show(this.jList, point.x, point.y);
        }
    }

    private void pushDirectory(TKFile dir) {
        Stack directories = this.directoriesFtp;
        if (dir == null) {
            return;
        }
        int brwType = this.tkFileChooser.getBrowseType();
        if (brwType != 100) {
            directories = this.directoriesNormal;
        } else if (!this.isFtpConnected) {
            return;
        }
        if (!directories.empty()) {
            TKFile peekDir = (TKFile)directories.peek();
            TKFile currPath = this.getCurrentDirectory();
            if (peekDir.equals(dir)) {
                return;
            }
            if (!(directories.size() <= 0 && peekDir.equals(currPath) || this.backButton == null)) {
                this.backButton.setEnabled(true);
            }
        }
        directories.push(dir);
    }

    private TKFile popDirectory() {
        TKFile peekDir = null;
        Stack directories = this.directoriesFtp;
        int brwType = this.tkFileChooser.getBrowseType();
        if (brwType != 100) {
            directories = this.directoriesNormal;
        }
        if (!directories.empty()) {
            try {
                peekDir = (TKFile)directories.pop();
                if (peekDir == this.getCurrentDirectory()) {
                    peekDir = (TKFile)directories.pop();
                }
            }
            catch (Exception ex) {
                DCDebugTracer.trace(ex);
            }
        }
        if (directories.empty() && this.backButton != null) {
            this.backButton.setEnabled(false);
        }
        return peekDir;
    }

    protected boolean updateCurrentDirectory(TKFile f) {
        TKFile tempFile;
        TKFile[] tfs;
        boolean isSucc = false;
        if (f == null) {
            return isSucc;
        }
        if (f.isFile() && TKFileUtilities.getParent(f) != null) {
            f = new TKFile(TKFileUtilities.getParent(f).getPath(), 1);
        }
        if ((tfs = this.listFiles(tempFile = f, false)) == null) {
            if (!this.isSave && TKCommUtility.isConnected()) {
                if (this.tkFileChooser.getBrowseType() == 102) {
                    TKOperationShowMgr.showOperationDlg((Component)TKResourceManager.getMainFrame(), this.res.getString("DirectoryInexistent"), false);
                    this.dirComboxModel.addItem(this.getCurrentDirectory());
                    return false;
                }
                tfs = this.listFiles(this.getCurrentDirectory(), true);
            } else {
                if (this.isSave) {
                    TKOperationShowMgr.showOperationDlg((Component)TKResourceManager.getMainFrame(), this.res.getString("DirectoryInexistent"), false);
                    this.dirComboxModel.addItem(this.getCurrentDirectory());
                    return false;
                }
                TKOperationShowMgr.showOperationDlg((Component)TKResourceManager.getMainFrame(), this.res.getString("TKComm_Fail"), false);
                this.dirComboxModel.addItem(this.getCurrentDirectory());
                return false;
            }
        }
        if (tfs == null) {
            return false;
        }
        if (tfs != null && tfs.length > 0) {
            TKFile prtF = TKFileUtilities.getParent(tfs[0]);
            if (prtF != null && !prtF.isHidden()) {
                this.setCurrentDirectory(prtF);
            } else {
                this.setCurrentDirectory(tempFile);
            }
            this.dirComboxModel.addItem(this.getCurrentDirectory());
        }
        this.listDirectory(tfs);
        return isSucc;
    }

    private TKFile[] listFiles(TKFile tkFile, boolean isNeglectErr) {
        return this.listFiles(tkFile, isNeglectErr, true);
    }

    private TKFile[] listFiles(TKFile tkFile, boolean isNeglectErr, boolean isLockUI) {
        if (isLockUI) {
            TKScreenToolKit.setComponentCursorBusy(this.tkFileChooser.getDialog(), true);
        }
        TKFile[] fs = this.fileModel.listFiles(tkFile, isNeglectErr);
        if (isLockUI) {
            TKScreenToolKit.setComponentCursorBusy(this.tkFileChooser.getDialog(), false);
        }
        if (fs != null && this.tkFileChooser.getBrowseType() == 100) {
            this.notifyFtpConnected(true);
        }
        return fs;
    }

    private void installIcons() {
        this.iconOfDirectory = UIManager.getIcon("FileView.directoryIcon");
        this.iconOfBack = TKResourceManager.getIcon("backFC.gif");
        this.iconOfComputer = UIManager.getIcon("FileView.computerIcon");
        this.iconOfFile = UIManager.getIcon("FileView.fileIcon");
        this.iconOfHardDrive = UIManager.getIcon("FileView.hardDriveIcon");
        this.iconOfNewFolder = UIManager.getIcon("FileChooser.newFolderIcon");
        this.iconOfFloppyDrive = UIManager.getIcon("FileView.floppyDriveIcon");
        this.iconOfHomeFolder = TKResourceManager.getIcon("rootFC.gif");
        this.iconOfUpFolder = TKResourceManager.getIcon("upFC.gif");
        this.iconOfDetailView = UIManager.getIcon("FileChooser.detailsViewIcon");
        this.iconOfRefresh = TKResourceManager.getIcon("refreshFile.gif");
        this.iconOfListView = UIManager.getIcon("FileChooser.listViewIcon");
    }

    private void installStrings() {
        Locale.getDefault();
        this.lookInLabelMnemonic = UIManager.getInt("FileChooser.lookInLabelMnemonic");
        this.lookInLabelText = this.res.getString("lookInLabelText");
        if (this.isSave) {
            this.lookInLabelText = this.res.getString("SaveTo");
        }
        this.fileNameLabelMnemonic = UIManager.getInt("FileChooser.fileNameLabelMnemonic");
        this.fileNameLabelText = this.res.getString("fileNameLabelText");
        this.filesOfTypeLabelMnemonic = UIManager.getInt("FileChooser.filesOfTypeLabelMnemonic");
        this.filesOfTypeLabelText = this.res.getString("filesOfTypeLabelText");
        this.fileNameLabelMnemonic = UIManager.getInt("FileChooser.fileNameLabelMnemonic");
        this.fileNameLabelText = this.res.getString("fileNameLabelText");
        this.saveOfTypeLabelText = this.res.getString("SaveLabelText");
        this.cancelButtonText = this.res.getString("cancelButtonText");
        this.approveButtonText = this.res.getString("OpenButtonText");
        this.saveButtonText = this.res.getString("SaveButtonText");
        this.fileNameHeaderText = this.res.getString("fileNameHeaderText");
        this.fileSizeHeaderText = this.res.getString("fileSizeHeaderText");
        this.fileTypeHeaderText = this.res.getString("fileTypeHeaderText");
        this.fileDateHeaderText = this.res.getString("fileDateHeaderText");
        this.listViewButtonToolTipText = this.res.getString("listViewButtonToolTipText");
        this.detailsViewButtonToolTipText = this.res.getString("detailsViewButtonToolTipText");
        this.upFolderButtonToolTipText = this.res.getString("upFolderButtonToolTipText");
        this.detailsViewButtonToolTipText = this.res.getString("detailsViewButtonToolTipText");
        this.homeFolderButtonToolTipText = this.res.getString("homeFolderButtonToolTipText");
        this.refreshBtnToolTipText = this.res.getString("refreshBtnToolTipText");
        this.newdirBtnToolTipText = this.res.getString("newdirBtnToolTipText");
        this.backDirBtnToolTipText = this.res.getString("backDirBtnToolTipText");
    }

    private void installPopupMenu() {
        this.pmiDetail.setText(this.detailsViewButtonToolTipText);
        this.pmiList.setText(this.listViewButtonToolTipText);
        this.pmiDetail.addActionListener(this.viewButtonListener);
        this.pmiList.addActionListener(this.viewButtonListener);
        this.pmiDetail.setVisible(false);
        this.pmiList.setVisible(false);
        JMenuItem topItem = new JMenuItem("topItem");
        this.popupMenu.add(topItem);
        topItem.setVisible(false);
        this.popupMenu.add(topItem);
        this.popupMenu.add(this.backAction);
        this.popupMenu.add(this.upFolderAction);
        this.popupMenu.add(this.goHomeAction);
        this.popupMenu.addSeparator();
        this.popupMenu.add(this.refreshAction);
        this.popupMenu.add(this.newFolderAction);
    }

    private void installComponents() {
        this.mainPanel.setBorder(new EmptyBorder(12, 12, 11, 11));
        this.mainPanel.setLayout(new BorderLayout(0, 11));
        JPanel topPanel = new JPanel(new BorderLayout(11, 0));
        JPanel topButtonPanel = new JPanel();
        topButtonPanel.setLayout(new BoxLayout(topButtonPanel, 2));
        topPanel.add((Component)topButtonPanel, "After");
        this.mainPanel.add((Component)topPanel, "North");
        this.initDirCombox(topPanel);
        this.dirCombox.addPopupMenuListener(new PopupMenuListener(){

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
                TKFileChooserUI.this.directoryComboBoxAction.actionPerformed(null);
            }

            @Override
            public void popupMenuCanceled(PopupMenuEvent e) {
            }
        });
        topPanel.add((Component)this.dirCombox, "Center");
        this.backButton = new TKButton(this.iconOfBack);
        this.backButton.setMargin(shrinkWrap);
        topButtonPanel.add(this.backButton);
        topButtonPanel.add(Box.createRigidArea(holStrut5));
        this.backButton.addActionListener(this.backAction);
        this.backButton.setToolTipText(this.backDirBtnToolTipText);
        this.initUpFolderButton();
        topButtonPanel.add(this.upFolderButton);
        topButtonPanel.add(Box.createRigidArea(holStrut5));
        this.initHomeFolderButton();
        topButtonPanel.add(this.homeFolderButton);
        topButtonPanel.add(Box.createRigidArea(holStrut5));
        this.initRefreshBotton();
        topButtonPanel.add(this.refreshBotton);
        topButtonPanel.add(Box.createRigidArea(holStrut5));
        this.initNewDirButton();
        topButtonPanel.add(this.newdirButton);
        topButtonPanel.add(Box.createRigidArea(holStrut5));
        this.initDetailViewButton();
        topButtonPanel.add(this.detailViewButton);
        this.initListViewButton();
        topButtonPanel.add(this.listViewButton);
        this.initCenterPanel();
        JPanel bellowPanel = new JPanel();
        bellowPanel.setLayout(new BoxLayout(bellowPanel, 1));
        this.mainPanel.add((Component)bellowPanel, "South");
        JPanel fnPanel = new JPanel();
        fnPanel.setLayout(new BoxLayout(fnPanel, 2));
        bellowPanel.add(fnPanel);
        bellowPanel.add(Box.createRigidArea(verStrut5));
        AlignedLabel fnLabel = new AlignedLabel(this.fileNameLabelText);
        fnLabel.setDisplayedMnemonic(this.fileNameLabelMnemonic);
        fnPanel.add(fnLabel);
        this.initFileNameTextField(fnPanel, fnLabel);
        JPanel fotPanel = new JPanel();
        fotPanel.setLayout(new BoxLayout(fotPanel, 2));
        bellowPanel.add(fotPanel);
        AlignedLabel fsotLabel = new AlignedLabel(this.filesOfTypeLabelText);
        fsotLabel.setDisplayedMnemonic(this.filesOfTypeLabelMnemonic);
        fotPanel.add(fsotLabel);
        this.initFilterCombox(fotPanel, fsotLabel);
        this.buttonPanel = new JPanel();
        this.buttonPanel.setLayout(new ButtonAreaLayout());
        this.approveButton = new TKButton(this.approveButtonText);
        this.approveButton.addActionListener(this.approveSelectionAction);
        if (this.isSave) {
            this.approveButton.setText(this.saveButtonText);
            fsotLabel.setText(this.saveOfTypeLabelText);
        }
        this.buttonPanel.add(this.approveButton);
        this.cancelButton = new TKButton(this.cancelButtonText);
        this.cancelButton.addActionListener(new CancelSelectionAction());
        this.buttonPanel.add(this.cancelButton);
        if (this.tkFileChooser.getControlButtonsAreShown()) {
            bellowPanel.add(this.buttonPanel);
        }
        TKFileChooserUI.groupLabels(new AlignedLabel[]{fnLabel, fsotLabel});
        this.detailsViewPanel = this.createDetailsView();
        this.setupKeyInput();
        if (this.tkFileChooser.getFileSelectionModel() == 1) {
            fotPanel.setVisible(false);
        }
        this.dirCombox.setName("_ComboBox_Directory");
        this.detailTable.setName("_Table_Detail");
        this.detailViewButton.setName("_Button_DetailView");
        this.listViewButton.setName("_Button_ListView");
        this.upFolderButton.setName("_Button_UpFolder");
        this.homeFolderButton.setName("_Button_HomeFolder");
        this.refreshBotton.setName("_Button_Refresh");
        this.newdirButton.setName("_Button_NewDirectory");
        this.fileNameTextField.setName("_TextField_FileName");
        this.filterComboBox.setName("_ComboBox_FileFilter");
        this.approveButton.setName("_Button_Open");
        this.cancelButton.setName("_Button_Cancel");
    }

    private void initDirCombox(JPanel topPanel) {
        this.dirCombox = new JComboBox();
        this.dirComboxModel = new DirectoryComboBoxModel();
        JLabel lookInLabel = new JLabel(this.lookInLabelText);
        lookInLabel.setDisplayedMnemonic(this.lookInLabelMnemonic);
        topPanel.add((Component)lookInLabel, "Before");
        this.dirCombox.getAccessibleContext().setAccessibleDescription(this.lookInLabelText);
        this.dirCombox.putClientProperty("JComboBox.lightweightKeyboardNavigation", "Lightweight");
        lookInLabel.setLabelFor(this.dirCombox);
        this.dirCombox.setModel(this.dirComboxModel);
        this.dirCombox.setRenderer(new DirectoryComboBoxRenderer());
        this.dirCombox.setAlignmentX(0.0f);
        this.dirCombox.setAlignmentY(0.0f);
        this.dirCombox.setMaximumRowCount(8);
        this.dirCombox.setUI(new TKComboBoxUI(true));
    }

    private void initFilterCombox(JPanel fotPanel, AlignedLabel fsotLabel) {
        this.filterComboBox = new JComboBox<TKFileFilter>(this.tkFileChooser.getFilters());
        this.filterComboBox.setUI(new TKComboBoxUI(true));
        String mark = "sameComboBox";
        TKComponentToolkit.addAlignComponent(mark, this.filterComboBox);
        TKComponentToolkit.addAlignComponent(mark, this.fileNameTextField);
        TKComponentToolkit.alignComponents(mark, 0);
        this.filterComboBox.getAccessibleContext().setAccessibleDescription(this.filesOfTypeLabelText);
        fsotLabel.setLabelFor(this.filterComboBox);
        this.filterComboBox.setRenderer(new FilterComboBoxRenderer());
        fotPanel.add(this.filterComboBox);
        this.filterComboBox.addActionListener(this.filterComboBoxAction);
    }

    private void initCenterPanel() {
        this.centerPanel = new JPanel(new BorderLayout());
        this.listViewPanel = this.createListView();
        this.listViewPanel.setPreferredSize(LIST_PREF_SIZE);
        this.currentViewPanel = this.listViewPanel;
        this.centerPanel.add((Component)this.listViewPanel, "Center");
        JPanel inclosurePanel = new JPanel(new BorderLayout());
        this.centerPanel.add((Component)inclosurePanel, "After");
        this.mainPanel.add((Component)this.centerPanel, "Center");
    }

    private void initFileNameTextField(JPanel fnPanel, AlignedLabel fnLabel) {
        this.fileNameTextField = new TKTextField(35){

            @Override
            public Dimension getMaximumSize() {
                return new Dimension(Short.MAX_VALUE, super.getPreferredSize().height);
            }
        };
        fnPanel.add(this.fileNameTextField);
        fnLabel.setLabelFor(this.fileNameTextField);
        this.fileNameTextField.setBackground(this.jList.getBackground());
        this.fileNameTextField.setText(this.tkFileChooser.getDefaultFileName());
        this.fileNameTextField.setBorder(BorderFactory.createLoweredBevelBorder());
    }

    private void initListViewButton() {
        this.listViewButton = new TKButton(this.iconOfListView);
        this.listViewButton.setToolTipText(this.listViewButtonToolTipText);
        this.listViewButton.setAlignmentX(0.0f);
        this.listViewButton.setAlignmentY(0.5f);
        this.listViewButton.setMargin(shrinkWrap);
        this.listViewButton.addActionListener(this.viewButtonListener);
        this.listViewButton.setVisible(false);
        this.detailViewButton.setVisible(false);
    }

    private void initDetailViewButton() {
        this.detailViewButton = new TKButton(this.iconOfDetailView);
        this.detailViewButton.setToolTipText(this.detailsViewButtonToolTipText);
        this.detailViewButton.setAlignmentX(0.0f);
        this.detailViewButton.setAlignmentY(0.5f);
        this.detailViewButton.setMargin(shrinkWrap);
        this.detailViewButton.addActionListener(this.viewButtonListener);
    }

    private void initNewDirButton() {
        this.newdirButton = new TKButton(this.iconOfNewFolder);
        this.newdirButton.setToolTipText(this.newdirBtnToolTipText);
        this.newdirButton.setAlignmentX(0.0f);
        this.newdirButton.setAlignmentY(0.5f);
        this.newdirButton.setMargin(shrinkWrap);
        this.newdirButton.addActionListener(this.newFolderAction);
    }

    private void initRefreshBotton() {
        this.refreshBotton = new TKButton(this.iconOfRefresh);
        this.refreshBotton.setToolTipText(this.refreshBtnToolTipText);
        this.refreshBotton.setAlignmentX(0.0f);
        this.refreshBotton.setAlignmentY(0.5f);
        this.refreshBotton.setMargin(shrinkWrap);
        this.refreshBotton.addActionListener(new RefreshAction());
    }

    private void initHomeFolderButton() {
        this.homeFolderButton = new TKButton(this.iconOfHomeFolder);
        this.homeFolderButton.setToolTipText(this.homeFolderButtonToolTipText);
        this.homeFolderButton.getAccessibleContext().setAccessibleName(this.homeFolderAccessibleName);
        this.homeFolderButton.setAlignmentX(0.0f);
        this.homeFolderButton.setAlignmentY(0.5f);
        this.homeFolderButton.setMargin(shrinkWrap);
        this.homeFolderButton.addActionListener(this.goHomeAction);
    }

    private void initUpFolderButton() {
        this.upFolderButton = new TKButton(this.iconOfUpFolder);
        this.upFolderButton.setToolTipText(this.upFolderButtonToolTipText);
        this.upFolderButton.getAccessibleContext().setAccessibleName(this.upFolderAccessibleName);
        this.upFolderButton.setAlignmentX(0.0f);
        this.upFolderButton.setAlignmentY(0.5f);
        this.upFolderButton.setMargin(shrinkWrap);
        this.upFolderButton.addActionListener(this.upFolderAction);
    }

    private static void groupLabels(AlignedLabel[] group) {
        for (int i = 0; i < group.length; ++i) {
            AlignedLabel.access$1102(group[i], group);
        }
    }

    private void setupKeyInput() {
        this.fileNameTextField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                TKFileChooserUI.this.jList.clearSelection();
                TKFileChooserUI.this.detailTable.clearSelection();
                if (TKFileChooserUI.this.isSave) {
                    TKFileChooserUI.this.approveButton.setText(TKFileChooserUI.this.saveButtonText);
                }
            }
        });
        AbstractAction selectAllAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TKFileChooserUI.this.selectAll();
            }
        };
        this.detailTable.getInputMap(0).put(KeyStroke.getKeyStroke(65, 2), "ctrl-all");
        this.detailTable.getActionMap().put("ctrl-all", selectAllAction);
        this.detailTable.getInputMap(0).put(KeyStroke.getKeyStroke(8, 0), "backspace");
        this.detailTable.getActionMap().put("backspace", this.upFolderAction);
        this.jList.getInputMap(0).put(KeyStroke.getKeyStroke(65, 2), "ctrl-all");
        this.jList.getActionMap().put("ctrl-all", selectAllAction);
        this.jList.getInputMap(0).put(KeyStroke.getKeyStroke(8, 0), "backspace");
        this.jList.getActionMap().put("backspace", this.upFolderAction);
        this.detailTable.getInputMap(0).put(KeyStroke.getKeyStroke(36, 0), "home");
        this.detailTable.getActionMap().put("home", this.goHomeAction);
        this.detailTable.getInputMap(0).put(KeyStroke.getKeyStroke(116, 0), "refresh");
        this.detailTable.getActionMap().put("refresh", this.refreshAction);
        this.jList.getInputMap(0).put(KeyStroke.getKeyStroke(36, 0), "home");
        this.jList.getActionMap().put("home", this.goHomeAction);
        this.jList.getInputMap(0).put(KeyStroke.getKeyStroke(116, 0), "refresh");
        this.jList.getActionMap().put("refresh", this.refreshAction);
        this.detailTable.getInputMap(0).put(KeyStroke.getKeyStroke(10, 0), "enter");
        this.detailTable.getActionMap().put("enter", this.approveSelectionAction);
        this.jList.getInputMap(0).put(KeyStroke.getKeyStroke(10, 0), "enter");
        this.jList.getActionMap().put("enter", this.approveSelectionAction);
        this.fileNameTextField.getInputMap(0).put(KeyStroke.getKeyStroke(10, 0), "enter");
        this.fileNameTextField.getActionMap().put("enter", this.approveSelectionAction);
    }

    public boolean getControlButtonsAreShown() {
        return this.isControlBtnShown;
    }

    public void setControlButtonsAreShown(boolean isShown) {
        this.isControlBtnShown = isShown;
        this.buttonPanel.setVisible(isShown);
    }

    public TKFile[] getSelectedFiles() {
        TKFile[] files = (TKFile[])this.jList.getSelectedValues();
        return files;
    }

    public TKFile getSelectedFile() {
        TKFile[] files = (TKFile[])this.jList.getSelectedValues();
        return files[0];
    }

    public TKFileFilter getSelectedFilter() {
        return this.curFileFilter;
    }

    private String fileNameString(Object[] files) {
        StringBuffer buf = new StringBuffer();
        for (int i = 0; files != null && i < files.length; ++i) {
            if (i > 0) {
                buf.append(" ");
            }
            if (files.length > 1) {
                buf.append("\"");
            }
            buf.append(this.fileNameString(files[i]));
            if (files.length <= 1) continue;
            buf.append("\"");
        }
        return buf.toString();
    }

    private String fileNameString(Object file) {
        if (file == null) {
            return null;
        }
        return ((TKFile)file).getName();
    }

    private void setFileName(String filename) {
        if (this.fileNameTextField != null) {
            this.fileNameTextField.setText(filename);
        }
        this.isFileNameChg = false;
    }

    public boolean isMultiSelectionEnabled() {
        return this.tkFileChooser.isMultiSelectionEnabled();
    }

    private void setDirectorySelected(boolean isSelected) {
        this.isDirectorySelected = isSelected;
    }

    private boolean isDirectorySelected() {
        return this.isDirectorySelected;
    }

    private void fixNameColumnWidth(int viewWidth) {
        TableColumn nameCol = this.detailTable.getColumnModel().getColumn(0);
        int tableWidth = this.detailTable.getPreferredSize().width;
        if (tableWidth < viewWidth) {
            nameCol.setPreferredWidth(nameCol.getPreferredWidth() + viewWidth - tableWidth);
        }
    }

    private JPanel createDetailsView() {
        JPanel p = new JPanel(new BorderLayout());
        this.detailTableModel = new DetailsTableModel();
        this.detailTable = new TKSortTable(this.detailTableModel);
        this.detailTable.getTableHeader().setReorderingAllowed(false);
        this.detailTable.getSelectionModel().addListSelectionListener(this.fileSelectionListener);
        this.detailTable.setSelectionMode(0);
        if (this.tkFileChooser.isMultiSelectionEnabled()) {
            this.detailTable.setSelectionMode(2);
        }
        this.detailTable.addColumnSortAction(0);
        this.detailTable.addColumnSortAction(3);
        this.detailTable.addColumnSortAction(2);
        this.detailTable.addColumnSortAction(1);
        this.detailTable.addMouseListener(this.doubleClickListener);
        this.detailTable.addKeyListener(this.detailKeyAdp);
        this.detailTable.setAutoscrolls(true);
        this.detailTable.setAutoResizeMode(0);
        this.detailTable.setShowGrid(false);
        this.detailTable.setIntercellSpacing(new Dimension(0, 1));
        Font font = this.detailTable.getFont();
        this.detailTable.setRowHeight(Math.max(font.getSize(), 19) + 3);
        TableColumnModel columnModel = this.detailTable.getColumnModel();
        TableColumn[] columns = new TableColumn[4];
        for (int i = 0; i < 4; ++i) {
            columns[i] = columnModel.getColumn(i);
            columns[i].setPreferredWidth(this.COLUMN_WIDTHS[i]);
        }
        DetailsTableCellRenderer cellRenderer = new DetailsTableCellRenderer();
        this.detailTable.setDefaultRenderer(Object.class, cellRenderer);
        JScrollPane scrollpane = new JScrollPane(this.detailTable);
        LookAndFeel.installColors(scrollpane.getViewport(), "Table.background", "Table.foreground");
        scrollpane.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                JScrollPane sp = (JScrollPane)e.getComponent();
                TKFileChooserUI.this.fixNameColumnWidth(sp.getViewport().getSize().width);
                sp.removeComponentListener(this);
            }
        });
        p.add((Component)scrollpane, "Center");
        return p;
    }

    private JPanel createListView() {
        JPanel p = new JPanel(new BorderLayout());
        this.initJList();
        JScrollPane scrollpane = new JScrollPane(this.jList);
        p.add((Component)scrollpane, "Center");
        return p;
    }

    private void initJList() {
        this.jList = new JList(){

            @Override
            public int getNextMatch(String prefix, int start, Position.Bias bias) {
                ListModel model = this.getModel();
                int end = model.getSize();
                if (prefix == null || start < 0 || start >= end) {
                    throw new IllegalArgumentException();
                }
                boolean backwards = bias == Position.Bias.Backward;
                int i = start;
                while (backwards ? i >= 0 : i < end) {
                    TKFile file = (TKFile)model.getElementAt(i);
                    String filename = file.toString();
                    if (filename.regionMatches(true, 0, prefix, 0, prefix.length())) {
                        return i + 2;
                    }
                    i += backwards ? -1 : 1;
                }
                return -1;
            }
        };
        this.jList.setCellRenderer(new FileRenderer());
        this.jList.setLayoutOrientation(1);
        this.jList.setVisibleRowCount(-1);
        this.jList.setAutoscrolls(true);
        this.jList.setModel(this.getListModel());
        this.jList.setSelectionMode(0);
        if (this.tkFileChooser.isMultiSelectionEnabled()) {
            this.jList.setSelectionMode(2);
        }
        this.jList.addListSelectionListener(this.fileSelectionListener);
        this.jList.addMouseListener(this.doubleClickListener);
        this.jList.addKeyListener(this.listKeyAdp);
    }

    private void fileListSelected(TKFile[] selectedFiles) {
        if (selectedFiles == null) {
            return;
        }
        Vector<TKFile> files = new Vector<TKFile>();
        files.addAll(Arrays.asList(selectedFiles));
        this.jList.clearSelection();
        for (int i = 0; i < this.listModel.getSize(); ++i) {
            TKFile aimFile = (TKFile)this.listModel.get(i);
            if (!files.contains(aimFile)) continue;
            this.jList.getSelectionModel().addSelectionInterval(i, i);
        }
    }

    private void fileDetailSelected(TKFile[] selectedFiles) {
        if (selectedFiles == null) {
            return;
        }
        Vector<TKFile> files = new Vector<TKFile>();
        files.addAll(Arrays.asList(selectedFiles));
        this.detailTable.clearSelection();
        for (int i = 0; i < this.detailTable.getRowCount(); ++i) {
            TKFile aimFile = (TKFile)this.detailTable.getValueAt(i, 0);
            if (!files.contains(aimFile)) continue;
            this.detailTable.getSelectionModel().addSelectionInterval(i, i);
        }
    }

    private ListModel getListModel() {
        return this.listModel;
    }

    private void cacheIcon(TKFile f, Icon i) {
        if (f == null || i == null) {
            return;
        }
        this.iconCache.put(f, i);
    }

    private Icon getCachedIcon(TKFile f) {
        return (Icon)this.iconCache.get(f);
    }

    private Icon getFileIcon(TKFile f) {
        Icon icon = this.getCachedIcon(f);
        if (icon != null) {
            return icon;
        }
        icon = this.iconOfFile;
        if (f != null) {
            String ext;
            Icon tempIcon;
            if (f.isFloppy()) {
                icon = this.iconOfFloppyDrive;
            } else if (f.isDrive()) {
                icon = this.iconOfHardDrive;
            } else if (f.isComputer()) {
                icon = this.iconOfComputer;
            } else if (f.isDirectory()) {
                icon = this.iconOfDirectory;
            } else if (f.isFile() && (tempIcon = TKResourceManager.getIcon(ext = f.getExtension() + ".gif")) != null) {
                icon = tempIcon;
            }
            if (f.isRoot()) {
                icon = this.iconOfHardDrive;
            }
        }
        this.cacheIcon(f, icon);
        return icon;
    }

    public void selectAll() {
        if (!this.tkFileChooser.isMultiSelectionEnabled()) {
            return;
        }
        int dirnum = this.listModel.getSize();
        int fileStartIndex = 0;
        if (this.tkFileChooser.getFileSelectionModel() == 2) {
            this.jList.setSelectionInterval(fileStartIndex, dirnum - 1);
            return;
        }
        if (this.tkFileChooser.getFileSelectionModel() == 1) {
            this.selectAllDirectories();
            return;
        }
        if (this.tkFileChooser.getFileSelectionModel() == 0) {
            this.selectAllFiles();
            return;
        }
    }

    public void selectAllFiles() {
        int dirnum = this.listModel.getSize();
        int fileStartIndex1 = -1;
        for (int i = 0; i < dirnum; ++i) {
            TKFile tkFile = (TKFile)this.listModel.getElementAt(i);
            if (tkFile == null || !tkFile.isFile()) continue;
            if (fileStartIndex1 == -1) {
                fileStartIndex1 = i;
            }
            if (fileStartIndex1 < 0) continue;
            this.jList.setSelectionInterval(fileStartIndex1, i);
        }
        int fileStartIndex2 = -1;
        for (int i = 0; i < dirnum; ++i) {
            TKFile tkFile = (TKFile)this.detailTable.getValueAt(i, 0);
            if (tkFile == null || !tkFile.isFile()) continue;
            if (fileStartIndex2 == -1) {
                fileStartIndex2 = i;
            }
            this.detailTable.setRowSelectionInterval(fileStartIndex2, i);
        }
    }

    public void selectAllDirectories() {
        int dirnum = this.listModel.getSize();
        int fileStartIndex1 = -1;
        for (int i = 0; i < dirnum; ++i) {
            TKFile tkFile = (TKFile)this.listModel.getElementAt(i);
            if (tkFile == null || !tkFile.isDirectory()) continue;
            if (fileStartIndex1 == -1) {
                fileStartIndex1 = i;
            }
            this.jList.setSelectionInterval(fileStartIndex1, i);
        }
        int fileStartIndex2 = -1;
        for (int i = 0; i < dirnum; ++i) {
            TKFile tkFile = (TKFile)this.detailTable.getValueAt(i, 0);
            if (tkFile == null || !tkFile.isDirectory()) continue;
            if (fileStartIndex2 == -1) {
                fileStartIndex2 = i;
            }
            this.detailTable.setRowSelectionInterval(fileStartIndex2, i);
        }
    }

    private void listDirectory(TKFile file) {
        if (file == null) {
            return;
        }
        this.setUpHomeBtnSts(file);
        this.listDirectory(this.listFiles(file, false));
    }

    private void listDirectory(TKFile[] files) {
        if (this.isSave) {
            this.approveButton.setText(this.saveButtonText);
        }
        if (this.tkFileChooser.getFileSelectionModel() == 1) {
            this.setFileName("");
        }
        if (files == null) {
            return;
        }
        this.allFiles = files;
        this.listModel.clear();
        this.jList.setSelectedIndex(-1);
        Vector<TKFile> vf = new Vector<TKFile>();
        for (int i = 0; i < files.length; ++i) {
            if (files[i].isHidden()) continue;
            if (this.tkFileChooser.getFileSelectionModel() == 1 && files[i].isFile() || null != this.curFileFilter && files[i].isFile() && !this.curFileFilter.accept(files[i])) continue;
            this.listModel.addElement(files[i]);
            vf.add(files[i]);
        }
        if (this.detailTableModel != null) {
            this.detailTableModel.updateData(vf.toArray());
        }
        this.grabFocus();
    }

    private void setSelection() {
        if (this.isShowDetail) {
            int rowCount = this.detailTable.getRowCount();
            int leadSelectIndex = this.detailTable.getSelectionModel().getLeadSelectionIndex();
            if (leadSelectIndex < rowCount) {
                this.detailTable.setRowSelectionInterval(leadSelectIndex, leadSelectIndex);
            }
        } else {
            int rowCount = this.jList.getModel().getSize();
            int leadSelectIndex = this.jList.getSelectionModel().getLeadSelectionIndex();
            if (leadSelectIndex < rowCount) {
                this.jList.setSelectedIndex(leadSelectIndex);
            }
        }
    }

    private void checkSaveFile(boolean evtFromBtn) {
        String fileNameInput = this.fileNameTextField.getText().trim();
        TKFile currentDir = this.getCurrentDirectory();
        String defaultFilePostfix = this.curFileFilter.getDefaulFileExtension();
        defaultFilePostfix = defaultFilePostfix.equals("") ? "" : "." + defaultFilePostfix;
        String tempStr = fileNameInput;
        int lastDoc = tempStr.lastIndexOf(".");
        if (lastDoc > 0) {
            tempStr = tempStr.substring(0, lastDoc);
        }
        if (tempStr.indexOf(File.separator) > 0) {
            int lastSeparator = tempStr.lastIndexOf(File.separator);
            tempStr = tempStr.substring(lastSeparator + 1, tempStr.length());
        }
        if (currentDir.getPath().length() + tempStr.trim().length() + defaultFilePostfix.length() > 255) {
            TKOperationShowMgr.showOperationDlg((Component)TKResourceManager.getMainFrame(), this.res.getString("InvaidFileNameLength"), false);
            return;
        }
        if (!fileNameInput.endsWith("..") && (fileNameInput.endsWith(".") || fileNameInput.startsWith(".")) || fileNameInput.equals(".")) {
            TKOperationShowMgr.showOperationDlg((Component)TKResourceManager.getMainFrame(), this.res.getString("InvaidFileNameInput2"), false);
            return;
        }
        if ((fileNameInput = fileNameInput.replace(File.separator.charAt(0), "/".charAt(0))).indexOf("/.") >= 0 || fileNameInput.indexOf("./") >= 0) {
            TKOperationShowMgr.showOperationDlg((Component)TKResourceManager.getMainFrame(), this.res.getString("InvaidFileNameInput2"), false);
            return;
        }
        if (this.selectedFiles != null && this.selectedFiles.length > 0) {
            TKFile selectedFile = this.selectedFiles[0];
            if (selectedFile.isDirectory()) {
                this.updateCurrentDirectory(selectedFile);
                this.approveButton.setText(this.saveButtonText);
                return;
            }
        } else if (fileNameInput.equals("")) {
            if (!evtFromBtn) {
                this.setSelection();
            }
            return;
        }
        if (fileNameInput.equals("/")) {
            TKOperationShowMgr.showOperationDlg((Component)TKResourceManager.getMainFrame(), this.res.getString("InvaidFileNameInput2"), false);
            return;
        }
        if (fileNameInput.indexOf("/") < 0) {
            TKFile selectTkFile = (TKFile)this.dirCombox.getSelectedItem();
            File file = new File(fileNameInput);
            String tmpFileNameInput = fileNameInput;
            fileNameInput = selectTkFile.getPath() + fileNameInput;
            if (new File(fileNameInput).exists()) {
                TKFile ckFile = new TKFile(file.getAbsolutePath(), 1);
                if (tmpFileNameInput.equals("..")) {
                    TKFile curDir = this.getCurrentDirectory();
                    TKFile curParentDir = TKFileUtilities.getParent(curDir);
                    if (curParentDir != null) {
                        this.updateCurrentDirectory(curParentDir);
                    }
                } else {
                    this.updateCurrentDirectory(ckFile);
                }
            } else {
                file = new File(fileNameInput);
                if (file.exists() && file.isDirectory()) {
                    TKFile ckFile = new TKFile(file.getAbsolutePath(), 1);
                    this.updateCurrentDirectory(ckFile);
                } else {
                    try {
                        TKFile rtFile;
                        File saveFile;
                        String defaultFileExt = this.curFileFilter.getDefaulFileExtension();
                        String string = defaultFileExt = defaultFileExt.equals("") ? "" : "." + defaultFileExt;
                        if (fileNameInput.endsWith(defaultFileExt)) {
                            defaultFileExt = "";
                        }
                        if (this.checkSaveFile(saveFile = new File((rtFile = new TKFile(fileNameInput + defaultFileExt)).getPath()), false)) {
                            this.approveSelectedFile(rtFile);
                        }
                    }
                    catch (Exception ex) {
                        TKOperationShowMgr.showOperationDlg((Component)TKResourceManager.getMainFrame(), this.res.getString("InvaidFileNameInput2"), false);
                    }
                }
            }
        } else if (!fileNameInput.endsWith("/")) {
            TKFile rtFile;
            File saveFile;
            String defaultFileExt;
            File tempFile = new File(fileNameInput);
            if (tempFile.exists() && tempFile.isDirectory()) {
                this.updateCurrentDirectory(new TKFile(fileNameInput, 1));
                return;
            }
            if (!tempFile.exists()) {
                String parentPath = this.getCurrentDirectory().getPath();
                if (fileNameInput.indexOf(":") > 0 || fileNameInput.startsWith("/")) {
                    parentPath = "";
                }
                fileNameInput = parentPath + fileNameInput;
                tempFile = null;
                tempFile = new File(fileNameInput);
                if (tempFile.exists() && tempFile.isDirectory()) {
                    this.updateCurrentDirectory(new TKFile(fileNameInput, 1));
                    return;
                }
            }
            String string = defaultFileExt = (defaultFileExt = this.curFileFilter.getDefaulFileExtension()).equals("") ? "" : "." + defaultFileExt;
            if (fileNameInput.endsWith(defaultFileExt)) {
                defaultFileExt = "";
            }
            if (this.checkSaveFile(saveFile = new File((rtFile = new TKFile(fileNameInput + defaultFileExt)).getPath()), true)) {
                this.approveSelectedFile(rtFile);
            }
        } else {
            File file = new File(fileNameInput);
            if (file.exists() && file.isDirectory()) {
                this.updateCurrentDirectory(new TKFile(file.getAbsolutePath(), 1));
            } else {
                TKOperationShowMgr.showOperationDlg((Component)TKResourceManager.getMainFrame(), this.res.getString("InvaidFileNameInput3"), false);
            }
        }
    }

    private boolean checkSaveFile(File saveFile, boolean checkDir) {
        block10: {
            try {
                File parentDir = saveFile.getParentFile();
                if (!parentDir.exists() || !parentDir.isDirectory()) {
                    TKOperationShowMgr.showOperationDlg((Component)TKResourceManager.getMainFrame(), this.res.getString("InexistentParentPath"), false);
                    return false;
                }
                if (!parentDir.canWrite()) {
                    TKOperationShowMgr.showOperationDlg((Component)TKResourceManager.getMainFrame(), this.res.getString("InvaidNewFilePermission"), false);
                    return false;
                }
                if (saveFile.exists()) {
                    this.updateCurrentDirectory(new TKFile(parentDir.getAbsolutePath(), 1));
                    if (checkDir && saveFile.isDirectory()) {
                        String noticeMsg = saveFile.getAbsolutePath() + "\n" + this.res.getString("FileNameConflict");
                        TKOperationShowMgr.showOperationDlg((Component)TKResourceManager.getMainFrame(), noticeMsg, false);
                        return false;
                    }
                    boolean isReadOnly = TKFileUtilities.isReadOnly(saveFile);
                    if (isReadOnly) {
                        String noticeMsg = saveFile.getAbsolutePath() + "\n" + this.res.getString("FileReadOnly");
                        TKOperationShowMgr.showOperationDlg((Component)TKResourceManager.getMainFrame(), noticeMsg, false);
                        return false;
                    }
                    String noticeMsg = saveFile.getAbsolutePath() + "\n" + this.res.getString("FileExist");
                    TKConfirmDialog confDlg = new TKConfirmDialog(TKResourceManager.getMainFrame(), this.res.getString("Hint"), noticeMsg, null, true, true);
                    confDlg.setDefaultCloseOperation(2);
                    int willContinue = confDlg.showDialog();
                    return willContinue != 1;
                }
                if (saveFile.createNewFile()) {
                    try {
                        saveFile.delete();
                    }
                    catch (SecurityException se) {
                        DCDebugTracer.trace(se);
                    }
                    break block10;
                }
                TKOperationShowMgr.showOperationDlg((Component)TKResourceManager.getMainFrame(), this.res.getString("InvaidFileNameInput"), false);
                return false;
            }
            catch (Exception ex) {
                TKOperationShowMgr.showOperationDlg((Component)TKResourceManager.getMainFrame(), this.res.getString("InvaidFileNameInput2"), false);
                return false;
            }
        }
        return true;
    }

    private void checkMutilFileiput() {
        String fileNameInput = this.fileNameTextField.getText().trim();
        fileNameInput = fileNameInput.replace(File.separator.charAt(0), "/".charAt(0));
        String[] fileNames = fileNameInput.split("\"");
        Vector<TKFile> files = new Vector<TKFile>();
        for (int i = 0; i < fileNames.length; ++i) {
            String fileName = fileNames[i].trim();
            if (fileName.length() == 0) continue;
            TKFile fileCk = this.containsFile(fileName);
            if (fileCk == null) {
                String noticeMsg = this.res.getString("FileInexistent1") + "\n" + fileName;
                TKOperationShowMgr.showOperationDlg((Component)TKResourceManager.getMainFrame(), noticeMsg, false);
                return;
            }
            if (fileCk.isFile()) {
                files.add(fileCk);
                continue;
            }
            if (!fileCk.isDirectory()) continue;
            this.updateCurrentDirectory(fileCk);
            return;
        }
        if (files.size() == 0) {
            return;
        }
        Object[] fs = new TKFile[files.size()];
        files.copyInto(fs);
        this.tkFileChooser.setSelectedFile((TKFile)fs[0]);
        this.tkFileChooser.setSelectedFiles((TKFile[])fs);
        this.tkFileChooser.approveAction();
    }

    private void findFile(String fileName) {
        if (this.isShowDetail) {
            int fileCount = this.detailTable.getModel().getRowCount();
            for (int i = 0; i < fileCount; ++i) {
                TKFile aimFile = (TKFile)this.detailTable.getValueAt(i, 0);
                if (!aimFile.getName().equalsIgnoreCase(fileName)) continue;
                this.detailTable.setRowSelectionInterval(i, i);
                this.detailTable.scrollRectToVisible(this.detailTable.getCellRect(i, 0, true));
                break;
            }
        } else {
            int fileCount = this.jList.getModel().getSize();
            for (int i = 0; i < fileCount; ++i) {
                TKFile aimFile = (TKFile)this.jList.getModel().getElementAt(i);
                if (!aimFile.getName().equalsIgnoreCase(fileName)) continue;
                this.jList.setSelectionInterval(i, i);
                this.jList.scrollRectToVisible(this.jList.getCellBounds(i, i));
                break;
            }
        }
        this.grabFocus();
    }

    protected void checkInputFileName() {
        String fileNameInput = this.fileNameTextField.getText().trim();
        if (fileNameInput.equals("") || fileNameInput.equals("\\") || fileNameInput.equals("/")) {
            return;
        }
        if (!fileNameInput.endsWith("..") && (fileNameInput.endsWith(".") || fileNameInput.startsWith(".")) || fileNameInput.equals(".")) {
            TKOperationShowMgr.showOperationDlg((Component)TKResourceManager.getMainFrame(), this.res.getString("InvaidFileNameInput2"), false);
            return;
        }
        if ((fileNameInput = fileNameInput.replace(File.separator.charAt(0), "/".charAt(0))).indexOf("/.") >= 0 || fileNameInput.indexOf("./") >= 0) {
            TKOperationShowMgr.showOperationDlg((Component)TKResourceManager.getMainFrame(), this.res.getString("InvaidFileNameInput2"), false);
            return;
        }
        boolean chatchError = true;
        if (fileNameInput.indexOf("/") < 0) {
            if (fileNameInput.indexOf("\"") >= 0 && this.tkFileChooser.isMultiSelectionEnabled()) {
                this.checkMutilFileiput();
                return;
            }
            if (fileNameInput.indexOf("\"") >= 0) {
                TKOperationShowMgr.showOperationDlg((Component)TKResourceManager.getMainFrame(), this.res.getString("FileInexistent"), false);
                return;
            }
            TKFile fileCk = this.containsDirectory(fileNameInput);
            if (fileCk != null) {
                chatchError = false;
                if (this.tkFileChooser.getFileSelectionModel() == 0) {
                    this.updateCurrentDirectory(fileCk);
                } else {
                    this.approveSelectedFile(fileCk);
                }
            } else {
                fileCk = this.containsFile(fileNameInput);
                if (fileCk != null) {
                    chatchError = false;
                    this.approveSelectedFile(fileCk);
                } else {
                    TKFile parentFile;
                    TKFile[] files;
                    if (fileNameInput.equals("..")) {
                        TKFile curDir = this.getCurrentDirectory();
                        TKFile curParentDir = TKFileUtilities.getParent(curDir);
                        if (curParentDir != null) {
                            this.updateCurrentDirectory(curParentDir);
                        }
                        return;
                    }
                    if (this.tkFileChooser.getBrowseType() != 100 && (files = this.listFiles(fileCk = new TKFile(fileNameInput + "/", 1), true)) != null && files.length > 0 && (parentFile = TKFileUtilities.getParent(files[0])).equals(fileCk)) {
                        this.setCurrentDirectory(parentFile);
                        this.dirComboxModel.addItem(parentFile);
                        this.listDirectory(files);
                        chatchError = false;
                    }
                }
            }
        } else {
            TKFile fileCk;
            boolean isFileApproved;
            TKScreenToolKit.setComponentCursorBusy(this.tkFileChooser.getDialog(), true);
            if (this.tkFileChooser.getBrowseType() == 100 && !fileNameInput.startsWith("/")) {
                fileNameInput = "/" + fileNameInput;
            }
            boolean bl = chatchError = !(isFileApproved = this.approveDirectory(fileCk = new TKFile(fileNameInput, 1)));
            if (!isFileApproved) {
                TKFile approveFile = this.approveFile(new TKFile(fileNameInput));
                boolean bl2 = chatchError = approveFile == null;
                if (!chatchError) {
                    this.approveSelectedFile(approveFile);
                } else {
                    String parentPath = this.getCurrentDirectory().getPath();
                    if (parentPath.endsWith("/")) {
                        parentPath = parentPath.substring(0, parentPath.length() - 1);
                    }
                    fileNameInput = parentPath + (fileNameInput.startsWith("/") ? "" : "/") + fileNameInput;
                    fileCk = new TKFile(fileNameInput, 1);
                    boolean bl3 = chatchError = !this.approveDirectory(fileCk);
                    if (chatchError) {
                        approveFile = this.approveFile(new TKFile(fileNameInput));
                        boolean bl4 = chatchError = approveFile == null;
                        if (!chatchError) {
                            this.approveSelectedFile(approveFile);
                        }
                    }
                }
            }
            TKScreenToolKit.setComponentCursorBusy(this.tkFileChooser.getDialog(), false);
        }
        if (chatchError) {
            TKOperationShowMgr.showOperationDlg((Component)TKResourceManager.getMainFrame(), this.res.getString("FileInexistent"), false);
        }
    }

    private void approveSelectedFile(TKFile rtFile) {
        this.tkFileChooser.setSelectedFile(rtFile);
        this.tkFileChooser.setSelectedFiles(new TKFile[]{rtFile});
        this.tkFileChooser.approveAction();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean approveDirectory(TKFile directory) {
        TKFile[] files = this.listFiles(directory, true, false);
        if (files == null || files.length <= 0) return false;
        TKFile parentFile = TKFileUtilities.getParent(files[0]);
        if (!parentFile.equals(directory)) return false;
        if (this.tkFileChooser.getFileSelectionModel() == 0) {
            this.dirComboxModel.addItem(parentFile);
            this.setCurrentDirectory(parentFile);
            this.listDirectory(files);
            return true;
        } else {
            this.approveSelectedFile(parentFile);
        }
        return true;
    }

    private TKFile approveFile(TKFile file) {
        if (file.getPath().endsWith("/")) {
            return null;
        }
        TKFile parentFile = TKFileUtilities.getParent(file);
        if (parentFile == null) {
            return file;
        }
        String fileName = file.getName();
        TKFile[] files = this.listFiles(parentFile, true, false);
        if (files != null && files.length > 0) {
            for (int i = 0; i < files.length; ++i) {
                String fileName_ = files[i].getName();
                if (!fileName_.equals(fileName) || file.fileType() != files[i].fileType()) continue;
                return files[i];
            }
        }
        return null;
    }

    private void setUpHomeBtnSts(TKFile oDirectory) {
        if (null == oDirectory) {
            return;
        }
        int brwType = this.tkFileChooser.getBrowseType();
        if (brwType == 101) {
            if (oDirectory.getPath().equals(TKFileUtilities.lastToolkitPath.getPath())) {
                this.upFolderButton.setEnabled(false);
                this.homeFolderButton.setEnabled(false);
            } else {
                this.upFolderButton.setEnabled(true);
                this.homeFolderButton.setEnabled(true);
            }
        } else {
            this.upFolderButton.setEnabled(TKFileUtilities.getParent(oDirectory) != null);
            this.homeFolderButton.setEnabled(TKFileUtilities.getParent(oDirectory) != null);
        }
    }

    public void setParentWin(Dialog parentWin) {
        this.parentWin = parentWin;
    }

    public Dialog getParentWin() {
        return this.parentWin;
    }

    class FileSelectionListener
    implements ListSelectionListener {
        @Override
        public void valueChanged(ListSelectionEvent e) {
            TKFileChooserUI.this.selectedFiles = null;
            TKFileChooserUI.this.isFileNameChg = false;
            boolean isDirSelected = false;
            if (!TKFileChooserUI.this.isShowDetail && e.getSource() instanceof JList) {
                JList jList = (JList)e.getSource();
                if (jList.getSelectedValues().length > 0) {
                    Object[] objs = jList.getSelectedValues();
                    TKFileChooserUI.this.selectedFiles = new TKFile[objs.length];
                    for (int i = 0; i < objs.length; ++i) {
                        TKFileChooserUI.this.selectedFiles[i] = (TKFile)objs[i];
                        if (isDirSelected || !TKFileChooserUI.this.selectedFiles[i].isDirectory()) continue;
                        isDirSelected = true;
                    }
                }
            } else {
                int[] selectedRows = TKFileChooserUI.this.detailTable.getSelectedRows();
                if (selectedRows != null) {
                    TKFileChooserUI.this.selectedFiles = new TKFile[selectedRows.length];
                    for (int i = 0; i < selectedRows.length; ++i) {
                        TKFileChooserUI.this.selectedFiles[i] = (TKFile)TKFileChooserUI.this.detailTable.getValueAt(selectedRows[i], 0);
                        if (isDirSelected || !TKFileChooserUI.this.selectedFiles[i].isDirectory()) continue;
                        isDirSelected = true;
                    }
                }
            }
            TKFileChooserUI.this.tkFileChooser.setSelectedFiles(TKFileChooserUI.this.selectedFiles);
            TKFileChooserUI.this.tkFileChooser.setSelectedFile(null);
            if (TKFileChooserUI.this.selectedFiles == null || TKFileChooserUI.this.selectedFiles.length == 0) {
                return;
            }
            if (TKFileChooserUI.this.isSave) {
                if (isDirSelected) {
                    TKFileChooserUI.this.approveButton.setText(TKFileChooserUI.this.approveButtonText);
                    TKFileChooserUI.this.tkFileChooser.setSelectedFiles(null);
                    return;
                }
                TKFileChooserUI.this.approveButton.setText(TKFileChooserUI.this.saveButtonText);
            }
            TKFile tkFile = TKFileChooserUI.this.selectedFiles[0];
            TKFileChooserUI.this.tkFileChooser.setSelectedFile(TKFileChooserUI.this.selectedFiles[0]);
            if (TKFileChooserUI.this.selectedFiles.length > 1 && !isDirSelected) {
                TKFileChooserUI.this.setFileName(TKFileChooserUI.this.fileNameString(TKFileChooserUI.this.selectedFiles));
            } else if (TKFileChooserUI.this.selectedFiles.length == 1 && !isDirSelected || TKFileChooserUI.this.tkFileChooser.getFileSelectionModel() == 1) {
                TKFileChooserUI.this.setFileName(TKFileChooserUI.this.fileNameString(tkFile));
            }
            TKFileChooserUI.this.setDirectorySelected(isDirSelected);
        }
    }

    class NewFolderAction
    extends AbstractAction {
        protected NewFolderAction() {
            super(TKFileChooserUI.this.res.getString("newdirBtnToolTipText"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (!TKFileChooserUI.this.isReadyDo(true)) {
                return;
            }
            TKInputDialog dialog = new TKInputDialog(TKFileChooserUI.this.res.getString("CreateDir"), (Object)(TKFileChooserUI.this.res.getString("NoticeCreateDir") + ":"), (Object)""){

                @Override
                public boolean checkApproveAction(String value) {
                    String newfolder = "";
                    if (null != value) {
                        newfolder = value.replace(File.separator.charAt(0), "/".charAt(0));
                    }
                    if (value == null || value.trim().equals("")) {
                        TKOperationShowMgr.showOperationDlg((Component)TKResourceManager.getMainFrame(), TKFileChooserUI.this.res.getString("NoticeCreateDir"), false);
                        return false;
                    }
                    if (newfolder.trim().indexOf("/") >= 0) {
                        TKOperationShowMgr.showOperationDlg((Component)TKResourceManager.getMainFrame(), TKFileChooserUI.this.res.getString("InvaidFileNameInput4"), false);
                        return false;
                    }
                    TKFile currentDir = TKFileChooserUI.this.getCurrentDirectory();
                    boolean isCreated = TKFileChooserUI.this.fileModel.mkDir(currentDir.getPath(), newfolder);
                    return isCreated;
                }
            };
            dialog.setModal(true);
            dialog.setDefaultCloseOperation(2);
            TKScreenToolKit.centerLocateToScreen(dialog);
            dialog.setVisible(true);
            String newfolder = dialog.getValue();
            if (newfolder != null && !newfolder.equals("")) {
                TKFile currentDir = TKFileChooserUI.this.getCurrentDirectory();
                TKFileChooserUI.this.listDirectory(currentDir);
                TKFileChooserUI.this.findFile(newfolder);
            }
        }
    }

    class ViewButtonListener
    implements ActionListener {
        ViewButtonListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JPanel oldViewPanel = TKFileChooserUI.this.currentViewPanel;
            int[] selectionInds = TKFileChooserUI.this.detailTable.getSelectedRows();
            if (!TKFileChooserUI.this.listViewButton.isVisible()) {
                TKFileChooserUI.this.isShowDetail = true;
                if (TKFileChooserUI.this.detailsViewPanel == null) {
                    TKFileChooserUI.this.detailsViewPanel = TKFileChooserUI.this.createDetailsView();
                    TKFileChooserUI.this.detailsViewPanel.setPreferredSize(TKFileChooseUIDef.LIST_PREF_SIZE);
                }
                TKFileChooserUI.this.fileDetailSelected(TKFileChooserUI.this.selectedFiles);
                if (TKFileChooserUI.this.detailTable.getSelectedRow() >= 0) {
                    TKFileChooserUI.this.detailTable.scrollRectToVisible(TKFileChooserUI.this.detailTable.getCellRect(TKFileChooserUI.this.detailTable.getSelectedRow(), 0, true));
                }
                TKFileChooserUI.this.currentViewPanel = TKFileChooserUI.this.detailsViewPanel;
            } else {
                TKFileChooserUI.this.isShowDetail = false;
                TKFileChooserUI.this.fileListSelected(TKFileChooserUI.this.selectedFiles);
                if (TKFileChooserUI.this.jList.getSelectedIndex() >= 0) {
                    TKFileChooserUI.this.jList.scrollRectToVisible(TKFileChooserUI.this.jList.getCellBounds(TKFileChooserUI.this.jList.getSelectedIndex(), TKFileChooserUI.this.jList.getSelectedIndex()));
                }
                TKFileChooserUI.this.currentViewPanel = TKFileChooserUI.this.listViewPanel;
            }
            if (TKFileChooserUI.this.currentViewPanel != oldViewPanel) {
                TKFileChooserUI.this.centerPanel.remove(oldViewPanel);
                TKFileChooserUI.this.centerPanel.add((Component)TKFileChooserUI.this.currentViewPanel, "Center");
                TKFileChooserUI.this.centerPanel.revalidate();
                TKFileChooserUI.this.centerPanel.repaint();
            }
            TKFileChooserUI.this.detailViewButton.setVisible(!TKFileChooserUI.this.isShowDetail);
            TKFileChooserUI.this.listViewButton.setVisible(TKFileChooserUI.this.isShowDetail);
            TKFileChooserUI.this.pmiDetail.setVisible(!TKFileChooserUI.this.isShowDetail);
            TKFileChooserUI.this.pmiList.setVisible(TKFileChooserUI.this.isShowDetail);
            if (TKFileChooserUI.this.isShowDetail) {
                TKFileChooserUI.this.listViewButton.requestFocus();
                if (selectionInds.length == 0) {
                    TKFileChooserUI.this.detailTable.getSelectionModel().clearSelection();
                }
            } else {
                TKFileChooserUI.this.detailViewButton.requestFocus();
            }
        }
    }

    class DetailsTableCellRenderer
    extends DefaultTableCellRenderer {
        private static final long serialVersionUID = 1583422907730109759L;

        DetailsTableCellRenderer() {
            this.setFocusable(false);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (column == 1) {
                this.setHorizontalAlignment(11);
            } else {
                this.setHorizontalAlignment(10);
            }
            return super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        }

        @Override
        public void setValue(Object value) {
            this.setIcon(null);
            if (value instanceof TKFile) {
                TKFile file = (TKFile)value;
                String fileName = file.getName();
                this.setText(fileName);
                FileIcon fIcon = new FileIcon(TKFileChooserUI.this.getFileIcon(file));
                this.setIcon(fIcon);
            } else {
                super.setValue(value);
            }
        }
    }

    class DetailsTableModel
    extends DefaultTableModel
    implements TKTableSortInterface {
        private Object[] data;
        private String[] columnNames;

        DetailsTableModel() {
            this.columnNames = new String[]{TKFileChooserUI.this.fileNameHeaderText, TKFileChooserUI.this.fileSizeHeaderText, TKFileChooserUI.this.fileTypeHeaderText, TKFileChooserUI.this.fileDateHeaderText};
        }

        @Override
        public int getColumnCount() {
            return 4;
        }

        @Override
        public String getColumnName(int column) {
            return this.columnNames[column];
        }

        @Override
        public boolean isCellEditable(int row, int column) {
            return false;
        }

        @Override
        public void sortByColumn(int column, boolean isAscent) {
            int sortState = 1;
            if (!isAscent) {
                sortState = -1;
            }
            TKDataSort.sortTable(this.getDataVector(), column, sortState);
            this.fireTableDataChanged();
        }

        protected void clear() {
            this.data = null;
        }

        public void updateData(Object[] files) {
            this.data = files;
            this.setRowCount(0);
            for (int i = 0; i < this.data.length; ++i) {
                Vector<Object> vector = new Vector<Object>();
                TKFile file = (TKFile)this.data[i];
                if (file == null) continue;
                vector.add(file);
                vector.add(file.isFile() ? TKFileUtilities.getFileSize(file.size()) : " ");
                vector.add(" " + TKFileUtilities.getFileTypeDescription(file));
                vector.add(file.getLastModified());
                this.addRow(vector);
            }
        }
    }

    class DoubleClickListener
    extends MouseAdapter {
        @Override
        public void mouseClicked(MouseEvent e) {
            if (SwingUtilities.isLeftMouseButton(e) && e.getClickCount() % 2 == 0) {
                TKFile clkFile;
                if (e.getSource() instanceof JList) {
                    clkFile = (TKFile)TKFileChooserUI.this.jList.getSelectedValue();
                } else {
                    int row = TKFileChooserUI.this.detailTable.rowAtPoint(e.getPoint());
                    clkFile = (TKFile)TKFileChooserUI.this.detailTable.getValueAt(row, 0);
                }
                if (clkFile == null) {
                    return;
                }
                if (!clkFile.isFile()) {
                    TKFileChooserUI.this.updateCurrentDirectory(clkFile);
                } else if (TKFileChooserUI.this.isSave) {
                    TKFileChooserUI.this.checkSaveFile(false);
                } else {
                    TKFileChooserUI.this.tkFileChooser.approveAction();
                }
            }
        }
    }

    class BackAction
    extends AbstractAction {
        public BackAction() {
            super(TKFileChooserUI.this.res.getString("backDirBtnToolTipText"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            TKFile lastDir = TKFileChooserUI.this.popDirectory();
            if (lastDir != null && TKFileChooserUI.this.updateCurrentDirectory(lastDir)) {
                TKFileChooserUI.this.popDirectory();
            }
        }
    }

    class CancelSelectionAction
    extends AbstractAction {
        CancelSelectionAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            TKFileChooserUI.this.tkFileChooser.cancleAction();
        }
    }

    class ApproveSelectionAction
    extends AbstractAction {
        private ApproveSelectionAction() {
            super("ApproveSelectionAction");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            boolean evtFromBt = false;
            if (e.getSource() instanceof TKButton || e.getSource() == TKFileChooserUI.this.fileNameTextField) {
                evtFromBt = true;
            }
            if (TKFileChooserUI.this.isSave) {
                TKFileChooserUI.this.checkSaveFile(evtFromBt);
                return;
            }
            String fileNameInput = TKFileChooserUI.this.fileNameTextField.getText().trim();
            fileNameInput = fileNameInput.replace(File.separator.charAt(0), "/".charAt(0));
            if (TKFileChooserUI.this.isFileNameChg && !fileNameInput.equals("")) {
                TKFileChooserUI.this.checkInputFileName();
                return;
            }
            if (TKFileChooserUI.this.selectedFiles == null || TKFileChooserUI.this.selectedFiles.length == 0) {
                if (!fileNameInput.equals("")) {
                    TKFileChooserUI.this.checkInputFileName();
                    return;
                }
                if (TKFileChooserUI.this.tkFileChooser.getFileSelectionModel() != 0) {
                    if (TKFileChooserUI.this.isFtpConnected || TKFileChooserUI.this.tkFileChooser.getBrowseType() != 100) {
                        TKFileChooserUI.this.tkFileChooser.setSelectedFile((TKFile)TKFileChooserUI.this.dirCombox.getSelectedItem());
                        TKFileChooserUI.this.tkFileChooser.approveAction();
                    }
                } else if (!evtFromBt) {
                    TKFileChooserUI.this.setSelection();
                }
            } else {
                TKFile selectedFile = TKFileChooserUI.this.selectedFiles[0];
                if (!TKFileChooserUI.this.isDirectorySelected()) {
                    TKFileChooserUI.this.tkFileChooser.approveAction();
                } else if (TKFileChooserUI.this.selectedFiles.length == 1) {
                    if (TKFileChooserUI.this.tkFileChooser.getFileSelectionModel() != 0) {
                        TKFileChooserUI.this.tkFileChooser.approveAction();
                    } else {
                        TKFileChooserUI.this.updateCurrentDirectory(selectedFile);
                    }
                }
            }
        }
    }

    private static class ButtonAreaLayout
    implements LayoutManager {
        private int topG = 5;
        private int upM = 17;

        private ButtonAreaLayout() {
        }

        @Override
        public void addLayoutComponent(String arg, Component container) {
        }

        @Override
        public void layoutContainer(Container comp) {
            Component[] cdn = comp.getComponents();
            if (cdn != null && cdn.length > 0) {
                int vOset;
                int hLoc;
                int count = cdn.length;
                Dimension[] dims = new Dimension[count];
                Insets is = comp.getInsets();
                int vLoc = is.top + this.upM;
                int maxWdh = 0;
                for (int num = 0; num < count; ++num) {
                    dims[num] = cdn[num].getPreferredSize();
                    maxWdh = Math.max(maxWdh, dims[num].width);
                }
                if (comp.getComponentOrientation().isLeftToRight()) {
                    hLoc = comp.getSize().width - is.left - maxWdh;
                    vOset = this.topG + maxWdh;
                } else {
                    hLoc = is.left;
                    vOset = -(this.topG + maxWdh);
                }
                for (int num = count - 1; num >= 0; --num) {
                    cdn[num].setBounds(hLoc, vLoc, maxWdh, dims[num].height);
                    hLoc -= vOset;
                }
            }
        }

        @Override
        public Dimension minimumLayoutSize(Container comp) {
            Component[] cdn;
            if (comp != null && (cdn = comp.getComponents()) != null && cdn.length > 0) {
                int count = cdn.length;
                int high = 0;
                Insets oIsets = comp.getInsets();
                int outHigh = this.upM + oIsets.top + oIsets.bottom;
                int outWdh = oIsets.left + oIsets.right;
                int maxWdh = 0;
                for (int counter = 0; counter < count; ++counter) {
                    Dimension aSize = cdn[counter].getPreferredSize();
                    high = Math.max(high, aSize.height);
                    maxWdh = Math.max(maxWdh, aSize.width);
                }
                return new Dimension(outWdh + count * maxWdh + (count - 1) * this.topG, outHigh + high);
            }
            return new Dimension(0, 0);
        }

        @Override
        public Dimension preferredLayoutSize(Container c) {
            return this.minimumLayoutSize(c);
        }

        @Override
        public void removeLayoutComponent(Component c) {
        }
    }

    class FilterComboBoxRenderer
    extends DefaultListCellRenderer {
        FilterComboBoxRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList jList, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            super.getListCellRendererComponent((JList<?>)jList, value, index, isSelected, cellHasFocus);
            if (value instanceof TKFileFilter) {
                this.setText(((TKFileFilter)value).getDescription());
            }
            return this;
        }
    }

    class AlignedLabel
    extends JLabel {
        private AlignedLabel[] group;
        private int maxWdh;

        AlignedLabel(String str) {
            super(str);
            this.maxWdh = 0;
            this.setAlignmentX(0.0f);
        }

        @Override
        public Dimension getPreferredSize() {
            Dimension dms = super.getPreferredSize();
            return new Dimension(this.getMaxWidth() + 11, dms.height);
        }

        private int getMaxWidth() {
            if (this.maxWdh == 0 && this.group != null) {
                int i;
                int val = 0;
                for (i = 0; i < this.group.length; ++i) {
                    val = Math.max(this.group[i].getSuperPreferredWidth(), val);
                }
                for (i = 0; i < this.group.length; ++i) {
                    this.group[i].maxWdh = val;
                }
            }
            return this.maxWdh;
        }

        private int getSuperPreferredWidth() {
            return super.getPreferredSize().width;
        }

        static /* synthetic */ AlignedLabel[] access$1102(AlignedLabel x0, AlignedLabel[] x1) {
            x0.group = x1;
            return x1;
        }
    }

    class FileRenderer
    extends DefaultListCellRenderer {
        FileRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList jList, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            super.getListCellRendererComponent((JList<?>)jList, value, index, isSelected, cellHasFocus);
            TKFile file = (TKFile)value;
            String fileName = file.getName();
            this.setText(fileName);
            FileIcon fIcon = new FileIcon(TKFileChooserUI.this.getFileIcon(file));
            this.setIcon(fIcon);
            return this;
        }
    }

    class UpFolderAction
    extends AbstractAction {
        private UpFolderAction() {
            super(TKFileChooserUI.this.res.getString("upFolderButtonToolTipText"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            TKFile f = TKFileChooserUI.this.getCurrentDirectory();
            if (f == null) {
                return;
            }
            int brwType = TKFileChooserUI.this.tkFileChooser.getBrowseType();
            if (brwType == 101 && f.getPath().equals(TKFileUtilities.lastToolkitPath.getPath())) {
                return;
            }
            TKFile pf = TKFileUtilities.getParent(f);
            if (pf != null) {
                TKFileChooserUI.this.updateCurrentDirectory(pf);
            }
        }
    }

    class RefreshAction
    extends AbstractAction {
        private RefreshAction() {
            super(TKFileChooserUI.this.res.getString("refreshBtnToolTipText"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (!TKFileChooserUI.this.isReadyDo(false)) {
                return;
            }
            TKFileChooserUI.this.listDirectory(TKFileChooserUI.this.getCurrentDirectory());
        }
    }

    class GoHomeAction
    extends AbstractAction {
        private GoHomeAction() {
            super(TKFileChooserUI.this.res.getString("homeFolderButtonToolTipText"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            TKFile f = TKFileChooserUI.this.getCurrentDirectory();
            int brwType = TKFileChooserUI.this.tkFileChooser.getBrowseType();
            if (brwType == 101) {
                if (!f.getPath().equals(TKFileUtilities.lastToolkitPath.getPath())) {
                    TKFileChooserUI.this.updateCurrentDirectory(TKFileUtilities.lastToolkitPath);
                }
            } else {
                while (TKFileUtilities.getParent(f) != null && (f = TKFileUtilities.getParent(f)) != null) {
                }
                if (null != f && !f.equals(TKFileChooserUI.this.getCurrentDirectory())) {
                    TKFileChooserUI.this.updateCurrentDirectory(f);
                }
            }
        }
    }

    class FileIcon
    implements Icon {
        Icon icon_ = null;

        public FileIcon(Icon icon) {
            this.icon_ = icon;
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            this.icon_.paintIcon(c, g, x, y);
        }

        @Override
        public int getIconWidth() {
            return TKFileChooserUI.this.iconOfDirectory.getIconWidth();
        }

        @Override
        public int getIconHeight() {
            return TKFileChooserUI.this.iconOfDirectory.getIconHeight();
        }
    }

    class ButtonIcon
    implements Icon {
        Icon icon_ = null;

        public ButtonIcon(Icon icon) {
            this.icon_ = icon;
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            this.icon_.paintIcon(c, g, x, y);
        }

        @Override
        public int getIconWidth() {
            return 18;
        }

        @Override
        public int getIconHeight() {
            return 18;
        }
    }

    class IndentIcon
    implements Icon {
        Icon picObj = null;
        int dpt = 0;

        public IndentIcon() {
            this.picObj = TKFileChooserUI.this.iconOfDirectory;
        }

        @Override
        public void paintIcon(Component comp, Graphics graph, int h, int v) {
            if (comp.getComponentOrientation().isLeftToRight()) {
                this.picObj.paintIcon(comp, graph, h + this.dpt * 10, v);
            } else {
                this.picObj.paintIcon(comp, graph, h, v);
            }
        }

        @Override
        public int getIconWidth() {
            return this.picObj.getIconWidth() + this.dpt * 10;
        }

        @Override
        public int getIconHeight() {
            return this.picObj.getIconHeight();
        }
    }

    class DirectoryComboBoxRenderer
    extends DefaultListCellRenderer {
        IndentIcon indIcn;

        DirectoryComboBoxRenderer() {
            this.indIcn = new IndentIcon();
        }

        @Override
        public Component getListCellRendererComponent(JList argLst, Object valObj, int num, boolean isChoosed, boolean isFocus) {
            Icon icn;
            super.getListCellRendererComponent((JList<?>)argLst, valObj, num, isChoosed, isFocus);
            if (valObj == null) {
                this.setText("");
                return this;
            }
            TKFile tkDir = (TKFile)valObj;
            String directoryName = tkDir.getName();
            this.setText(directoryName);
            this.setToolTipText(tkDir.toString());
            this.indIcn.picObj = icn = TKFileChooserUI.this.getFileIcon(tkDir);
            this.indIcn.dpt = TKFileChooserUI.this.dirComboxModel.getDepth(num);
            this.setIcon(this.indIcn);
            return this;
        }
    }

    class FilterComboBoxAction
    extends AbstractAction {
        private FilterComboBoxAction() {
            super("FilterComboBoxAction");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            TKFileFilter selectTkFilter = (TKFileFilter)TKFileChooserUI.this.filterComboBox.getSelectedItem();
            if (TKFileChooserUI.this.getCurrentDirectory() != null && selectTkFilter != null && selectTkFilter != TKFileChooserUI.this.curFileFilter) {
                TKFileChooserUI.this.curFileFilter = selectTkFilter;
                if (!TKFileChooserUI.this.isReadyDo(false)) {
                    return;
                }
                TKFileChooserUI.this.updateCurrentDirectory(TKFileChooserUI.this.getCurrentDirectory());
            }
        }
    }

    class DirectoryComboBoxAction
    extends AbstractAction {
        private DirectoryComboBoxAction() {
            super("DirectoryComboBoxAction");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (!TKFileChooserUI.this.isReadyDo(false)) {
                return;
            }
            TKFile selectTkFile = (TKFile)TKFileChooserUI.this.dirCombox.getSelectedItem();
            if (selectTkFile != null && TKFileChooserUI.this.getCurrentDirectory() != selectTkFile) {
                TKFileChooserUI.this.updateCurrentDirectory(selectTkFile);
            }
        }
    }

    class DirectoryComboBoxModel
    extends AbstractListModel
    implements ComboBoxModel {
        Vector m_oDirectoriesVct = new Vector();
        int[] m_idepths = null;
        TKFile m_oSelectedDirectory = null;

        public DirectoryComboBoxModel() {
            this.setSelectedItem(TKFileChooserUI.this.rootDirs[0]);
        }

        public void removeAllItems() {
            this.m_oSelectedDirectory = null;
            this.m_oDirectoriesVct.clear();
        }

        private void addItem(TKFile oDirectory) {
            if (oDirectory == null) {
                return;
            }
            String dirName = oDirectory.getName();
            if (dirName == null || dirName.trim().equals("")) {
                return;
            }
            TKFileChooserUI.this.setUpHomeBtnSts(oDirectory);
            this.m_oDirectoriesVct.clear();
            this.m_oDirectoriesVct.addAll(Arrays.asList(TKFileChooserUI.this.rootDirs));
            TKFile oFileInfo = oDirectory;
            Vector<TKFile> path = new Vector<TKFile>(10);
            do {
                path.addElement(oFileInfo);
            } while ((oFileInfo = TKFileUtilities.getParent(oFileInfo)) != null);
            int pathCount = path.size();
            for (int i = 0; i < pathCount; ++i) {
                oFileInfo = (TKFile)path.get(i);
                if (!this.m_oDirectoriesVct.contains(oFileInfo)) continue;
                int topIndex = this.m_oDirectoriesVct.indexOf(oFileInfo);
                for (int j = i - 1; j >= 0; --j) {
                    TKFile tf = (TKFile)path.get(j);
                    this.m_oDirectoriesVct.insertElementAt(tf, topIndex + i - j);
                }
                break;
            }
            this.calculateDepths();
            this.setSelectedItem(oDirectory);
        }

        private void calculateDepths() {
            int iLength = this.m_oDirectoriesVct.size();
            this.m_idepths = new int[iLength];
            TKFile dir = null;
            TKFile parent = null;
            block0: for (int i = 0; i < iLength; ++i) {
                dir = (TKFile)this.m_oDirectoriesVct.get(i);
                if (dir == null) continue;
                parent = TKFileUtilities.getParent(dir);
                this.m_idepths[i] = 0;
                if (parent == null) continue;
                for (int j = i - 1; j >= 0; --j) {
                    if (!parent.equals((TKFile)this.m_oDirectoriesVct.get(j))) continue;
                    this.m_idepths[i] = this.m_idepths[j] + 1;
                    continue block0;
                }
            }
        }

        public int getDepth(int i) {
            return this.m_idepths != null && i >= 0 && i < this.m_idepths.length ? this.m_idepths[i] : 0;
        }

        @Override
        public void setSelectedItem(Object selectedDirectory) {
            this.m_oSelectedDirectory = (TKFile)selectedDirectory;
            this.fireContentsChanged(this, -1, -1);
        }

        @Override
        public Object getSelectedItem() {
            return this.m_oSelectedDirectory;
        }

        @Override
        public int getSize() {
            return this.m_oDirectoriesVct.size();
        }

        @Override
        public Object getElementAt(int index) {
            return this.m_oDirectoriesVct.elementAt(index);
        }
    }
}

