/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.toolkit.client.base.util.filechooser;

import com.huawei.dc.common.components.u2kcbb.U2kPasswordFiled;
import com.huawei.dc.common.util.DCDebugTracer;
import com.huawei.dc.toolkit.client.base.communicate.TKCommUtility;
import com.huawei.dc.toolkit.client.base.communicate.TKCommandResult;
import com.huawei.dc.toolkit.client.base.util.TKCommonUtil;
import com.huawei.dc.toolkit.client.base.util.TKFile;
import com.huawei.dc.toolkit.client.base.util.TKFileUtilities;
import com.huawei.dc.toolkit.client.base.util.TKRes;
import com.huawei.dc.toolkit.client.base.util.TKResourceManager;
import com.huawei.dc.toolkit.client.base.util.TKScreenToolKit;
import com.huawei.dc.toolkit.client.base.util.component.TKButton;
import com.huawei.dc.toolkit.client.base.util.component.TKCheckBox;
import com.huawei.dc.toolkit.client.base.util.component.TKComponentToolkit;
import com.huawei.dc.toolkit.client.base.util.component.TKIntegerTextField;
import com.huawei.dc.toolkit.client.base.util.component.TKIpTextField;
import com.huawei.dc.toolkit.client.base.util.component.TKList;
import com.huawei.dc.toolkit.client.base.util.component.TKNameTextField;
import com.huawei.dc.toolkit.client.base.util.component.TKTextField;
import com.huawei.dc.toolkit.client.base.util.filechooser.TKFileChooser;
import com.huawei.dc.toolkit.client.base.util.filechooser.TKToolkitFileModel;
import com.huawei.dc.toolkit.client.base.util.operresult.TKOperationShowMgr;
import com.huawei.te.toolkit.AsnToolkitFileBrowseReq;
import com.huawei.te.toolkit.AsnToolkitFileBrowseRsp;
import com.huawei.te.toolkit.AsnToolkitFileBrowseRspSeqOf;
import com.huawei.te.toolkit.AsnToolkitFileBrowseRspSeqOf1;
import com.huawei.te.toolkit.AsnToolkitFileInfo;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.File;
import java.math.BigInteger;
import java.util.Arrays;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListModel;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import net.commustru.fstru.FStruct;

public class TKFileChooserPanel
extends JPanel {
    TKRes res = TKRes.instance();
    TKFileChooser fc;
    TKTextField jTFUser = new TKNameTextField();
    U2kPasswordFiled jTFPw = null;
    TKIpTextField jTFHost = new TKIpTextField();
    TKIntegerTextField jTFPt = new TKIntegerTextField(0, 65535);
    TKButton jBtnConnect = new TKButton();
    TKCheckBox jCheckBoxFtp = new TKCheckBox();
    JPanel jPanelFtpInfo = new JPanel();
    DefaultListModel listModel = new DefaultListModel();
    TKList jListFile = new TKList((ListModel)this.listModel);
    TKButton jBtnRmv = new TKButton();
    TKButton jBtnAdd = new TKButton();
    TKButton jBtnCancel = new TKButton();
    TKButton jBtnOpen = new TKButton();
    JPanel jPanelButton = new JPanel();
    JPanel jPanelFtp;
    JPanel jPanelFileUI;
    BorderLayout borderLayout1 = new BorderLayout();
    JPanel jPanelCenter = new JPanel();
    BorderLayout borderLayout2 = new BorderLayout();
    JPanel jPanelMutilFile = new TKMutiFilePanel();
    JPanel jPanelBottom = new JPanel();
    BorderLayout borderLayout3 = new BorderLayout();
    GridBagLayout gridBagLayout1 = new GridBagLayout();
    private TKFile[] roots;
    private TKFile[] files;
    private TKFile curPath;
    private TKFile[] oldRoots;
    private TKFile[] oldFiles;
    private TKFile oldCurPath;
    private boolean isFtp = false;
    private static final Insets shrinkwrap = new Insets(0, 0, 0, 0);
    private boolean isOkToApprove = false;
    private final String XFTP_INIT_PORT = "22";
    KeyAdapter escKa = new KeyAdapter(){

        @Override
        public void keyReleased(KeyEvent e) {
            if (e.getKeyCode() == 27) {
                TKFileChooserPanel.this.fc.cancleAction();
            }
        }
    };
    KeyAdapter connKa = new KeyAdapter(){

        @Override
        public void keyReleased(KeyEvent e) {
            if (e.getKeyCode() == 10) {
                TKFileChooserPanel.this.cntBtn_actionPerformed();
            }
        }
    };
    KeyAdapter switchKa = new KeyAdapter(){

        @Override
        public void keyReleased(KeyEvent e) {
            if (e.getKeyCode() == 10) {
                TKFileChooserPanel.this.jCheckBoxFtp.setSelected(TKFileChooserPanel.this.isFtp);
                TKFileChooserPanel.this.updateServerType();
            }
        }
    };

    public TKFileChooserPanel(TKFileChooser fc) {
        this.fc = fc;
        try {
            this.jbInit();
        }
        catch (Exception e) {
            DCDebugTracer.trace(e);
        }
        fc.fcui.fileNameTextField.requestFocus();
    }

    void jbInit() throws Exception {
        this.jPanelFileUI = this.fc.getUI().getFileChooserUI();
        this.jTFPw = new U2kPasswordFiled(this.fc.getDialog());
        this.jPanelFtp = new TKFtpPanel();
        this.setLayout(this.borderLayout1);
        this.jPanelCenter.setLayout(this.borderLayout2);
        this.jBtnCancel.setText(this.res.getString("cancelButtonText"));
        this.jBtnOpen.setText(this.res.getString("OpenButtonText"));
        this.jPanelBottom.setLayout(this.borderLayout3);
        this.jPanelBottom.setBorder(new EmptyBorder(0, 12, 0, 12));
        this.jPanelButton.setLayout(this.gridBagLayout1);
        this.add((Component)this.jPanelFtp, "North");
        this.add((Component)this.jPanelCenter, "Center");
        this.jPanelCenter.add((Component)this.jPanelFileUI, "Center");
        this.jPanelCenter.add((Component)this.jPanelMutilFile, "East");
        this.add((Component)this.jPanelBottom, "South");
        this.jPanelBottom.add((Component)this.jPanelButton, "East");
        this.jPanelButton.add((Component)this.jBtnOpen, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(5, 5, 9, 10), 0, 0));
        this.jPanelButton.add((Component)this.jBtnCancel, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(5, 0, 9, 1), 0, 0));
        this.jBtnAdd.setName("_Button_Add");
        this.jBtnCancel.setName("_Button_Cancel");
        this.jListFile.setName("_ListBox_File");
        this.jBtnRmv.setName("_Button_Remove");
        this.jBtnOpen.setName("_Button_Open");
        this.jTFUser.setName("_TextField_User");
        this.jTFPw.setName("_TextField_Password");
        this.jTFHost.setName("_TextField_Host");
        this.jTFPt.setName("_TextField_Port");
        this.jBtnConnect.setName("_Button_Connect");
        this.jCheckBoxFtp.setName("_CheckBox_FTP");
        this.initFtp();
        this.initAction();
        this.fc.fcui.fileNameTextField.requestFocus();
    }

    protected boolean isOkToApprove() {
        return this.isOkToApprove;
    }

    private void removeSelectedFile() {
        Object[] files = this.jListFile.getSelectedValues();
        for (int i = 0; i < files.length; ++i) {
            this.listModel.removeElement(files[i]);
        }
    }

    protected void addFiles() {
        TKFile[] files = this.fc.getSelectedFiles();
        if (files == null) {
            return;
        }
        for (int i = 0; i < files.length; ++i) {
            if (files[i] == null || !files[i].isFile() || this.listModel.contains(files[i])) continue;
            this.listModel.addElement(files[i]);
        }
    }

    private void initAction() {
        if (!this.fc.isShowFtp()) {
            this.jPanelFtpInfo.setVisible(false);
            this.jCheckBoxFtp.setSelected(false);
            this.jCheckBoxFtp.setVisible(false);
            this.jCheckBoxFtp.setEnabled(false);
        }
        if (!this.fc.isShowToolkit()) {
            this.jCheckBoxFtp.setSelected(true);
            this.jCheckBoxFtp.setEnabled(false);
            this.jPanelFtp.setVisible(true);
        }
        if (this.fc.getBrowseType() == 102) {
            this.jPanelFtp.setVisible(false);
            this.isFtp = false;
        } else if (this.fc.getBrowseType() == 100) {
            this.jCheckBoxFtp.setSelected(true);
            this.isFtp = true;
        } else if (this.fc.getBrowseType() == 101) {
            this.jCheckBoxFtp.setSelected(false);
            this.isFtp = false;
        }
        this.enableFtpInfo(this.isFtp);
        TKComponentToolkit.addAllKeyListener(this, "javax.swing.JComponent", this.escKa);
        this.jTFHost.addKeyListener(this.connKa);
        this.jTFPt.addKeyListener(this.connKa);
        this.jTFPw.addKeyListener(this.connKa);
        this.jTFUser.addKeyListener(this.connKa);
        TKComponentToolkit.addAllButtonEnterKeyAdp(this);
        UpdateServerActionListener actionLis = new UpdateServerActionListener();
        this.jCheckBoxFtp.addActionListener(actionLis);
        this.jCheckBoxFtp.addKeyListener(this.switchKa);
        boolean showMutilFile = this.fc.isMultiSelectionEnabled() && this.fc.getFileSelectionModel() == 0;
        this.jPanelMutilFile.setVisible(showMutilFile);
        this.jPanelBottom.setVisible(showMutilFile);
        this.jBtnRmv.setEnabled(false);
        this.jListFile.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                TKFileChooserPanel.this.jBtnRmv.setEnabled(TKFileChooserPanel.this.jListFile.getSelectedValues().length > 0);
            }
        });
        this.jBtnRmv.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TKFileChooserPanel.this.removeSelectedFile();
            }
        });
        this.jBtnAdd.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TKFileChooserPanel.this.addFiles();
            }
        });
        this.jBtnOpen.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (TKFileChooserPanel.this.listModel.size() == 0) {
                    if (TKFileChooserPanel.this.fc.getSelectedFile() == null) {
                        TKFileChooserPanel.this.fc.fcui.checkInputFileName();
                        return;
                    }
                    if (!TKFileChooserPanel.this.fc.getSelectedFile().isFile()) {
                        TKFileChooserPanel.this.fc.getUI().updateCurrentDirectory(TKFileChooserPanel.this.fc.getSelectedFile());
                    }
                } else {
                    Object[] selectFiles = new TKFile[TKFileChooserPanel.this.listModel.size()];
                    TKFileChooserPanel.this.listModel.copyInto(selectFiles);
                    TKFileChooserPanel.this.fc.setSelectedFiles((TKFile[])selectFiles);
                }
                TKFileChooserPanel.this.isOkToApprove = true;
                TKFileChooserPanel.this.fc.approveAction();
            }
        });
        this.jBtnCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TKFileChooserPanel.this.isOkToApprove = false;
                TKFileChooserPanel.this.fc.cancleAction();
            }
        });
        this.jBtnConnect.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TKFileChooserPanel.this.cntBtn_actionPerformed();
            }
        });
    }

    private void enableFtpInfo(boolean enable) {
        this.jTFHost.setEnabled(enable);
        this.jTFPt.setEnabled(enable);
        this.jTFPw.setEnabled(enable);
        this.jTFUser.setEnabled(enable);
        this.jBtnConnect.setEnabled(enable);
    }

    public JPanel getPanel() {
        return this;
    }

    private void updateServerType() {
        this.oldCurPath = this.fc.getUI().getCurrentDirectory();
        this.oldFiles = this.fc.getUI().fileList();
        this.oldRoots = this.fc.getUI().rootList();
        this.listModel.clear();
        if (!this.jCheckBoxFtp.isSelected()) {
            this.isFtp = false;
            this.fc.getUI().clear();
            this.fc.setBrowseType(101);
            if (this.roots != null && this.files != null && this.curPath != null) {
                this.fc.getUI().updateRootList(this.roots);
                if (this.files.length > 0 && this.files[0] != null) {
                    this.curPath = TKFileUtilities.getParent(this.files[0]);
                }
                this.fc.getUI().updateFileList(this.files, this.curPath);
            } else {
                this.updateFileList(false);
            }
        } else {
            this.isFtp = true;
            this.fc.setBrowseType(100);
            this.jTFHost.requestFocus();
            this.fc.getUI().clear();
            if (this.roots != null && this.files != null && this.curPath != null) {
                this.fc.getUI().updateRootList(this.roots);
                if (this.files.length > 0 && this.files[0] != null) {
                    this.curPath = TKFileUtilities.getParent(this.files[0]);
                }
                this.fc.getUI().updateFileList(this.files, this.curPath);
            }
        }
        this.roots = this.oldRoots;
        this.files = this.oldFiles;
        this.curPath = this.oldCurPath;
    }

    private void initFtp() {
        this.jTFHost.setText(TKFileUtilities.ftpServer);
        this.jTFUser.setText(TKFileUtilities.ftpUser);
        String pt = String.valueOf(TKFileUtilities.ftpPort);
        pt = pt.equals("0") ? "22" : pt;
        pt = pt.equals("") ? "22" : pt;
        this.jTFPt.setText(pt);
        this.jTFPw.setPassword(TKFileUtilities.ftpPass.toCharArray());
    }

    private void cntBtn_actionPerformed() {
        boolean isRightIP = TKResourceManager.isRightIP(this.jTFHost.getText().trim());
        if (!isRightIP) {
            this.jTFHost.requestFocus();
            TKOperationShowMgr.showOperationDlg((Component)this.getPanel(), this.res.getString("IPInfoFail"), false);
            return;
        }
        if (this.jTFUser.getText().trim().equals("")) {
            this.jTFUser.requestFocus();
            TKOperationShowMgr.showOperationDlg((Component)this.getPanel(), this.res.getString("UserInfoFail"), false);
            return;
        }
        if (String.valueOf(this.jTFPw.getPasswordInChar()).isEmpty()) {
            this.jTFPw.requestFocus();
            TKOperationShowMgr.showOperationDlg((Component)this.getPanel(), this.res.getString("PwdInfoFail"), false);
            return;
        }
        int port = this.jTFPt.getValue();
        if (port != TKCommonUtil.getxFtpPort()) {
            port = TKCommonUtil.getxFtpPort();
        }
        if (port < 1) {
            this.jTFPt.requestFocus();
            TKOperationShowMgr.showOperationDlg((Component)this.getPanel(), this.res.getString("PortInfoFail"), false);
            return;
        }
        if (port > 65535) {
            this.jTFPt.requestFocus();
            TKOperationShowMgr.showOperationDlg((Component)this.getPanel(), this.res.getString("PortInfoFail2"), false);
            return;
        }
        this.fc.getUI().notifyFtpConnected(true);
        this.isFtp = true;
        new Thread(){

            @Override
            public void run() {
                TKFileChooserPanel.this.updateFileList(true);
            }
        }.start();
    }

    private void updateFileList(boolean showError) {
        Object[] files;
        String ftpIp = this.jTFHost.getText().trim();
        String ftpUser = this.jTFUser.getText().trim();
        String ftpPawd = String.valueOf(this.jTFPw.getPasswordInChar());
        int ftpPort = this.jTFPt.getValue();
        String lastPath = TKFileUtilities.lastToolkitPath.getAbsolutePath();
        if (lastPath.trim().equals("")) {
            return;
        }
        AsnToolkitFileBrowseReq req = new AsnToolkitFileBrowseReq();
        req.dir = lastPath.getBytes();
        req.ftpInfo.ip = ftpIp.getBytes();
        req.ftpInfo.userName = ftpUser.getBytes();
        req.ftpInfo.userPwd = ftpPawd.getBytes();
        req.ftpInfo.port = BigInteger.valueOf(ftpPort);
        String IP = ftpIp;
        if (showError && IP.equals("0.0.0.0") || IP.equals("255.255.255.255")) {
            TKOperationShowMgr.showOperationDlg((Component)this.getPanel(), this.res.getString("InputErr"), false);
            return;
        }
        char cmdCode = '\u1701';
        if (this.isFtp) {
            req.dir = "/".getBytes();
            cmdCode = '\u1702';
        }
        AsnToolkitFileBrowseRsp rsp = new AsnToolkitFileBrowseRsp();
        byte receiveModule1 = 23;
        TKScreenToolKit.setComponentCursorBusy(this.fc.getDialog(), true);
        TKCommandResult ret = TKCommUtility.sendCommand((FStruct)req, (FStruct)rsp, cmdCode, receiveModule1, 120);
        TKScreenToolKit.setComponentCursorBusy(this.fc.getDialog(), false);
        if (!ret.isSuccess) {
            TKOperationShowMgr.showOperationDlg((Component)TKResourceManager.getMainFrame(), ret.resultInfo, false);
            return;
        }
        if (!rsp.ret.isSuccess && showError) {
            TKOperationShowMgr.showOperationDlg((Component)TKResourceManager.getMainFrame(), TKRes.getErrorInfo(rsp.ret), false);
            this.fc.getUI().notifyFtpConnected(false);
        }
        AsnToolkitFileBrowseRspSeqOf1 rootSeq = rsp.rootList;
        AsnToolkitFileBrowseRspSeqOf fileSeq = rsp.fileList;
        if (null == rootSeq) {
            return;
        }
        TKFile[] roots = new TKFile[rsp.rootList.size()];
        for (int i = 0; i < rootSeq.size(); ++i) {
            String root = new String((byte[])rootSeq.get(i));
            root = root.replace(File.separator.toCharArray()[0], "/".toCharArray()[0]);
            TKFile tkfile = new TKFile(root, 1, true, "Drive");
            tkfile.size = 0L;
            tkfile.modified = "";
            roots[i] = tkfile;
        }
        String directory = new String(rsp.dir);
        directory = directory.endsWith("/") ? directory : directory + "/";
        directory = directory.replace(File.separator.toCharArray()[0], "/".toCharArray()[0]);
        if (null == fileSeq) {
            files = new TKFile[]{new TKFile("")};
            files[0].isHidden(true);
        } else {
            files = new TKFile[fileSeq.size()];
            for (int i = 0; i < fileSeq.size(); ++i) {
                AsnToolkitFileInfo file = (AsnToolkitFileInfo)fileSeq.get(i);
                TKFile tkfile = new TKFile(directory + new String(file.fileName), file.type.intValue());
                try {
                    tkfile.size = Long.parseLong(new String(file.length));
                }
                catch (Exception ex) {
                    DCDebugTracer.trace(ex);
                }
                tkfile.modified = new String(file.time);
                files[i] = tkfile;
            }
        }
        TKFile path = new TKFile(directory, 1);
        if (directory.equals("/")) {
            path.isRoot(true);
        }
        if (files != null) {
            Arrays.sort(files);
        }
        this.fc.getUI().setCurrentDirectory(path);
        this.fc.getUI().updateRootList(roots);
        this.fc.getUI().updateFileList((TKFile[])files, path);
        TKToolkitFileModel tfm = (TKToolkitFileModel)this.fc.getUI().getFileModel();
        tfm.firePropertyChange("1", ftpIp);
        tfm.firePropertyChange("3", ftpUser);
        tfm.firePropertyChange("4", ftpPawd);
        tfm.firePropertyChange("2", String.valueOf(ftpPort));
        int ipt = ftpPort;
        if (0 == ftpPort) {
            ipt = Integer.valueOf("22");
        }
        TKFileUtilities.ftpPort = ipt;
        TKFileUtilities.ftpServer = ftpIp;
        TKFileUtilities.ftpUser = ftpUser;
        TKFileUtilities.ftpPass = ftpPawd;
    }

    private class UpdateServerActionListener
    implements ActionListener {
        private UpdateServerActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            TKFileChooserPanel.this.isFtp = TKFileChooserPanel.this.jCheckBoxFtp.isSelected();
            TKFileChooserPanel.this.enableFtpInfo(TKFileChooserPanel.this.isFtp);
            TKFileChooserPanel.this.updateServerType();
        }
    }

    public class TKMutiFilePanel
    extends JPanel {
        BorderLayout borderLayoutMF = new BorderLayout();
        JPanel jPanelLeftButton = new JPanel();
        JPanel jPanelScrolMF = new JPanel();
        JScrollPane jScrollPaneMF = new JScrollPane();
        GridBagLayout gridBagLayoutMF = new GridBagLayout();
        BorderLayout borderLayoutMF2 = new BorderLayout();

        public TKMutiFilePanel() {
            try {
                this.jbInit();
            }
            catch (Exception ex) {
                DCDebugTracer.trace(ex);
            }
        }

        void jbInit() throws Exception {
            this.setBorder(new EmptyBorder(12, 0, 11, 11));
            this.jScrollPaneMF.setMinimumSize(new Dimension(0, 0));
            this.jScrollPaneMF.setPreferredSize(new Dimension(160, 20));
            this.setLayout(this.borderLayoutMF);
            this.jPanelScrolMF.setLayout(this.borderLayoutMF2);
            TKFileChooserPanel.this.jBtnRmv.setText(" << ");
            TKFileChooserPanel.this.jBtnAdd.setText(" >> ");
            TKFileChooserPanel.this.jBtnRmv.setMargin(shrinkwrap);
            TKFileChooserPanel.this.jBtnAdd.setMargin(shrinkwrap);
            this.jPanelLeftButton.setLayout(this.gridBagLayoutMF);
            this.add((Component)this.jPanelLeftButton, "West");
            this.jPanelLeftButton.add((Component)TKFileChooserPanel.this.jBtnAdd, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(88, 1, 0, 0), 0, 0));
            this.jPanelLeftButton.add((Component)TKFileChooserPanel.this.jBtnRmv, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(40, 1, 121, 0), 0, 0));
            this.jPanelScrolMF.setBorder(new EmptyBorder(0, 11, 0, 0));
            this.add((Component)this.jPanelScrolMF, "Center");
            this.jPanelScrolMF.add((Component)this.jScrollPaneMF, "Center");
            this.jScrollPaneMF.getViewport().add((Component)TKFileChooserPanel.this.jListFile, null);
        }
    }

    public class TKFtpPanel
    extends JPanel {
        JLabel jLabHost = new JLabel();
        JLabel jLabUser = new JLabel();
        JLabel jLabPW = new JLabel();
        JLabel jLabPt = new JLabel();
        GridBagLayout gridBagLayoutFtpPanel = new GridBagLayout();
        BorderLayout borderLayout1FtpPanel = new BorderLayout();

        public TKFtpPanel() {
            try {
                this.jbInit();
            }
            catch (Exception ex) {
                DCDebugTracer.trace(ex);
            }
        }

        void jbInit() throws Exception {
            this.setBorder(new EmptyBorder(12, 13, -6, 11));
            this.jLabHost.setText(TKFileChooserPanel.this.res.getString("FC_Server") + ":");
            TKFileChooserPanel.this.jTFHost.setText("");
            this.jLabUser.setText(TKFileChooserPanel.this.res.getString("FC_User") + ":");
            TKFileChooserPanel.this.jTFUser.setText("");
            this.jLabPW.setText(TKFileChooserPanel.this.res.getString("FC_Password") + ":");
            TKFileChooserPanel.this.jTFPw.setPassword("".toCharArray());
            this.jLabPt.setText(TKFileChooserPanel.this.res.getString("FC_Port") + ":");
            TKFileChooserPanel.this.jTFPt.setText("22");
            Icon connectIcon = TKResourceManager.getIcon("connectFtp.gif");
            TKFileChooserPanel.this.jBtnConnect.setToolTipText(TKFileChooserPanel.this.res.getString("FC_ConnectFTP"));
            TKFileChooserPanel.this.jBtnConnect.setIcon(connectIcon);
            TKFileChooserPanel.this.jBtnConnect.setMargin(shrinkwrap);
            this.jLabHost.setLabelFor(TKFileChooserPanel.this.jTFHost);
            this.jLabUser.setLabelFor(TKFileChooserPanel.this.jTFUser);
            this.jLabPW.setLabelFor(TKFileChooserPanel.this.jTFPw);
            this.jLabPt.setRequestFocusEnabled(true);
            this.jLabPt.setLabelFor(TKFileChooserPanel.this.jTFPt);
            TKFileChooserPanel.this.jCheckBoxFtp.setText(TKFileChooserPanel.this.res.getString("FileOnFtp"));
            this.setLayout(this.borderLayout1FtpPanel);
            TKFileChooserPanel.this.jPanelFtpInfo.setLayout(this.gridBagLayoutFtpPanel);
            this.borderLayout1FtpPanel.setVgap(0);
            this.add((Component)TKFileChooserPanel.this.jPanelFtpInfo, "Center");
            TKFileChooserPanel.this.jPanelFtpInfo.add((Component)this.jLabHost, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 1, 6, 0), 0, 0));
            TKFileChooserPanel.this.jPanelFtpInfo.add((Component)TKFileChooserPanel.this.jTFHost, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 6, 0), 87, 0));
            TKFileChooserPanel.this.jPanelFtpInfo.add((Component)TKFileChooserPanel.this.jTFPt, new GridBagConstraints(7, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 6, 5), 13, 0));
            TKFileChooserPanel.this.jPanelFtpInfo.add((Component)TKFileChooserPanel.this.jTFPw, new GridBagConstraints(5, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 6, 0), 63, 0));
            TKFileChooserPanel.this.jPanelFtpInfo.add((Component)TKFileChooserPanel.this.jTFUser, new GridBagConstraints(3, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 6, 0), 54, 0));
            TKFileChooserPanel.this.jPanelFtpInfo.add((Component)this.jLabPW, new GridBagConstraints(4, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 10, 6, 0), 0, 0));
            TKFileChooserPanel.this.jPanelFtpInfo.add((Component)this.jLabUser, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 10, 6, 0), 0, 0));
            TKFileChooserPanel.this.jPanelFtpInfo.add((Component)this.jLabPt, new GridBagConstraints(6, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 10, 6, 0), 0, 0));
            TKFileChooserPanel.this.jPanelFtpInfo.add((Component)TKFileChooserPanel.this.jBtnConnect, new GridBagConstraints(8, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 1, 6, 1), 0, 0));
            this.add((Component)TKFileChooserPanel.this.jCheckBoxFtp, "North");
        }
    }
}

