/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.toolkit.client.base.util.filechooser;

import com.huawei.dc.common.util.DCDebugTracer;
import com.huawei.dc.configuration.system.SystemSettingDlg;
import com.huawei.dc.toolkit.client.base.communicate.TKCommUtility;
import com.huawei.dc.toolkit.client.base.util.TKCommonUtil;
import com.huawei.dc.toolkit.client.base.util.TKFile;
import com.huawei.dc.toolkit.client.base.util.TKFileUtilities;
import com.huawei.dc.toolkit.client.base.util.TKFtpStruct;
import com.huawei.dc.toolkit.client.base.util.TKRes;
import com.huawei.dc.toolkit.client.base.util.TKResourceManager;
import com.huawei.dc.toolkit.client.base.util.TKScreenToolKit;
import com.huawei.dc.toolkit.client.base.util.filechooser.TKFileChooserPanel;
import com.huawei.dc.toolkit.client.base.util.filechooser.TKFileChooserUI;
import com.huawei.dc.toolkit.client.base.util.filechooser.TKFileFilter;
import com.huawei.dc.toolkit.client.base.util.filechooser.TKFileModel;
import com.huawei.dc.toolkit.client.base.util.filechooser.TKToolkitFileModel;
import com.huawei.dc.toolkit.client.base.util.help.TKHelpMgr;
import com.huawei.dc.toolkit.client.base.util.operresult.TKOperationShowMgr;
import com.huawei.dc.toolkit.control.Toolkit4T2kInterface;
import com.huawei.dc.toolkit.control.Toolkit4T2kInterfaceMgr;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Vector;
import javax.swing.JDialog;

public class TKFileChooser {
    private TKRes res = TKRes.instance();
    public static final int TKFILECHOOSER_SELECTION_ONLY_FILE = 0;
    public static final int TKFILECHOOSER_SELECTION_DIRECTORY = 1;
    public static final int TKFILECHOOSER_SELECTION_DIR_AND_FILE = 2;
    private int fileSelectModel = 0;
    public static final int TKFILECHOOSER_DISPOSE_CLOSE = -1;
    public static final int TKFILECHOOSER_DISPOSE_CANCLE = 1;
    public static final int TKFILECHOOSER_DISPOSE_APPROVE = 0;
    private int disposeType = -1;
    public static final int TKFILECHOOSER_BROWSE_FTP = 100;
    public static final int TKFILECHOOSER_BROWSE_TOOLKIT = 101;
    public static final int TKFILECHOOSER_BROWSE_NORMAL = 102;
    private int browseType = 101;
    TKFileChooserUI fcui = new TKFileChooserUI();
    private boolean isMultiSelectionEnabled = false;
    private boolean isControlButtonShown = true;
    private Window frame;
    boolean model = false;
    String dialogTitle = this.res.getString("FileChooser");
    JDialog dialog;
    boolean hasUpdateUI = false;
    private Vector filters = new Vector(5);
    private boolean isShowAllFileFilter = true;
    private TKFile selectedFile;
    private TKFile[] selectedFiles;
    private TKToolkitFileModel ToolkitFileModel = new TKToolkitFileModel(this.browseType);
    private boolean isShowFtp = true;
    private boolean isShowToolkit = true;
    String defualtFileName = "";
    private static final int WIDTH_C = 591;
    private static final int WIDTH_ZH = 540;
    private static final int HIGHT = 450;
    private static final int WIDTH_UNIX_C = 593;
    private static final int WIDTH_UNIX_ZH = 562;
    private static final int WIDTH_M = 760;
    private static final int HIGHT_M = 450;
    private int SFTPPORT = 22;
    private int FTPPORT = 21;
    TKFileChooserPanel fcPanel;

    public TKFileChooser(String oTkPath) {
        if (null != oTkPath) {
            TKFileUtilities.lastToolkitPath = new TKFile(oTkPath, 1);
        }
        this.dialogTitle = this.res.getString("FileChooser");
        this.model = true;
        this.frame = TKResourceManager.getMainFrame();
        this.fcui.setFileModel(this.ToolkitFileModel);
        this.fcui.setFileChooser(this);
        this.filters.add(TKFileFilter.getAllFileFilter());
        this.initFtp(TKFileUtilities.ftpServer, this.SFTPPORT, TKFileUtilities.ftpUser, "");
        this.fcui.setCurrentDirectory(TKFileUtilities.lastToolkitPath, 101);
        TKFtpStruct ftpPath = new TKFtpStruct(TKFileUtilities.lastFtpPath);
        ftpPath.ftpIP = TKFileUtilities.ftpServer;
        ftpPath.ftpPort = TKFileUtilities.ftpPort;
        ftpPath.ftpUser = TKFileUtilities.ftpUser;
        ftpPath.ftpPass = TKFileUtilities.ftpPass;
        this.fcui.setCurrentDirectory(ftpPath, 100);
    }

    public TKFileChooser() {
        if (null != TKCommonUtil.getRootPath()) {
            TKFileUtilities.lastToolkitPath = new TKFile(TKCommonUtil.getRootPath(), 1, true, "Drive");
        } else {
            SystemSettingDlg oSystemSettingDlg = new SystemSettingDlg();
            if (null != oSystemSettingDlg) {
                TKFileUtilities.lastToolkitPath = new TKFile(oSystemSettingDlg.getFTSRootPath(), 1, true, "Drive");
            }
        }
        this.dialogTitle = this.res.getString("FileChooser");
        this.model = true;
        this.frame = TKResourceManager.getMainFrame();
        this.fcui.setFileModel(this.ToolkitFileModel);
        this.fcui.setFileChooser(this);
        this.filters.add(TKFileFilter.getAllFileFilter());
        this.initFtp(TKFileUtilities.ftpServer, this.SFTPPORT, TKFileUtilities.ftpUser, "");
        this.fcui.setCurrentDirectory(TKFileUtilities.lastToolkitPath, 101);
        TKFtpStruct ftpPath = new TKFtpStruct(TKFileUtilities.lastFtpPath);
        ftpPath.ftpIP = TKFileUtilities.ftpServer;
        ftpPath.ftpPort = TKFileUtilities.ftpPort;
        ftpPath.ftpUser = TKFileUtilities.ftpUser;
        ftpPath.ftpPass = TKFileUtilities.ftpPass;
        this.fcui.setCurrentDirectory(ftpPath, 100);
    }

    public void setDefaultFileName(String defualtFileName) {
        this.defualtFileName = defualtFileName;
    }

    public String getDefaultFileName() {
        return this.defualtFileName;
    }

    public JDialog getDialog() {
        return this.dialog;
    }

    public void setShowFtpEnable(boolean b) {
        this.isShowFtp = b;
    }

    public void setShowToolkitEnable(boolean b) {
        this.isShowToolkit = b;
    }

    public boolean isShowFtp() {
        return this.isShowFtp;
    }

    public boolean isShowToolkit() {
        return this.isShowToolkit;
    }

    public TKFileModel getFileModel() {
        return this.ToolkitFileModel;
    }

    public void setBrowseType(int browseType) {
        this.browseType = browseType;
        if (browseType > 102 || browseType < 100) {
            this.browseType = 102;
        }
        this.ToolkitFileModel.setBrowseType(this.browseType);
    }

    public int getBrowseType() {
        return this.browseType;
    }

    public void setFileSelectionMode(int fileSelectModel) {
        this.fileSelectModel = fileSelectModel;
        if (fileSelectModel == 1) {
            this.setMultiSelectionEnabled(false);
        }
    }

    public int getFileSelectionModel() {
        return this.fileSelectModel;
    }

    public TKFile getSelectedFile() {
        return this.toFtpStruct(this.selectedFile);
    }

    public TKFileFilter getSelectedFilter() {
        return this.fcui.getSelectedFilter();
    }

    public TKFile[] getSelectedFiles() {
        if (this.selectedFiles == null) {
            return null;
        }
        TKFile[] retFiles = new TKFile[this.selectedFiles.length];
        for (int i = 0; i < this.selectedFiles.length; ++i) {
            retFiles[i] = this.toFtpStruct(this.selectedFiles[i]);
        }
        return retFiles;
    }

    public void setSelectedFile(TKFile selectedFile) {
        this.selectedFile = selectedFile;
    }

    public void setSelectedFiles(TKFile[] selectedFiles) {
        this.selectedFiles = selectedFiles;
    }

    public void setCurrentDirectory(TKFile currentDirectory) {
        this.fcui.setCurrentDirectory(currentDirectory);
    }

    public int getResultOption() {
        return this.disposeType;
    }

    public boolean isMultiSelectionEnabled() {
        return this.isMultiSelectionEnabled;
    }

    public void setMultiSelectionEnabled(boolean isMultiSelectionEnabled) {
        this.isMultiSelectionEnabled = isMultiSelectionEnabled;
        this.setControlButtonsAreShown(!isMultiSelectionEnabled);
    }

    public void approveAction() {
        if (this.selectedFile == null && (this.selectedFiles == null || this.selectedFiles.length == 0)) {
            return;
        }
        if (this.isMultiSelectionEnabled() && !this.fcPanel.isOkToApprove()) {
            this.fcPanel.addFiles();
            return;
        }
        if (this.selectedFile != null) {
            if (this.getBrowseType() != 100) {
                TKFileUtilities.lastToolkitPath = this.selectedFile.isFile() ? TKFileUtilities.getParent(this.selectedFile) : this.selectedFile;
            } else {
                TKFileUtilities.lastFtpPath = this.selectedFile.isFile() ? TKFileUtilities.getParent(this.selectedFile).getPath() : this.selectedFile.getPath();
            }
        }
        this.disposeType = 0;
        this.dialog.setVisible(false);
    }

    public void cancleAction() {
        this.disposeType = 1;
        this.setSelectedFile(null);
        this.setSelectedFiles(null);
        this.dialog.setVisible(false);
    }

    public void setDialogTitle(String title) {
        this.dialogTitle = title;
    }

    public void setShowAllFileFilter(boolean b) {
        this.isShowAllFileFilter = b;
    }

    public int showSaveFileDialog() {
        this.setDialogTitle(this.res.getString("SaveFile"));
        this.setMultiSelectionEnabled(false);
        this.fcui.setSaveAsOpr(true);
        this.fcui.saveFile();
        this.fcui.setSaveAsOpr(false);
        return this.showFileDialog();
    }

    public int showFileDialog() {
        if (this.getBrowseType() != 102 && !TKCommUtility.isConnected()) {
            TKOperationShowMgr.showOperationDlg((Component)TKResourceManager.getMainFrame(), this.res.getString("TKComm_Fail"), false);
            return 1;
        }
        boolean isSuccees = this.hasUpdateUI();
        if (!isSuccees) {
            return 1;
        }
        this.dialog = this.frame instanceof Frame ? new JDialog((Frame)this.frame, this.dialogTitle, this.model) : new JDialog((Dialog)this.frame, this.dialogTitle, this.model);
        this.fcui.setParentWin(this.dialog);
        this.fcPanel = new TKFileChooserPanel(this);
        this.dialog.getContentPane().add(this.fcPanel.getPanel());
        Toolkit4T2kInterface inf = Toolkit4T2kInterfaceMgr.getInstance();
        if (inf != null) {
            try {
                inf.helpComponent(this.dialog.getContentPane(), "HELP_TOPIC_CHOOSE_FILE");
            }
            catch (Exception ex) {
                DCDebugTracer.trace(ex);
            }
        } else {
            TKHelpMgr.instance().helpRootPane(this.dialog.getRootPane());
            TKHelpMgr.instance().helpComponent(this.dialog, "FileChooser");
        }
        int width = 591;
        int hight = 450;
        if (this.isMultiSelectionEnabled()) {
            width = 760;
            hight = 450;
        }
        this.dialog.setSize(width, hight);
        TKScreenToolKit.centerLocateToScreen(this.dialog);
        this.dialog.addWindowListener(new WindowAdapter(){

            @Override
            public void windowOpened(WindowEvent e) {
                TKFileChooser.this.fcui.fileNameTextField.requestFocus();
            }
        });
        this.dialog.show();
        this.fcui.fileNameTextField.requestFocus();
        this.dialog.dispose();
        return this.getResultOption();
    }

    public boolean getControlButtonsAreShown() {
        return this.isControlButtonShown;
    }

    public void setControlButtonsAreShown(boolean b) {
        this.isControlButtonShown = b;
    }

    private boolean hasUpdateUI() {
        boolean isSuccees = false;
        if (!this.hasUpdateUI) {
            isSuccees = this.fcui.setup(this);
            this.hasUpdateUI = true;
        }
        return isSuccees;
    }

    public TKFileChooserUI getUI() {
        this.hasUpdateUI();
        return this.fcui;
    }

    public void addFileFilter(TKFileFilter fileFilter) {
        if (!this.filters.contains(fileFilter)) {
            this.filters.add(0, fileFilter);
        }
    }

    public void removeFileFilter(TKFileFilter fileFilter) {
        this.filters.remove(fileFilter);
    }

    public TKFileFilter[] getFilters() {
        Object[] filterArray = new TKFileFilter[this.filters.size()];
        this.filters.copyInto(filterArray);
        return filterArray;
    }

    public void initFtp(String sv, int pt, String usr, String pw) {
        int ipt;
        this.ToolkitFileModel.firePropertyChange("1", sv);
        this.ToolkitFileModel.firePropertyChange("2", String.valueOf(pt));
        this.ToolkitFileModel.firePropertyChange("3", usr);
        this.ToolkitFileModel.firePropertyChange("4", pw);
        TKFileUtilities.ftpPass = pw;
        TKFileUtilities.ftpServer = sv;
        String spt = String.valueOf(pt);
        TKFileUtilities.ftpPort = ipt = Integer.valueOf(spt.equals("0") ? this.FTPPORT : pt).intValue();
        TKFileUtilities.ftpUser = usr;
    }

    public TKFtpStruct toFtpStruct(TKFile tkFile) {
        if (tkFile == null) {
            return null;
        }
        TKFtpStruct ftpStruct = new TKFtpStruct(tkFile.getPath(), tkFile.fileType());
        ftpStruct.ftpIP = this.ToolkitFileModel.getProperty("1");
        ftpStruct.ftpPass = this.ToolkitFileModel.getProperty("4");
        try {
            ftpStruct.ftpPort = Integer.parseInt(this.ToolkitFileModel.getProperty("2"));
        }
        catch (Exception ex) {
            DCDebugTracer.trace(ex);
        }
        ftpStruct.ftpUser = this.ToolkitFileModel.getProperty("3");
        ftpStruct.isFtp = this.getBrowseType() == 100;
        return ftpStruct;
    }

    public Window getFrame() {
        return this.frame;
    }

    public void setFrame(Window frame) {
        this.frame = frame;
    }
}

