/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.toolkit.client.base.util.filechooser;

import com.huawei.dc.common.util.DCDebugTracer;
import com.huawei.dc.toolkit.client.base.util.TKFile;
import com.huawei.dc.toolkit.client.base.util.TKFileUtilities;
import com.huawei.dc.toolkit.client.base.util.TKFtpStruct;
import com.huawei.dc.toolkit.client.base.util.TKRes;
import com.huawei.dc.toolkit.client.base.util.TKResourceManager;
import com.huawei.dc.toolkit.client.base.util.filechooser.TKFileModel;
import com.huawei.dc.toolkit.client.base.util.operresult.TKOperationShowMgr;
import java.awt.Component;
import java.io.File;
import java.util.Arrays;
import java.util.Vector;

public class TKDefaultFileModel
implements TKFileModel {
    TKRes res = TKRes.instance();

    @Override
    public TKFile[] listRoot(TKFile tkFile) {
        File[] roots = File.listRoots();
        TKFile[] root = new TKFile[roots.length];
        for (int i = 0; i < roots.length; ++i) {
            String path = roots[i].getAbsolutePath().replace(File.separator.toCharArray()[0], "/".toCharArray()[0]);
            root[i] = new TKFile(path, 1, true, "Drive");
        }
        TKFile[] files = this.listFiles(tkFile, true);
        TKFile[] rtFiles = null;
        if (files == null) {
            files = this.listFiles(root[0], true);
        }
        if (files == null || files.length <= 0) {
            return root;
        }
        rtFiles = new TKFile[files.length + root.length];
        System.arraycopy(root, 0, rtFiles, 0, root.length);
        System.arraycopy(files, 0, rtFiles, root.length, files.length);
        return rtFiles;
    }

    @Override
    public TKFile[] listFiles(TKFile tkFile, boolean isIgnoreError) {
        File[] fs;
        if (tkFile.isComputer()) {
            fs = File.listRoots();
        } else {
            File f = new File(tkFile.getPath());
            if (f.isFile()) {
                return null;
            }
            if (!f.exists()) {
                return null;
            }
            fs = f.listFiles();
        }
        if (fs == null || fs.length == 0) {
            String directory = tkFile.getPath();
            directory = (directory = directory.replace(File.separator.toCharArray()[0], "/".toCharArray()[0])).endsWith("/") ? directory : directory + "/";
            TKFile[] files = new TKFile[]{new TKFile(directory + "file")};
            files[0].isHidden(true);
            return files;
        }
        Vector<TKFtpStruct> vFiles = new Vector<TKFtpStruct>();
        for (int i = 0; i < fs.length; ++i) {
            if (fs[i].isHidden()) continue;
            vFiles.add(TKFileUtilities.toTKFile(fs[i]));
        }
        Object[] files = new TKFile[vFiles.size()];
        vFiles.copyInto(files);
        if (files != null) {
            Arrays.sort(files);
        }
        return files;
    }

    @Override
    public boolean mkDir(String path, String newDir) {
        File file = new File(path);
        File crtDir = new File(file, newDir);
        if (!file.canWrite()) {
            TKOperationShowMgr.showOperationDlg((Component)TKResourceManager.getMainFrame(), this.res.getString("InvaidNewDirPermission"), false);
            return false;
        }
        try {
            if (crtDir.exists()) {
                TKOperationShowMgr.showOperationDlg((Component)TKResourceManager.getMainFrame(), this.res.getString("FileNameConflict"), false);
                return false;
            }
            crtDir.mkdir();
        }
        catch (Exception ex) {
            TKOperationShowMgr.showOperationDlg((Component)TKResourceManager.getMainFrame(), this.res.getString("InvaidDirNameInput"), false);
            return false;
        }
        if (!crtDir.exists()) {
            TKOperationShowMgr.showOperationDlg((Component)TKResourceManager.getMainFrame(), this.res.getString("InvaidDirNameInput"), false);
            return false;
        }
        return true;
    }

    @Override
    public boolean createFile(String path, String fileName) {
        File dir = new File(path);
        if (!dir.exists()) {
            try {
                if (!dir.mkdir()) {
                    return false;
                }
            }
            catch (Exception ex) {
                DCDebugTracer.trace(ex);
                return false;
            }
        }
        File file = new File(path + File.separator + fileName);
        try {
            return file.createNewFile();
        }
        catch (Exception ex) {
            DCDebugTracer.trace(ex);
            return false;
        }
    }
}

