/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.toolkit.client.base.util.component;

import java.util.Iterator;
import java.util.Vector;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;

public class TKVisibleTreeNode
extends DefaultMutableTreeNode {
    private boolean isVisible = true;

    public TKVisibleTreeNode() {
        this("");
    }

    public TKVisibleTreeNode(Object userObject) {
        super(userObject);
    }

    public TKVisibleTreeNode(Object userObject, boolean allowsChildren) {
        super(userObject, allowsChildren);
    }

    public Vector getVisibleChildren() {
        return this.filterChildren();
    }

    public void setVisible(boolean isVisible) {
        this.isVisible = isVisible;
    }

    public boolean isVisible() {
        return this.isVisible;
    }

    @Override
    public int getChildCount() {
        Vector filterChildren = this.filterChildren();
        if (filterChildren == null) {
            return 0;
        }
        return filterChildren.size();
    }

    @Override
    public TreeNode getChildAt(int index) {
        Vector filterChildren = this.filterChildren();
        if (filterChildren == null) {
            throw new ArrayIndexOutOfBoundsException("node has no children");
        }
        TKVisibleTreeNode treeNode = null;
        if (filterChildren.size() > index) {
            treeNode = (TKVisibleTreeNode)filterChildren.elementAt(index);
        }
        return treeNode;
    }

    @Override
    public int getIndex(TreeNode aChild) {
        if (aChild == null) {
            throw new IllegalArgumentException("argument is null");
        }
        Vector filterChildren = this.filterChildren();
        if (filterChildren == null) {
            throw new ArrayIndexOutOfBoundsException("node has no children filter");
        }
        return filterChildren.indexOf(aChild);
    }

    public Vector filterChildren() {
        Vector vec = new Vector();
        if (this.children != null) {
            vec.addAll(this.children);
            Iterator iter = vec.iterator();
            while (iter.hasNext()) {
                TKVisibleTreeNode item = (TKVisibleTreeNode)iter.next();
                if (item.isVisible()) continue;
                iter.remove();
            }
        }
        return vec;
    }

    @Override
    public void remove(int childIndex) {
        Vector filterChildren = this.filterChildren();
        if (filterChildren == null) {
            throw new ArrayIndexOutOfBoundsException("node has no children");
        }
        if (childIndex < 0) {
            return;
        }
        TKVisibleTreeNode treeNode = (TKVisibleTreeNode)filterChildren.elementAt(childIndex);
        this.children.removeElement(treeNode);
        filterChildren.removeElementAt(childIndex);
        treeNode.setParent(null);
    }

    @Override
    public void removeAllChildren() {
        int size = 0;
        if (this.children == null) {
            return;
        }
        size = this.children.size();
        for (int i = size - 1; i >= 0; --i) {
            MutableTreeNode child = (MutableTreeNode)this.children.elementAt(i);
            this.children.removeElementAt(i);
            child.setParent(null);
        }
    }

    @Override
    public void remove(MutableTreeNode aChild) {
        if (aChild == null) {
            throw new IllegalArgumentException("argument is null");
        }
        this.children.remove(aChild);
    }
}

