/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.toolkit.client.base.util.component;

import java.awt.Component;
import java.awt.Graphics;
import java.io.Serializable;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.UIManager;
import javax.swing.plaf.UIResource;

public class TKTridStateIcon
implements Icon,
UIResource,
Serializable {
    private int iState = 1;
    public static final int NONE_SELECT = 1;
    public static final int PART_SELECT = 2;
    public static final int ALL_SELECT = 3;
    private int iControlSize = 13;

    public TKTridStateIcon() {
        this.iState = 1;
    }

    public TKTridStateIcon(int state) {
        this.iState = state;
    }

    protected int getControlSize() {
        return this.iControlSize;
    }

    @Override
    public void paintIcon(Component component, Graphics graphics, int iX, int iY) {
        boolean isEnabled = true;
        int controlSize = this.getControlSize();
        boolean isBorderPainted = true;
        if (component instanceof JCheckBox) {
            JCheckBox cb = (JCheckBox)component;
            ButtonModel model = cb.getModel();
            isEnabled = model.isEnabled();
            isBorderPainted = cb.isBorderPaintedFlat();
        }
        if (isEnabled) {
            if (isBorderPainted) {
                graphics.drawRect(iX + 1, iY, controlSize - 1, controlSize - 1);
            }
            if (2 == this.iState) {
                if (isBorderPainted) {
                    graphics.setColor(UIManager.getColor("controlShadow"));
                    graphics.fillRect(iX + 2, iY + 1, controlSize - 2, controlSize - 2);
                } else {
                    graphics.setColor(UIManager.getColor("controlShadow"));
                    graphics.fillRect(iX, iY, controlSize - 1, controlSize - 1);
                    this.drawPressed3DBorder(graphics, iX, iY, controlSize, controlSize);
                }
            } else if (!isBorderPainted) {
                this.drawFlush3DBorder(graphics, iX, iY, controlSize, controlSize);
            }
            graphics.setColor(UIManager.getColor("controlText"));
        } else {
            graphics.setColor(UIManager.getColor("controlShadow"));
            graphics.drawRect(iX, iY, controlSize - 1, controlSize - 1);
        }
        if (3 == this.iState || 2 == this.iState) {
            if (isBorderPainted) {
                ++iX;
            }
            this.drawCheck(component, graphics, iX, iY);
        }
    }

    protected void drawCheck(Component oComponet, Graphics oGraphics, int iX, int iY) {
        int controlSize = this.getControlSize();
        oGraphics.fillRect(iX + 3, iY + 5, 2, controlSize - 8);
        oGraphics.drawLine(iX + (controlSize - 4), iY + 3, iX + 5, iY + (controlSize - 6));
        oGraphics.drawLine(iX + (controlSize - 4), iY + 4, iX + 5, iY + (controlSize - 5));
    }

    @Override
    public int getIconWidth() {
        return this.getControlSize();
    }

    @Override
    public int getIconHeight() {
        return this.getControlSize();
    }

    public void setState(int iState) {
        this.iState = iState;
    }

    public int getState() {
        return this.iState;
    }

    public void setControlSize(int iControlSize) {
        this.iControlSize = iControlSize;
    }

    void drawFlush3DBorder(Graphics g, int x, int y, int w, int h) {
        g.translate(x, y);
        g.setColor(UIManager.getColor("controlDkShadow"));
        g.drawRect(0, 0, w - 2, h - 2);
        g.setColor(UIManager.getColor("controlLtHighlight"));
        g.drawRect(1, 1, w - 2, h - 2);
        g.setColor(UIManager.getColor("control"));
        g.drawLine(0, h - 1, 1, h - 2);
        g.drawLine(w - 1, 0, w - 2, 1);
        g.translate(-x, -y);
    }

    void drawPressed3DBorder(Graphics g, int x, int y, int w, int h) {
        g.translate(x, y);
        this.drawFlush3DBorder(g, 0, 0, w, h);
        g.setColor(UIManager.getColor("controlShadow"));
        g.drawLine(1, 1, 1, h - 2);
        g.drawLine(1, 1, w - 2, 1);
        g.translate(-x, -y);
    }
}

