/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.toolkit.client.base.util.component;

import com.huawei.dc.toolkit.client.base.util.component.TKTable;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.util.Vector;
import javax.swing.ListSelectionModel;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;

public class TKTooltipTable
extends TKTable {
    private String m_sTooltipText = "";
    private String m_sRegRowColumn = "**";
    private String m_sRegRow = "**";
    private String m_sRegColumn = "**";
    private String m_sSperator = "$";
    private boolean m_bShowAllCell = false;

    public TKTooltipTable() {
        this.setupTooltip();
    }

    public TKTooltipTable(Object[][] data, String[] columnName) {
        super(data, columnName);
        this.setupTooltip();
    }

    public TKTooltipTable(Vector rowData, Vector columnNames) {
        super(rowData, columnNames);
        this.setupTooltip();
    }

    public TKTooltipTable(TableModel dm, TableColumnModel cm, ListSelectionModel sm) {
        super(dm, cm, sm);
        this.setupTooltip();
    }

    public TKTooltipTable(TableModel dm, TableColumnModel cm) {
        super(dm, cm);
        this.setupTooltip();
    }

    public TKTooltipTable(TableModel dm) {
        super(dm);
        this.setupTooltip();
    }

    @Override
    public String getToolTipText() {
        return this.m_sTooltipText;
    }

    private void setupTooltip() {
        this.setToolTipText("NULL");
        this.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent e) {
                TKTooltipTable.this.m_sTooltipText = null;
                int colum = TKTooltipTable.this.columnAtPoint(e.getPoint());
                int row = TKTooltipTable.this.rowAtPoint(e.getPoint());
                if (colum < 0 || row < 0) {
                    TKTooltipTable.this.m_sTooltipText = null;
                } else {
                    String regRC = "**" + row + TKTooltipTable.this.m_sSperator + colum + "**";
                    String regR = "**" + row + "**";
                    String regC = "**" + colum + "**";
                    if (TKTooltipTable.this.m_bShowAllCell || TKTooltipTable.this.m_sRegRowColumn.indexOf(regRC) >= 0 || TKTooltipTable.this.m_sRegRow.indexOf(regR) >= 0 || TKTooltipTable.this.m_sRegColumn.indexOf(regC) >= 0) {
                        TKTooltipTable.this.m_sTooltipText = TKTooltipTable.this.toTooltip(row, colum);
                    }
                }
            }
        });
    }

    public void registerTooltipRowAndColumn(int row, int column) {
        this.m_sRegRowColumn = this.m_sRegRowColumn + "**" + row + this.m_sSperator + column + "**";
    }

    public void registerTooltipRow(int row) {
        this.m_sRegRow = this.m_sRegRow + "**" + row + "**";
    }

    public void registerTooltipColumn(int column) {
        this.m_sRegColumn = this.m_sRegColumn + "**" + column + "**";
    }

    public void registerTooltipAllCell(boolean bShowAllCell) {
        this.m_bShowAllCell = bShowAllCell;
    }

    public String toTooltip(int row, int column) {
        return this.getValueAt(row, column).toString();
    }
}

