/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.toolkit.client.base.util.component;

import com.huawei.dc.common.util.DCDebugTracer;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;
import javax.swing.AbstractAction;
import javax.swing.JRootPane;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import javax.swing.text.Document;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoManager;

public class TKTextField
extends JTextField {
    UndoManager undoMgr = new UndoManager();

    public TKTextField() {
        this.installUndo();
    }

    public TKTextField(int columns) {
        super(null, null, columns);
        this.installUndo();
    }

    public TKTextField(String text) {
        super(text);
        this.installUndo();
    }

    public TKTextField(Document doc, String text, int columns) {
        super(doc, text, columns);
        this.installUndo();
    }

    private void installUndo() {
        this.getDocument().addUndoableEditListener(new UndoableEditListener(){

            @Override
            public void undoableEditHappened(UndoableEditEvent evt) {
                TKTextField.this.undoMgr.addEdit(evt.getEdit());
            }
        });
        this.getActionMap().put("Undo", new AbstractAction("Undo"){

            @Override
            public void actionPerformed(ActionEvent evt) {
                try {
                    if (TKTextField.this.undoMgr.canUndo()) {
                        TKTextField.this.undoMgr.undo();
                    }
                }
                catch (CannotUndoException e) {
                    DCDebugTracer.trace(e);
                }
            }
        });
        this.getInputMap().put(KeyStroke.getKeyStroke("control Z"), "Undo");
    }

    @Override
    protected void processKeyEvent(KeyEvent event) {
        JRootPane rootPane = this.getRootPane();
        if (!rootPane.getGlassPane().isVisible()) {
            super.processKeyEvent(event);
        }
    }

    @Override
    protected void processFocusEvent(FocusEvent event) {
        if (this.hasFocus()) {
            this.selectAll();
        }
        super.processFocusEvent(event);
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension dimension = super.getPreferredSize();
        dimension.height = 23;
        return dimension;
    }
}

