/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.toolkit.client.base.util.component;

import com.huawei.dc.common.util.DCDebugTracer;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import javax.swing.AbstractAction;
import javax.swing.JRootPane;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import javax.swing.text.Document;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoManager;

public class TKTextArea
extends JTextArea {
    UndoManager undoMgr = new UndoManager();

    public TKTextArea() {
        this.installUndo();
    }

    public TKTextArea(int p0, int p1) {
        super(p0, p1);
        this.installUndo();
    }

    public TKTextArea(String p0) {
        super(p0);
        this.installUndo();
    }

    public TKTextArea(String p0, int p1, int p2) {
        super(p0, p1, p2);
        this.installUndo();
    }

    public TKTextArea(Document p0) {
        super(p0);
        this.installUndo();
    }

    public TKTextArea(Document p0, String p1, int p2, int p3) {
        super(p0, p1, p2, p3);
        this.installUndo();
    }

    public void repaintX() {
        if (SwingUtilities.isEventDispatchThread()) {
            this.repaint();
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    TKTextArea.this.repaint();
                }
            });
        }
    }

    private void installUndo() {
        this.getDocument().addUndoableEditListener(new UndoableEditListener(){

            @Override
            public void undoableEditHappened(UndoableEditEvent evt) {
                TKTextArea.this.undoMgr.addEdit(evt.getEdit());
            }
        });
        this.getActionMap().put("Undo", new AbstractAction("Undo"){

            @Override
            public void actionPerformed(ActionEvent evt) {
                try {
                    if (TKTextArea.this.undoMgr.canUndo()) {
                        TKTextArea.this.undoMgr.undo();
                    }
                }
                catch (CannotUndoException e) {
                    DCDebugTracer.trace(e);
                }
            }
        });
        this.getInputMap().put(KeyStroke.getKeyStroke("control Z"), "Undo");
    }

    @Override
    protected void processKeyEvent(KeyEvent event) {
        JRootPane rootPane = this.getRootPane();
        if (!rootPane.getGlassPane().isVisible()) {
            super.processKeyEvent(event);
        }
    }
}

