/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.toolkit.client.base.util.component;

import com.huawei.dc.toolkit.client.base.util.component.TKTableUI;
import java.awt.Component;
import java.awt.Container;
import java.awt.FocusTraversalPolicy;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.plaf.TableUI;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;

public class TKTable
extends JTable {
    public static final int AUTO_RESIZE_HUAWEI_MODE = 5;

    public TKTable() {
        this.setUI((TableUI)((Object)new TKTableUI()));
        this.enableFocusTraversalPolicy(true);
        this.getTableHeader().setReorderingAllowed(false);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                Point p = e.getPoint();
                int row = TKTable.this.rowAtPoint(p);
                if (row < 0) {
                    return;
                }
                if (TKTable.this.getSelectedRows().length < 2) {
                    TKTable.this.setRowSelectionInterval(row, row);
                }
            }
        });
    }

    public TKTable(Object[][] data, String[] columnName) {
        super(data, columnName);
        this.setUI((TableUI)((Object)new TKTableUI()));
        this.enableFocusTraversalPolicy(true);
        this.getTableHeader().setReorderingAllowed(false);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                Point p = e.getPoint();
                int row = TKTable.this.rowAtPoint(p);
                if (row < 0) {
                    return;
                }
                if (TKTable.this.getSelectedRows().length < 2) {
                    TKTable.this.setRowSelectionInterval(row, row);
                }
            }
        });
    }

    public TKTable(Vector rowData, Vector columnNames) {
        super(rowData, columnNames);
        this.setUI((TableUI)((Object)new TKTableUI()));
        this.enableFocusTraversalPolicy(true);
        this.getTableHeader().setReorderingAllowed(false);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                Point p = e.getPoint();
                int row = TKTable.this.rowAtPoint(p);
                if (row < 0) {
                    return;
                }
                if (TKTable.this.getSelectedRows().length < 2) {
                    TKTable.this.setRowSelectionInterval(row, row);
                }
            }
        });
    }

    public TKTable(TableModel model) {
        super(model);
        this.setUI((TableUI)((Object)new TKTableUI()));
        this.enableFocusTraversalPolicy(true);
        this.getTableHeader().setReorderingAllowed(false);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                Point p = e.getPoint();
                int row = TKTable.this.rowAtPoint(p);
                if (row < 0) {
                    return;
                }
                if (TKTable.this.getSelectedRows().length < 2) {
                    TKTable.this.setRowSelectionInterval(row, row);
                }
            }
        });
    }

    public TKTable(TableModel dm, TableColumnModel cm) {
        super(dm, cm);
        this.setUI((TableUI)((Object)new TKTableUI()));
        this.enableFocusTraversalPolicy(true);
        this.getTableHeader().setReorderingAllowed(false);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                Point p = e.getPoint();
                int row = TKTable.this.rowAtPoint(p);
                if (row < 0) {
                    return;
                }
                if (TKTable.this.getSelectedRows().length < 2) {
                    TKTable.this.setRowSelectionInterval(row, row);
                }
            }
        });
    }

    public TKTable(TableModel dm, TableColumnModel cm, ListSelectionModel sm) {
        super(dm, cm, sm);
        this.setUI((TableUI)((Object)new TKTableUI()));
        this.enableFocusTraversalPolicy(true);
        this.getTableHeader().setReorderingAllowed(false);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                Point p = e.getPoint();
                int row = TKTable.this.rowAtPoint(p);
                if (row < 0) {
                    return;
                }
                if (TKTable.this.getSelectedRows().length < 2) {
                    TKTable.this.setRowSelectionInterval(row, row);
                }
            }
        });
    }

    protected void enableFocusTraversalPolicy(boolean enable) {
        if (enable) {
            AbstractAction focusTraversalAction = new AbstractAction("TABFocues "){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (TKTable.this.findNextFocus() != null) {
                        TKTable.this.findNextFocus().requestFocus();
                    }
                }
            };
            this.getInputMap(0).put(KeyStroke.getKeyStroke(9, 0), "TABFocues");
            this.getActionMap().put("TABFocues", focusTraversalAction);
        }
    }

    public Component findNextFocus() {
        Container root;
        Component c = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
        Container container = root = c == null ? null : c.getFocusCycleRootAncestor();
        if (root != null) {
            FocusTraversalPolicy policy = root.getFocusTraversalPolicy();
            Component nextFocus = policy.getComponentAfter(root, c);
            if (nextFocus == null) {
                nextFocus = policy.getDefaultComponent(root);
            }
            return nextFocus;
        }
        return null;
    }

    public void repaintRow(final int row) {
        if (SwingUtilities.isEventDispatchThread()) {
            this.repaintRowX(row);
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    TKTable.this.repaintRowX(row);
                }
            });
        }
    }

    public void repaintCell(final int row, final int column) {
        if (SwingUtilities.isEventDispatchThread()) {
            this.repaintCellX(row, column);
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    TKTable.this.repaintCellX(row, column);
                }
            });
        }
    }

    public void repaintRow(final int rowStart, final int rowEnd) {
        if (SwingUtilities.isEventDispatchThread()) {
            this.repaintRowX(rowStart, rowEnd);
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    TKTable.this.repaintRowX(rowStart, rowEnd);
                }
            });
        }
    }

    private void repaintRowX(int row) {
        if (row < 0 || row >= this.getRowCount()) {
            return;
        }
        int heigth = this.getRowHeight() * row;
        this.repaint(0, heigth, this.getWidth(), this.getRowHeight(row));
        ((AbstractTableModel)this.getModel()).fireTableRowsUpdated(row, row);
    }

    private void repaintCellX(int row, int column) {
        if (row < 0 || row >= this.getRowCount() || column < 0 || column >= this.getColumnCount()) {
            return;
        }
        if (this.getEditingRow() == row && this.getEditingColumn() == column && this.getCellEditor() != null) {
            this.getCellEditor().stopCellEditing();
        }
        TableCellRenderer renderer = this.getCellRenderer(row, column);
        this.getDefaultRenderer(this.getClass());
        if (renderer != null) {
            this.prepareRenderer(renderer, row, column).repaint();
        } else {
            int width = 0;
            TableColumnModel cm = this.getColumnModel();
            for (int i = 0; i < column; ++i) {
                width += cm.getColumn(i).getWidth();
            }
            int heigth = this.getRowHeight() * row;
            this.repaint(width, heigth, cm.getColumn(column).getWidth(), this.getRowHeight(row));
        }
        ((AbstractTableModel)this.getModel()).fireTableRowsUpdated(row, row);
    }

    private void repaintRowX(int rowStart, int rowEnd) {
        if (rowStart < 0 || rowStart >= this.getRowCount() || rowEnd < 0 || rowEnd >= this.getRowCount() || rowEnd < rowStart) {
            return;
        }
        for (int row = 0; row <= rowEnd; ++row) {
            if (rowStart > row) continue;
            this.repaintRowX(row);
        }
    }

    @Override
    public final int getRowHeight() {
        return 21;
    }
}

