/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.toolkit.client.base.util.component;

import com.huawei.dc.common.util.DCDebugTracer;
import com.huawei.dc.toolkit.client.base.util.component.TKTextField;
import java.awt.Toolkit;
import java.util.ArrayList;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import javax.swing.text.PlainDocument;

public class TKNameTextField
extends TKTextField {
    private int maxLength = 32;
    private int cType = 1;
    private boolean isDirectInput = false;
    public static final int NORMAL_CHAR = 1;
    public static final int NET_CHAR = 2;
    public static final int SUBNET_CHAR = 3;
    public static final int NO_CHAR = 4;
    public static final int FILE_CHAR = 5;
    public static final int SCHE_CHAR = 6;
    private ArrayList cNormalChar = new ArrayList();

    public TKNameTextField() {
        this.initNormalList();
        this.setDocument(new NameDocument(this));
    }

    public TKNameTextField(int maxLength) {
        this();
        this.maxLength = maxLength;
    }

    public TKNameTextField(int maxLength, int type) {
        this.cType = type;
        if (type == 2) {
            this.initNetList();
        } else if (type == 3) {
            this.initSubNetList();
        } else if (type == 4) {
            this.initNoSpecialChar();
        } else if (type == 5) {
            this.initFileCharList();
        } else if (type == 6) {
            this.initSchedulList();
        } else {
            this.initNormalList();
        }
        this.setDocument(new NameDocument(this));
        if (maxLength > 0) {
            this.maxLength = maxLength;
        }
    }

    private void initNormalList() {
        this.cNormalChar.add(String.valueOf('/'));
        this.cNormalChar.add(String.valueOf('('));
        this.cNormalChar.add(String.valueOf(')'));
        this.cNormalChar.add(String.valueOf('-'));
        this.cNormalChar.add(String.valueOf('_'));
        this.cNormalChar.add(String.valueOf('\uff08'));
        this.cNormalChar.add(String.valueOf('\uff09'));
    }

    private void initSchedulList() {
        this.cNormalChar.add(String.valueOf('/'));
        this.cNormalChar.add(String.valueOf('('));
        this.cNormalChar.add(String.valueOf(')'));
        this.cNormalChar.add(String.valueOf('-'));
        this.cNormalChar.add(String.valueOf('_'));
        this.cNormalChar.add(String.valueOf('\uff08'));
        this.cNormalChar.add(String.valueOf('\uff09'));
        this.cNormalChar.add(String.valueOf(' '));
    }

    private void initNetList() {
        this.cNormalChar.add(String.valueOf('/'));
        this.cNormalChar.add(String.valueOf('('));
        this.cNormalChar.add(String.valueOf(')'));
        this.cNormalChar.add(String.valueOf('-'));
        this.cNormalChar.add(String.valueOf('_'));
        this.cNormalChar.add(String.valueOf('.'));
        this.cNormalChar.add(String.valueOf(":"));
        this.cNormalChar.add(String.valueOf('+'));
    }

    private void initSubNetList() {
        this.cNormalChar.add(String.valueOf('('));
        this.cNormalChar.add(String.valueOf(')'));
        this.cNormalChar.add(String.valueOf('-'));
        this.cNormalChar.add(String.valueOf('_'));
        this.cNormalChar.add(String.valueOf('.'));
        this.cNormalChar.add(String.valueOf(':'));
        this.cNormalChar.add(String.valueOf('+'));
    }

    private void initFileCharList() {
        this.cNormalChar.add(String.valueOf('/'));
        this.cNormalChar.add(String.valueOf('\\'));
        this.cNormalChar.add(String.valueOf('*'));
        this.cNormalChar.add(String.valueOf('?'));
        this.cNormalChar.add(String.valueOf('\"'));
        this.cNormalChar.add(String.valueOf('<'));
        this.cNormalChar.add(String.valueOf('>'));
        this.cNormalChar.add(String.valueOf('|'));
        this.cNormalChar.add(String.valueOf(':'));
    }

    private void initNoSpecialChar() {
        this.cNormalChar = null;
    }

    public void setMaxLength(int length) {
        this.maxLength = length;
    }

    public void setTextEx(String str) {
        this.isDirectInput = true;
        super.setText(str);
        this.isDirectInput = false;
    }

    public String makeTextValid(String text) {
        if (text == null || text.equals("")) {
            return "";
        }
        if (this.cNormalChar == null) {
            return text;
        }
        String lastChar = text.substring(text.length() - 1);
        int length = this.cNormalChar.size();
        boolean isLastCharValid = true;
        for (int i = 0; i < length; ++i) {
            if (!lastChar.equals(this.cNormalChar.get(i))) continue;
            text = text.substring(0, text.length() - 1);
            isLastCharValid = false;
        }
        if (!isLastCharValid) {
            text = this.makeTextValid(text);
        }
        return text;
    }

    public String parseName(String s) {
        if (this.maxLength == 32) {
            return s;
        }
        char[] temp = s.toCharArray();
        String one = null;
        for (int i = 0; i < temp.length; ++i) {
            if (!((this.isLatinByte(temp[i]) || this.isSymbolsByte(temp[i])) && (this.isDigit(temp[i]) || this.isLetter(temp[i]) || this.isValidByte(temp[i])) || this.isChinaByte(temp[i]))) {
                DCDebugTracer.trace("invalid char: " + temp[i] + "(" + temp[i] + ")= " + Character.UnicodeBlock.of(temp[i]));
                return null;
            }
            one = s;
        }
        one = s;
        return one;
    }

    boolean isDigit(char c) {
        boolean isDigit = Character.isDigit(c);
        return isDigit;
    }

    boolean isLetter(char c) {
        boolean isLetter = Character.isLetter(c);
        return isLetter;
    }

    boolean isValidByte(char c) {
        if (this.cType == 5) {
            return this.isValidFileByte(c);
        }
        return this.isValidNameByte(c);
    }

    boolean isValidNameByte(char c) {
        if (this.cNormalChar == null) {
            return false;
        }
        int length = this.cNormalChar.size();
        for (int i = 0; i < length; ++i) {
            if (!this.cNormalChar.get(i).equals(String.valueOf(c))) continue;
            return true;
        }
        return false;
    }

    boolean isValidFileByte(char c) {
        if (this.cNormalChar == null) {
            return false;
        }
        int length = this.cNormalChar.size();
        for (int i = 0; i < length; ++i) {
            if (!this.cNormalChar.get(i).equals(String.valueOf(c))) continue;
            return false;
        }
        return true;
    }

    boolean isSymbolsByte(char c) {
        boolean isSymbolsByte = Character.UnicodeBlock.of(c) == Character.UnicodeBlock.HALFWIDTH_AND_FULLWIDTH_FORMS;
        return isSymbolsByte;
    }

    boolean isChinaByte(char c) {
        boolean isChinaByte = Character.UnicodeBlock.of(c) == Character.UnicodeBlock.CJK_UNIFIED_IDEOGRAPHS;
        return isChinaByte;
    }

    boolean isLatinByte(char c) {
        return Character.UnicodeBlock.of(c) == Character.UnicodeBlock.BASIC_LATIN;
    }

    class NameDocument
    extends PlainDocument {
        private JTextComponent textComponent;

        @Override
        public void insertString(int offset, String s, AttributeSet attributeSet) throws BadLocationException {
            char inputChar;
            if (s.length() > 1) {
                s = s.trim();
            } else if (s.length() == 1 && (inputChar = s.charAt(0)) == ' ' && offset == 0) {
                Toolkit.getDefaultToolkit().beep();
                return;
            }
            if (TKNameTextField.this.isDirectInput) {
                super.insertString(offset, s, attributeSet);
                return;
            }
            try {
                if (TKNameTextField.this.parseName(s) == null) {
                    return;
                }
            }
            catch (Exception ex) {
                Toolkit.getDefaultToolkit().beep();
                return;
            }
            int length = this.textComponent.getText().getBytes().length + s.getBytes().length;
            if (length > TKNameTextField.this.maxLength) {
                Toolkit.getDefaultToolkit().beep();
            } else {
                super.insertString(offset, s, attributeSet);
            }
        }

        public NameDocument(JTextComponent tc) {
            this.textComponent = tc;
        }
    }
}

