/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.toolkit.client.base.util.component;

import JACE.ASX.TimeValue;
import JACE.Reactor.EventHandler;
import JACE.Reactor.TimerQueue;
import com.huawei.dc.common.util.DCDebugTracer;
import com.huawei.dc.toolkit.client.base.util.TKRes;
import com.huawei.dc.toolkit.client.base.util.TKResourceManager;
import com.huawei.dc.toolkit.client.base.util.TKScreenToolKit;
import com.huawei.dc.toolkit.client.base.util.component.TKButton;
import com.huawei.dc.toolkit.client.base.util.component.TKCheckBox;
import com.huawei.dc.toolkit.client.base.util.component.TKComponentToolkit;
import com.huawei.dc.toolkit.client.base.util.component.TKTextArea;
import com.huawei.dc.toolkit.client.base.util.component.TKTextField;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.BorderFactory;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;

public class TKLoadProgressDialog
extends JDialog {
    private String textTitle = "";
    private String textTip = "";
    private String textStopping = "";
    TKRes res = TKRes.instance();
    private boolean isCanceled = false;
    private int stepLength = 10;
    private int stepNum = 10;
    private TimerQueue timerQueue;
    StepProgress stepProgress;
    private int stepProgressTimerId = -1;
    private static final int WindowWidth = 300;
    private static final int WindowHeightCollapse = 180;
    private static final int WindowHeightExtend = 360;
    private boolean isCompleteOpration = false;
    JPanel panelCenter = new JPanel();
    JPanel lowerPanel = new JPanel();
    JLabel labelWaitNotice = new JLabel();
    JPanel upperPanel = new JPanel();
    JPanel panelIcon = new JPanel();
    JLabel loadProgressLabel = new JLabel();
    BorderLayout upperBorderLayout = new BorderLayout();
    BorderLayout lowerBorderLayout = new BorderLayout();
    BorderLayout southPanelBorderLayout = new BorderLayout();
    BorderLayout loadProgressBorderLayout = new BorderLayout();
    JProgressBar progressBar = new JProgressBar();
    GridBagLayout gridBagLayout1 = new GridBagLayout();
    BorderLayout borderLayout1 = new BorderLayout();
    JPanel panelPrg = new JPanel();
    JPanel jPanel1 = new JPanel();
    JScrollPane detailInfoScroll = new JScrollPane();
    BorderLayout borderLayout2 = new BorderLayout();
    JPanel jPanel2 = new JPanel();
    TKButton btnDetail = new TKButton();
    TKButton btnNoDetail = new TKButton();
    JPanel btnPnl = new JPanel();
    BorderLayout borderLayout3 = new BorderLayout();
    TKButton btnCancel = new TKButton();
    TKButton btnClose = new TKButton();
    TKTextField tfTotal = new TKTextField();
    TKTextArea taDetailInfo = new TKTextArea();
    Border border1;
    TKCheckBox cbAutoClose = new TKCheckBox(this.res.getString("IgnoreErrorAutoCLose"));
    private Runnable runnable = null;
    KeyAdapter disposeKa = new KeyAdapter(){

        @Override
        public void keyPressed(KeyEvent e) {
            if (TKLoadProgressDialog.this.isCompleteOpration && e.getKeyCode() == 27) {
                TKLoadProgressDialog.this.dispose();
            }
        }
    };

    public TKLoadProgressDialog(String title) {
        super(TKResourceManager.getMainFrame(), title, true);
        this.textTitle = title;
        try {
            this.jbInit();
            this.setDefaultCloseOperation(2);
        }
        catch (Exception ex) {
            DCDebugTracer.trace(ex);
        }
        this.stepProgress = new StepProgress();
        this.timerQueue = new TimerQueue(true);
    }

    private void jbInit() throws Exception {
        this.setSize(300, 200);
        this.border1 = BorderFactory.createEmptyBorder(10, 0, 10, 0);
        this.loadProgressLabel.setIcon(TKResourceManager.getIcon("loading.gif"));
        this.btnDetail.setText(this.res.getString("button_Detail"));
        this.btnCancel.setText(this.res.getString("button_CANCEL"));
        this.btnNoDetail.setText(this.res.getString("button_NoDetail"));
        this.btnClose.setText(this.res.getString("Close"));
        this.setResizable(false);
        this.setDefaultCloseOperation(0);
        this.getContentPane().setLayout(this.loadProgressBorderLayout);
        this.panelCenter.setLayout(this.southPanelBorderLayout);
        this.lowerPanel.setLayout(this.lowerBorderLayout);
        this.labelWaitNotice.setText("labelWaitNotice        ");
        this.upperPanel.setLayout(this.upperBorderLayout);
        this.panelIcon.setLayout(new BorderLayout());
        this.panelPrg.setLayout(this.borderLayout1);
        this.jPanel1.setLayout(this.borderLayout2);
        this.jPanel2.setLayout(this.borderLayout3);
        this.upperPanel.setBorder(this.border1);
        this.getContentPane().add((Component)this.panelCenter, "Center");
        this.panelCenter.add((Component)this.upperPanel, "North");
        this.upperPanel.add((Component)this.panelIcon, "Center");
        this.panelIcon.add((Component)this.loadProgressLabel, "Center");
        this.panelCenter.add((Component)this.lowerPanel, "Center");
        this.cbAutoClose.setBorder(BorderFactory.createEmptyBorder(6, 0, 0, 0));
        this.panelPrg.add((Component)this.progressBar, "Center");
        this.panelPrg.add((Component)this.labelWaitNotice, "North");
        this.lowerPanel.add((Component)this.jPanel1, "South");
        this.jPanel1.add((Component)this.jPanel2, "South");
        this.jPanel2.add((Component)this.btnPnl, "East");
        this.btnPnl.add((Component)this.btnNoDetail, null);
        this.btnPnl.add((Component)this.btnDetail, null);
        this.btnPnl.add((Component)this.btnCancel, null);
        this.btnPnl.add((Component)this.btnClose, null);
        this.detailInfoScroll.getViewport().add(this.taDetailInfo);
        this.panelPrg.setBorder(BorderFactory.createEmptyBorder(5, 0, 5, 0));
        this.lowerPanel.add((Component)this.panelPrg, "North");
        this.taDetailInfo.setLineWrap(true);
        this.taDetailInfo.setEditable(false);
        this.btnClose.setVisible(false);
        this.tfTotal.setBackground(this.jPanel1.getBackground());
        this.tfTotal.setEditable(false);
        this.tfTotal.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.initAction();
        this.panelCenter.setBorder(BorderFactory.createEmptyBorder(2, 10, 5, 8));
        this.cbAutoClose.setVisible(false);
        this.btnDetail.setVisible(false);
        this.btnNoDetail.setVisible(false);
        this.taDetailInfo.setVisible(false);
        TKScreenToolKit.centerLocateToScreen(this);
        this.pack();
    }

    @Override
    public Component getMostRecentFocusOwner() {
        int width = this.loadProgressLabel.getWidth();
        int iconWidth = this.loadProgressLabel.getIcon().getIconWidth();
        this.loadProgressLabel.setBorder(BorderFactory.createEmptyBorder(0, (width - iconWidth) / 2 - 1, 0, 0));
        if (this.runnable != null) {
            new Thread(this.runnable).start();
        }
        return this.loadProgressLabel;
    }

    public void setRunnable(Runnable runnable) {
        this.runnable = runnable;
    }

    private void initAction() {
        this.btnDetail.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TKLoadProgressDialog.this.detailBtn_actionPerformed(e);
            }
        });
        this.btnNoDetail.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TKLoadProgressDialog.this.noDetailBtn_actionPerformed(e);
            }
        });
        this.btnCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TKLoadProgressDialog.this.isCanceled = true;
                TKLoadProgressDialog.this.labelWaitNotice.setText(TKLoadProgressDialog.this.textStopping);
                TKLoadProgressDialog.this.btnCancel.setEnabled(false);
            }
        });
        this.btnClose.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TKLoadProgressDialog.this.setVisible(false);
            }
        });
        TKComponentToolkit.addAllKeyListener(this, "javax.swing.JComponent", this.disposeKa);
        this.addDialogWindowListener();
        TKComponentToolkit.addAllButtonEnterKeyAdp(this);
    }

    private void detailBtn_actionPerformed(ActionEvent e) {
        this.setSize(300, 360);
        this.detailInfoScroll.setVisible(true);
        this.btnNoDetail.setVisible(true);
        this.btnDetail.setVisible(false);
        this.btnNoDetail.grabFocus();
        this.validate();
        this.repaint();
    }

    private void noDetailBtn_actionPerformed(ActionEvent e) {
        this.setSize(300, 180);
        TKScreenToolKit.centerLocateToScreen(this);
        this.validate();
    }

    public void isShowProgress(boolean show) {
        this.progressBar.setVisible(show);
    }

    public int getProgressValue() {
        return this.progressBar.getValue();
    }

    public int getMaxProgressValue() {
        return this.progressBar.getMaximum();
    }

    public synchronized boolean isCanceled() {
        return this.isCanceled;
    }

    public synchronized boolean isFullProgressValue() {
        return this.progressBar.getMaximum() == this.progressBar.getValue();
    }

    public synchronized void setProgressValue(int value) {
        this.progressBar.setValue(value);
    }

    public synchronized void completeOpration() {
        this.setTitle(this.res.getString("OprationComplete"));
        this.isCompleteOpration = true;
        this.labelWaitNotice.setText(this.res.getString("OprationComplete"));
        this.progressBar.setValue(this.progressBar.getMaximum());
        this.btnClose.setEnabled(true);
        this.btnClose.setVisible(true);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                TKLoadProgressDialog.this.btnCancel.setVisible(false);
            }
        });
        this.btnClose.grabFocus();
        this.cbAutoClose.setEnabled(true);
        new Thread(){

            @Override
            public void run() {
                try {
                    Thread.currentThread();
                    Thread.sleep(200L);
                }
                catch (Exception ex) {
                    DCDebugTracer.trace(ex);
                }
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        TKLoadProgressDialog.this.setVisible(false);
                    }
                });
            }
        }.start();
    }

    public void initail() {
        this.isCanceled = false;
        this.setTitle(this.textTitle);
        this.labelWaitNotice.setText(this.textTip);
        this.cbAutoClose.setEnabled(true);
        this.isCompleteOpration = false;
        this.progressBar.setValue(0);
        this.btnClose.setVisible(false);
        this.btnCancel.setVisible(true);
        this.btnCancel.setEnabled(true);
        this.noDetailBtn_actionPerformed(null);
    }

    public void stepProgressValue() {
        this.setProgressValue(this.progressBar.getValue() + 1);
    }

    public void step(int stepNum, int stepLen) {
        this.stepLength = stepLen;
        this.stepNum = stepNum;
        this.setProgressMaxValue(stepNum * this.stepLength);
    }

    public void startStep(int stepIndex) {
        this.setProgressValue(stepIndex * this.stepLength);
        if (this.stepProgressTimerId != -1) {
            this.timerQueue.cancelTimer(this.stepProgressTimerId);
        }
        this.stepProgress = null;
        this.stepProgress = new StepProgress();
        this.stepProgressTimerId = this.timerQueue.scheduleTimer((EventHandler)this.stepProgress, (Object)new StepHandle(), new TimeValue(1L), new TimeValue(1L));
    }

    public void appendOperationResult(String info) {
        this.taDetailInfo.append(info + "\n");
    }

    public void clearOperationResult() {
        this.taDetailInfo.setText("");
    }

    public void fullProgressValue() {
        this.setProgressValue(this.progressBar.getMaximum());
        this.completeOpration();
    }

    public void setProgressMaxValue(int value) {
        this.progressBar.setMaximum(value);
    }

    public void setProgressMinValue(int value) {
        this.progressBar.setMinimum(value);
    }

    public void addCancelActionListener(ActionListener actionListener) {
        this.btnCancel.removeActionListener(actionListener);
        this.btnCancel.addActionListener(actionListener);
    }

    protected void addDialogWindowListener() {
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent we) {
                if (TKLoadProgressDialog.this.isCanceled) {
                    return;
                }
                TKLoadProgressDialog.this.isCanceled = true;
                TKLoadProgressDialog.this.labelWaitNotice.setText(TKLoadProgressDialog.this.textStopping);
                TKLoadProgressDialog.this.btnCancel.setEnabled(false);
            }
        });
    }

    public void removeActionListener(ActionListener actionListener) {
        this.btnCancel.removeActionListener(actionListener);
    }

    public synchronized void setTipText(String tipText) {
        this.textTip = tipText;
        this.labelWaitNotice.setText(tipText);
    }

    public synchronized void setStoppingText(String stoppingText) {
        this.textStopping = stoppingText;
    }

    class StepHandle {
        public int step = 0;

        StepHandle() {
        }
    }

    class StepProgress
    implements EventHandler {
        StepProgress() {
        }

        public int handleTimeout(TimeValue tv, Object obj) {
            DCDebugTracer.trace("public int handleTimeout(TimeValue tv, Object obj)");
            if (((StepHandle)obj).step >= TKLoadProgressDialog.this.stepLength - 1) {
                return -1;
            }
            ++((StepHandle)obj).step;
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    TKLoadProgressDialog.this.stepProgressValue();
                }
            });
            return 0;
        }
    }
}

