/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.toolkit.client.base.util.component;

import com.huawei.dc.common.util.DCDebugTracer;
import com.huawei.dc.toolkit.client.base.util.TKIpValue;
import com.huawei.dc.toolkit.client.base.util.TKRes;
import com.huawei.dc.toolkit.client.base.util.component.TKOptionPane;
import com.huawei.dc.toolkit.client.base.util.component.TKTextField;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import javax.swing.text.PlainDocument;

public class TKIpTextField
extends TKTextField {
    TKRes res = TKRes.instance();
    private boolean isShow = false;
    private TKIpValue ipValue = new TKIpValue(0L);

    public TKIpTextField() {
        TEIPInputDocument doc = new TEIPInputDocument(this);
        this.setDocument(doc);
        this.setValue(0L);
    }

    public long getValue() {
        if (!this.isValidFormatString(TKIpTextField.splitString(this.getText(), '.')) && this.isShow) {
            Toolkit.getDefaultToolkit().beep();
            TKOptionPane.showMessageDialog(this.getParent(), (Object)this.res.getString("INPUT_IP_ERR"), this.res.getString("Hint"), 1);
        }
        return this.ipValue.getValue();
    }

    public void setValue(long value) {
        this.ipValue.setValue(value);
        this.setText(this.ipValue.toString());
    }

    public boolean isValidFormatString(ArrayList strList) {
        boolean flag = false;
        if (strList != null && strList.size() == 4 && !strList.contains("")) {
            flag = true;
            int[] ip = new int[]{0, 0, 0, 0};
            for (int i = 0; i < 4; ++i) {
                ip[i] = Integer.parseInt((String)strList.get(i));
                boolean bl = i == 0 ? ip[i] > 0 && ip[i] <= 255 : (flag = ip[i] >= 0 && ip[i] <= 255);
                if (!flag) break;
            }
            if (flag) {
                this.ipValue.setValue((long)ip[0] << 24 | (long)ip[1] << 16 | (long)(ip[2] << 8) | (long)ip[3]);
            }
        }
        return flag;
    }

    private boolean isValidString(ArrayList strList) {
        boolean flag = false;
        if (strList != null && strList.size() == 4) {
            flag = true;
            int value = 0;
            for (int i = 0; i < 4; ++i) {
                String tmp = (String)strList.get(i);
                if (tmp.trim().equals("")) continue;
                try {
                    value = Integer.parseInt(tmp);
                    flag = value >= 0 && value <= 255;
                }
                catch (Exception ex) {
                    flag = false;
                }
                if (!flag) break;
            }
        }
        return flag;
    }

    public static ArrayList splitString(String strSplit, char index) {
        ArrayList<String> strList = new ArrayList<String>(5);
        if (strSplit != null) {
            int len = strSplit.length();
            int oldPos = 0;
            for (int i = 0; i < len; ++i) {
                if (strSplit.charAt(i) != index) continue;
                if (oldPos == i) {
                    strList.add("");
                } else {
                    strList.add(strSplit.substring(oldPos, i).trim());
                }
                oldPos = i + 1;
            }
            if (oldPos == len) {
                strList.add("");
            } else {
                strList.add(strSplit.substring(oldPos).trim());
            }
        }
        return strList;
    }

    public void setIsShow(boolean isShow) {
        this.isShow = isShow;
    }

    public static void main(String[] args) {
        JFrame frame = new JFrame("Test Formated Document");
        final TKIpTextField test = new TKIpTextField();
        frame.getContentPane().setLayout(new GridBagLayout());
        frame.setBounds(100, 100, 150, 120);
        JButton btn = new JButton("test");
        test.setIsShow(true);
        btn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                test.setText("129.9.0.1");
            }
        });
        frame.getContentPane().add((Component)test, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        frame.getContentPane().add((Component)btn, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        frame.setVisible(true);
    }

    @Override
    public String getText() {
        String text = super.getText();
        if (text != null) {
            text = text.trim();
            ArrayList iplist = TKIpTextField.splitString(text, '.');
            int[] ip = new int[]{0, 0, 0, 0};
            try {
                ip[0] = Integer.parseInt(iplist.get(0).toString());
                ip[1] = Integer.parseInt(iplist.get(1).toString());
                ip[2] = Integer.parseInt(iplist.get(2).toString());
                ip[3] = Integer.parseInt(iplist.get(3).toString());
            }
            catch (Exception e) {
                DCDebugTracer.trace(e);
            }
            text = "" + ip[0] + "." + ip[1] + "." + ip[2] + "." + ip[3];
        }
        return text;
    }

    class TEIPInputDocument
    extends PlainDocument {
        public JTextComponent textComponent;

        public TEIPInputDocument(JTextComponent tc) {
            this.textComponent = tc;
        }

        @Override
        public void insertString(int offset, String s, AttributeSet attributeSet) throws BadLocationException {
            if (s.length() > 1 && TKIpTextField.this.isValidString(TKIpTextField.splitString(s, '.'))) {
                super.remove(0, this.getLength());
                super.insertString(0, s, attributeSet);
            } else if (s.length() == 1) {
                char inputChar = s.charAt(0);
                String oldStr = this.getText(0, this.getLength());
                if (inputChar == '.' && offset != oldStr.length() && oldStr.charAt(offset) == '.') {
                    this.textComponent.setCaretPosition(offset + 1);
                    return;
                }
                if (!this.parseChar(inputChar)) {
                    Toolkit.getDefaultToolkit().beep();
                    return;
                }
                if (this.isValidInputString(oldStr, s.charAt(0), offset)) {
                    super.insertString(offset, s, attributeSet);
                } else if (this.isLastField(oldStr, offset)) {
                    int pos = offset + oldStr.substring(offset).indexOf(".") + 1;
                    if (this.isValidInputString(oldStr, s.charAt(0), pos)) {
                        this.textComponent.setCaretPosition(pos);
                        this.textComponent.setSelectionStart(pos);
                        super.insertString(pos, s, attributeSet);
                    } else {
                        Toolkit.getDefaultToolkit().beep();
                    }
                } else {
                    Toolkit.getDefaultToolkit().beep();
                }
            }
        }

        @Override
        public void remove(int offset, int length) throws BadLocationException {
            String oldStr = this.getText(0, this.getLength());
            if (oldStr.equals("") || offset < 0 || offset >= oldStr.length()) {
                return;
            }
            if (length > 1) {
                String subString = oldStr.substring(offset, length + offset);
                StringBuffer sb = new StringBuffer();
                sb.append(oldStr.substring(0, offset));
                int pos = subString.indexOf(".");
                int size = subString.length();
                for (int i = 0; i < size && pos != -1; ++i) {
                    sb.append('.');
                    pos = subString.indexOf(".", pos + 1);
                }
                sb.append(oldStr.substring(offset + length));
                super.remove(offset, length);
                this.insertString(0, sb.toString(), null);
                this.textComponent.setCaretPosition(offset);
            } else if (oldStr.charAt(offset) != '.') {
                super.remove(offset, length);
            } else if (offset >= 0) {
                this.textComponent.setCaretPosition(offset);
            }
        }

        public boolean parseChar(char inputValue) {
            boolean retValue = false;
            if (inputValue >= '0' && inputValue <= '9') {
                retValue = true;
            }
            return retValue;
        }

        private boolean isValidInputString(String oldStr, char inputValue, int offset) {
            boolean flag = false;
            offset = offset > oldStr.length() ? oldStr.length() : offset;
            String validValue = oldStr.substring(0, offset).trim();
            int startStation = validValue.lastIndexOf(".");
            int inputStation = 0;
            if (startStation == -1) {
                startStation = 0;
                inputStation = oldStr.indexOf(".");
            } else {
                inputStation = oldStr.indexOf(".", startStation + 1);
                if (inputStation == -1) {
                    inputStation = oldStr.length();
                }
            }
            StringBuffer sb = new StringBuffer();
            for (int i = 0; i <= inputStation; ++i) {
                if (startStation > i) continue;
                if (i == offset) {
                    sb.append(inputValue);
                }
                if (i >= oldStr.length() || oldStr.charAt(i) == '.') continue;
                sb.append(oldStr.charAt(i));
            }
            validValue = sb.toString().trim();
            try {
                int value = Integer.parseInt(validValue);
                flag = startStation == 0 ? value >= 1 && value <= 223 && validValue.indexOf("00") != 0 && validValue.length() <= 3 : value >= 0 && value <= 255 && validValue.indexOf("00") != 0 && validValue.length() <= 3;
            }
            catch (Exception ex) {
                flag = false;
            }
            return flag;
        }

        private boolean isLastField(String oldStr, int offset) {
            int pos = oldStr.indexOf(".", offset);
            return pos == offset;
        }
    }
}

