/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.toolkit.client.base.util.component;

import com.huawei.dc.toolkit.client.base.util.TKCommonUtil;
import com.huawei.dc.toolkit.client.base.util.component.TKTextField;
import java.awt.Toolkit;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.util.zip.DataFormatException;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import javax.swing.text.PlainDocument;

public class TKIntegerTextField
extends TKTextField {
    boolean bAlarm = true;
    int nLimit = 11;
    int min = 0;
    int max = Integer.MAX_VALUE;
    int ct = 0;
    int radix = -1;
    private boolean acceptNull = false;
    boolean isDirectInsert = false;
    FocusListener listener = new FocusListener(){

        @Override
        public synchronized void focusLost(FocusEvent e) {
            TKIntegerTextField.this.doFocusOperation();
        }

        @Override
        public void focusGained(FocusEvent evt) {
        }
    };

    public void setAcceptNull(boolean acceptNull) {
        this.acceptNull = acceptNull;
    }

    public TKIntegerTextField() {
        this(0, Integer.MAX_VALUE, 10);
    }

    public TKIntegerTextField(int minN) {
        this(minN, Integer.MAX_VALUE, 10);
    }

    public TKIntegerTextField(int minN, int maxN) {
        this(minN, maxN, 10);
    }

    @Override
    protected boolean processKeyBinding(KeyStroke ks, KeyEvent e, int condition, boolean pressed) {
        if (this.hasFocus()) {
            return super.processKeyBinding(ks, e, condition, pressed);
        }
        return false;
    }

    public TKIntegerTextField(int minN, int maxN, int radix) {
        this.setDocument(new IntegerDocument(this));
        this.min = minN;
        this.max = maxN;
        this.radix = radix;
        this.nLimit = this.min > 0 ? 10 : 11;
        this.addFocusListener(this.listener);
    }

    public void removeFocusListener() {
        this.removeFocusListener(this.listener);
    }

    public int getValue() {
        String s = this.getText();
        if (s.length() == 0) {
            if (this.bAlarm && this.ct == 0) {
                ++this.ct;
                Toolkit.getDefaultToolkit().beep();
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        --TKIntegerTextField.this.ct;
                    }
                });
            }
            return this.min;
        }
        int value = s.equals("-") ? 0 : Integer.parseInt(s, this.radix);
        if (value < this.min || value > this.max) {
            this.setText(Integer.valueOf(this.min).toString());
            value = this.min;
            if (this.bAlarm && this.ct == 0) {
                ++this.ct;
                Toolkit.getDefaultToolkit().beep();
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                    }
                });
                --this.ct;
            }
        }
        return value;
    }

    public void setRange(int min, int max) {
        this.min = min;
        this.max = max;
    }

    public int getMin() {
        return this.min;
    }

    public int getMax() {
        return this.max;
    }

    public void setAlarm(boolean bAlarm) {
        this.bAlarm = bAlarm;
    }

    @Override
    public String getText() {
        int value;
        try {
            value = Integer.parseInt(super.getText(), this.radix);
        }
        catch (Exception e) {
            return super.getText();
        }
        if (this.max < value) {
            super.setText(Integer.toString(this.max, this.radix));
        }
        if (value == 0) {
            super.setText("");
        }
        return super.getText();
    }

    public String getTextEx() {
        return super.getText();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFocusOperation() {
        String text = this.getText();
        if (this.acceptNull && (text == null || text.equals(""))) {
            return;
        }
        try {
            if (text.length() == 0) {
                throw new DataFormatException();
            }
            int value = Integer.parseInt(text, this.radix);
            if (value < this.min || value > this.max) {
                throw new DataFormatException();
            }
        }
        catch (DataFormatException ex) {
            this.isDirectInsert = true;
            this.isDirectInsert = false;
            if (this.bAlarm && this.ct == 0) {
                ++this.ct;
                Toolkit.getDefaultToolkit().beep();
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                    }
                });
                --this.ct;
            }
        }
        finally {
            this.doOperation();
        }
    }

    public void doOperation() {
    }

    class IntegerDocument
    extends PlainDocument {
        private JTextComponent textComponent;

        public IntegerDocument(JTextComponent tc) {
            this.textComponent = tc;
        }

        @Override
        public void insertString(int offset, String s, AttributeSet attributeSet) throws BadLocationException {
            int value;
            int insertCount = s.length();
            if (TKIntegerTextField.this.isDirectInsert) {
                super.insertString(offset, s, attributeSet);
                return;
            }
            String prevStr = this.textComponent.getText();
            String dbgStr = "";
            if (s.equals("-") && TKIntegerTextField.this.min >= 0) {
                return;
            }
            if (prevStr.trim().length() + s.trim().length() > TKIntegerTextField.this.nLimit) {
                return;
            }
            try {
                if (offset > 0 && offset < prevStr.length()) {
                    dbgStr = prevStr.substring(0, offset) + s + prevStr.substring(offset, prevStr.length());
                    Integer.parseInt(dbgStr, TKIntegerTextField.this.radix);
                } else if (offset == 0) {
                    if (!s.equals("-") || this.textComponent.getText().length() != 0) {
                        dbgStr = s + prevStr;
                        Integer.parseInt(dbgStr, TKIntegerTextField.this.radix);
                    }
                } else {
                    dbgStr = prevStr + s;
                    Integer.parseInt(dbgStr, TKIntegerTextField.this.radix);
                }
            }
            catch (Exception ex) {
                return;
            }
            if (dbgStr.startsWith("00")) {
                return;
            }
            if (dbgStr.length() >= 2) {
                TKCommonUtil.setxFtpPort(Integer.valueOf(dbgStr.substring(0, 2)));
            }
            super.insertString(offset, s, attributeSet);
            if (s.equals("-") && this.textComponent.getText().length() == 1) {
                value = 0;
            } else {
                try {
                    value = Integer.parseInt(this.textComponent.getText(), TKIntegerTextField.this.radix);
                }
                catch (Exception ex) {
                    value = 0;
                }
            }
            if (value > TKIntegerTextField.this.max) {
                super.remove(offset, insertCount);
                if (TKIntegerTextField.this.bAlarm && TKIntegerTextField.this.ct == 0) {
                    ++TKIntegerTextField.this.ct;
                    this.textComponent.removeFocusListener(((TKIntegerTextField)this.textComponent).listener);
                    Toolkit.getDefaultToolkit().beep();
                    --TKIntegerTextField.this.ct;
                    this.textComponent.addFocusListener(((TKIntegerTextField)this.textComponent).listener);
                }
                this.textComponent.setText(Integer.valueOf(TKIntegerTextField.this.max).toString());
            } else if (dbgStr.length() == 4 && Integer.parseInt(dbgStr, TKIntegerTextField.this.radix) < TKIntegerTextField.this.min) {
                super.remove(offset, insertCount);
                if (TKIntegerTextField.this.bAlarm && TKIntegerTextField.this.ct == 0) {
                    ++TKIntegerTextField.this.ct;
                    this.textComponent.removeFocusListener(((TKIntegerTextField)this.textComponent).listener);
                    Toolkit.getDefaultToolkit().beep();
                    --TKIntegerTextField.this.ct;
                    this.textComponent.addFocusListener(((TKIntegerTextField)this.textComponent).listener);
                }
                this.textComponent.setText(Integer.valueOf(TKIntegerTextField.this.min).toString());
            }
        }
    }
}

