/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.toolkit.client.base.util.component;

import java.awt.Component;
import javax.swing.JProgressBar;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.table.DefaultTableCellRenderer;

public class TKGuageRenderer
extends DefaultTableCellRenderer {
    private JProgressBar progressBar = null;

    public TKGuageRenderer(int min, int max) {
        this.progressBar = new JProgressBar(min, max);
        this.progressBar.setStringPainted(true);
    }

    public void setValue(int value) {
        this.progressBar.setValue(value);
        this.progressBar.setString(Integer.toString(value));
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        this.progressBar.setFont(table.getFont());
        if (hasFocus) {
            this.progressBar.setBorder(UIManager.getBorder("Table.focusCellHighlightBorder"));
            if (table.isCellEditable(row, column)) {
                this.progressBar.setForeground(UIManager.getColor("Table.focusCellForeground"));
                this.progressBar.setBackground(UIManager.getColor("Table.focusCellBackground"));
            }
        } else {
            this.progressBar.setBorder(noFocusBorder);
        }
        try {
            int v = Integer.parseInt(value.toString());
            this.progressBar.setValue(v);
            this.progressBar.setString(String.valueOf(v));
        }
        catch (Exception ex) {
            return this.progressBar;
        }
        return this.progressBar;
    }
}

