/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.toolkit.client.base.util.component;

import com.huawei.dc.common.util.DCDebugTracer;
import com.huawei.dc.toolkit.client.base.util.TKFile;
import com.huawei.dc.toolkit.client.base.util.TKLoadFileStruct;
import com.huawei.dc.toolkit.client.base.util.component.TKComboBox;
import com.huawei.dc.toolkit.client.base.util.component.TKComboBoxUI;
import com.huawei.dc.toolkit.client.base.util.component.TKTooltipCellRender;
import java.awt.Component;
import java.awt.event.ItemListener;
import java.util.EventListener;
import java.util.EventObject;
import javax.swing.AbstractCellEditor;
import javax.swing.JTable;
import javax.swing.table.TableCellEditor;

public class TKFileListEditor
extends AbstractCellEditor
implements TableCellEditor {
    TKComboBox fileBox = new TKComboBox();
    TKLoadFileStruct obj = null;
    private int index = 0;

    public TKFileListEditor() {
        this.fileBox.setUI(new TKComboBoxUI());
        TKTooltipCellRender tcr = new TKTooltipCellRender(){

            @Override
            public String toTooltipText(Object value) {
                if (value instanceof TKFile) {
                    TKFile file = (TKFile)value;
                    if (file.toString().equals("")) {
                        return "";
                    }
                    return file + "    " + file.softVersion;
                }
                return value.toString();
            }

            @Override
            public String toText(Object value) {
                if (value instanceof TKFile) {
                    TKFile file = (TKFile)value;
                    if (file.toString().equals("")) {
                        return "";
                    }
                    return file + "    " + file.softVersion;
                }
                return value.toString();
            }
        };
        this.fileBox.setRenderer(tcr);
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        this.obj = (TKLoadFileStruct)value;
        TKFile[] filelist = this.obj.fileList();
        EventListener[] el = this.fileBox.getListeners(ItemListener.class);
        this.fileBox.removeItemListener((ItemListener)el[0]);
        this.fileBox.removeAllItems();
        this.fileBox.addItemListener((ItemListener)el[0]);
        for (int i = 0; i < filelist.length; ++i) {
            if (filelist[i] == null) continue;
            if (filelist[i].equals(this.obj.getCurrentFile())) {
                this.index = i;
            }
            this.fileBox.addItem(filelist[i]);
        }
        if (filelist.length > 0 && this.fileBox.getItemCount() > 0 && this.index < filelist.length) {
            this.fileBox.setSelectedIndex(this.index);
        }
        return this.fileBox;
    }

    @Override
    public Object getCellEditorValue() {
        return this.obj;
    }

    @Override
    public boolean isCellEditable(EventObject anEvent) {
        return true;
    }

    @Override
    public boolean shouldSelectCell(EventObject anEvent) {
        return true;
    }

    @Override
    public boolean stopCellEditing() {
        DCDebugTracer.trace("TKFileListEditor stopCellEditing");
        return super.stopCellEditing();
    }
}

