/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.toolkit.client.base.util.component;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Rectangle;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.font.FontRenderContext;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Hashtable;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.text.JTextComponent;

public class TKComponentToolkit {
    private static Hashtable components = new Hashtable();
    public static final int DIALOG_RESULT_OK = 0;
    public static final int DIALOG_RESULT_CANCEL = -1;
    public static final int DIALOG_RESULT_CLOSED = 1;
    public static final Font ToolTipFont = UIManager.getFont("ToolTip.font");
    public static final int TOOLTIP_WIDTH = 300;
    private static final TKComponentToolkit instance = new TKComponentToolkit();
    public static final KeyAdapter enterKeyAdapterForButton = new KeyAdapter(){
        boolean keyPressed = false;

        @Override
        public void keyReleased(KeyEvent e) {
            if (e.getKeyCode() == 10 && this.keyPressed) {
                this.keyPressed = false;
                AbstractButton jButton = (AbstractButton)e.getSource();
                jButton.getModel().setPressed(false);
                jButton.getModel().setArmed(false);
            }
        }

        @Override
        public void keyPressed(KeyEvent e) {
            if (e.getKeyCode() == 10) {
                this.keyPressed = true;
                AbstractButton jButton = (AbstractButton)e.getSource();
                jButton.getModel().setPressed(true);
                Dimension size = jButton.getSize();
                jButton.getModel().setArmed(true);
                jButton.paintImmediately(new Rectangle(0, 0, size.width, size.height));
            }
        }
    };

    private TKComponentToolkit() {
    }

    public static TKComponentToolkit instance() {
        return instance;
    }

    public static String formatToolTip(String text) {
        String toolTip = text;
        int width = TKComponentToolkit.getRectangle((Font)TKComponentToolkit.ToolTipFont, (String)toolTip).getBounds().width;
        if (width > 300) {
            toolTip = "<html><body><table  width=300 > <tr width=300 ><td width=300 >" + toolTip + "</td></tr></table></body><html>";
        }
        return toolTip;
    }

    public static Rectangle2D getRectangle(Font font, String text) {
        Rectangle2D r2d = font.getStringBounds(text, new FontRenderContext(new AffineTransform(), true, true));
        return r2d;
    }

    public static void clearAlignComponents() {
        components.clear();
    }

    public static void clearAlignComponents(String alignId) {
        components.remove(alignId);
    }

    public static void addAlignComponent(String alignId, JComponent component) {
        Object obj = components.get(alignId);
        if (obj == null) {
            ArrayList<JComponent> comps = new ArrayList<JComponent>();
            comps.add(component);
            components.put(alignId, comps);
        } else {
            ArrayList comps = (ArrayList)obj;
            comps.add(component);
        }
    }

    public static void addAlignComponent(String alignId, JComponent[] componentList) {
        Object obj = components.get(alignId);
        if (obj == null) {
            ArrayList<JComponent> comps = new ArrayList<JComponent>();
            comps.addAll(Arrays.asList(componentList));
        } else {
            ArrayList comps = (ArrayList)obj;
            comps.addAll(Arrays.asList(componentList));
        }
    }

    public static void alignComponents(String alignId, int widthWarp) {
        int i;
        Object obj = components.get(alignId);
        if (obj == null) {
            return;
        }
        ArrayList comps = (ArrayList)obj;
        int max = 0;
        for (i = 0; i < comps.size(); ++i) {
            max = Math.max(((JComponent)comps.get((int)i)).getPreferredSize().width, max);
        }
        for (i = 0; i < comps.size(); ++i) {
            JComponent component = (JComponent)comps.get(i);
            component.setPreferredSize(new Dimension(max + widthWarp, component.getPreferredSize().height));
        }
        TKComponentToolkit.clearAlignComponents(alignId);
    }

    public static void addAllKeyListener(Container c, String componentClassName, KeyListener kl) {
        int n = c.getComponentCount();
        for (int i = 0; i < n; ++i) {
            Component comp = c.getComponent(i);
            if (TKComponentToolkit.isSubClassOf(comp.getClass(), componentClassName)) {
                JComponent jComponent = (JComponent)comp;
                jComponent.addKeyListener(kl);
            }
            if (!(comp instanceof Container)) continue;
            TKComponentToolkit.addAllKeyListener((Container)comp, componentClassName, kl);
        }
    }

    public static void addAllButtonAction(Container c, ActionListener al) {
        int n = c.getComponentCount();
        for (int i = 0; i < n; ++i) {
            Component comp = c.getComponent(i);
            if (comp instanceof JButton) {
                JButton jButton = (JButton)comp;
                jButton.addActionListener(al);
            }
            if (!(comp instanceof Container)) continue;
            TKComponentToolkit.addAllButtonAction((Container)comp, al);
        }
    }

    public static void addAllButtonEnterKeyAdp(Container c) {
        int n = c.getComponentCount();
        for (int i = 0; i < n; ++i) {
            Component comp = c.getComponent(i);
            if (comp instanceof AbstractButton) {
                AbstractButton jButton = (AbstractButton)comp;
                jButton.addKeyListener(enterKeyAdapterForButton);
            }
            if (!(comp instanceof Container)) continue;
            TKComponentToolkit.addAllButtonEnterKeyAdp((Container)comp);
        }
    }

    public static boolean isSubClassOf(Class cls, String superClassname) {
        Class pc = cls.getSuperclass();
        String cName = cls.getName();
        if (cName.equals(superClassname)) {
            return true;
        }
        if (pc.getClass().getName().equals(superClassname)) {
            return true;
        }
        Class<?> ocls = new Object().getClass();
        while (!pc.getName().equals(ocls.getName())) {
            if (pc.getName().equals(superClassname)) {
                return true;
            }
            pc = pc.getSuperclass();
        }
        return false;
    }

    public void addButtonsFocusAdapter(AbstractButton[] buttons, int orientation) {
        ButtonsFocusKeyAdapter focusAdapter = new ButtonsFocusKeyAdapter(buttons, orientation);
        if (buttons != null) {
            for (int i = 0; i < buttons.length; ++i) {
                if (buttons[i] == null) continue;
                buttons[i].addKeyListener(focusAdapter);
            }
        }
    }

    public void addTextComponentsFocusAdapter(JTextComponent[] textComponents, int orientation) {
        TextComponentFocusKeyAdapter focusAdapter = new TextComponentFocusKeyAdapter(textComponents, orientation);
        if (textComponents != null) {
            for (int i = 0; i < textComponents.length; ++i) {
                if (textComponents[i] == null) continue;
                textComponents[i].addKeyListener(focusAdapter);
            }
        }
    }

    private class TextComponentFocusKeyAdapter
    extends KeyAdapter {
        JTextComponent[] textComponents;
        int orientation;

        public TextComponentFocusKeyAdapter(JTextComponent[] textComponents, int orientation) {
            this.textComponents = textComponents;
            this.orientation = orientation;
        }

        @Override
        public void keyPressed(KeyEvent e) {
            if (e.getKeyCode() == 37 && this.orientation == 0 || e.getKeyCode() == 38 && this.orientation == 1) {
                this.preComponentFocus(e);
            } else if (e.getKeyCode() == 39 && this.orientation == 0 || e.getKeyCode() == 40 && this.orientation == 1) {
                this.nextComponentFocus(e);
            }
        }

        public void nextComponentFocus(KeyEvent e) {
            if (this.textComponents != null) {
                int i;
                int startIndex = -1;
                for (int i2 = 0; i2 < this.textComponents.length; ++i2) {
                    if (this.textComponents[i2] == null || !this.textComponents[i2].equals(e.getSource())) continue;
                    startIndex = i2;
                    break;
                }
                int findIndex = -1;
                for (i = startIndex + 1; i < this.textComponents.length; ++i) {
                    if (this.textComponents[i] == null || !this.textComponents[i].isEnabled() || !this.textComponents[i].isVisible()) continue;
                    findIndex = i;
                    break;
                }
                if (findIndex >= 0) {
                    this.textComponents[findIndex].requestFocus();
                    return;
                }
                for (i = 0; i < startIndex; ++i) {
                    if (this.textComponents[i] == null || !this.textComponents[i].isEnabled() || !this.textComponents[i].isVisible()) continue;
                    findIndex = i;
                    break;
                }
                if (findIndex >= 0) {
                    this.textComponents[findIndex].requestFocus();
                }
            }
        }

        public void preComponentFocus(KeyEvent e) {
            if (this.textComponents != null) {
                int i;
                int startIndex = -1;
                for (int i2 = 0; i2 < this.textComponents.length; ++i2) {
                    if (this.textComponents[i2] == null || !this.textComponents[i2].equals(e.getSource())) continue;
                    startIndex = i2;
                    break;
                }
                int findIndex = -1;
                for (i = startIndex - 1; i >= 0; --i) {
                    if (this.textComponents[i] == null || !this.textComponents[i].isEnabled() || !this.textComponents[i].isVisible()) continue;
                    findIndex = i;
                    break;
                }
                if (findIndex >= 0) {
                    this.textComponents[findIndex].requestFocus();
                    return;
                }
                for (i = this.textComponents.length - 1; i > startIndex; --i) {
                    if (this.textComponents[i] == null || !this.textComponents[i].isEnabled() || !this.textComponents[i].isVisible()) continue;
                    findIndex = i;
                    break;
                }
                if (findIndex >= 0) {
                    this.textComponents[findIndex].requestFocus();
                }
            }
        }
    }

    private class ButtonsFocusKeyAdapter
    extends KeyAdapter {
        AbstractButton[] buttons;
        int orientation;

        public ButtonsFocusKeyAdapter(AbstractButton[] buttons, int orientation) {
            this.buttons = buttons;
            this.orientation = orientation;
        }

        @Override
        public void keyPressed(KeyEvent e) {
            if (e.getKeyCode() == 37 && this.orientation == 0 || e.getKeyCode() == 38 && this.orientation == 1) {
                this.preComponentFocus(e);
            } else if (e.getKeyCode() == 39 && this.orientation == 0 || e.getKeyCode() == 40 && this.orientation == 1) {
                this.nextComponentFocus(e);
            }
        }

        public void nextComponentFocus(KeyEvent e) {
            if (this.buttons != null) {
                int i;
                int startIndex = -1;
                for (int i2 = 0; i2 < this.buttons.length; ++i2) {
                    if (this.buttons[i2] == null || !this.buttons[i2].equals(e.getSource())) continue;
                    startIndex = i2;
                    break;
                }
                int findIndex = -1;
                for (i = startIndex + 1; i < this.buttons.length; ++i) {
                    if (this.buttons[i] == null || !this.buttons[i].isEnabled() || !this.buttons[i].isVisible()) continue;
                    findIndex = i;
                    break;
                }
                if (findIndex >= 0) {
                    this.buttons[findIndex].requestFocus();
                    return;
                }
                for (i = 0; i < startIndex; ++i) {
                    if (this.buttons[i] == null || !this.buttons[i].isEnabled() || !this.buttons[i].isVisible()) continue;
                    findIndex = i;
                    break;
                }
                if (findIndex >= 0) {
                    this.buttons[findIndex].requestFocus();
                }
            }
        }

        public void preComponentFocus(KeyEvent e) {
            if (this.buttons != null) {
                int i;
                int startIndex = -1;
                for (int i2 = 0; i2 < this.buttons.length; ++i2) {
                    if (this.buttons[i2] == null || !this.buttons[i2].equals(e.getSource())) continue;
                    startIndex = i2;
                    break;
                }
                int findIndex = -1;
                for (i = startIndex - 1; i >= 0; --i) {
                    if (this.buttons[i] == null || !this.buttons[i].isEnabled() || !this.buttons[i].isVisible()) continue;
                    findIndex = i;
                    break;
                }
                if (findIndex >= 0) {
                    this.buttons[findIndex].requestFocus();
                    return;
                }
                for (i = this.buttons.length - 1; i > startIndex; --i) {
                    if (this.buttons[i] == null || !this.buttons[i].isEnabled() || !this.buttons[i].isVisible()) continue;
                    findIndex = i;
                    break;
                }
                if (findIndex >= 0) {
                    this.buttons[findIndex].requestFocus();
                }
            }
        }
    }
}

