/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.toolkit.client.base.util.component;

import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.plaf.basic.BasicComboPopup;
import javax.swing.plaf.basic.ComboPopup;
import javax.swing.plaf.metal.MetalComboBoxUI;

public class TKComboBoxUI
extends MetalComboBoxUI {
    private boolean canSelected = false;

    public TKComboBoxUI() {
        this(false);
    }

    public TKComboBoxUI(boolean canSelected) {
        this.canSelected = canSelected;
    }

    @Override
    protected ComboPopup createPopup() {
        return new TKComboBoxPopup(this.comboBox, this.canSelected);
    }

    class TKComboBoxPopup
    extends BasicComboPopup {
        private boolean canSelected;

        public TKComboBoxPopup(JComboBox combo, boolean canSelected) {
            super(combo);
            this.canSelected = false;
            this.canSelected = canSelected;
            combo.addKeyListener(new KeyAdapter(){

                @Override
                public void keyPressed(KeyEvent e) {
                    if (e.getKeyCode() == 10 || e.getKeyCode() == 32) {
                        TKComboBoxPopup.this.comboBox.setSelectedIndex(TKComboBoxPopup.this.list.getSelectedIndex());
                    }
                }
            });
        }

        public TKComboBoxPopup(JComboBox combo) {
            this(combo, false);
        }

        @Override
        protected JScrollPane createScroller() {
            JScrollPane sp = new JScrollPane(this.list, 20, 30);
            return sp;
        }

        @Override
        public void show() {
            Insets insets = this.getInsets();
            int popupPrefWid = this.list.getPreferredSize().width + insets.left + insets.right;
            Dimension scrollSize = new Dimension(this.comboBox.getWidth(), this.getPopupHeightForRowCount(this.comboBox.getMaximumRowCount()));
            if (popupPrefWid > scrollSize.width) {
                scrollSize.height += this.scroller.getHorizontalScrollBar().getPreferredSize().height;
            }
            this.scroller.setMaximumSize(scrollSize);
            this.scroller.setPreferredSize(scrollSize);
            this.scroller.setMinimumSize(scrollSize);
            this.list.revalidate();
            this.show(this.comboBox, 0, this.comboBox.getHeight());
        }

        public void itemStateChanged(ItemEvent e) {
            if (e.getStateChange() == 1) {
                JComboBox comboBox = (JComboBox)e.getSource();
                this.setListSelection(comboBox.getSelectedIndex());
            }
        }

        private void setListSelection(int selectedIndex) {
            if (selectedIndex == -1) {
                this.list.clearSelection();
            } else {
                ((MyList)this.list).superSetSelectedIndex(selectedIndex);
                this.list.ensureIndexIsVisible(selectedIndex);
            }
        }

        protected JList createList() {
            return new MyList();
        }

        class MyList
        extends JList {
            public MyList() {
                super(TKComboBoxPopup.this.comboBox.getModel());
            }

            public void superSetSelectedIndex(int index) {
                super.setSelectedIndex(index);
            }

            @Override
            public void setSelectedIndex(int index) {
                if (TKComboBoxPopup.this.canSelected) {
                    super.setSelectedIndex(index);
                }
            }

            @Override
            public void setSelectedIndices(int[] indices) {
                if (TKComboBoxPopup.this.canSelected) {
                    super.setSelectedIndices(indices);
                }
            }

            @Override
            public void setSelectedValue(Object anObject, boolean shouldScroll) {
                if (TKComboBoxPopup.this.canSelected) {
                    super.setSelectedValue(anObject, shouldScroll);
                }
            }

            @Override
            public void setSelectionInterval(int anchor, int lead) {
                if (TKComboBoxPopup.this.canSelected) {
                    super.setSelectionInterval(anchor, lead);
                }
            }
        }
    }
}

