/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.toolkit.client.base.util.component;

import com.huawei.dc.toolkit.client.base.util.component.TKButton;
import com.huawei.dc.toolkit.client.base.util.component.TKTextField;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Insets;
import javax.swing.Icon;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.border.EmptyBorder;
import javax.swing.table.TableCellRenderer;

public class TKButtonRenderer
implements TableCellRenderer {
    JPanel panel = new JPanel();
    TKTextField textField = new TKTextField();
    TKButton button = new TKButton();

    public TKButtonRenderer(String buttonText) {
        this(buttonText, null);
    }

    public TKButtonRenderer(Icon icon) {
        this("", icon);
    }

    public TKButtonRenderer(String buttonText, Icon icon) {
        this.button.setText(buttonText);
        if (icon != null) {
            this.button.setHorizontalTextPosition(2);
            this.button.setIcon(icon);
        }
        Insets insets = this.button.getMargin();
        insets.left = 0;
        insets.right = 0;
        this.button.setMargin(new Insets(0, 0, 0, 0));
        this.textField.setBorder(new EmptyBorder(1, 1, 1, 1));
        this.textField.setEditable(false);
        this.panel.setLayout(new BorderLayout());
        this.panel.add((Component)this.textField, "Center");
        this.panel.add((Component)this.button, "East");
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        boolean isCellEditable = table.isCellEditable(row, column);
        this.button.setEnabled(isCellEditable);
        if (isSelected) {
            this.textField.setForeground(table.getSelectionForeground());
            this.textField.setBackground(table.getSelectionBackground());
        } else {
            this.textField.setEnabled(isCellEditable);
            this.textField.setForeground(table.getForeground());
            this.textField.setBackground(table.getBackground());
        }
        if (value != null) {
            this.textField.setText(value.toString());
        }
        this.textField.repaint();
        return this.panel;
    }
}

