/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.toolkit.client.base.util.component;

import com.huawei.dc.toolkit.client.base.util.TKResourceManager;
import com.huawei.dc.toolkit.client.base.util.component.TKComponentToolkit;
import java.awt.Dimension;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JRootPane;
import javax.swing.SwingUtilities;

public class TKButton
extends JButton {
    private boolean setEnable = true;

    public TKButton() {
        this.addKeyListener(TKComponentToolkit.enterKeyAdapterForButton);
    }

    public TKButton(String text) {
        super(text);
        this.addKeyListener(TKComponentToolkit.enterKeyAdapterForButton);
    }

    public TKButton(Icon icon) {
        super(icon);
        this.addKeyListener(TKComponentToolkit.enterKeyAdapterForButton);
    }

    @Override
    public void setEnabled(boolean b) {
        this.setEnable = b;
        if (SwingUtilities.isEventDispatchThread()) {
            super.setEnabled(b);
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    TKButton.super.setEnabled(TKButton.this.setEnable);
                }
            });
        }
    }

    @Override
    public String getToolTipText() {
        if (this.isMainFrameActive()) {
            return super.getToolTipText();
        }
        return null;
    }

    protected boolean isMainFrameActive() {
        return true;
    }

    @Override
    protected void processKeyEvent(KeyEvent event) {
        JRootPane rootPane = this.getRootPane();
        if (!rootPane.getGlassPane().isVisible() && !TKResourceManager.getMainFrame().getRootPane().getGlassPane().isVisible()) {
            super.processKeyEvent(event);
        }
    }

    @Override
    protected void processMouseEvent(MouseEvent e) {
        int clickCount = e.getClickCount();
        if (clickCount >= 2) {
            return;
        }
        super.processMouseEvent(e);
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension dimension = super.getPreferredSize();
        dimension.height = 23;
        return dimension;
    }
}

