/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.toolkit.client.base.util;

import com.huawei.dc.common.util.DCDebugTracer;
import com.huawei.dc.toolkit.client.base.util.TKDebug;
import com.huawei.dc.toolkit.client.base.util.TKLogManager;
import com.huawei.dc.toolkit.client.base.util.TKProfileFactory;
import java.awt.Color;
import java.awt.Font;
import javax.swing.UIManager;

public class TKUIStyleManager {
    public static final int DEFAULT_BUTTON_WIDTH = 83;
    public static final int DEFAULT_BUTTON_HEIGHT = 26;
    public static final int CONTAINER_TOP_GAP = 20;
    public static final int CONTAINER_BOTTOM_GAP = 20;
    public static final int CONTAINER_SIDE_GAP = 20;
    public static final int CONTAINER_LEFT_GAP = 12;
    public static final int CONTAINER_RIGHT_GAP = 12;
    public static final int TAB_ITEM_BOARDER_WIDTH = 8;
    public static final int BUTTON_H_GAP = 4;
    public static final int BUTTON_V_GAP = 20;
    public static final int BUTTON_GROUP_H_GAP = 10;
    public static final Color COLOR_DISEDITABLE = new Color(230, 230, 230);
    private static final int DEFAULT_FONT_SIZE = 12;
    public static final String metalClassName = "javax.swing.plaf.metal.MetalLookAndFeel";
    public static final String motifClassName = "com.sun.java.swing.plaf.motif.MotifLookAndFeel";
    public static final String windowsClassName = "com.sun.java.swing.plaf.windows.WindowsLookAndFeel";
    public static final String MOTIF_STYLE = "Motif";
    public static final String METAL_STYLE = "Metal";
    public static final String WINDOWS_STYLE = "Windows";
    public static final String HUAWEI_STYLE = "Huawei";
    private static Font BoldFont = null;
    private static final Color alterColorHigh = new Color(196, 48, 45);
    private static final Color alterColorImportant = new Color(222, 149, 34);

    public static void setUIStyle(String styleClassName) {
        UIManager.put("FileChooser.cancelButtonToolTipText", "");
        try {
            UIManager.setLookAndFeel(styleClassName);
        }
        catch (Exception exc) {
            DCDebugTracer.trace("UnsupportedLookAndFeelException:" + exc + "\n" + "Huawei Look&*Feel is adopted!");
            TKDebug.inmAssert(false);
            TKUIStyleManager.setHuaweiStyle();
            TKUIStyleManager.writeBackUIStyle(HUAWEI_STYLE);
        }
    }

    public static String getUIStyle() {
        String uiStyle = TKProfileFactory.getCfgString("ui_style", "uistyle");
        if (uiStyle == null) {
            TKDebug.inmAssert(false, "Get Look&Feel failed. Default setting will be used.");
            uiStyle = HUAWEI_STYLE;
            TKUIStyleManager.writeBackUIStyle(uiStyle);
        }
        return uiStyle;
    }

    public static void writeBackUIStyle(String sUIStyle) {
    }

    public static void setUIStyle() {
        String sUIStyle = TKUIStyleManager.getUIStyle();
        if (null != sUIStyle) {
            if (sUIStyle.equals(MOTIF_STYLE)) {
                TKUIStyleManager.setMotifStyle();
            } else if (sUIStyle.equals(METAL_STYLE)) {
                TKUIStyleManager.setUIStyle(metalClassName);
            } else if (sUIStyle.equals(WINDOWS_STYLE)) {
                TKUIStyleManager.setUIStyle(windowsClassName);
            } else {
                TKUIStyleManager.setHuaweiStyle();
            }
        }
    }

    public static void setMotifStyle() {
        TKUIStyleManager.setUIStyle(motifClassName);
        UIManager.put("Table.selectionBackground", new Color(48, 55, 144));
        UIManager.put("Table.selectionForeground", Color.white);
    }

    public static void setHuaweiStyle() {
        TKUIStyleManager.setUIStyle(metalClassName);
        String sOsName = System.getProperty("os.name");
        TKLogManager.writeToDebug("Client OS : " + sOsName);
        int iUnixFontSize = TKUIStyleManager.getFontSize("huawei_unix");
        int iWindowsFontSize = TKUIStyleManager.getFontSize("huawei_windows");
        if (null != sOsName) {
            if (0 <= sOsName.indexOf("SunOS") || 0 <= sOsName.indexOf("HP-UX") || 0 <= sOsName.indexOf("Solaris") || 0 <= sOsName.indexOf("AIX")) {
                new Font("Dialog", 0, iUnixFontSize);
            } else if (sOsName.indexOf(WINDOWS_STYLE) >= 0) {
                new Font("Dialog", 0, iWindowsFontSize);
            } else {
                new Font("Dialog", 0, iUnixFontSize);
            }
        }
        try {
            UIManager.getDefaults().put("com.huawei.base.util.treetable.TKTreeTableUI", Class.forName("com.huawei.base.util.treetable.TKTreeTableUI"));
            UIManager.getDefaults().put("com.huawei.base.util.treetable.TKTreeTableUI", "com.huawei.base.util.treetable.TKTreeTableUI");
        }
        catch (Exception ex) {
            DCDebugTracer.trace(ex);
        }
    }

    private static int getFontSize(String sStyle) {
        String fontSize = TKProfileFactory.getCfgString("font_size", sStyle);
        if (fontSize == null) {
            TKDebug.inmAssert(false, "get font size failed");
            return 12;
        }
        try {
            return Integer.parseInt(fontSize);
        }
        catch (Exception exc) {
            TKDebug.inmAssert(false, sStyle + "\u00ef\u00bc\u009aset the size of font is invalid");
            return 12;
        }
    }

    public static Font getBoldFont() {
        if (BoldFont == null) {
            Font font = UIManager.getFont("Button.font");
            BoldFont = new Font(font.getFontName(), 1, font.getSize());
        }
        return BoldFont;
    }

    public static Color getMostAlterColor() {
        return alterColorHigh;
    }

    public static Color getImportantAlterColor() {
        return alterColorImportant;
    }
}

