/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.toolkit.client.base.util;

import com.huawei.dc.toolkit.client.base.util.TKDebug;
import com.huawei.dc.toolkit.client.base.util.TKResourceManager;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.RootPaneContainer;
import javax.swing.SwingUtilities;

public class TKScreenToolKit {
    private static MouseAdapter mouseAdapter = new MouseAdapter(){

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
        }

        @Override
        public void mouseReleased(MouseEvent e) {
        }

        @Override
        public void mousePressed(MouseEvent e) {
        }
    };
    static RootPaneContainer rootPaneContainer = null;

    private TKScreenToolKit() {
    }

    public static void centerLocateToScreen(Component comtoLocate) {
        TKDebug.inmAssert(null != comtoLocate);
        Dimension dScreen = Toolkit.getDefaultToolkit().getScreenSize();
        if (null != comtoLocate) {
            Dimension dComponent = comtoLocate.getSize();
            Point pos = new Point();
            pos.x = (int)(dScreen.getWidth() / 2.0 - dComponent.getWidth() / 2.0);
            pos.y = (int)(dScreen.getHeight() / 2.0 - dComponent.getHeight() / 2.0);
            comtoLocate.setLocation(pos);
        }
    }

    public static void adjustToScreen(Container comtoSize) {
        TKDebug.inmAssert(null != comtoSize);
        int screenWidth = Toolkit.getDefaultToolkit().getScreenSize().width;
        int screenHeight = Toolkit.getDefaultToolkit().getScreenSize().height;
        if (null != comtoSize) {
            comtoSize.setSize(screenWidth, screenHeight - 30);
            comtoSize.setLocation(0, 0);
        }
    }

    public static int getScreenWidth() {
        return Toolkit.getDefaultToolkit().getScreenSize().width;
    }

    public static int getScreenHeight() {
        return Toolkit.getDefaultToolkit().getScreenSize().height;
    }

    public static Point getPopupMenuShowupPosition(Component invoker, JPopupMenu popupMenu, int xpos, int ypos) {
        int x = (int)invoker.getLocationOnScreen().getX() + xpos;
        int y = (int)invoker.getLocationOnScreen().getY() + ypos;
        int absoluteStarty = (int)invoker.getLocationOnScreen().getY();
        int width = (int)popupMenu.getPreferredSize().getWidth();
        int height = (int)popupMenu.getPreferredSize().getHeight();
        if (x + width > TKScreenToolKit.getScreenWidth()) {
            xpos -= width;
        }
        if (y + height > TKScreenToolKit.getScreenHeight() - 30 && 30 > (ypos -= height) + absoluteStarty) {
            ypos = 30 - absoluteStarty;
        }
        return new Point(xpos, ypos);
    }

    public static void sendCommandPrepare(JDialog dlg) {
        TKScreenToolKit.setComponentCursorBusy(dlg, true);
        dlg.setDefaultCloseOperation(0);
    }

    public static void sendCommandEnd(final JDialog dlg) {
        TKScreenToolKit.setComponentCursorBusy(dlg, false);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                dlg.setDefaultCloseOperation(2);
            }
        });
    }

    public static synchronized void setComponentCursorBusy(RootPaneContainer myPaneContainer, final boolean isBusy) {
        rootPaneContainer = myPaneContainer instanceof JDialog ? myPaneContainer : TKResourceManager.getMainFrame();
        if (SwingUtilities.isEventDispatchThread()) {
            if (isBusy) {
                rootPaneContainer.getGlassPane().setVisible(true);
                rootPaneContainer.getGlassPane().setCursor(new Cursor(3));
                rootPaneContainer.getGlassPane().addMouseListener(mouseAdapter);
            } else {
                rootPaneContainer.getGlassPane().setVisible(false);
                rootPaneContainer.getGlassPane().setCursor(new Cursor(0));
                rootPaneContainer.getGlassPane().removeMouseListener(mouseAdapter);
            }
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (isBusy) {
                        rootPaneContainer.getGlassPane().setVisible(true);
                        rootPaneContainer.getGlassPane().setCursor(new Cursor(3));
                        rootPaneContainer.getGlassPane().addMouseListener(mouseAdapter);
                    } else {
                        rootPaneContainer.getGlassPane().setVisible(false);
                        rootPaneContainer.getGlassPane().setCursor(new Cursor(0));
                        rootPaneContainer.getGlassPane().removeMouseListener(mouseAdapter);
                    }
                }
            });
        }
    }

    public static void setPanelCursorBusy(final JPanel Panel, final boolean isBusy) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (null == Panel) {
                    return;
                }
                if (isBusy) {
                    Panel.setVisible(true);
                    Panel.setCursor(new Cursor(3));
                } else {
                    Panel.setCursor(new Cursor(0));
                }
            }
        });
    }

    public static void setFrameCursorBusy(final RootPaneContainer rootPaneContainer, final boolean isBusy) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (isBusy) {
                    rootPaneContainer.getGlassPane().setVisible(true);
                    rootPaneContainer.getGlassPane().setCursor(new Cursor(3));
                } else {
                    rootPaneContainer.getGlassPane().setVisible(false);
                    rootPaneContainer.getGlassPane().setCursor(new Cursor(0));
                }
            }
        });
    }
}

