/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.toolkit.client.base.util;

import com.huawei.dc.common.util.DCDebugTracer;
import com.huawei.dc.toolkit.client.base.util.TKDebug;
import com.huawei.dc.toolkit.client.base.util.TKFile;
import com.huawei.dc.toolkit.client.base.util.TKLogManager;
import com.huawei.dc.toolkit.client.base.util.TKProfileFactory;
import com.huawei.dc.toolkit.client.base.util.resource.TKAreaDescObject;
import com.huawei.dc.toolkit.client.base.util.resource.TKFileDescObject;
import com.huawei.dc.toolkit.client.te.toolkit.TKMainFrame;
import com.huawei.dc.toolkit.control.Toolkit4T2kInterface;
import com.huawei.dc.toolkit.control.Toolkit4T2kInterfaceMgr;
import java.io.File;
import java.net.URL;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JFrame;

public class TKResourceManager {
    public static final String DEV_MML = "mml";
    public static final String DEV_TL1 = "tl1";
    public static final String DEV_ALL = "all";
    public static final String OEM_HUAWEI = "huawei";
    public static final String OEM_MARCONI = "marconi";
    private static String sIconResourceFileName = "";
    private static String sIconAreaObjectName = "";
    private static TKAreaDescObject iconAreaObject = null;
    private static String sStringResourceFileName = "";
    private static String sStringAreaObjectName = "";
    private static TKAreaDescObject stringAreaObject = null;
    private static String sAppClientPath = null;
    private static Icon mainIcon = null;

    private TKResourceManager() {
    }

    public static synchronized String getString(String fileName, String areaName, String key, boolean bClear) {
        TKDebug.inmAssert(null != fileName && null != areaName && null != key);
        if (sStringResourceFileName.equals(fileName) && sStringAreaObjectName.equals(areaName) && null != stringAreaObject) {
            String sValue = stringAreaObject.getStringPropertyvalue(key, "value");
            return sValue;
        }
        sStringResourceFileName = fileName;
        sStringAreaObjectName = areaName;
        TKFileDescObject fileDescObject = TKProfileFactory.getFileDescObject(fileName);
        if (null == fileDescObject) {
            String message = "\u00e8\u00b5\u0084\u00e6\u00ba\u0090\u00e6\u0096\u0087\u00e4\u00bb\u00b6\u00e8\u008e\u00b7\u00e5\u008f\u0096\u00e5\u00a4\u00b1\u00e8\u00b4\u00a5: ";
            TKLogManager.writeToDebug(message + fileName);
            stringAreaObject = null;
            return null;
        }
        stringAreaObject = fileDescObject.getAreaDescObject(areaName);
        if (null == stringAreaObject) {
            String message = "\u00e4\u00bb\u008e\u00e9\u0085\u008d\u00e7\u00bd\u00ae\u00e6\u0096\u0087\u00e4\u00bb\u00b6\u00ef\u00bc\u009a";
            message = message + fileName;
            message = message + " \u00e4\u00bd\u009c\u00e7\u0094\u00a8\u00e5\u009f\u009f\u00e5\u00af\u00b9\u00ef\u00bf\u00bd?string_resource \u00e5\u00a4\u00b1\u00e8\u00b4\u00a5";
            TKLogManager.writeToDebug(message);
            return null;
        }
        String sValue = stringAreaObject.getStringPropertyvalue(key, "value");
        if (bClear) {
            sIconAreaObjectName = "";
            sStringAreaObjectName = "";
            stringAreaObject = null;
        }
        return sValue;
    }

    public static synchronized String getComInfoString(String fileName, String areaName, String key, boolean bClear) {
        TKDebug.inmAssert(null != fileName && null != areaName && null != key);
        if (sStringResourceFileName.equals(fileName) && sStringAreaObjectName.equals(areaName) && null != stringAreaObject) {
            String sValue = stringAreaObject.getStringPropertyvalue(key, "value");
            return sValue;
        }
        sStringResourceFileName = fileName;
        sStringAreaObjectName = areaName;
        TKFileDescObject fileDescObject = TKProfileFactory.getComInfoFileDescObject(fileName);
        if (null == fileDescObject) {
            String message = "\u00e8\u00b5\u0084\u00e6\u00ba\u0090\u00e6\u0096\u0087\u00e4\u00bb\u00b6\u00e8\u008e\u00b7\u00e5\u008f\u0096\u00e5\u00a4\u00b1\u00e8\u00b4\u00a5: ";
            TKLogManager.writeToDebug(message + fileName);
            stringAreaObject = null;
            return null;
        }
        stringAreaObject = fileDescObject.getAreaDescObject(areaName);
        if (null == stringAreaObject) {
            String message = "\u00e4\u00bb\u008e\u00e9\u0085\u008d\u00e7\u00bd\u00ae\u00e6\u0096\u0087\u00e4\u00bb\u00b6\u00ef\u00bc\u009a";
            message = message + fileName;
            message = message + " \u00e4\u00bd\u009c\u00e7\u0094\u00a8\u00e5\u009f\u009f\u00e5\u00af\u00b9\u00ef\u00bf\u00bd?string_resource \u00e5\u00a4\u00b1\u00e8\u00b4\u00a5";
            TKLogManager.writeToDebug(message);
            return null;
        }
        String sValue = stringAreaObject.getStringPropertyvalue(key, "value");
        if (bClear) {
            sIconAreaObjectName = "";
            sStringAreaObjectName = "";
            stringAreaObject = null;
        }
        return sValue;
    }

    public static String getComInfoString(String fileName, String key) {
        return TKResourceManager.getComInfoString(fileName, "string_resource", key, false);
    }

    public static String getComInfoString(String fileName, String areaName, String key) {
        return TKResourceManager.getComInfoString(fileName, areaName, key, false);
    }

    public static String getString(String fileName, String key) {
        return TKResourceManager.getString(fileName, "string_resource", key, false);
    }

    public static String getString(String fileName, String areaName, String key) {
        return TKResourceManager.getString(fileName, areaName, key, false);
    }

    public static String join(String baseString, String para) {
        if (baseString == null || para == null) {
            TKLogManager.writeToDebug("Warning: InmResourceMgr.fitTogeter was called with null parameter!");
            return baseString;
        }
        int i = baseString.indexOf("%0%");
        if (i < 0) {
            TKLogManager.writeToDebug("String Format Error: " + baseString);
            return baseString;
        }
        return baseString.substring(0, i) + para + baseString.substring(i + 3);
    }

    public static String join(String baseString, int para) {
        return TKResourceManager.join(baseString, String.valueOf(para));
    }

    public static String join(String baseString, String para0, String para1) {
        String[] paras = new String[]{para0, para1};
        return TKResourceManager.join(baseString, paras);
    }

    public static String join(String baseString, int para0, int para1) {
        String[] paras = new String[]{String.valueOf(para0), String.valueOf(para1)};
        return TKResourceManager.join(baseString, paras);
    }

    public static String join(String baseString, String[] paras) {
        if (baseString == null || paras == null) {
            TKLogManager.writeToDebug("Warning: InmResourceMgr.fitTogeter was called with null parameter!");
            return baseString;
        }
        int len = paras.length;
        String result = baseString;
        for (int i = 0; i < len; ++i) {
            int idx = result.indexOf("%" + i + "%");
            if (idx < 0) {
                TKLogManager.writeToDebug("String Format Error: " + baseString);
                return baseString;
            }
            result = result.substring(0, idx) + paras[i] + result.substring(idx + 3);
        }
        return result;
    }

    public static Icon getMainIcon() {
        if (mainIcon != null) {
            return mainIcon;
        }
        Toolkit4T2kInterface inf = Toolkit4T2kInterfaceMgr.getInstance();
        mainIcon = inf != null ? TKResourceManager.getComIcon("t2000.gif") : TKResourceManager.getComIcon("tklogo.gif");
        return mainIcon;
    }

    public static JFrame getMainFrame() {
        Toolkit4T2kInterface inf = Toolkit4T2kInterfaceMgr.getInstance();
        if (inf != null) {
            return inf.getMainFrame();
        }
        return TKMainFrame.instance;
    }

    public static Icon getIcon(String FileName) {
        StringBuffer sbFileName = new StringBuffer();
        try {
            sbFileName.append("/");
            sbFileName.append("client");
            sbFileName.append("/");
            sbFileName.append("tkconfig");
            sbFileName.append("/");
            sbFileName.append("common");
            sbFileName.append("/");
            sbFileName.append("images");
            sbFileName.append("/");
        }
        catch (SecurityException e) {
            TKLogManager.writeToDebug("\u00e8\u008e\u00b7\u00e5\u008f\u0096\u00e8\u00af\u00ad\u00e8\u00a8\u0080ID\u00e5\u00a4\u00b1\u00e8\u00b4\u00a5");
            sbFileName.setLength(0);
            sbFileName.append(TKProfileFactory.DEFAULT_LANGUAGE_PATH);
        }
        sbFileName.append(FileName);
        String iconFileName = sbFileName.toString();
        TKFile f = new TKFile("");
        URL url = f.getClass().getResource(iconFileName);
        if (url == null) {
            return null;
        }
        ImageIcon icon = new ImageIcon(url);
        return icon;
    }

    public static Icon getComIcon(String FileName) {
        StringBuffer sbFileName = new StringBuffer();
        String com = TKResourceManager.getOEMType();
        try {
            sbFileName.append("/");
            sbFileName.append("client");
            sbFileName.append("/");
            sbFileName.append("tkconfig");
            sbFileName.append("/");
            if (!TKResourceManager.isHuawei()) {
                sbFileName.append(com);
                sbFileName.append("/");
            }
            sbFileName.append("common");
            sbFileName.append("/");
            sbFileName.append("images");
            sbFileName.append("/");
        }
        catch (SecurityException e) {
            TKLogManager.writeToDebug("\u00e8\u008e\u00b7\u00e5\u008f\u0096\u00e8\u00af\u00ad\u00e8\u00a8\u0080ID\u00e5\u00a4\u00b1\u00e8\u00b4\u00a5");
            sbFileName.setLength(0);
            sbFileName.append(TKProfileFactory.DEFAULT_LANGUAGE_PATH);
        }
        sbFileName.append(FileName);
        String iconFileName = sbFileName.toString();
        TKFile f = new TKFile("");
        URL url = f.getClass().getResource(iconFileName);
        if (url == null) {
            try {
                throw new Exception("get Icon null:" + iconFileName);
            }
            catch (Exception ex) {
                DCDebugTracer.trace(ex);
                return null;
            }
        }
        ImageIcon icon = new ImageIcon(url);
        return icon;
    }

    public static String getIconPath(String FileName) {
        StringBuffer sbFileName = new StringBuffer();
        try {
            sbFileName.append(TKResourceManager.getPath());
            sbFileName.append(File.separator);
            sbFileName.append("client");
            sbFileName.append(File.separator);
            sbFileName.append("tkconfig");
            sbFileName.append(File.separator);
            sbFileName.append("common");
            sbFileName.append(File.separator);
            sbFileName.append("images");
            sbFileName.append(File.separator);
        }
        catch (SecurityException e) {
            TKLogManager.writeToDebug("\u00e8\u008e\u00b7\u00e5\u008f\u0096\u00e8\u00af\u00ad\u00e8\u00a8\u0080ID\u00e5\u00a4\u00b1\u00e8\u00b4\u00a5");
            sbFileName.setLength(0);
            sbFileName.append(TKProfileFactory.DEFAULT_LANGUAGE_PATH);
        }
        sbFileName.append(FileName);
        String iconFileName = sbFileName.toString();
        return iconFileName;
    }

    public static synchronized String getGrandParentdirectory(String fullPathName) {
        int posU;
        int pos;
        String fullPathNameOrigin = fullPathName;
        int posS = fullPathName.lastIndexOf("/");
        int n = pos = posS > (posU = fullPathName.lastIndexOf(File.separator)) ? posS : posU;
        if (0 >= pos) {
            TKLogManager.writeToDebug("\u00e9\u0085\u008d\u00e7\u00bd\u00ae\u00e6\u0096\u0087\u00e4\u00bb\u00b6\u00e5\u0090\u008d\u00e7\u00a7\u00b0\u00e9\u0094\u0099\u00e8\u00af\u00af" + fullPathNameOrigin);
            return null;
        }
        posS = (fullPathName = fullPathName.substring(0, pos)).lastIndexOf("/");
        if (posS > (posU = fullPathName.lastIndexOf(File.separator))) {
            fullPathName = fullPathName.substring(0, posS + 1);
        } else if (posS < posU || posS == posU && posS > 0) {
            fullPathName = fullPathName.substring(0, posU + File.separator.length());
        } else {
            TKLogManager.writeToDebug("\u00e9\u0085\u008d\u00e7\u00bd\u00ae\u00e6\u0096\u0087\u00e4\u00bb\u00b6\u00e5\u0090\u008d\u00e7\u00a7\u00b0\u00e9\u0094\u0099\u00e8\u00af\u00af" + fullPathNameOrigin);
            return null;
        }
        return fullPathName;
    }

    public static synchronized String getParentDirectory(String fullPathName) {
        int posU;
        int pos;
        String fullPathNameOrigin = fullPathName;
        int posS = fullPathName.lastIndexOf("/");
        int n = pos = posS > (posU = fullPathName.lastIndexOf(File.separator)) ? posS : posU;
        if (0 >= pos) {
            TKLogManager.writeToDebug("\u00e9\u0085\u008d\u00e7\u00bd\u00ae\u00e6\u0096\u0087\u00e4\u00bb\u00b6\u00e5\u0090\u008d\u00e7\u00a7\u00b0\u00e9\u0094\u0099\u00e8\u00af\u00af" + fullPathNameOrigin);
            return null;
        }
        fullPathName = fullPathName.substring(0, pos);
        return fullPathName;
    }

    public static String getPath() {
        if (null == sAppClientPath) {
            File temFile = new File(".");
            temFile = new File(temFile.getAbsolutePath());
            sAppClientPath = temFile.getParentFile().getAbsolutePath();
            String sTemp = null;
            sTemp = temFile.getParentFile().getAbsolutePath();
            if (null == sTemp) {
                return sAppClientPath;
            }
            if (null == (sTemp = TKResourceManager.getParentDirectory(sTemp))) {
                TKLogManager.writeToDebug("\u00e6\u008f\u0090\u00e7\u00a4\u00ba\u00ef\u00bc\u009a\u00e8\u00af\u00b7\u00e6\u00a3\u0080\u00e6\u009f\u00a5imap\u00e5\u008f\u0098\u00e9\u0087\u008f\u00e6\u0098\u00af\u00e5\u0090\u00a6\u00e8\u00ae\u00be\u00e7\u00bd\u00ae\u00e6\u00ad\u00a3\u00e7\u00a1\u00ae" + System.getProperty("imap"));
                return sAppClientPath;
            }
            File cp = new File(sTemp = sTemp + File.separator + "toolkit");
            if (!cp.isDirectory()) {
                TKLogManager.writeToDebug("\u00e6\u008f\u0090\u00e7\u00a4\u00ba\u00ef\u00bc\u009a\u00e6\u0097\u00a0\u00e6\u00b3\u0095\u00e6\u00a0\u00b9\u00e6\u008d\u00aeimap\u00e5\u008f\u0098\u00e9\u0087\u008f\u00e5\u00ae\u009a\u00e4\u00bd\u008dclient\u00e8\u00b7\u00af\u00e5\u00be\u0084" + System.getProperty("imap"));
                return sAppClientPath;
            }
            sAppClientPath = sTemp;
        }
        return sAppClientPath;
    }

    public static String getDevType() {
        String tp = TKProfileFactory.getCfgString("dev", "type");
        if (tp != null && tp.trim().length() > 1) {
            return tp;
        }
        return DEV_ALL;
    }

    public static int getNumberOfLoadObject() {
        int objects = 5;
        String num = TKProfileFactory.getCfgString("comm", "MaxLoadNumber");
        try {
            objects = Integer.parseInt(num);
        }
        catch (Exception ex) {
            DCDebugTracer.trace(ex);
        }
        return objects;
    }

    public static int getNumberOfMaxNENumber() {
        int maxNENumber = -1;
        String maxNENumberStr = TKProfileFactory.getCfgString("comm", "MaxNENumber");
        try {
            maxNENumber = Integer.parseInt(maxNENumberStr);
        }
        catch (Exception ex) {
            DCDebugTracer.trace(ex);
        }
        return maxNENumber;
    }

    public static String getOEMType() {
        String tp = TKProfileFactory.getCfgString("dev", "oem");
        if (tp != null && tp.trim().length() > 1) {
            return tp;
        }
        return OEM_HUAWEI;
    }

    public static boolean isHuawei() {
        String oem = TKResourceManager.getOEMType();
        return oem.trim().equalsIgnoreCase(OEM_HUAWEI);
    }

    public static String getCfgPath() {
        String cfgPath = TKResourceManager.getPath() + File.separator + "client" + File.separator + "tkconfig" + File.separator + "common";
        return cfgPath;
    }

    public static boolean isRightIP(String ipAddress) {
        boolean isRightIP = true;
        if (ipAddress.length() < 7 || ipAddress.equals("")) {
            return false;
        }
        String temIPAddress = ipAddress.replace('.', 'a');
        String[] IParea = temIPAddress.split("a");
        if (IParea.length < 4) {
            return false;
        }
        if (Integer.parseInt(IParea[0]) < 1 || Integer.parseInt(IParea[0]) > 223) {
            return false;
        }
        for (int i = 0; i < IParea.length; ++i) {
            if (IParea[i].trim().equals("")) {
                return false;
            }
            try {
                int tempInt = Integer.parseInt(IParea[i]);
                if (tempInt >= 0 && tempInt <= 255) continue;
                return false;
            }
            catch (Exception ex) {
                return false;
            }
        }
        return isRightIP;
    }
}

