/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.toolkit.client.base.util;

import com.huawei.dc.toolkit.client.base.util.TKResourceManager;
import com.huawei.dc.toolkit.client.base.util.resource.TKErrorCodeRes;
import com.huawei.dc.toolkit.client.base.util.resource.TKErrorNECodeRes;
import com.huawei.te.toolkit.AsnSingleReturn;
import com.huawei.te.toolkit.AsnTkMessageRpt;
import com.huawei.te.toolkit.AsnToolkitError;
import com.huawei.te.toolkit.AsnToolkitParameter;
import java.util.MissingResourceException;
import java.util.Vector;

public class TKRes {
    public static final int MSGTYPE_ALARM = 1;
    public static final int MSGTYPE_ERROR = 0;
    private String fileName = "stringres.ini";
    private static TKRes instance = null;
    private String comInfoFileName = "comres.ini";

    public static TKRes instance() {
        if (null == instance) {
            instance = new TKRes();
        }
        return instance;
    }

    public final String getString(String key) throws MissingResourceException {
        String s = TKResourceManager.getString(this.fileName, key);
        if (null == s) {
            s = key;
        }
        return s;
    }

    public final String getComInfoString(String key) throws MissingResourceException {
        String s = TKResourceManager.getComInfoString(this.comInfoFileName, key);
        if (null == s) {
            s = key;
        }
        return s;
    }

    public static String getErrorInfo(AsnSingleReturn asr) {
        return TKRes.getErrorInfo(asr, 0);
    }

    public static String getErrorInfo(AsnSingleReturn asr, int msgType) {
        String seReasonText;
        int errcode = asr.retCode.intValue();
        String msgCode = instance.getString("ErrCode");
        if (msgType == 1) {
            msgCode = instance.getString("MsgCode");
        }
        StringBuilder stringBuilder = new StringBuilder().append(msgCode).append(":");
        TKErrorCodeRes.instance();
        String reason = stringBuilder.append(TKErrorCodeRes.parseCode(errcode)).toString();
        String reasonText = TKErrorCodeRes.instance().getErrString(String.valueOf(errcode));
        reason = !reasonText.equals("") ? reasonText + " (" + reason + ")" : ((seReasonText = TKErrorNECodeRes.instance().getErrString(String.valueOf(errcode &= 0xFFFF))).equals("") ? (asr.reason != null && asr.reason.length > 0 ? new String(asr.reason) + " (" + reason + ")" : reasonText + " (" + reason + ")") : seReasonText + " (" + reason + ")");
        if (asr.parameters != null) {
            for (int i = 0; i < asr.parameters.size(); ++i) {
                AsnToolkitParameter atp = (AsnToolkitParameter)asr.parameters.get(i);
                String repName = new String(atp.name).trim();
                String repValue = new String(atp.value);
                reason = reason.replaceAll(repName, repValue);
            }
        }
        return reason;
    }

    public static String getErrorInfo(AsnToolkitError asr) {
        return TKRes.getErrorInfo(asr, 0);
    }

    public static String getResultInfo(AsnTkMessageRpt rptEvt) {
        String operResult = instance.getString("Error_Report");
        if (rptEvt.msgType.intValue() == 1) {
            operResult = instance.getString("Notice_Report");
        }
        return operResult;
    }

    public static String getErrorInfo(AsnToolkitError error, int msgType) {
        String seReasonText;
        int errcode = error.errCode.intValue();
        String msgCode = instance.getString("ErrCode");
        if (msgType == 1) {
            msgCode = instance.getString("MsgCode");
        }
        StringBuilder stringBuilder = new StringBuilder().append(msgCode).append(":");
        TKErrorCodeRes.instance();
        String reason = stringBuilder.append(TKErrorCodeRes.parseCode(errcode)).toString();
        String reasonText = TKErrorCodeRes.instance().getErrString(String.valueOf(errcode));
        reason = !reasonText.equals("") ? reasonText + " (" + reason + ")" : ((seReasonText = TKErrorNECodeRes.instance().getErrString(String.valueOf(errcode &= 0xFFFF))).equals("") ? (error.reason != null && error.reason.length > 0 ? new String(error.reason) + " (" + reason + ")" : reasonText + " (" + reason + ")") : seReasonText + " (" + reason + ")");
        if (error.parameters != null) {
            for (int i = 0; i < error.parameters.size(); ++i) {
                AsnToolkitParameter atp = (AsnToolkitParameter)error.parameters.get(i);
                String repName = new String(atp.name).trim();
                String repValue = new String(atp.value);
                reason = reason.replaceAll(repName, repValue);
            }
        }
        return reason;
    }

    public static void fillData(Vector v, Object[] objs) {
        if (objs == null) {
            return;
        }
        for (int i = 0; i < objs.length; ++i) {
            v.add(objs[i]);
        }
    }
}

