/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.toolkit.client.base.util;

import com.huawei.dc.toolkit.client.base.util.TKDebug;
import com.huawei.dc.toolkit.client.base.util.TKLogManager;
import com.huawei.dc.toolkit.client.base.util.TKResourceManager;
import com.huawei.dc.toolkit.client.base.util.resource.TKAreaDescObject;
import com.huawei.dc.toolkit.client.base.util.resource.TKDescObject;
import com.huawei.dc.toolkit.client.base.util.resource.TKFileDescObject;
import com.huawei.dc.toolkit.control.Toolkit4T2kInterface;
import com.huawei.dc.toolkit.control.Toolkit4T2kInterfaceMgr;
import java.io.File;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;

public class TKProfileFactory {
    private static Hashtable saveFileTable = new Hashtable();
    private static Hashtable fileTable = new Hashtable();
    public static final String ENGLISH_LANGUAGE_ID = "en_US";
    public static final String CHINESE_LANGUAGE_ID = "zh_CN";
    public static final String DEFAULT_LANGUAGE_PATH = TKResourceManager.getPath() + File.separator + "client" + File.separator + "tkconfig" + File.separator + "en_US" + File.separator;
    private static String sResourcePath = "";
    private static String sComInfoResourcePath = "";
    private static String languageID = null;
    private static Hashtable commonFileTable = null;

    private TKProfileFactory() {
    }

    public static String getLanguageID() {
        return languageID;
    }

    public static String getCfgString(String area, String cfgname) {
        return TKProfileFactory.getCfgString("sysconfig.ini", area, cfgname);
    }

    public static String getBaseCfgString(String area, String cfgname) {
        return TKProfileFactory.getCfgString("tkconfig.ini", area, cfgname);
    }

    public static String getCfgString(String file, String area, String cfgname) {
        TKFileDescObject cfile = TKProfileFactory.getCommonFileDescObject(file);
        if (null == cfile) {
            TKLogManager.writeToDebug("\u00e8\u008e\u00b7\u00e5\u008f\u0096\u00e9\u0085\u008d\u00e7\u00bd\u00ae\u00e6\u0096\u0087\u00e4\u00bb\u00b6" + file + "\u00e5\u00a4\u00b1\u00e8\u00b4\u00a5");
            return null;
        }
        TKAreaDescObject areaObject = cfile.getAreaDescObject(area);
        if (null == areaObject) {
            TKLogManager.writeToDebug("\u00e8\u008e\u00b7\u00e5\u008f\u0096\u00e9\u0085\u008d\u00e7\u00bd\u00ae\u00e6\u0096\u0087\u00e4\u00bb\u00b6" + file + "\u00e7\u009a\u0084\u00e4\u00bd\u009c\u00e7\u0094\u00a8\u00e5\u009f\u009f\u00e5\u00af\u00b9\u00e8\u00b1\u00a1" + area + "\u00e5\u00a4\u00b1\u00e8\u00b4\u00a5");
            return null;
        }
        String oString = areaObject.getStringPropertyvalue(cfgname, "value");
        if (null == oString) {
            return null;
        }
        return oString;
    }

    public static void setLanguageProperty() {
        Toolkit4T2kInterface inf = Toolkit4T2kInterfaceMgr.getInstance();
        if (inf != null) {
            Locale oCurrentLocale = inf.getLanguageConfig();
            languageID = oCurrentLocale.getLanguage() + "_" + oCurrentLocale.getCountry();
            return;
        }
    }

    public static synchronized TKFileDescObject getCommonFileDescObject(String fileName) {
        TKFileDescObject fileObject;
        if (null == languageID) {
            TKProfileFactory.setLanguageProperty();
        }
        TKDebug.inmAssert(null != fileName && 0 < fileName.length());
        if (null == commonFileTable) {
            commonFileTable = new Hashtable();
        }
        if (null != (fileObject = (TKFileDescObject)commonFileTable.get(fileName))) {
            return fileObject;
        }
        StringBuffer sbFileName = new StringBuffer();
        sbFileName.append("/");
        sbFileName.append("client");
        sbFileName.append("/");
        sbFileName.append("tkconfig");
        sbFileName.append("/");
        sbFileName.append("common");
        sbFileName.append("/");
        sbFileName.append(fileName);
        fileObject = new TKFileDescObject();
        if (!fileObject.initialize(sbFileName.toString()) && null != fileName) {
            if (fileName.equals("tkconfig.ini")) {
                saveFileTable.put(fileName, Boolean.TRUE);
                fileObject = TKFileDescObject.getBaseConfig();
            } else {
                fileObject = null;
                return null;
            }
        }
        commonFileTable.put(fileName, fileObject);
        return fileObject;
    }

    public static void removeCommonFileDescObject(String fileName) {
        TKDebug.inmAssert(null != fileName);
        commonFileTable.remove(TKResourceManager.getPath() + File.separator + "client" + File.separator + "tkconfig" + File.separator + "common" + File.separator + fileName);
    }

    public static synchronized TKFileDescObject getFileDescObject(String fileName) {
        TKFileDescObject fileObject;
        if (null == languageID) {
            TKProfileFactory.setLanguageProperty();
        }
        TKDebug.inmAssert(null != fileName && 0 < fileName.length());
        String fullFileName = "";
        StringBuffer tempBuf = new StringBuffer();
        if (0 == sResourcePath.length()) {
            tempBuf.append("/");
            tempBuf.append("client");
            tempBuf.append("/");
            tempBuf.append("tkconfig");
            tempBuf.append("/");
            tempBuf.append(languageID);
            tempBuf.append("/");
            sResourcePath = tempBuf.toString();
        }
        if (null != (fileObject = (TKFileDescObject)fileTable.get(fullFileName = sResourcePath + fileName))) {
            return fileObject;
        }
        fileObject = new TKFileDescObject();
        if (!fileObject.initialize(fullFileName)) {
            fileObject = null;
            return null;
        }
        fileTable.put(fullFileName, fileObject);
        return fileObject;
    }

    public static void writeBackCommonFile() {
        saveFileTable.put("tkconfig.ini", Boolean.TRUE);
        Enumeration files = saveFileTable.keys();
        while (files.hasMoreElements()) {
            TKFileDescObject file;
            String fileName = files.nextElement().toString();
            Boolean willSave = (Boolean)saveFileTable.get(fileName);
            if (!willSave.booleanValue() || (file = TKProfileFactory.getCommonFileDescObject(fileName)) == null) continue;
            file.writeBackToFile();
        }
        saveFileTable.clear();
    }

    public static int writeBackCommonStringProperty(String fileName, String areaDescName, String descName, String propertyName, String propertyValue) {
        TKFileDescObject file = TKProfileFactory.getCommonFileDescObject(fileName);
        if (file == null) {
            TKLogManager.writeToDebug("Failed reading file " + fileName);
            return 8;
        }
        saveFileTable.put(fileName, Boolean.FALSE);
        return TKProfileFactory.writeProperty(file, areaDescName, descName, propertyName, propertyValue);
    }

    public static int saveCommonStringProperty(String fileName, String areaDescName, String descName, String propertyName, String propertyValue) {
        TKFileDescObject file = TKProfileFactory.getCommonFileDescObject(fileName);
        if (file == null) {
            TKLogManager.writeToDebug("Failed reading file " + fileName);
            return 8;
        }
        String proValue = TKProfileFactory.getCfgString(fileName, areaDescName, descName);
        if (proValue != null && proValue.equals(propertyValue)) {
            return 7;
        }
        saveFileTable.put(fileName, Boolean.TRUE);
        return TKProfileFactory.saveProperty(file, areaDescName, descName, propertyName, propertyValue);
    }

    private static int saveProperty(TKFileDescObject file, String areaDescName, String descName, String propertyName, String propertyValue) {
        TKAreaDescObject areaObject = file.getAreaDescObject(areaDescName);
        if (null == areaObject) {
            TKLogManager.writeToDebug("Failed getting AreaDescObject " + areaDescName);
            return 8;
        }
        TKDescObject descObject = areaObject.getDescObject(descName);
        if (descObject == null) {
            TKLogManager.writeToDebug("Failed getting DescObject " + descName);
            return 8;
        }
        descObject.setPropertyValue(propertyName, propertyValue);
        return file.saveDescObject(descObject);
    }

    private static int writeProperty(TKFileDescObject file, String areaDescName, String descName, String propertyName, String propertyValue) {
        TKAreaDescObject areaObject = file.getAreaDescObject(areaDescName);
        if (null == areaObject) {
            TKLogManager.writeToDebug("Failed getting AreaDescObject " + areaDescName);
            return 8;
        }
        TKDescObject descObject = areaObject.getDescObject(descName);
        if (descObject == null) {
            TKLogManager.writeToDebug("Failed getting DescObject " + descName);
            return 8;
        }
        descObject.setPropertyValue(propertyName, propertyValue);
        return file.writeDescObject(descObject, true);
    }

    public static synchronized TKFileDescObject getComInfoFileDescObject(String fileName) {
        String fullFileName;
        TKFileDescObject fileObject;
        if (null == languageID) {
            TKProfileFactory.setLanguageProperty();
        }
        TKDebug.inmAssert(null != fileName && 0 < fileName.length());
        StringBuffer tempBuf = new StringBuffer();
        if (0 == sComInfoResourcePath.length()) {
            tempBuf.append("/");
            tempBuf.append("client");
            tempBuf.append("/");
            tempBuf.append("tkconfig");
            tempBuf.append("/");
            tempBuf.append(languageID);
            tempBuf.append("/");
            sComInfoResourcePath = tempBuf.toString();
        }
        if (null != (fileObject = (TKFileDescObject)fileTable.get(fullFileName = sComInfoResourcePath + fileName))) {
            return fileObject;
        }
        fileObject = new TKFileDescObject();
        if (!fileObject.initialize(fullFileName)) {
            fileObject = null;
            return null;
        }
        fileTable.put(fullFileName, fileObject);
        return fileObject;
    }
}

