/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.toolkit.client.base.util;

import com.huawei.dc.toolkit.client.base.communicate.TKCmdMSG;
import com.huawei.dc.toolkit.client.base.communicate.TKCommUtility;
import com.huawei.dc.toolkit.client.base.communicate.TKNoticeReceiver;
import com.huawei.dc.toolkit.client.base.util.TKDebug;
import com.huawei.dc.toolkit.client.base.util.TKLogManager;
import com.huawei.dc.toolkit.client.base.util.TKRes;
import com.huawei.dc.toolkit.client.base.util.resource.TKErrorCodeRes;
import com.huawei.dc.toolkit.control.TKCommNotifier;
import com.huawei.te.toolkit.AsnToolkitOperateLogRpt;
import net.commustru.fstru.FStruct;

public class TKLogUtility
implements TKNoticeReceiver,
TKCommNotifier {
    private static TKLogUtility instance = new TKLogUtility();
    private static char TOOLKIT_CMD_RPT_LOG_TO_T2K = (char)4871;
    private static int SUCC_CODE = 0;
    private static int FAILED_CODE = 0;

    public static void init() {
        TKCommUtility.addCommunicationNotifier(instance);
    }

    public static void unInstall() {
        if (TKCommUtility.comm != null) {
            TKCommUtility.comm.unregisterListener(TOOLKIT_CMD_RPT_LOG_TO_T2K, instance);
        }
        TKCommUtility.removeCommunicationNotifier(instance);
    }

    private TKLogUtility() {
    }

    @Override
    public byte handleNotice(char cmdCode, TKCmdMSG data) {
        if (cmdCode == TOOLKIT_CMD_RPT_LOG_TO_T2K) {
            AsnToolkitOperateLogRpt rpt = new AsnToolkitOperateLogRpt();
            boolean result = TKCommUtility.getASNData(data, (FStruct)rpt);
            if (!result) {
                TKDebug.inmAssert(false, "Decode Fail!");
                return 0;
            }
            String object = new String(rpt.neName);
            String detail = new String(rpt.result);
            String sTimeInfo = new String(rpt.time);
            int errCode = 0;
            if (rpt.errCode.intValue() > SUCC_CODE) {
                StringBuilder stringBuilder = new StringBuilder().append("(").append(TKRes.instance().getString("ErrCode")).append(":");
                TKErrorCodeRes.instance();
                String reason = stringBuilder.append(TKErrorCodeRes.parseCode(rpt.errCode.intValue())).append(")").toString();
                detail = detail + reason;
                errCode = 74040;
            }
            TKLogManager.writeT2kLog(object, detail, sTimeInfo, errCode);
        }
        return 1;
    }

    @Override
    public void notifyCommunication(boolean isConnected) {
        if (isConnected) {
            TKCommUtility.comm.unregisterListener(TOOLKIT_CMD_RPT_LOG_TO_T2K, instance);
            TKCommUtility.comm.registerListener(TOOLKIT_CMD_RPT_LOG_TO_T2K, instance);
        }
    }
}

