/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.toolkit.client.base.util;

import com.huawei.dc.toolkit.client.base.util.TKFile;
import java.util.Vector;

public class TKLoadFileStruct {
    private Vector m_vcFiles = new Vector();
    private String version = "";
    private TKFile curFile;
    public static final TKFile nullFile = new TKFile("");

    public TKLoadFileStruct() {
        this.curFile = nullFile;
    }

    public TKLoadFileStruct(TKFile[] fs) {
        if (fs != null && fs.length >= 1) {
            this.putFiles(fs);
        } else {
            this.setCurrentFile(nullFile);
        }
    }

    public void putFiles(TKFile[] fs) {
        if (fs == null) {
            return;
        }
        for (int i = 0; i < fs.length; ++i) {
            this.add(fs[i]);
        }
    }

    public boolean add(TKFile f) {
        if (this.contains(f)) {
            return false;
        }
        this.addFile(f);
        return true;
    }

    public void update(String fPath) {
        this.clear();
        this.setCurrentFile(new TKFile(fPath));
    }

    public void update(TKFile f) {
        this.clear();
        this.setCurrentFile(f);
    }

    public void updateVersion(TKFile f) {
        if (this.contains(f)) {
            TKFile tkFile = (TKFile)this.m_vcFiles.get(this.m_vcFiles.indexOf(f));
            tkFile.softVersion = f.softVersion;
        } else {
            this.addFile(f);
        }
    }

    public void update(TKFile[] fs) {
        this.clear();
        this.putFiles(fs);
    }

    public boolean contains(TKFile tkFile) {
        boolean contains = this.m_vcFiles.contains(tkFile);
        return contains;
    }

    public Vector getTKFiles() {
        return this.m_vcFiles;
    }

    public void setCurrentFile(TKFile f) {
        if (f == null) {
            return;
        }
        if (f.getAbsolutePath().trim().equals("")) {
            return;
        }
        if (!this.contains(f)) {
            this.curFile = f;
            this.addFile(f);
        } else {
            this.curFile = (TKFile)this.m_vcFiles.get(this.m_vcFiles.indexOf(f));
        }
    }

    public void setCurrentFile(String fPath) {
        if (fPath != null && !fPath.trim().equals("")) {
            this.setCurrentFile(new TKFile(fPath));
        }
    }

    private void addFile(TKFile f) {
        if (this.curFile == null || this.curFile.equals(nullFile)) {
            this.curFile = f;
        }
        this.m_vcFiles.add(f);
    }

    public TKFile getCurrentFile() {
        return this.curFile;
    }

    public synchronized String getVersion() {
        return this.version;
    }

    public synchronized void setVersion(String version) {
        this.version = version;
    }

    public void clear() {
        this.curFile = nullFile;
        this.m_vcFiles.clear();
    }

    public TKFile[] fileList() {
        if (this.contains(nullFile)) {
            this.m_vcFiles.remove(nullFile);
        }
        Object[] fs = new TKFile[this.m_vcFiles.size()];
        this.m_vcFiles.copyInto(fs);
        return fs;
    }

    public String toString() {
        StringBuffer fInfos = new StringBuffer();
        for (int i = 0; i < this.m_vcFiles.size(); ++i) {
            String filePath = this.m_vcFiles.get(i).toString();
            if (filePath.equals("")) continue;
            fInfos.append(filePath);
            fInfos.append(i == this.m_vcFiles.size() - 1 ? "" : "*");
        }
        return fInfos.toString();
    }
}

