/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.toolkit.client.base.util;

public class TKIpValue
implements Comparable {
    private long ipValue = 0L;

    public TKIpValue(long ipValue) {
        this.setValue(ipValue);
    }

    public String toString() {
        return TKIpValue.ipToString(this.ipValue);
    }

    public static String ipToString(long ip) {
        long ip1 = ip >> 24 & 0xFFL;
        long ip2 = ip >> 16 & 0xFFL;
        long ip3 = ip >> 8 & 0xFFL;
        long ip4 = ip & 0xFFL;
        return "" + ip1 + "." + ip2 + "." + ip3 + "." + ip4;
    }

    public void setValue(long value) {
        this.ipValue = TKIpValue.convertToIPValue(value);
    }

    public static long convertToIPValue(long value) {
        long ip1 = value >> 24 & 0xFFL;
        long ip2 = value >> 16 & 0xFFL;
        long ip3 = value >> 8 & 0xFFL;
        long ip4 = value & 0xFFL;
        return ip1 << 24 | ip2 << 16 | ip3 << 8 | ip4;
    }

    public long getValue() {
        return this.ipValue;
    }

    public boolean equals(Object parm1) {
        if (parm1 instanceof TKIpValue) {
            return this.ipValue == ((TKIpValue)parm1).getValue();
        }
        return false;
    }

    public int hashCode() {
        return (int)(this.ipValue ^ this.ipValue >> 32);
    }

    public int compareTo(Object o) {
        long compareValue = this.ipValue - ((TKIpValue)o).ipValue;
        int retValue = 0;
        if (compareValue > 0L) {
            retValue = 1;
        } else if (compareValue < 0L) {
            retValue = -1;
        }
        return retValue;
    }
}

