/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.toolkit.client.base.util;

import com.huawei.dc.common.util.DCDebugTracer;
import com.huawei.dc.toolkit.client.base.util.TKCommonUtil;
import com.huawei.dc.toolkit.client.base.util.TKFile;
import com.huawei.dc.toolkit.client.base.util.TKFileUtilities;
import com.huawei.dc.toolkit.client.base.util.text.TKCodeContent;

public class TKFtpStruct
extends TKFile {
    public String ftpIP = "127.0.0.1";
    public int ftpPort = 21;
    public String ftpUser = "";
    public String ftpPass = "";
    public boolean isFtp = true;
    public Object exValue = "";

    public TKFtpStruct(String fileName) {
        super(fileName);
        if (0 != fileName.length() && !fileName.equals("") && fileName.startsWith("sftp:")) {
            try {
                TKFtpStruct file = TKFileUtilities.parseFTPPath(fileName);
                this.ftpIP = file.ftpIP;
                this.ftpPort = file.ftpPort;
                this.ftpPass = file.ftpPass;
                this.ftpUser = file.ftpUser;
            }
            catch (Exception e) {
                DCDebugTracer.trace(e);
            }
        }
    }

    public TKFtpStruct(String path, int tkType) {
        super(path, tkType);
    }

    public TKFtpStruct(String path, int tkType, boolean isRoot) {
        super(path, tkType);
        this.isRoot(isRoot);
    }

    public TKFtpStruct(String path, int tkType, boolean isRoot, String fileDesc) {
        super(path, tkType, fileDesc);
        this.isRoot(isRoot);
    }

    public TKFtpStruct(String path, int tkType, boolean isRoot, boolean isHidden, String fileDesc) {
        super(path, tkType, isRoot, fileDesc);
        this.isRoot(isRoot);
    }

    @Override
    public String getAbsolutePath() {
        if (this.getPath().equals("")) {
            return "";
        }
        String absolutePath = this.getPath();
        if (this.isFtp && !absolutePath.startsWith(TKCommonUtil.getxFtpType(this.ftpPort) + "/" + "/")) {
            absolutePath = TKCommonUtil.getxFtpType(this.ftpPort) + "/" + "/" + this.ftpUser + ":" + this.ftpPass + "@" + this.ftpIP + ":" + this.ftpPort + absolutePath;
        }
        return absolutePath;
    }

    @Override
    public String toString() {
        String path = this.getPath();
        if (path.equals("")) {
            return "";
        }
        String absolutePath = TKCodeContent.formatFtpPath(path);
        if (this.isFtp && !absolutePath.startsWith(TKCommonUtil.getxFtpType(this.ftpPort) + "/" + "/")) {
            absolutePath = TKCommonUtil.getxFtpType(this.ftpPort) + "/" + "/" + this.ftpUser + ":" + "******" + "@" + this.ftpIP + ":" + this.ftpPort + absolutePath;
        }
        return absolutePath;
    }

    @Override
    public String getPath() {
        String prefix = TKCommonUtil.getxFtpType(this.ftpPort) + "/" + "/" + this.ftpUser + ":" + this.ftpPass + "@" + this.ftpIP + ":" + this.ftpPort;
        String path = super.getPath();
        int index = path.indexOf(prefix);
        if (index >= 0) {
            path = path.substring(index + prefix.length());
        }
        if (this.isDirectory() && !path.endsWith("/")) {
            path = path + "/";
        }
        return path;
    }
}

