/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.toolkit.client.base.util;

import com.huawei.dc.common.util.DCDebugTracer;
import com.huawei.dc.toolkit.client.base.util.TKDebug;
import com.huawei.dc.toolkit.client.base.util.TKFile;
import com.huawei.dc.toolkit.client.base.util.TKFtpStruct;
import com.huawei.dc.toolkit.client.base.util.TKRes;
import com.huawei.dc.toolkit.client.base.util.TKResourceManager;
import java.io.File;
import java.text.NumberFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import javax.swing.filechooser.FileSystemView;
import sun.awt.shell.ShellFolder;

public class TKFileUtilities {
    private static int compare_orientation = 0;
    public static final int COMPARE_OF_FILE = 0;
    public static final int COMPARE_OF_SIZE = 1;
    public static final int COMPARE_OF_DESC = 2;
    public static final int COMPARE_OF_DATE = 3;
    private static boolean isAscent_ = true;
    private static String resourceFileName = "fileres.ini";
    public static TKFile lastToolkitPath = new TKFile("C:", 1, true, "Drive");
    public static String ftpServer = "";
    public static int ftpPort = 22;
    public static String ftpUser = "";
    public static String ftpPass = "";
    public static String lastFtpPath = "/";

    public static String getFileTypeDescription(String fileExtension) {
        String s = TKResourceManager.getString(resourceFileName, fileExtension.toLowerCase());
        if (null == s) {
            s = TKRes.instance().getString(fileExtension);
            s = s + " " + TKResourceManager.getString(resourceFileName, "file");
        }
        return s;
    }

    public static String getFileDescription(String fileDescription) {
        String s = TKResourceManager.getString(resourceFileName, fileDescription);
        if (null == s) {
            s = TKRes.instance().getString(fileDescription);
        }
        return s;
    }

    public static synchronized void setFileCompareOrientation(int orientation) {
        compare_orientation = orientation;
    }

    public static synchronized int getFileCompareOrientation() {
        return compare_orientation;
    }

    public static synchronized void setFileCompositor(boolean isAscent) {
        isAscent_ = isAscent;
    }

    public static synchronized boolean isAscentFileCompositor() {
        return isAscent_;
    }

    public static String getFileTypeDescription(TKFile tkFile) {
        if (tkFile.isDirectory()) {
            return TKFileUtilities.getFileDescription("Directory");
        }
        String ext = TKFileUtilities.getFileExtension(tkFile);
        if (ext.equals("")) {
            return TKFileUtilities.getFileDescription("file");
        }
        return ext + " " + TKFileUtilities.getFileDescription("file");
    }

    public static String getFileName(TKFile f) {
        String name_ = f.getPath().trim();
        int len = name_.length();
        if (len == 0) {
            return "";
        }
        int spIndex = name_.lastIndexOf("/");
        if (spIndex >= 0 && spIndex < len - 1) {
            name_ = name_.substring(spIndex + 1);
        } else if (spIndex == len - 1 && (spIndex = (name_ = name_.substring(0, len - 1)).lastIndexOf("/")) >= 0) {
            name_ = name_.substring(spIndex + 1);
        }
        if (name_.length() > 1 && name_.endsWith("/")) {
            name_ = name_.substring(0, name_.length() - 1);
        }
        return name_;
    }

    public static String getFileExtension(TKFile f) {
        String ext = "";
        String _name = TKFileUtilities.getFileName(f);
        int lstPoit = _name.lastIndexOf(".");
        if (lstPoit >= 0 && lstPoit < _name.length() - 1) {
            ext = _name.substring(lstPoit + 1);
        }
        return ext.toLowerCase();
    }

    /*
     * Enabled aggressive block sorting
     */
    public static TKFile getParent(TKFile tkFile) {
        String parName;
        block10: {
            parName = tkFile.getPath().trim();
            int len = parName.trim().length();
            int spIndex = parName.lastIndexOf("/");
            if (spIndex == 0 && len > 1) {
                return new TKFile("/", 1, true, "Drive");
            }
            if (spIndex == 0) {
                return null;
            }
            if (spIndex > 0 && spIndex < len - 1) {
                parName = parName.substring(0, spIndex);
            } else {
                if (spIndex > 0) {
                    if ((spIndex = (parName = parName.substring(0, spIndex)).lastIndexOf("/")) > 0 && spIndex < len - 1) {
                        parName = parName.substring(0, spIndex + 1);
                        break block10;
                    } else {
                        if (spIndex < 0) {
                            return null;
                        }
                        return new TKFile("/", 1, true, "Drive");
                    }
                }
                if (spIndex < 0) {
                    return null;
                }
                return new TKFile("/", 1, true, "Drive");
            }
        }
        if ((parName.lastIndexOf("/") != parName.indexOf("/") || parName.lastIndexOf("/") != parName.length() - 1) && parName.lastIndexOf("/") >= 0) {
            return new TKFile(parName, 1);
        }
        return new TKFile(parName, 1, true, "Drive");
    }

    public static TKFtpStruct toTKFile(File f) {
        FileSystemView fvs = FileSystemView.getFileSystemView();
        int fileType = 0;
        boolean isRoot = false;
        String desc = "file";
        if (f.isDirectory()) {
            fileType = 1;
        } else if (fvs.isFileSystem(f)) {
            fileType = 0;
        }
        if (fvs.isComputerNode(f)) {
            desc = "Computer";
            isRoot = true;
        } else if (fvs.isDrive(f)) {
            desc = "Drive";
            isRoot = true;
        } else if (fvs.isFloppyDrive(f)) {
            desc = "Floppy";
            isRoot = true;
        }
        String path = f.getAbsolutePath().replace(File.separator.toCharArray()[0], "/".toCharArray()[0]);
        TKFtpStruct tkFile = new TKFtpStruct(path, fileType, isRoot, desc);
        tkFile.isFtp = false;
        tkFile.size = f.length();
        Date date = new Date(f.lastModified());
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(date);
        tkFile.modified = TKDebug.toDateString(calendar, "-") + " " + TKDebug.toTimeString(calendar);
        tkFile.isLocal(true);
        return tkFile;
    }

    public static String getFileSize(long leng) {
        long len = leng / 1024L;
        NumberFormat nf = NumberFormat.getIntegerInstance();
        long left = leng % 1024L;
        long size = len == 0L ? (leng == 0L ? 0L : 1L) : len + (long)(left >= 1L ? 1 : 0);
        return nf.format(size) + " KB";
    }

    public static final String shieldPassword(String pwd, char shieldChar) {
        char[] cs = pwd.toCharArray();
        for (int i = 0; i < cs.length; ++i) {
            cs[i] = shieldChar;
        }
        return String.valueOf(cs);
    }

    public static void main(String[] args) {
        String ftp = "ftp://:bbbb@129.9.6.3/";
        TKFileUtilities.parseFTPPath(ftp);
    }

    public static boolean isReadOnly(File file) {
        try {
            ShellFolder she = ShellFolder.getShellFolder(file);
            return !she.canWrite();
        }
        catch (Exception ex) {
            return false;
        }
    }

    public static TKFtpStruct parseFTPPath(String path) {
        int indexOfSeparator;
        String user = "";
        String pass = "";
        String ip = "";
        String port = "";
        String dir = "";
        String tempPath = path;
        String sigAt = "@";
        String sigColon = ":";
        tempPath = TKFileUtilities.cleanXftpPath(tempPath);
        int indexOfAt = tempPath.indexOf(sigAt);
        String usrAndPw = tempPath.substring(0, indexOfAt);
        String ipPortPath = tempPath.substring(indexOfAt + 1);
        int indexOfColon = usrAndPw.indexOf(sigColon);
        if (indexOfColon >= 0) {
            if (indexOfColon > 0) {
                user = usrAndPw.substring(0, indexOfColon);
            }
            if (indexOfColon < usrAndPw.length()) {
                pass = usrAndPw.substring(indexOfColon + 1);
            }
        }
        if ((indexOfSeparator = (ipPortPath = ipPortPath.replace(File.separator.charAt(0), "/".charAt(0))).indexOf("/")) >= 0) {
            dir = ipPortPath.substring(indexOfSeparator);
            String ipAndPort = ipPortPath.substring(0, indexOfSeparator);
            indexOfColon = ipAndPort.indexOf(sigColon);
            if (indexOfColon >= 0) {
                if (indexOfColon > 0) {
                    ip = ipAndPort.substring(0, indexOfColon);
                }
                port = ipAndPort.substring(indexOfColon + 1);
            }
        }
        TKFtpStruct retVal = new TKFtpStruct(dir);
        retVal.ftpIP = ip;
        retVal.ftpPass = pass;
        try {
            retVal.ftpPort = Integer.parseInt(port);
        }
        catch (Exception ex) {
            DCDebugTracer.trace(ex);
        }
        retVal.ftpUser = user;
        retVal.isFtp = path.toLowerCase().startsWith("ftp:") || path.toLowerCase().startsWith("sftp:");
        return retVal;
    }

    private static String cleanXftpPath(String path) {
        String[] xftpHead = new String[]{"ftp://", "FTP://", "FTP:\\\\", "ftp:\\\\", "sftp://", "SFTP://", "SFTP:\\\\", "sftp:\\\\"};
        String temp = null;
        for (int i = 0; i < xftpHead.length; ++i) {
            if (!path.startsWith(xftpHead[i])) continue;
            temp = xftpHead[i];
            path = path.replaceFirst(temp, "");
            break;
        }
        return path;
    }
}

