/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.toolkit.client.base.util;

import com.huawei.dc.toolkit.client.base.util.TKFileUtilities;
import com.huawei.dc.toolkit.client.base.util.TKRes;
import com.huawei.dc.toolkit.client.base.util.text.TKCodeContent;
import java.io.File;
import java.text.Collator;
import java.util.Locale;

public class TKFile
implements Comparable {
    public static final String Separator = "/";
    public static final String FTP = "ftp:";
    public static final String SFTP = "sftp:";
    public static final String SFTP_KEY = "sftp_key:";
    public static final int TKFILE_FILE = 0;
    public static final int TKFILE_DIRECTORY = 1;
    public static final String TKFILE_DRIVE = "Drive";
    public static final String TKFILE_CDROOM = "CD-Room";
    public static final String TKFILE_FLOPPY = "Floppy";
    public static final String TKFILE_COMPUTER = "Computer";
    String _path = "";
    private String toStringPath = "";
    int _tkType = 0;
    public long size = 1L;
    public String modified = "2006-1-15";
    public String softVersion = "";
    public int softType = 0;
    public int resetType = 0;
    private String fileDescription = "file";
    private boolean m_bIsHidden = false;
    private boolean m_bIsRoot = false;
    private boolean m_bIsLocal = false;

    public TKFile(String path, int tkType, boolean isRoot, boolean isHidden, String fileDesc) {
        this(path, tkType, isRoot, fileDesc);
        this.fileDescription = fileDesc;
        this.m_bIsHidden = isHidden;
    }

    public TKFile(String path, int tkType, boolean isRoot, String fileDesc) {
        this(path, tkType, fileDesc);
        this.m_bIsRoot = isRoot;
    }

    public TKFile(String path, int tkType, String fileDesc) {
        this(path, tkType);
        this.fileDescription = fileDesc;
    }

    public TKFile(String path, int tkType) {
        this._path = path;
        this._tkType = tkType;
        this._path = this._path.replace(File.separator.toCharArray()[0], Separator.toCharArray()[0]);
        if (this.isDirectory()) {
            this.fileDescription = "Directory";
        }
        if (this.isDirectory() && !this._path.endsWith(Separator)) {
            this._path = this._path + Separator;
        }
        this.formatString();
    }

    public TKFile(String path) {
        this._path = path;
        this._path = this._path.replace(File.separator.toCharArray()[0], Separator.toCharArray()[0]);
        if (this.isDirectory() && !this._path.endsWith(Separator)) {
            this._path = this._path + Separator;
        }
        this.formatString();
    }

    public void isHidden(boolean isHidden) {
        this.m_bIsHidden = isHidden;
    }

    public void isRoot(boolean isRoot) {
        this.m_bIsRoot = isRoot;
    }

    public long size() {
        return this.size;
    }

    public String getLastModified() {
        return this.modified;
    }

    public String getPath() {
        return this._path;
    }

    public String getAbsolutePath() {
        return this._path;
    }

    public String toString() {
        return this.toStringPath;
    }

    public String getName() {
        if (this._path.indexOf(Separator) < 0) {
            return this._path;
        }
        if (this._path.equals(Separator)) {
            return TKRes.instance().getString("Home_Directory");
        }
        return TKFileUtilities.getFileName(this);
    }

    public String getExtension() {
        return TKFileUtilities.getFileExtension(this);
    }

    public boolean isFile() {
        return this._tkType == 0;
    }

    public boolean isDirectory() {
        return this._tkType == 1;
    }

    public boolean isFloppy() {
        return this.fileDescription.equals(TKFILE_FLOPPY);
    }

    public boolean isCDRoom() {
        return this.fileDescription.equals(TKFILE_CDROOM);
    }

    public boolean isDrive() {
        return this.fileDescription.equals(TKFILE_DRIVE);
    }

    public boolean isComputer() {
        return this.fileDescription.equals(TKFILE_COMPUTER);
    }

    public boolean isHidden() {
        return this.m_bIsHidden;
    }

    public boolean isRoot() {
        return this.m_bIsRoot;
    }

    public boolean isLocal() {
        return this.m_bIsLocal;
    }

    public void isLocal(boolean isLocal) {
        this.m_bIsLocal = isLocal;
    }

    public int fileType() {
        return this._tkType;
    }

    public int hashCode() {
        String hashCodeString = "HashCode" + this._path.hashCode() + this.toStringPath.hashCode() + this.modified.hashCode() + this.softVersion.hashCode() + this.fileDescription.hashCode();
        return hashCodeString.hashCode();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof TKFile)) {
            return false;
        }
        TKFile cf = (TKFile)obj;
        String objAbsolutePath = cf.getAbsolutePath();
        String thisAbsolutePath = this.getAbsolutePath();
        objAbsolutePath = objAbsolutePath.endsWith(Separator) ? objAbsolutePath : objAbsolutePath + Separator;
        thisAbsolutePath = thisAbsolutePath.endsWith(Separator) ? thisAbsolutePath : thisAbsolutePath + Separator;
        boolean isEquals = objAbsolutePath.equals(thisAbsolutePath) && cf.fileType() == this.fileType();
        return isEquals;
    }

    public int compareTo(Object o) {
        if (!(o instanceof TKFile)) {
            return 1;
        }
        TKFile f = (TKFile)o;
        int cmp = 0;
        cmp = f.fileType() == this.fileType() ? Collator.getInstance(Locale.CHINA).compare(this.getPath(), f.getPath()) : Collator.getInstance(Locale.CHINA).compare(this.fileType() + "", f.fileType() + "") * -1;
        if (!TKFileUtilities.isAscentFileCompositor()) {
            cmp *= -1;
        }
        return cmp;
    }

    public String getFileTypeDescription() {
        return this.fileDescription;
    }

    private void formatString() {
        this.toStringPath = this._path;
        if (this._path.startsWith("ftp://") || this._path.startsWith("sftp://") || this._path.startsWith("sftp_key://")) {
            this.toStringPath = TKCodeContent.formatFtpPath(this._path);
        }
    }
}

