/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.toolkit.client.base.util;

import com.huawei.dc.common.util.DCDebugTracer;
import com.huawei.dc.toolkit.client.base.util.TKResourceManager;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.TimeZone;

public class TKDebug {
    private static ArrayList debugCmdCodeList = new ArrayList();
    private static boolean bDebugEnable = false;
    public static final boolean bDemoEnable = false;
    public static final TKPrintStream out = TKDebug.getPrintStream();
    static TKPrintStream printStream = null;
    private static final String sLogPath = TKResourceManager.getPath() + File.separator + "client" + File.separator + "tklog";
    private static final String sU2000LogPath = System.getProperty("user.dir") + File.separator + "log" + File.separator + "tklog";
    private static String sLogFile = sLogPath + File.separator + "tkexception.log";
    private static String sU2000LogFile = sU2000LogPath + File.separator + "tkexception.log";
    private static PrintStream eout = null;
    private static final String sLoadFile = "tkloadinfo.ini";
    private static int loadMode = 1;
    private static BufferedOutputStream loadStream = null;
    private static BufferedOutputStream outStream = null;

    public static synchronized void trace() {
        if (!bDebugEnable) {
            return;
        }
    }

    public static synchronized void trace(String str) {
        if (!bDebugEnable) {
            return;
        }
    }

    public static synchronized void trace(int i) {
        if (!bDebugEnable) {
            return;
        }
    }

    public static synchronized void trace(Object o) {
        if (!bDebugEnable) {
            return;
        }
    }

    public static synchronized void trace(Throwable e) {
        if (!bDebugEnable) {
            return;
        }
        e.printStackTrace(System.out);
    }

    public static synchronized void inmAssert(boolean bJudge) {
        TKDebug.inmAssert(bJudge, "");
    }

    public static synchronized void inmAssert(boolean bJudge, String msg) {
        if (!bJudge) {
            System.err.println("ASSERTION FAILURED: " + msg);
            if (bDebugEnable) {
                new Exception().printStackTrace(System.err);
            }
        }
    }

    public static synchronized void trace(String view, String func, String info) {
        if (!bDebugEnable) {
            return;
        }
        Exception s = new Exception();
        ByteArrayOutputStream byteStream = new ByteArrayOutputStream();
        s.fillInStackTrace();
        ObjectOutputStream stream = null;
        try {
            stream = new ObjectOutputStream(byteStream);
        }
        catch (IOException e) {
            DCDebugTracer.trace(e);
        }
        PrintStream ps = new PrintStream(stream);
        s.printStackTrace(ps);
        ps.flush();
        String temp = byteStream.toString();
        int skipFirstStream = temp.indexOf(")") + 1;
        String stackInfo = temp.substring(skipFirstStream);
        int frameStart = stackInfo.indexOf("(");
        int frameFinish = stackInfo.indexOf(")") + 1;
        String frameName = null;
        if (frameStart > 0 && frameFinish > frameStart) {
            frameName = stackInfo.substring(frameStart, frameFinish);
        } else {
            frameName = "";
            DCDebugTracer.trace(s);
        }
        DCDebugTracer.trace(frameName + "<" + view + ">" + "<" + func + ">" + ":::" + info);
    }

    private static TKPrintStream getPrintStream() throws NullPointerException {
        if (System.currentTimeMillis() > 0L) {
            if (outStream == null) {
                outStream = new BufferedOutputStream(System.out, 128);
            }
            if (printStream == null) {
                printStream = new TKPrintStream(outStream, true);
            }
            return printStream;
        }
        throw new IllegalArgumentException();
    }

    public static synchronized void setLoadMode(boolean _bLoadMode) {
        if (loadMode == 0) {
            bDebugEnable = _bLoadMode;
        }
        try {
            if (_bLoadMode) {
                if (loadStream == null) {
                    loadStream = new BufferedOutputStream(new FileOutputStream(sLoadFile));
                }
                out.setOutputStream(loadStream);
                System.setOut(out);
            } else {
                if (loadStream != null) {
                    loadStream.close();
                    loadStream = null;
                }
                if (outStream == null) {
                    outStream = new BufferedOutputStream(new FileOutputStream(FileDescriptor.out), 128);
                }
                out.setOutputStream(outStream);
                System.setOut(out);
            }
        }
        catch (Exception e) {
            DCDebugTracer.trace(e);
        }
    }

    public static String getCurrentTime() {
        GregorianCalendar currentTime = new GregorianCalendar(TimeZone.getDefault(), Locale.getDefault());
        return TKDebug.toTimeString(currentTime);
    }

    public static void exInfoBackup() {
        if (eout == null) {
            return;
        }
        eout.close();
        File f = new File(sLogFile);
        if (f.exists() && f.length() > 0L) {
            String sfilename = sLogPath + File.separator + "ex_" + TKDebug.toCurrentDateString() + ".log";
            File f1 = new File(sfilename);
            if (!f1.renameTo(f1)) {
                DCDebugTracer.traceDetail("file rename failed.");
            }
        } else if (!f.delete()) {
            DCDebugTracer.traceDetail("file can't be deleted.");
        }
    }

    public static String toTimeString(Calendar calendar) {
        String sHour = null;
        String sMinute = null;
        String sSecond = null;
        int currentHour = -1;
        int currentMinute = -1;
        int currentSecond = -1;
        currentHour = calendar.get(11);
        sHour = Integer.toString(currentHour);
        currentMinute = calendar.get(12);
        sMinute = Integer.toString(currentMinute);
        currentSecond = calendar.get(13);
        sSecond = Integer.toString(currentSecond);
        if (sHour.length() == 1) {
            sHour = "0" + sHour;
        }
        if (sMinute.length() == 1) {
            sMinute = "0" + sMinute;
        }
        if (sSecond.length() == 1) {
            sSecond = "0" + sSecond;
        }
        return sHour + ":" + sMinute + ":" + sSecond;
    }

    public static String toTimeString(Calendar calendar, String separator) {
        String sHour = null;
        String sMinute = null;
        String sSecond = null;
        int currentHour = -1;
        int currentMinute = -1;
        int currentSecond = -1;
        currentHour = calendar.get(11);
        sHour = Integer.toString(currentHour);
        currentMinute = calendar.get(12);
        sMinute = Integer.toString(currentMinute);
        currentSecond = calendar.get(13);
        sSecond = Integer.toString(currentSecond);
        if (sHour.length() == 1) {
            sHour = "0" + sHour;
        }
        if (sMinute.length() == 1) {
            sMinute = "0" + sMinute;
        }
        if (sSecond.length() == 1) {
            sSecond = "0" + sSecond;
        }
        return sHour + separator + sMinute + separator + sSecond;
    }

    public static String toDateString(Calendar calendar, String separator) {
        String month = "00" + (calendar.get(2) + 1);
        month = month.substring(month.length() - 2);
        String day = "00" + calendar.get(5);
        day = day.substring(day.length() - 2);
        String dateStr = calendar.get(1) + separator + month + separator + day;
        return dateStr;
    }

    public static String toCurrentDateString() {
        GregorianCalendar calendar = new GregorianCalendar(TimeZone.getDefault(), Locale.getDefault());
        return TKDebug.toDateString(calendar, "");
    }

    public static String toStandardFormatString() {
        GregorianCalendar currentTime = new GregorianCalendar(TimeZone.getDefault(), Locale.getDefault());
        String toString = TKDebug.toDateString(currentTime, "-") + " " + TKDebug.toTimeString(currentTime);
        return toString;
    }

    public static void addDebugCmdCode(char cmdCode) {
        Character c = Character.valueOf(cmdCode);
        debugCmdCodeList.add(c);
    }

    public static boolean isDebugCmdCode(char cmdCode) {
        Character c = Character.valueOf(cmdCode);
        return bDebugEnable && debugCmdCodeList.contains(c);
    }

    public static void removeDebugCmdCode(char cmdCode) {
        Character c = Character.valueOf(cmdCode);
        debugCmdCodeList.remove(c);
    }

    public static void debugTrace(String traceInfo) {
        try {
            throw new Exception(traceInfo);
        }
        catch (Exception ex) {
            DCDebugTracer.trace(ex);
            return;
        }
    }

    private static class ErrPrintStream
    extends PrintStream {
        public ErrPrintStream(OutputStream out) {
            super(out);
        }

        @Override
        public void println(Object x) {
            GregorianCalendar currentTime = new GregorianCalendar(TimeZone.getDefault(), Locale.getDefault());
            if (x instanceof Throwable) {
                this.print(TKDebug.toTimeString(currentTime) + "  ");
            }
            super.println(x);
        }
    }

    public static class TKPrintStream
    extends PrintStream {
        public TKPrintStream(OutputStream out) {
            super(out);
        }

        public TKPrintStream(OutputStream out, boolean autoFlush) {
            super(out, autoFlush);
        }

        protected void setOutputStream(OutputStream _out) {
            this.out = _out;
        }

        @Override
        public void println(Object x) {
            if (bDebugEnable) {
                super.println(x);
            }
        }

        @Override
        public void println(float f) {
            if (bDebugEnable) {
                super.println(f);
            }
        }

        @Override
        public void println(char[] s) {
            if (bDebugEnable) {
                super.println(s);
            }
        }

        @Override
        public void println(String s) {
            if (bDebugEnable) {
                super.println(s);
            }
        }

        @Override
        public void println(long l) {
            if (bDebugEnable) {
                super.println(l);
            }
        }

        @Override
        public void println(boolean b) {
            if (bDebugEnable) {
                super.println(b);
            }
        }

        @Override
        public void println(char c) {
            if (bDebugEnable) {
                super.println(c);
            }
        }

        @Override
        public void println(double x) {
            if (bDebugEnable) {
                super.println(x);
            }
        }

        @Override
        public void println(int i) {
            if (bDebugEnable) {
                super.println(i);
            }
        }

        @Override
        public void println() {
            if (bDebugEnable) {
                super.println();
            }
        }

        @Override
        public void print(Object x) {
            if (bDebugEnable) {
                super.print(x);
            }
        }

        @Override
        public void print(double d) {
            if (bDebugEnable) {
                super.print(d);
            }
        }

        @Override
        public void print(float f) {
            if (bDebugEnable) {
                super.print(f);
            }
        }

        @Override
        public void print(char[] s) {
            if (bDebugEnable) {
                super.print(s);
            }
        }

        @Override
        public void print(String s) {
            if (bDebugEnable) {
                super.print(s);
            }
        }

        @Override
        public void print(long l) {
            if (bDebugEnable) {
                super.print(l);
            }
        }

        @Override
        public void print(boolean b) {
            if (bDebugEnable) {
                super.print(b);
            }
        }

        @Override
        public void print(char c) {
            if (bDebugEnable) {
                super.print(c);
            }
        }

        @Override
        public void print(int i) {
            if (bDebugEnable) {
                super.print(i);
            }
        }

        @Override
        public void write(byte[] buf, int off, int len) {
            if (bDebugEnable) {
                super.write(buf, off, len);
            }
        }

        @Override
        public void write(int b) {
            if (bDebugEnable) {
                super.write(b);
            }
        }

        @Override
        public void write(byte[] buf) {
            if (bDebugEnable) {
                try {
                    super.write(buf);
                }
                catch (IOException e) {
                    DCDebugTracer.trace(e);
                }
            }
        }
    }
}

