/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.toolkit.client.base.util;

import com.huawei.dc.common.controller.DeviceInfoManagerImpl;
import com.huawei.dc.configuration.system.SystemSettingDlg;
import com.huawei.dc.toolkit.client.base.util.TKFileUtilities;
import java.awt.Component;
import java.awt.Frame;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.TimeZone;

public class TKCommonUtil {
    public static final int SYSTEM_START_YEAR = 1990;
    public static final int SYSTEM_END_YEAR = 2037;
    public static final byte HAS_YF = 0;
    public static final byte HAS_YMF = 1;
    public static final byte HAS_YMDF = 2;
    public static final byte HAS_YMDTF = 3;
    public static final byte HAS_TF = 4;
    public static final String patternChars = "GyMdkHmsSEDFwWahKzZ";
    private static String configPattern;
    public static final String DATEFORMAT;
    public static final String dateFormat;
    public static final int yearStartIndex;
    public static final int yearEndIndex;
    public static final int monthStartIndex;
    public static final int monthEndIndex;
    public static final int dayStartIndex;
    public static final int dayEndIndex;
    public static final int hourStartIndex;
    public static final int hourEndIndex;
    public static final int minuteStartIndex;
    public static final int minuteEndIndex;
    public static final int secondStartIndex;
    public static final int secondEndIndex;
    public static final int millisecondStartIndex;
    public static final int millisecondEndIndex;
    private static final int startDateIndex;
    private static final int endDateIndex;
    private static final int startTimeIndex;
    private static final int endTimeIndex;
    private static String strSysRootPath;
    private static int ixftpPort;

    public static final boolean validateDate(int year, int month, int date) {
        if (year < 0 || month < 0 || date < 0 || month > 12 || date > 31) {
            return false;
        }
        GregorianCalendar calendar = new GregorianCalendar(year, month - 1, date);
        return calendar.get(1) == year && calendar.get(2) == month - 1 && calendar.get(5) == date;
    }

    public static final boolean validateDate(String yearStr, String monthStr, String dateStr, int startyear, int endyear) {
        int year = -1;
        int month = -1;
        int date = -1;
        try {
            year = Integer.parseInt(yearStr.trim());
            month = Integer.parseInt(monthStr.trim());
            date = Integer.parseInt(dateStr.trim());
        }
        catch (Exception e) {
            return false;
        }
        if (year < startyear || year > endyear) {
            return false;
        }
        return TKCommonUtil.validateDate(year, month, date);
    }

    public static final boolean validateDate(String yearStr, String monthStr, String dateStr) {
        int year = -1;
        int month = -1;
        int date = -1;
        try {
            year = Integer.parseInt(yearStr.trim());
            month = Integer.parseInt(monthStr.trim());
            date = Integer.parseInt(dateStr.trim());
        }
        catch (Exception e) {
            return false;
        }
        return TKCommonUtil.validateDate(year, month, date);
    }

    public static final boolean validateTime(int hour, int min, int sec) {
        if (TKCommonUtil.isAM_PM()) {
            return hour >= 1 && min >= 0 && sec >= 0 && hour <= 11 && min <= 59 && sec <= 59;
        }
        return hour >= 0 && min >= 0 && sec >= 0 && hour <= 23 && min <= 59 && sec <= 59;
    }

    public static final String toTimeString(Calendar calendar) {
        return TKCommonUtil.toTimeString(calendar, false);
    }

    public static final String toTimeString(Calendar calendar, boolean bCont) {
        StringBuffer buf = new StringBuffer();
        String formatStr = "";
        if (bCont) {
            for (int i = startTimeIndex; i <= endTimeIndex; ++i) {
                char c = DATEFORMAT.charAt(i);
                if ('H' != c && 'h' != c && 'm' != c && 's' != c && 'S' != c) continue;
                buf.append(c);
            }
        } else {
            buf.append(DATEFORMAT.substring(startTimeIndex, endTimeIndex + 1));
        }
        formatStr = buf.toString();
        String pattern = TKCommonUtil.filterConstantString(DATEFORMAT);
        int indexOfa = pattern.indexOf("a");
        if (indexOfa != -1) {
            if (indexOfa < startTimeIndex) {
                formatStr = DATEFORMAT.substring(indexOfa, startTimeIndex) + formatStr;
            } else if (indexOfa > endTimeIndex) {
                formatStr = formatStr + DATEFORMAT.substring(endTimeIndex + 1, indexOfa + 1);
            }
        }
        return TKCommonUtil.getFormatDate(calendar, formatStr);
    }

    public static final String getFormatDate(Calendar calendar, String pattern) {
        if (calendar == null) {
            return null;
        }
        SimpleDateFormat df = new SimpleDateFormat(pattern);
        Date date = calendar.getTime();
        return df.format(date);
    }

    public static final String toYearString(Calendar calendar) {
        String pattern = "";
        if (yearStartIndex != -1) {
            pattern = DATEFORMAT.substring(yearStartIndex, yearEndIndex + 1);
        }
        return TKCommonUtil.getFormatDate(calendar, pattern);
    }

    public static final String toMonthString(Calendar calendar) {
        String pattern = "";
        if (monthStartIndex != -1) {
            pattern = DATEFORMAT.substring(monthStartIndex, monthEndIndex + 1);
        }
        return TKCommonUtil.getFormatDate(calendar, pattern);
    }

    public static final String toDateString(Calendar calendar) {
        String pattern = "";
        if (dayStartIndex != -1) {
            pattern = DATEFORMAT.substring(dayStartIndex, dayEndIndex + 1);
        }
        return TKCommonUtil.getFormatDate(calendar, pattern);
    }

    public static byte[] calendarToBytes(Calendar calendar) {
        int year = calendar.get(1) - 1990;
        int mon = calendar.get(2) + 1;
        int day = calendar.get(5);
        int hour = calendar.get(11);
        int minute = calendar.get(12);
        int second = calendar.get(13);
        byte[] tempByte = new byte[]{(byte)year, (byte)mon, (byte)day, (byte)hour, (byte)minute, (byte)second};
        return tempByte;
    }

    public static boolean isBetweenSingleQuote(String pattern, char c, int index) {
        String afterStr;
        int indexOfSingleQuote;
        boolean flag = false;
        int singleQuoteNum = 0;
        for (int i = 0; i < index; ++i) {
            if ('\'' != pattern.charAt(i)) continue;
            ++singleQuoteNum;
        }
        if (singleQuoteNum % 2 == 0) {
            flag = false;
        } else if (singleQuoteNum % 2 != 0 && (indexOfSingleQuote = (afterStr = pattern.substring(index + 1)).indexOf(39)) >= 0) {
            flag = true;
        }
        return flag;
    }

    public static int numOfSingleQuote(String pattern) {
        int num = 0;
        for (int i = 0; i < pattern.length(); ++i) {
            if (pattern.charAt(i) != '\'') continue;
            ++num;
        }
        return num;
    }

    private static boolean isValidPattern(String pattern) {
        boolean flag = true;
        for (int i = 0; i < pattern.length(); ++i) {
            char c = pattern.charAt(i);
            if ((c < 'a' || c > 'z') && (c < 'A' || c > 'Z') || patternChars.indexOf(c) != -1) continue;
            flag = false;
            break;
        }
        return flag;
    }

    public static String filterConstantString(String pattern) {
        StringBuffer initString = new StringBuffer();
        for (int i = 0; i < pattern.length(); ++i) {
            char c = pattern.charAt(i);
            if (c != '\'') {
                if (TKCommonUtil.isBetweenSingleQuote(pattern, c, i)) {
                    initString.append(" ");
                    continue;
                }
                initString.append(c);
                continue;
            }
            initString.append(c);
        }
        return initString.toString();
    }

    public static boolean isAM_PM() {
        boolean flag = false;
        int indexOfa = TKCommonUtil.filterConstantString(DATEFORMAT).indexOf("a");
        if (indexOfa != -1) {
            flag = true;
        }
        return flag;
    }

    private static int getNumOfLetterInPattern(String pattern, char c) {
        int num = 0;
        int len = pattern.length();
        for (int i = 0; i < len; ++i) {
            char ch = pattern.charAt(i);
            if (c != ch) continue;
            ++num;
        }
        return num;
    }

    public static boolean checkPattern(String pattern) {
        boolean flag = true;
        int num = TKCommonUtil.numOfSingleQuote(pattern);
        int len = pattern.length();
        if (num == 0) {
            flag = TKCommonUtil.isValidPattern(pattern);
        } else if (num % 2 != 0) {
            flag = false;
        } else {
            for (int i = 0; i < len; ++i) {
                String[] childPattern = pattern.split("'");
                for (int j = 0; j < childPattern.length && (flag = TKCommonUtil.isValidPattern(childPattern[j])); j += 2) {
                }
                if (!flag) break;
            }
        }
        pattern = TKCommonUtil.filterConstantString(pattern);
        if (flag) {
            boolean isExista;
            int indexOfH = pattern.indexOf("H");
            int indexOfh = pattern.indexOf("h");
            int indexOfa = pattern.indexOf("a");
            boolean isExistH = indexOfH != -1 && !TKCommonUtil.isBetweenSingleQuote(pattern, 'H', indexOfH);
            boolean isExisth = indexOfh != -1 && !TKCommonUtil.isBetweenSingleQuote(pattern, 'h', indexOfh);
            boolean bl = isExista = indexOfa != -1 && !TKCommonUtil.isBetweenSingleQuote(pattern, 'a', indexOfa);
            if (isExistH) {
                if (isExisth || isExista) {
                    flag = false;
                }
            } else if (isExisth) {
                if (!isExista) {
                    flag = false;
                }
            } else {
                flag = false;
            }
        }
        if (flag) {
            int yearIndex = pattern.indexOf("y");
            int monthIndex = pattern.indexOf("M");
            int dayIndex = pattern.indexOf("d");
            int minuteIndex = pattern.indexOf("m");
            if (yearIndex == -1 || monthIndex == -1 || dayIndex == -1 || minuteIndex == -1) {
                flag = false;
            }
        }
        if (flag) {
            int numOfYearLetter = TKCommonUtil.getNumOfLetterInPattern(pattern, 'y');
            int numOfMonthLetter = TKCommonUtil.getNumOfLetterInPattern(pattern, 'M');
            int numOfDayLetter = TKCommonUtil.getNumOfLetterInPattern(pattern, 'd');
            int HourIndex = pattern.indexOf(72);
            int numOfHourLetter = TKCommonUtil.getNumOfLetterInPattern(pattern, 'H');
            int hourIndex = pattern.indexOf(104);
            int numOfhourLetter = TKCommonUtil.getNumOfLetterInPattern(pattern, 'h');
            int numOfMinuteLetter = TKCommonUtil.getNumOfLetterInPattern(pattern, 'm');
            int secondIndex = pattern.indexOf(115);
            int numOfSecondLetter = TKCommonUtil.getNumOfLetterInPattern(pattern, 's');
            if (numOfYearLetter != 2 && numOfYearLetter != 4 || numOfMonthLetter != 2 || numOfDayLetter != 2 || HourIndex != -1 && numOfHourLetter != 2 || hourIndex != -1 && numOfhourLetter != 2 || numOfMinuteLetter != 2 || secondIndex != -1 && numOfSecondLetter != 2) {
                flag = false;
            }
        }
        return flag;
    }

    public static String convertCalendarToStr(Calendar calendar, byte hf) {
        if (calendar == null) {
            return null;
        }
        String pattern = TKCommonUtil.getDateFormat(DATEFORMAT, hf);
        return TKCommonUtil.getFormatDate(calendar, pattern);
    }

    public static String getDateFormat(String pattern, byte hf) {
        String yearPattern = pattern.substring(yearStartIndex, yearEndIndex + 1);
        if (hf == 0) {
            return yearPattern;
        }
        if (hf == 1) {
            String splitOfYM = "";
            String monthPattern = pattern.substring(monthStartIndex, monthEndIndex + 1);
            StringBuffer buf = new StringBuffer();
            if (monthStartIndex > yearEndIndex) {
                splitOfYM = yearStartIndex > dayEndIndex ? DATEFORMAT.substring(yearEndIndex + 1, monthStartIndex) : (dayStartIndex > monthEndIndex ? DATEFORMAT.substring(yearEndIndex + 1, monthStartIndex) : DATEFORMAT.substring(dayEndIndex + 1, monthStartIndex));
                buf.append(yearPattern).append(splitOfYM).append(monthPattern);
            } else {
                splitOfYM = dayEndIndex < monthStartIndex ? DATEFORMAT.substring(monthEndIndex + 1, yearStartIndex) : (dayEndIndex < yearStartIndex ? DATEFORMAT.substring(dayEndIndex + 1, yearStartIndex) : DATEFORMAT.substring(monthEndIndex + 1, yearStartIndex));
                buf.append(monthPattern).append(splitOfYM).append(yearPattern);
            }
            return buf.toString();
        }
        if (hf == 2) {
            if (yearStartIndex > monthEndIndex) {
                if (monthStartIndex > dayEndIndex) {
                    return DATEFORMAT.substring(dayStartIndex, yearEndIndex + 1);
                }
                if (dayStartIndex > yearEndIndex) {
                    return DATEFORMAT.substring(monthStartIndex, dayEndIndex + 1);
                }
                return DATEFORMAT.substring(monthStartIndex, yearEndIndex + 1);
            }
            if (monthEndIndex < dayStartIndex) {
                return DATEFORMAT.substring(yearStartIndex, dayEndIndex + 1);
            }
            if (dayEndIndex < yearStartIndex) {
                return DATEFORMAT.substring(dayStartIndex, monthEndIndex + 1);
            }
            return DATEFORMAT.substring(yearStartIndex, monthEndIndex + 1);
        }
        if (hf == 4) {
            String timeFormat = pattern.substring(startTimeIndex, endTimeIndex + 1);
            int indexOfa = TKCommonUtil.filterConstantString(DATEFORMAT).indexOf("a");
            if (indexOfa != -1) {
                if (indexOfa < startTimeIndex) {
                    timeFormat = DATEFORMAT.substring(indexOfa, startTimeIndex) + timeFormat;
                } else if (indexOfa > endTimeIndex) {
                    timeFormat = timeFormat + DATEFORMAT.substring(endTimeIndex + 1, indexOfa + 1);
                }
            }
            return timeFormat;
        }
        if (hf == 3) {
            return DATEFORMAT;
        }
        return DATEFORMAT;
    }

    public static String getNoSepNoQuoteDateFormat(String pattern) {
        StringBuffer buf = new StringBuffer();
        GregorianCalendar calendar = new GregorianCalendar(TimeZone.getDefault(), Locale.getDefault());
        for (int i = 0; i < pattern.length(); ++i) {
            char c = pattern.charAt(i);
            if (!TKCommonUtil.isBetweenSingleQuote(pattern, c, i) && patternChars.indexOf(c) != -1) {
                if (c == 'a' || c == 'G' || c == 'z' || c == 'Z') {
                    int len = TKCommonUtil.getFormatDate(calendar, String.valueOf(c)).length();
                    for (int j = 0; j < len; ++j) {
                        buf.append(" ");
                    }
                    continue;
                }
                buf.append(c);
                continue;
            }
            if (c == '\'') {
                if (i + 1 >= pattern.length() || '\'' != pattern.charAt(i + 1)) continue;
                buf.append(" ");
                continue;
            }
            buf.append(" ");
        }
        return buf.toString();
    }

    public static String getNoSepNoQuoteDateFormat(String pattern, byte hf) {
        pattern = TKCommonUtil.getDateFormat(pattern, hf);
        return TKCommonUtil.getNoSepNoQuoteDateFormat(pattern);
    }

    private static String getNoSepDateFormat(String pattern) {
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < pattern.length(); ++i) {
            char c = pattern.charAt(i);
            if (!TKCommonUtil.isBetweenSingleQuote(pattern, c, i) && patternChars.indexOf(c) != -1) {
                buf.append(c);
                continue;
            }
            if (c == '\'') {
                buf.append(c);
                continue;
            }
            buf.append(" ");
        }
        return buf.toString();
    }

    public static String getDataTimeString() {
        GregorianCalendar currentTime = new GregorianCalendar(TimeZone.getDefault(), Locale.getDefault());
        StringBuffer buf = new StringBuffer(TKCommonUtil.toYearString(currentTime));
        buf.append(TKCommonUtil.toMonthString(currentTime));
        buf.append(TKCommonUtil.toDateString(currentTime));
        buf.append(TKCommonUtil.toTimeString(currentTime, true));
        return buf.toString();
    }

    public static String getcurrentDate() {
        GregorianCalendar calendar = new GregorianCalendar(TimeZone.getDefault(), Locale.getDefault());
        if (calendar == null) {
            return "fail to get current date";
        }
        return TKCommonUtil.convertCalendarToStr(calendar, (byte)2);
    }

    public static String getcurrentTime() {
        GregorianCalendar calendar = new GregorianCalendar(TimeZone.getDefault(), Locale.getDefault());
        String formatStr = DATEFORMAT.substring(startTimeIndex, endTimeIndex + 1) + ".SSS";
        String pattern = TKCommonUtil.filterConstantString(DATEFORMAT);
        int indexOfa = pattern.indexOf("a");
        if (indexOfa != -1) {
            if (indexOfa < startTimeIndex) {
                formatStr = DATEFORMAT.substring(indexOfa, startTimeIndex) + formatStr;
            } else if (indexOfa > endTimeIndex) {
                formatStr = formatStr + DATEFORMAT.substring(endTimeIndex + 1, indexOfa + 1);
            }
        }
        return TKCommonUtil.getFormatDate(calendar, formatStr);
    }

    public static final String getCurrentTimeStr() {
        GregorianCalendar calendar = new GregorianCalendar(TimeZone.getDefault(), Locale.getDefault());
        String pattern = "";
        pattern = endDateIndex < startTimeIndex ? DATEFORMAT.substring(0, endTimeIndex + 1) + ".SSS" : DATEFORMAT.substring(0, endTimeIndex + 1) + ".SSS" + DATEFORMAT.substring(endTimeIndex + 1);
        return TKCommonUtil.getFormatDate(calendar, pattern);
    }

    public static String getcurrentDateTime() {
        GregorianCalendar calendar = new GregorianCalendar(TimeZone.getDefault(), Locale.getDefault());
        return TKCommonUtil.convertCalendarToStr(calendar, (byte)3);
    }

    public static long convertIPStrToLong(String ipStr) {
        if (null == ipStr) {
            return 0L;
        }
        char[] ch = ipStr.toCharArray();
        long result = 0L;
        long sum = 0L;
        int TCount = 0;
        boolean frontIsPoint = true;
        int[] T = new int[]{0x1000000, 65536, 256};
        int[] nMax = new int[]{223, 255, 255, 255};
        for (int i = 0; i < ipStr.length(); ++i) {
            if (ch[i] >= '0' && ch[i] <= '9') {
                if ((sum = sum * 10L + (long)(ch[i] - 48)) > (long)nMax[3]) {
                    return 0L;
                }
                frontIsPoint = false;
                continue;
            }
            if (ch[i] == '.') {
                if (frontIsPoint) {
                    return 0L;
                }
                frontIsPoint = true;
                if (TCount >= 3) {
                    return 0L;
                }
                if (sum > (long)nMax[TCount]) {
                    return 0L;
                }
                result += sum * (long)T[TCount++];
                sum = 0L;
                continue;
            }
            if (ch[i] == ' ') continue;
            return 0L;
        }
        if (frontIsPoint) {
            return 0L;
        }
        if (TCount != 3) {
            return 0L;
        }
        if (sum > (long)nMax[TCount]) {
            return 0L;
        }
        return result + sum;
    }

    public static String ipToString(long ip) {
        long ip1 = ip >> 24 & 0xFFL;
        long ip2 = ip >> 16 & 0xFFL;
        long ip3 = ip >> 8 & 0xFFL;
        long ip4 = ip & 0xFFL;
        return "" + ip1 + "." + ip2 + "." + ip3 + "." + ip4;
    }

    public static int[] ipToArray(long ip) {
        int[] array = new int[]{(int)(ip >> 24 & 0xFFL), (int)(ip >> 16 & 0xFFL), (int)(ip >> 8 & 0xFFL), (int)(ip & 0xFFL)};
        return array;
    }

    public static Frame getWindowForComponent(Component parentComponent) {
        if (parentComponent == null) {
            return null;
        }
        if (parentComponent instanceof Frame) {
            return (Frame)parentComponent;
        }
        return TKCommonUtil.getWindowForComponent(parentComponent.getParent());
    }

    public static String getBoardName(int iBoardID) {
        return DeviceInfoManagerImpl.getInstance().getBoardNameForT2000(iBoardID);
    }

    public static void setRootPath(String strRootPath) {
        strSysRootPath = strRootPath;
    }

    public static String getRootPath() {
        if (null == strSysRootPath) {
            SystemSettingDlg systemSettingDlg = new SystemSettingDlg();
        }
        return strSysRootPath;
    }

    public static void setxFtpPort(int iftpPort) {
        ixftpPort = iftpPort;
    }

    public static int getxFtpPort() {
        return ixftpPort;
    }

    public static String getxFtpType(boolean bContainColon) {
        if (22 == ixftpPort) {
            return "sftp:";
        }
        return "ftp:";
    }

    public static String getxFtpType(int port) {
        if (22 == port) {
            return "sftp:";
        }
        return "ftp:";
    }

    static {
        DATEFORMAT = configPattern == null || configPattern.equals("") || !TKCommonUtil.checkPattern(configPattern) ? "yyyy-MM-dd HH:mm:ss" : configPattern;
        dateFormat = TKCommonUtil.getNoSepDateFormat(DATEFORMAT);
        yearStartIndex = dateFormat.indexOf("y");
        yearEndIndex = dateFormat.lastIndexOf("y");
        monthStartIndex = dateFormat.indexOf("M");
        monthEndIndex = dateFormat.lastIndexOf("M");
        dayStartIndex = dateFormat.indexOf("d") != -1 ? dateFormat.indexOf("d") : dateFormat.indexOf("D");
        dayEndIndex = dateFormat.lastIndexOf("d") != -1 ? dateFormat.lastIndexOf("d") : dateFormat.lastIndexOf("D");
        hourStartIndex = dateFormat.indexOf("H") != -1 ? dateFormat.indexOf("H") : dateFormat.indexOf("h");
        hourEndIndex = dateFormat.lastIndexOf("H") != -1 ? dateFormat.lastIndexOf("H") : dateFormat.lastIndexOf("h");
        minuteStartIndex = dateFormat.indexOf("m");
        minuteEndIndex = dateFormat.lastIndexOf("m");
        secondStartIndex = dateFormat.indexOf("s");
        secondEndIndex = dateFormat.lastIndexOf("s");
        millisecondStartIndex = dateFormat.indexOf("S");
        millisecondEndIndex = dateFormat.lastIndexOf("S");
        int n = monthStartIndex == -1 ? yearStartIndex : (startDateIndex = Math.min(yearStartIndex, dayStartIndex == -1 ? monthStartIndex : Math.min(monthStartIndex, dayStartIndex)));
        endDateIndex = monthEndIndex == -1 ? yearEndIndex : Math.max(yearEndIndex, dayEndIndex == -1 ? monthEndIndex : Math.max(monthEndIndex, dayEndIndex));
        startTimeIndex = Math.min(hourStartIndex, secondStartIndex == -1 ? minuteStartIndex : Math.min(minuteStartIndex, secondStartIndex));
        endTimeIndex = Math.max(hourEndIndex, secondEndIndex == -1 ? minuteEndIndex : Math.max(minuteEndIndex, secondEndIndex));
        strSysRootPath = null;
        ixftpPort = TKFileUtilities.ftpPort;
    }
}

