/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.toolkit.client.base.communicate;

import JACE.ASX.MessageBlock;
import JACE.ASX.Task;
import JACE.ASX.TimeValue;
import JACE.Concurrency.Mutex;
import JACE.Reactor.EventHandler;
import JACE.Reactor.TimerQueue;
import com.huawei.dc.common.util.DCDebugTracer;
import com.huawei.dc.toolkit.client.base.communicate.TKCmdMSG;
import com.huawei.dc.toolkit.client.base.communicate.TKCmdMSGHeader;
import com.huawei.dc.toolkit.client.base.communicate.TKCommUtility;
import com.huawei.dc.toolkit.client.base.communicate.TKCommand;
import com.huawei.dc.toolkit.client.base.communicate.TKConnector;
import com.huawei.dc.toolkit.client.base.communicate.TKListener;
import com.huawei.dc.toolkit.client.base.communicate.TKListenerVector;
import com.huawei.dc.toolkit.client.base.communicate.TKMutexSet;
import com.huawei.dc.toolkit.client.base.communicate.TKNoticeReceiver;
import com.huawei.dc.toolkit.client.base.communicate.TKResponseReceiver;
import com.huawei.dc.toolkit.client.base.communicate.TKTask;
import com.huawei.dc.toolkit.client.base.util.TKDebug;
import com.huawei.dc.toolkit.client.base.util.TKLogManager;
import com.huawei.dc.toolkit.client.base.util.TKRes;
import com.huawei.dc.toolkit.client.base.util.TKResourceManager;
import com.huawei.dc.toolkit.client.base.util.operresult.TKOperResultStruct;
import com.huawei.dc.toolkit.client.base.util.operresult.TKOperResultVector;
import com.huawei.dc.toolkit.client.base.util.operresult.TKOperationShowMgr;
import com.huawei.dc.toolkit.client.base.util.resource.TKErrorCodeRes;
import com.huawei.te.toolkit.AsnTkMessageRpt;
import com.huawei.te.toolkit.AsnToolkitError;
import java.awt.Component;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import net.commustru.fstru.FStruct;

public class TKTaskManager
extends Task {
    private byte registerState = 0;
    private byte connectID;
    private Mutex currentSeqIDMutex;
    private char currentSequenceID = '\u0000';
    private TKConnector connector;
    private Mutex commandTableMutex;
    private Hashtable commandTable;
    private Mutex listenerTableMutex;
    private Hashtable listenerTable;
    private TimerQueue timerQueue;
    private int shakeHandTimerID;
    private int threadNumber = 1;
    private Mutex mutexSetPoolMutex;
    private Vector mutexSetPool;
    private String name = "default";
    private int thread_id = 0;
    private Object thread_idMutex;
    private TKErrorCodeRes errorRes = TKErrorCodeRes.instance();
    private TKRes res = TKRes.instance();

    public TKTaskManager(String name, int threadNum) {
        this.name = name;
        this.commandTable = new Hashtable();
        this.listenerTable = new Hashtable();
        this.timerQueue = new TimerQueue(true);
        this.mutexSetPool = new Vector();
        this.currentSeqIDMutex = new Mutex();
        this.commandTableMutex = new Mutex();
        this.listenerTableMutex = new Mutex();
        this.mutexSetPoolMutex = new Mutex();
        this.thread_idMutex = new Object();
        for (int i = 0; i < this.threadNumber + 1; ++i) {
            this.insertMutexSet(new TKMutexSet());
        }
    }

    public void reset() {
        try {
            while (!this.msgQueue().isEmpty()) {
                this.msgQueue().dequeueHead();
            }
        }
        catch (InterruptedException e) {
            DCDebugTracer.trace(e);
        }
        this.removeCommands();
        this.removeListeners();
        TKListener listener = new TKListener();
        class ConnectListener
        implements TKNoticeReceiver {
            ConnectListener() {
            }

            @Override
            public synchronized byte handleNotice(char cmdCode, TKCmdMSG data) {
                switch (cmdCode) {
                    case '\u0001': {
                        TKTaskManager.this.setRegisterState((byte)0);
                        TKTaskManager.this.removeShakeHandTimer();
                        TKLogManager.writeToDebug("TKCommConstant is INMCOMM_UNCONNECT_NOTIFY removeShakeHandTimer");
                        break;
                    }
                    case '\u0002': {
                        try {
                            new Thread(){

                                @Override
                                public void run() {
                                    TKLogManager.writeToDebug("Begin to register!");
                                    TKTaskManager.this.registerProcess();
                                }
                            }.start();
                        }
                        catch (Exception ex) {
                            DCDebugTracer.trace(ex);
                        }
                        break;
                    }
                    case '\u0005': {
                        TKTaskManager.this.addShakeHandTimer();
                        TKLogManager.writeToDebug("register is successed addShakeHandTimer");
                        TKTaskManager.this.connector.addConnectTimer();
                        TKTaskManager.this.connector.addReConnectTimer();
                        break;
                    }
                }
                return 0;
            }
        }
        listener.noticeReceiver = new ConnectListener();
        this.insertListener('\u0001', listener, (byte)1);
        this.insertListener('\u0002', listener, (byte)1);
        this.insertListener('\u0005', listener, (byte)1);
        this.open(null);
    }

    public int put(MessageBlock mb, TimeValue tv) {
        try {
            TKDebug.trace("TKTaskManager put: mb =" + mb.obj() + ",tv =" + tv);
            this.putq(mb, null);
        }
        catch (InterruptedException e) {
            DCDebugTracer.trace(e);
            return 0;
        }
        return 1;
    }

    public int putHead(MessageBlock mb, TimeValue tv) {
        try {
            TKDebug.trace("TKTaskManager putHead: mb =" + mb.obj() + ",tv =" + tv);
            this.msgQueue().enqueueHead(mb, tv);
        }
        catch (InterruptedException e) {
            DCDebugTracer.trace(e);
            return 0;
        }
        return 1;
    }

    public int open(Object obj) {
        this.activate(256L, this.threadNumber, false);
        return 0;
    }

    public int close(long flags) {
        if (this.thrCount() == 0) {
            return 0;
        }
        this.removeShakeHandTimer();
        TKLogManager.writeToDebug("close threadremoveShakeHandTimer");
        try {
            TKCmdMSG mg = new TKCmdMSG();
            mg.msgHead.msgType = (char)5;
            MessageBlock mb = new MessageBlock((Object)mg);
            TKLogManager.writeToDebug("Tskm clsd : " + mg.toString());
            this.msgQueue().enqueueHead(mb, null);
        }
        catch (InterruptedException e) {
            DCDebugTracer.trace(e);
        }
        return 0;
    }

    public void setConnector(TKConnector connector) {
        this.connector = connector;
    }

    public TKConnector getConnector() {
        return this.connector;
    }

    public synchronized byte getRegisterState() {
        return this.registerState;
    }

    public synchronized byte getConnectID() {
        return this.connectID;
    }

    public synchronized void setRegisterState(byte state) {
        this.registerState = state;
    }

    public TimerQueue getTimerQueue() {
        return this.timerQueue;
    }

    public char insertCommand(TKCommand command) {
        char seqID = this.getNextSequenceID();
        Character sequenceIDKey = Character.valueOf(seqID);
        try {
            this.commandTableMutex.acquire();
            this.commandTable.put(sequenceIDKey, command);
            this.commandTableMutex.release();
        }
        catch (Exception e) {
            DCDebugTracer.trace(e);
            return '\u0000';
        }
        command.message.msgHead.sequence = seqID;
        return seqID;
    }

    public Vector removeCommand(TKCommand command) {
        Vector<TKCommand> timerIDVector = new Vector<TKCommand>();
        try {
            this.commandTableMutex.acquire();
            Enumeration e = this.commandTable.keys();
            while (e.hasMoreElements()) {
                Object keyObj = e.nextElement();
                Object valObj = this.commandTable.get(keyObj);
                if (valObj != command) continue;
                this.commandTable.remove(keyObj);
                timerIDVector.add(command);
                break;
            }
            this.commandTableMutex.release();
        }
        catch (InterruptedException e) {
            DCDebugTracer.trace(e);
        }
        return timerIDVector;
    }

    public void removeCommand(char sequenceID) {
        try {
            this.commandTableMutex.acquire();
            Character keyObj = Character.valueOf(sequenceID);
            this.commandTable.get(keyObj);
            this.commandTable.remove(keyObj);
            this.commandTableMutex.release();
        }
        catch (InterruptedException e) {
            DCDebugTracer.trace(e);
        }
    }

    public void removeCommand(TKResponseReceiver responseReceiver) {
        Vector timerIDVector = new Vector();
        try {
            this.commandTableMutex.acquire();
            Enumeration e = this.commandTable.keys();
            while (e.hasMoreElements()) {
                Object keyObj = e.nextElement();
                Object valObj = this.commandTable.get(keyObj);
                if (((TKCommand)valObj).responseReceiver != responseReceiver) continue;
                this.commandTable.remove(keyObj);
                timerIDVector.add(valObj);
            }
            this.commandTableMutex.release();
            for (int i = 0; i < timerIDVector.size(); ++i) {
                this.removeTimer(((TKCommand)timerIDVector.get((int)i)).timerID);
            }
            timerIDVector.clear();
        }
        catch (InterruptedException e) {
            DCDebugTracer.trace(e);
        }
    }

    public void removeCommands() {
        Vector timerIDVector = new Vector();
        try {
            this.commandTableMutex.acquire();
            Enumeration e = this.commandTable.elements();
            while (e.hasMoreElements()) {
                timerIDVector.add(e.nextElement());
            }
            this.commandTable.clear();
            this.commandTableMutex.release();
            for (int i = 0; i < timerIDVector.size(); ++i) {
                this.removeTimer(((TKCommand)timerIDVector.get((int)i)).timerID);
            }
            timerIDVector.clear();
        }
        catch (InterruptedException e) {
            DCDebugTracer.trace(e);
        }
    }

    public void insertListener(char cmdCode, TKListener listener, byte level) {
        try {
            this.listenerTableMutex.acquire();
            Character cmdCodeKey = Character.valueOf(cmdCode);
            if (this.listenerTable.containsKey(cmdCodeKey)) {
                Object obj = this.listenerTable.get(cmdCodeKey);
                if (obj instanceof TKListenerVector) {
                    TKListenerVector listenerVector = (TKListenerVector)obj;
                    listenerVector.addElement(listener, level);
                }
            } else {
                TKListenerVector listenerVector = new TKListenerVector();
                listenerVector.addElement(listener, level);
                this.listenerTable.put(cmdCodeKey, listenerVector);
            }
        }
        catch (Exception e) {
            DCDebugTracer.trace(e);
            return;
        }
        this.listenerTableMutex.release();
    }

    public void removeListener(char cmdCode, TKListener listener) {
        try {
            this.listenerTableMutex.acquire();
            Character keyObj = Character.valueOf(cmdCode);
            Object valObj = this.listenerTable.get(keyObj);
            if (valObj == null) {
                this.listenerTableMutex.release();
                return;
            }
            TKListenerVector listenerVector = (TKListenerVector)valObj;
            listenerVector.removeElement(listener);
            if (listenerVector.isEmpty()) {
                this.listenerTable.remove(keyObj);
            }
        }
        catch (InterruptedException e) {
            DCDebugTracer.trace(e);
        }
        this.listenerTableMutex.release();
    }

    public void removeListener(TKListener listener) {
        try {
            this.listenerTableMutex.acquire();
            Enumeration keyEnum = this.listenerTable.keys();
            while (keyEnum.hasMoreElements()) {
                Object keyObj = keyEnum.nextElement();
                Object listenerObj = this.listenerTable.get(keyObj);
                TKListenerVector listenerVector = (TKListenerVector)listenerObj;
                Enumeration valEnum = listenerVector.elements();
                while (valEnum.hasMoreElements()) {
                    Object obj = valEnum.nextElement();
                    if (obj == null) continue;
                    if (obj == listener) {
                        listenerVector.removeElement(listener);
                    }
                    if (!listenerVector.isEmpty()) continue;
                    this.listenerTable.remove(keyObj);
                }
            }
            this.listenerTableMutex.release();
        }
        catch (InterruptedException e) {
            DCDebugTracer.trace(e);
        }
    }

    public void removeListener(char cmdCode, TKNoticeReceiver noticeReceiver) {
        try {
            this.listenerTableMutex.acquire();
            Character keyObj = Character.valueOf(cmdCode);
            Object valObj = this.listenerTable.get(keyObj);
            if (valObj == null) {
                this.listenerTableMutex.release();
                return;
            }
            TKListenerVector listenerVector = (TKListenerVector)valObj;
            Enumeration e = listenerVector.elements();
            while (e.hasMoreElements()) {
                Object listenerObj = e.nextElement();
                if (listenerObj == null) continue;
                TKListener listener = (TKListener)listenerObj;
                if (listener.noticeReceiver == noticeReceiver) {
                    listenerVector.removeElement(listener);
                }
                if (!listenerVector.isEmpty()) continue;
                this.listenerTable.remove(keyObj);
            }
            this.listenerTableMutex.release();
        }
        catch (InterruptedException e) {
            DCDebugTracer.trace(e);
        }
    }

    public void removeListener(TKNoticeReceiver noticeReceiver) {
        try {
            this.listenerTableMutex.acquire();
            Enumeration keyEnum = this.listenerTable.keys();
            while (keyEnum.hasMoreElements()) {
                Object keyObj = keyEnum.nextElement();
                Object listenerObj = this.listenerTable.get(keyObj);
                TKListenerVector listenerVector = (TKListenerVector)listenerObj;
                Enumeration valEnum = listenerVector.elements();
                while (valEnum.hasMoreElements()) {
                    Object obj = valEnum.nextElement();
                    if (obj == null) continue;
                    TKListener valObj = (TKListener)obj;
                    if (valObj.noticeReceiver == noticeReceiver) {
                        listenerVector.removeElement(valObj);
                    }
                    if (!listenerVector.isEmpty()) continue;
                    this.listenerTable.remove(keyObj);
                }
            }
            this.listenerTableMutex.release();
        }
        catch (InterruptedException e) {
            DCDebugTracer.trace(e);
        }
    }

    public void removeListeners() {
        try {
            this.listenerTableMutex.acquire();
            this.listenerTable.clear();
            this.listenerTableMutex.release();
        }
        catch (InterruptedException e) {
            DCDebugTracer.trace(e);
        }
    }

    private void removeTask(TKTask task) {
        if (task instanceof TKCommand) {
            Vector timerIDVector = this.removeCommand((TKCommand)task);
            if (timerIDVector.size() > 0) {
                this.removeTimer(((TKCommand)timerIDVector.get((int)0)).timerID);
                timerIDVector.clear();
            }
        } else if (task instanceof TKListener) {
            this.removeListener((TKListener)task);
        }
    }

    public char getNextSequenceID() {
        try {
            this.currentSeqIDMutex.acquire();
            do {
                this.currentSequenceID = (char)(this.currentSequenceID + '\u0001');
                if (this.currentSequenceID != '\u0000') continue;
                this.currentSequenceID = (char)(this.currentSequenceID + '\u0001');
            } while (this.commandTable.containsKey(Character.valueOf(this.currentSequenceID)));
            this.currentSeqIDMutex.release();
            return this.currentSequenceID;
        }
        catch (InterruptedException e) {
            DCDebugTracer.trace(e);
            return '\u0000';
        }
    }

    public byte registerProcess() {
        if (this.getRegisterState() == 1 || this.getRegisterState() == 2) {
            return 1;
        }
        this.setRegisterState((byte)2);
        this.notifyRegisterState((byte)2);
        TKCommand command = new TKCommand();
        command.message.msgHead.cmdCode = (char)666;
        command.message.msgHead.msgType = (char)4;
        command.message.msgHead.contentLength = 0;
        if (TKCommUtility.isStartLocalServer) {
            command.message.msgHead.cmdCode = (char)555;
        }
        command.message.msgHead.connectID = this.connectID;
        TKLogManager.writeToDebug("Tskm set cnt ID:" + this.connectID);
        this.insertCommand(command);
        this.addTimer(command, 40);
        command.setTaskState((byte)2);
        TKLogManager.writeToDebug("Tskm rgst cmd:" + command.message.toString());
        TKCmdMSG data = this.sendMessageAndWait(command, true);
        if (data == null) {
            TKLogManager.writeToDebug("Tskm Rigester Fail\t" + command.message.toString());
            this.setRegisterState((byte)0);
            this.notifyRegisterState((byte)0);
            return 0;
        }
        if (data.msgHead.connectID < 0) {
            TKLogManager.writeToDebug("Tskm Rigester Fail:-1");
            this.setRegisterState((byte)0);
            this.notifyRegisterState((byte)0);
            return 0;
        }
        if (this.getRegisterState() == 1) {
            TKLogManager.writeToDebug("getRegisterState is REGISTERED! return");
            return 0;
        }
        this.connector.handShake(false);
        TKLogManager.writeToDebug("Tskm get cnt ID:" + data.msgHead.connectID);
        TKDebug.trace("TKTaskManager: REGISTERED ......");
        this.setRegisterState((byte)1);
        TKLogManager.writeToDebug("SetRegisterState -> registered");
        this.notifyRegisterState((byte)1);
        TKLogManager.ConnectID = this.connectID = data.msgHead.connectID;
        TKCmdMSGHeader header = data.msgHead;
        TKCommUtility.serverTime.set(header.year, header.month, header.day, header.hour, header.minute, header.second);
        TKCommUtility.notifyCommunication(true);
        return 1;
    }

    public int svc() {
        Thread.currentThread().setPriority(Thread.currentThread().getPriority() - 1);
        Thread.currentThread().setName(this.getThreadName());
        this.service();
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getThreadName() {
        Object object = this.thread_idMutex;
        synchronized (object) {
            return ((Object)((Object)this)).toString() + "-" + this.thread_id++;
        }
    }

    private void service() {
        while (true) {
            try {
                while (true) {
                    MessageBlock mb;
                    if ((mb = this.getq(null)) == null) {
                        continue;
                    }
                    TKCmdMSG message = (TKCmdMSG)mb.obj();
                    TKDebug.trace("TKTaskManager service : " + message.toString());
                    if (message.msgHead.msgType == '\u0005') {
                        if (this.thrCount() > 1) {
                            this.ungetq(mb, null);
                        }
                        return;
                    }
                    this.dispatchMessage(message);
                }
            }
            catch (InterruptedException e) {
                DCDebugTracer.trace(e);
                continue;
            }
            catch (Exception e) {
                DCDebugTracer.trace(e);
                continue;
            }
            break;
        }
    }

    private void dispatchMessage(TKCmdMSG messageBlock) {
        if (messageBlock.msgHead.msgType == '\u0003' || messageBlock.msgHead.msgType == 'd') {
            TKDebug.trace("TKTaskManager dispatchMessage : " + messageBlock.toString());
            this.dispatchListener(messageBlock);
        } else {
            TKDebug.trace("TKTaskManager dispatchMessage Command: " + messageBlock.toString());
            TKCommand command = this.matchCommandBySequenceID(messageBlock.msgHead.sequence);
            if (command == null) {
                return;
            }
            switch (command.getTaskState()) {
                case 0: {
                    break;
                }
                case 1: {
                    this.dispatchRequest(command, messageBlock);
                    break;
                }
                case 2: {
                    this.dispatchCommand(command, messageBlock);
                    break;
                }
                case 3: {
                    this.dispatchCommandAndCheck(command, messageBlock);
                    break;
                }
                case 4: {
                    break;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dispatchCommand(TKCommand command, TKCmdMSG message) {
        this.threadInTask(command);
        TKCommand tKCommand = command;
        synchronized (tKCommand) {
            command.messageInSignal = true;
            command.setData(message);
            TKDebug.trace("TKTaskManager dispatchCommand: " + message.toString());
            command.setTaskState((byte)4);
            command.notifyAll();
        }
        this.preThreadOutTask(command);
        this.threadOutTask(command);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dispatchCommandAndCheck(TKCommand command, TKCmdMSG message) {
        boolean dataValid = false;
        TKCmdMSG data = message;
        this.threadInTask(command);
        try {
            TKDebug.trace("TKTaskManager dispatchCommandAndCheck: " + message.toString());
            dataValid = command.checkData(data);
        }
        catch (Exception e) {
            command.setTaskState((byte)4);
            DCDebugTracer.trace(e);
        }
        try {
            this.preThreadOutTask(command);
            if (dataValid) {
                if (command.referenceCount == 0) {
                    TKCommand e = command;
                    synchronized (e) {
                        command.messageInSignal = true;
                        command.notifyAll();
                    }
                } else {
                    command.setTaskState((byte)4);
                }
            } else if (command.getTaskState() == 4 && command.referenceCount == 0) {
                TKCommand e = command;
                synchronized (e) {
                    command.messageInSignal = true;
                    command.setData(null);
                    command.notifyAll();
                }
            }
            this.threadOutTask(command);
        }
        catch (Exception e) {
            DCDebugTracer.trace(e);
        }
    }

    private void dispatchRequest(TKCommand command, TKCmdMSG message) {
        int ret = -1;
        TKCmdMSG data = message;
        this.threadInTask(command);
        try {
            ret = command.handleResponse(data);
        }
        catch (Exception e) {
            DCDebugTracer.trace(e);
        }
        try {
            Vector timerIDVector = new Vector();
            this.preThreadOutTask(command);
            if (ret == -1 || command.getTaskState() == 4) {
                if (command.referenceCount == 0) {
                    timerIDVector = this.removeCommand(command);
                } else {
                    command.setTaskState((byte)4);
                }
            }
            this.threadOutTask(command);
            if (timerIDVector.size() > 0) {
                this.removeTimer(((TKCommand)timerIDVector.get((int)0)).timerID);
                timerIDVector.clear();
            }
        }
        catch (Exception e) {
            DCDebugTracer.trace(e);
        }
    }

    private void ftpServerHint(final TKCmdMSG message) {
        try {
            new Thread(){

                @Override
                public void run() {
                    AsnTkMessageRpt rptEvt = new AsnTkMessageRpt();
                    boolean result = TKCommUtility.getASNData(message, (FStruct)rptEvt);
                    if (!result) {
                        TKDebug.inmAssert(false, "ftpServerHint method decode error.");
                        return;
                    }
                    Iterator errorItr = rptEvt.msgList.iterator();
                    TKOperResultVector resultV = new TKOperResultVector();
                    while (errorItr.hasNext()) {
                        AsnToolkitError error = (AsnToolkitError)errorItr.next();
                        String operObj = TKTaskManager.this.res.getString("FTP Server");
                        String operResult = TKTaskManager.this.res.getString("Error_Report");
                        String operReason = TKRes.getErrorInfo(error);
                        TKOperResultStruct struct = new TKOperResultStruct(operObj, operResult, operReason);
                        resultV.addElement(struct);
                    }
                    if (resultV.size() > 0) {
                        final TKOperResultVector resultVector = resultV;
                        try {
                            for (int j = 0; j < 20; ++j) {
                                Thread.sleep(500L);
                                JFrame frame = TKResourceManager.getMainFrame();
                                if (null == frame) {
                                    continue;
                                }
                                break;
                            }
                        }
                        catch (Exception ex) {
                            DCDebugTracer.trace(ex);
                        }
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                TKOperationShowMgr.showOperationDlg((Component)TKResourceManager.getMainFrame(), TKTaskManager.this.res.getString("Error_Report"), resultVector);
                            }
                        });
                    }
                }
            }.start();
        }
        catch (Exception ex) {
            DCDebugTracer.trace(ex);
        }
    }

    private void dispatchListener(TKCmdMSG message) {
        TKListenerVector listeners;
        if (message.msgHead.cmdCode == '\u1603') {
            this.ftpServerHint(message);
        }
        if ((listeners = this.matchListenerByCmdCode(message.msgHead.cmdCode)) == null) {
            return;
        }
        Enumeration e = listeners.elements();
        while (e.hasMoreElements()) {
            Object obj = e.nextElement();
            if (obj == null) continue;
            TKListener listener = (TKListener)obj;
            TKCmdMSG data = message;
            this.threadInTask(listener);
            int ret = -1;
            try {
                TKDebug.trace("TKTaskManager dispatchListener : " + message.toString());
                ret = listener.handleNotice(message.msgHead.cmdCode, data);
            }
            catch (Exception exception) {
                DCDebugTracer.trace(exception);
            }
            try {
                this.preThreadOutTask(listener);
                if (ret == -1 || listener.getTaskState() == 4) {
                    if (listener.referenceCount == 0) {
                        this.removeListener(message.msgHead.cmdCode, listener);
                    } else {
                        listener.setTaskState((byte)4);
                    }
                }
                this.threadOutTask(listener);
            }
            catch (Exception exception) {
                DCDebugTracer.trace(exception);
            }
        }
    }

    public void sendMessage(TKCommand command) {
        this.sendMessage(command, false);
    }

    public void sendMessage(TKCommand command, boolean urgent) {
        try {
            MessageBlock mb = new MessageBlock((Object)command.message);
            if (urgent) {
                this.connector.putHead(mb, null);
            } else {
                this.connector.put(mb, null);
            }
        }
        catch (Exception e) {
            DCDebugTracer.trace(e);
        }
    }

    public TKCmdMSG sendMessageAndWait(TKCommand command) {
        return this.sendMessageAndWait(command, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TKCmdMSG sendMessageAndWait(TKCommand command, boolean urgent) {
        try {
            TKLogManager.writeToDebug(command.message.toString());
            this.sendMessage(command, urgent);
            TKCommand tKCommand = command;
            synchronized (tKCommand) {
                while (!command.messageInSignal) {
                    command.wait();
                }
            }
        }
        catch (InterruptedException e) {
            DCDebugTracer.trace(e);
            return null;
        }
        Vector timerIDVector = this.removeCommand(command);
        if (timerIDVector.size() > 0) {
            this.removeTimer(((TKCommand)timerIDVector.get((int)0)).timerID);
            timerIDVector.clear();
        }
        return command.getData();
    }

    public TKCommand matchCommandBySequenceID(char sequenceID) {
        try {
            this.commandTableMutex.acquire();
            Object obj = this.commandTable.get(Character.valueOf(sequenceID));
            this.commandTableMutex.release();
            if (obj == null) {
                return null;
            }
            return (TKCommand)obj;
        }
        catch (InterruptedException e) {
            DCDebugTracer.trace(e);
            return null;
        }
    }

    public TKListenerVector matchListenerByCmdCode(char cmdCode) {
        try {
            this.listenerTableMutex.acquire();
            Object obj = this.listenerTable.get(Character.valueOf(cmdCode));
            this.listenerTableMutex.release();
            if (obj == null) {
                return null;
            }
            return (TKListenerVector)obj;
        }
        catch (InterruptedException e) {
            DCDebugTracer.trace(e);
            return null;
        }
    }

    private void threadInTask(TKTask task) {
        try {
            task.mutexSetMutex.acquire();
            this.attatchMutexSet(task);
            task.referenceCountMutex.acquire();
            task.referenceCount = (byte)(task.referenceCount + 1);
            task.referenceCountMutex.release();
            task.mutexSetMutex.release();
        }
        catch (InterruptedException e) {
            DCDebugTracer.trace(e);
        }
    }

    private void preThreadOutTask(TKTask task) {
        try {
            task.mutexSetMutex.acquire();
            task.referenceCountMutex.acquire();
            task.taskStateMutex.acquire();
            task.referenceCount = (byte)(task.referenceCount - 1);
        }
        catch (InterruptedException e) {
            DCDebugTracer.trace(e);
        }
    }

    private void threadOutTask(TKTask task) {
        try {
            if (task.referenceCount < 0) {
                task.referenceCount = 0;
            }
            if (task.referenceCount == 0) {
                Mutex tmpRefMutex = task.referenceCountMutex;
                Mutex tmpTaskMutex = task.taskStateMutex;
                this.detatchMutexSet(task);
                tmpRefMutex.release();
                tmpTaskMutex.release();
            } else {
                task.referenceCountMutex.release();
                task.taskStateMutex.release();
            }
            task.mutexSetMutex.release();
        }
        catch (Exception e) {
            DCDebugTracer.trace(e);
        }
    }

    private void attatchMutexSet(TKTask task) {
        try {
            if (task.isMutexAttatched == 0) {
                task.mutexSet = this.getMutexSet();
                task.isMutexAttatched = 1;
                task.taskStateMutex = task.mutexSet.taskStateMutex;
                task.referenceCountMutex = task.mutexSet.referenceCountMutex;
                task.timerIDMutex = task.mutexSet.timerIDMutex;
            }
        }
        catch (Exception e) {
            DCDebugTracer.trace(e);
        }
    }

    private void detatchMutexSet(TKTask task) {
        try {
            if (task.isMutexAttatched == 1) {
                this.insertMutexSet(task.mutexSet);
                task.isMutexAttatched = 0;
                task.mutexSet = null;
                task.taskStateMutex = null;
                task.referenceCountMutex = null;
                task.timerIDMutex = null;
            }
        }
        catch (Exception e) {
            DCDebugTracer.trace(e);
        }
    }

    private TKMutexSet getMutexSet() {
        try {
            this.mutexSetPoolMutex.acquire();
            if (this.mutexSetPool.isEmpty()) {
                this.mutexSetPoolMutex.release();
                return new TKMutexSet();
            }
            Object obj = this.mutexSetPool.firstElement();
            this.mutexSetPool.removeElement(obj);
            this.mutexSetPoolMutex.release();
            return (TKMutexSet)obj;
        }
        catch (InterruptedException e) {
            DCDebugTracer.trace(e);
            return new TKMutexSet();
        }
    }

    private void insertMutexSet(TKMutexSet mutexSet) {
        if (mutexSet == null) {
            return;
        }
        try {
            this.mutexSetPoolMutex.acquire();
            if (this.mutexSetPool.size() < this.threadNumber + 1) {
                this.mutexSetPool.addElement(mutexSet);
            }
            this.mutexSetPoolMutex.release();
        }
        catch (InterruptedException e) {
            DCDebugTracer.trace(e);
        }
    }

    public void addTimer(TKTask task, int timeout) {
        int timerID = this.timerQueue.scheduleTimer((EventHandler)this, (Object)task, new TimeValue((long)timeout), new TimeValue((long)timeout));
        task.setTimerID(timerID);
    }

    public void removeTimer(final int timerID) {
        try {
            new Thread(){

                @Override
                public void run() {
                    try {
                        TKTaskManager.this.timerQueue.cancelTimer(timerID);
                    }
                    catch (Exception ex) {
                        DCDebugTracer.trace(ex);
                    }
                }
            }.start();
        }
        catch (Exception ex) {
            DCDebugTracer.trace(ex);
        }
    }

    public int handleTimeout(TimeValue tv, Object obj) {
        if (!(obj instanceof TKTask)) {
            return 0;
        }
        TKTask task = (TKTask)obj;
        switch (task.getTaskState()) {
            case 0: {
                this.removeTask(task);
                break;
            }
            case 1: {
                this.handleAsyncTimeout(tv, task);
                break;
            }
            case 2: {
                this.handleSyncTimeout(tv, task);
                break;
            }
            case 3: {
                this.handleSyncCheckTimeout(tv, task);
                break;
            }
            case 4: {
                break;
            }
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleSyncTimeout(TimeValue tv, TKTask task) {
        TKCommand command;
        if (!(task instanceof TKCommand)) {
            return;
        }
        TKCommand tKCommand = command = (TKCommand)task;
        synchronized (tKCommand) {
            command.messageInSignal = true;
            command.setData(null);
            command.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleSyncCheckTimeout(TimeValue tv, TKTask task) {
        if (!(task instanceof TKCommand)) {
            return;
        }
        int ret = -1;
        TKCommand command = (TKCommand)task;
        this.threadInTask(command);
        try {
            ret = command.handleTimeout(tv, null);
        }
        catch (Exception e) {
            DCDebugTracer.trace(e);
        }
        try {
            this.preThreadOutTask(command);
            if (ret == -1 || command.getTaskState() == 4) {
                if (command.referenceCount == 0) {
                    TKCommand e = command;
                    synchronized (e) {
                        command.messageInSignal = true;
                        command.setData(null);
                        command.notifyAll();
                    }
                } else {
                    command.setTaskState((byte)4);
                }
            } else if (ret > 0) {
                this.removeTimer(task.timerID);
                this.addTimer(task, ret);
            }
            this.threadOutTask(command);
        }
        catch (Exception e) {
            DCDebugTracer.trace(e);
        }
    }

    private void handleAsyncTimeout(TimeValue tv, TKTask task) {
        if (!(task instanceof TKCommand)) {
            return;
        }
        int ret = -1;
        this.threadInTask(task);
        try {
            ret = task.handleTimeout(tv, null);
        }
        catch (Exception e) {
            DCDebugTracer.trace(e);
        }
        try {
            this.preThreadOutTask(task);
            if (ret == -1 || task.getTaskState() == 4) {
                if (task.referenceCount == 0) {
                    this.removeTask(task);
                } else {
                    task.setTaskState((byte)4);
                }
            } else if (ret > 0) {
                this.removeTimer(task.timerID);
                this.addTimer(task, ret);
            }
            this.threadOutTask(task);
        }
        catch (Exception e) {
            DCDebugTracer.trace(e);
        }
    }

    private void notifyRegisterState(byte state) {
        TKCmdMSG message = new TKCmdMSG();
        message.msgHead.msgType = (char)100;
        switch (state) {
            case 0: {
                message.msgHead.cmdCode = (char)4;
                break;
            }
            case 1: {
                message.msgHead.cmdCode = (char)5;
                break;
            }
            case 2: {
                message.msgHead.cmdCode = (char)6;
                break;
            }
        }
        try {
            MessageBlock mb = new MessageBlock((Object)message);
            this.putHead(mb, null);
        }
        catch (Exception e) {
            DCDebugTracer.trace(e);
        }
    }

    private void addShakeHandTimer() {
        int timeInterval = 10;
        class ShakeHand
        implements EventHandler {
            ShakeHand() {
            }

            public int handleTimeout(TimeValue tv, Object obj) {
                TKCommand command = new TKCommand();
                command.message.msgHead.cmdCode = '\u0000';
                command.message.msgHead.msgType = (char)6;
                command.message.msgHead.connectID = TKTaskManager.this.connectID;
                command.message.msgHead.contentLength = 0;
                TKTaskManager.this.sendMessage(command);
                TKTaskManager.this.connector.handShake(true);
                return 0;
            }
        }
        ShakeHand shakeHandInstance = new ShakeHand();
        this.shakeHandTimerID = this.getTimerQueue().scheduleTimer((EventHandler)shakeHandInstance, null, new TimeValue((long)timeInterval), new TimeValue((long)timeInterval));
    }

    private void removeShakeHandTimer() {
        try {
            new Thread(){

                @Override
                public void run() {
                    try {
                        TKTaskManager.this.getTimerQueue().cancelTimer(TKTaskManager.this.shakeHandTimerID);
                    }
                    catch (Exception ex) {
                        DCDebugTracer.trace(ex);
                    }
                }
            }.start();
        }
        catch (Exception ex) {
            DCDebugTracer.trace(ex);
        }
    }

    public void autoStartMark() {
        TKCommand command = new TKCommand();
        command.message.msgHead.cmdCode = '\u0000';
        command.message.msgHead.msgType = (char)6;
        command.message.msgHead.connectID = this.connectID;
        command.message.msgHead.contentLength = 0;
        this.sendMessage(command);
    }
}

