/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.toolkit.client.base.communicate;

import JACE.ASX.MessageBlock;
import JACE.ASX.TimeValue;
import JACE.Concurrency.Mutex;
import JACE.Connection.Connector;
import JACE.Connection.SvcHandler;
import JACE.OS.ACE;
import JACE.Reactor.EventHandler;
import JACE.Reactor.TimerQueue;
import JACE.SOCK_SAP.SOCKStream;
import com.huawei.dc.common.util.DCDebugTracer;
import com.huawei.dc.toolkit.client.base.communicate.SSLSOCKConnector;
import com.huawei.dc.toolkit.client.base.communicate.TKCmdMSG;
import com.huawei.dc.toolkit.client.base.communicate.TKCmdMSGHeader;
import com.huawei.dc.toolkit.client.base.communicate.TKCommConstant;
import com.huawei.dc.toolkit.client.base.communicate.TKCommUtility;
import com.huawei.dc.toolkit.client.base.communicate.TKTaskManager;
import com.huawei.dc.toolkit.client.base.util.TKDebug;
import com.huawei.dc.toolkit.client.base.util.TKLogManager;
import com.huawei.dc.toolkit.client.base.util.TKProfileFactory;
import java.io.IOException;
import java.net.SocketException;

public class TKConnector
extends SvcHandler
implements TKCommConstant {
    public String hostIP;
    public int hostPort;
    private int handShakes;
    private Object handShakesMutex;
    private boolean exitMark;
    private Object exitMarkMutex;
    private byte connectState;
    private Object connectStateMutex;
    private byte connectMark;
    private Object connectMarkMutex;
    private boolean ReadIOMark;
    private Object ReadIOMarkMutex;
    private boolean WriteIOMark;
    private Object WriteIOMarkMutex;
    private Mutex IOMarkMutex;
    private TimerQueue timerQueue;
    private int connectTimerID;
    private int reconnectTimerID = -1;
    private Synchronizor reConnectMutex;
    private Connector connector;
    private TKTaskManager taskManager;
    static final int DEFAULT_MSG_LENGTH = 65536;
    ConnectWatcher connectWatcherInstance = new ConnectWatcher();

    public TKConnector(String hostIP, int hostPort) {
        final String sslip = hostIP;
        final int sslport = hostPort;
        this.exitMark = false;
        this.connectState = 0;
        this.connectMark = 0;
        this.ReadIOMark = false;
        this.WriteIOMark = false;
        this.exitMarkMutex = new Object();
        this.connectStateMutex = new Object();
        this.connectMarkMutex = new Object();
        this.ReadIOMarkMutex = new Object();
        this.WriteIOMarkMutex = new Object();
        this.handShakesMutex = new Object();
        this.reConnectMutex = new Synchronizor("TKConnector");
        this.IOMarkMutex = new Mutex();
        this.timerQueue = new TimerQueue(true);
        this.connector = TKCommUtility.SSL_COMM ? new Connector(hostIP, hostPort){

            protected int connectSvcHandler(SvcHandler sh) throws SocketException, IOException {
                SOCKStream sockStream = new SOCKStream();
                int port = sslport;
                String hostname = sslip;
                new SSLSOCKConnector(sockStream, hostname, port);
                ACE.DEBUG((String)("Connected to " + sockStream.socket().getInetAddress()));
                sh.setHandle(sockStream);
                return 0;
            }
        } : (TKProfileFactory.getBaseCfgString("option", "UseSSL").equals("true") ? (!TKCommUtility.SSL_COMM ? new Connector(hostIP, hostPort) : new Connector(hostIP, hostPort){

            protected int connectSvcHandler(SvcHandler sh) throws SocketException, IOException {
                SOCKStream sockStream = new SOCKStream();
                int port = sslport;
                String hostname = sslip;
                new SSLSOCKConnector(sockStream, hostname, port);
                ACE.DEBUG((String)("Connected to " + sockStream.socket().getInetAddress()));
                sh.setHandle(sockStream);
                return 0;
            }
        }) : new Connector(hostIP, hostPort));
        this.msgQueue().highWaterMark(1024000);
    }

    public void reset(String hostIP, int hostPort) {
        this.hostIP = hostIP;
        this.hostPort = hostPort;
        try {
            while (!this.msgQueue().isEmpty()) {
                this.msgQueue().dequeueHead();
            }
        }
        catch (InterruptedException e) {
            DCDebugTracer.trace(e);
        }
    }

    public void setTaskManager(TKTaskManager taskManager) {
        this.taskManager = taskManager;
    }

    public TKTaskManager getTaskManager() {
        return this.taskManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte getConnectState() {
        Object object = this.connectStateMutex;
        synchronized (object) {
            return this.connectState;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getHandShake() {
        Object object = this.handShakesMutex;
        synchronized (object) {
            return this.handShakes;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handShake(boolean add) {
        Object object = this.handShakesMutex;
        synchronized (object) {
            if (add) {
                ++this.handShakes;
                if (this.handShakes > 36000) {
                    new Thread("HandShake"){

                        @Override
                        public void run() {
                            Exception connException = new Exception("HandShake time out: " + TKConnector.this.handShakes);
                            DCDebugTracer.trace(connException);
                            TKLogManager.writeToDebug("cnn close:HandShake time out: " + TKConnector.this.handShakes);
                            TKConnector.this.ExceptionHandle(connException);
                        }
                    }.start();
                    this.handShakes = 0;
                }
            } else {
                this.handShakes = 0;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setConnectState(byte state) {
        Object object = this.connectStateMutex;
        synchronized (object) {
            this.connectState = state;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte getConnectMark() {
        Object object = this.connectMarkMutex;
        synchronized (object) {
            return this.connectMark;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setConnectMark(byte mark) {
        Object object = this.connectMarkMutex;
        synchronized (object) {
            this.connectMark = mark;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean getWriteIOMark() {
        Object object = this.WriteIOMarkMutex;
        synchronized (object) {
            return this.WriteIOMark;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setWriteIOMark(boolean IOMark) {
        Object object = this.WriteIOMarkMutex;
        synchronized (object) {
            this.WriteIOMark = IOMark;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean getReadIOMark() {
        Object object = this.ReadIOMarkMutex;
        synchronized (object) {
            return this.ReadIOMark;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setReadIOMark(boolean IOMark) {
        Object object = this.ReadIOMarkMutex;
        synchronized (object) {
            this.ReadIOMark = IOMark;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean getExitMark() {
        Object object = this.exitMarkMutex;
        synchronized (object) {
            return this.exitMark;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setExitMark(boolean bExitMark) {
        Object object = this.exitMarkMutex;
        synchronized (object) {
            this.exitMark = bExitMark;
        }
    }

    public int put(MessageBlock mb, TimeValue tv) {
        try {
            this.putq(mb, tv);
        }
        catch (InterruptedException e) {
            DCDebugTracer.trace(e);
            return 0;
        }
        return 1;
    }

    public int putHead(MessageBlock mb, TimeValue tv) {
        try {
            this.msgQueue().enqueueHead(mb, tv);
        }
        catch (InterruptedException e) {
            DCDebugTracer.trace(e);
            return 0;
        }
        return 1;
    }

    synchronized boolean connect() {
        if (this.getConnectState() == 1) {
            TKLogManager.writeToDebug("Cntr ok, ntf (" + this.reConnectMutex + ")");
            this.notifyConnectState((byte)1);
            return true;
        }
        TKLogManager.writeToDebug("Cntr.cnt:" + this.hostIP + " pt:" + this.hostPort + "(" + this.reConnectMutex + ")");
        this.connector.open(this.hostIP, this.hostPort);
        this.setExitMark(false);
        this.setConnectState((byte)2);
        this.notifyConnectState((byte)2);
        try {
            TKLogManager.writeToFile("To create connect");
            this.connector.connect((SvcHandler)this);
            TKLogManager.writeToFile("To create connectted!");
            this.setConnectState((byte)1);
            this.notifyConnectState((byte)1);
            TKLogManager.writeToDebug("Cntr ok (" + this.reConnectMutex + ")");
            return true;
        }
        catch (Exception e) {
            DCDebugTracer.trace(e);
            TKLogManager.writeToDebug("Cntr Failed!(" + this.reConnectMutex + ")");
            this.setConnectState((byte)0);
            this.notifyConnectState((byte)0);
            return false;
        }
    }

    public void close() {
        if (this.stream_ != null) {
            try {
                this.stream_.socket().close();
            }
            catch (IOException e) {
                DCDebugTracer.trace(e);
            }
            try {
                this.stream_.close();
            }
            catch (IOException e) {
                DCDebugTracer.trace(e);
            }
        }
    }

    public int open(Object obj) {
        this.activate(256L, 3 - this.thrCount() > 2 ? 2 : 3 - this.thrCount(), true);
        return 0;
    }

    public int close(long flags) {
        this.removeReConnectTimer();
        this.setExitMark(true);
        if (this.getWriteIOMark()) {
            this.sendCloseMessage();
        }
        if (flags == 1L) {
            this.addReConnectTimer();
        }
        return 0;
    }

    public void sendCloseMessage() {
        TKCmdMSG mg = new TKCmdMSG();
        mg.msgHead.connectID = this.taskManager.getConnectID();
        mg.msgHead.msgType = (char)5;
        mg.msgHead.contentLength = 0;
        MessageBlock mb = new MessageBlock((Object)mg);
        try {
            this.msgQueue().enqueueHead(mb, null);
        }
        catch (InterruptedException e) {
            DCDebugTracer.trace(e);
        }
    }

    public int svc() {
        try {
            this.IOMarkMutex.acquire();
            if (!this.getReadIOMark()) {
                Thread.currentThread().setName(((Object)((Object)this.taskManager)).toString() + "-Iutput");
                this.handleInput();
            } else if (!this.getWriteIOMark()) {
                Thread.currentThread().setName(((Object)((Object)this.taskManager)).toString() + "-Output");
                this.handleOutput();
            } else {
                this.IOMarkMutex.release();
            }
        }
        catch (InterruptedException e) {
            DCDebugTracer.trace(e);
        }
        return 0;
    }

    private byte[] handleInputByLength(int length) throws IOException {
        if (length < 1) {
            return null;
        }
        byte[] buf = new byte[length];
        int expectLength = length;
        int receivedLength = 0;
        int actualLength = 0;
        do {
            actualLength = this.stream_.recvN(buf, receivedLength, expectLength);
            this.setConnectMark((byte)1);
            receivedLength += actualLength;
        } while (actualLength < (expectLength -= actualLength));
        return buf;
    }

    void handleInput() {
        this.setReadIOMark(true);
        this.IOMarkMutex.release();
        byte[] messageBuffer = new byte[65536];
        try {
            while (true) {
                byte[] header = this.handleInputByLength(24);
                TKCmdMSGHeader messageHeader = new TKCmdMSGHeader();
                messageHeader.fromByte(header);
                StringBuffer sb = new StringBuffer();
                sb.append("msgHead cID(");
                sb.append(messageHeader.connectID);
                sb.append(") cC(");
                sb.append((int)messageHeader.cmdCode);
                sb.append(")");
                TKLogManager.writeToDebug("Cntr recv:" + sb);
                this.handShake(false);
                if (messageHeader.contentLength > 65512) {
                    messageBuffer = new byte[messageHeader.contentLength + 24];
                }
                TKLogManager.writeToDebug("Cntr recv:" + sb + "messageHeader.contentLength = " + messageHeader.contentLength);
                System.arraycopy(header, 0, messageBuffer, 0, 24);
                if (messageHeader.contentLength > 0) {
                    byte[] content = this.handleInputByLength(messageHeader.contentLength);
                    System.arraycopy(content, 0, messageBuffer, 24, messageHeader.contentLength);
                }
                TKCmdMSG msg = new TKCmdMSG();
                msg.fromByte(messageBuffer);
                MessageBlock mb = new MessageBlock((Object)msg);
                this.taskManager.put(mb, null);
            }
        }
        catch (Exception e) {
            TKLogManager.writeToDebug("Cntr: receive failed with exception");
            DCDebugTracer.trace(e);
            this.setReadIOMark(false);
            this.ExceptionHandle(e);
            return;
        }
    }

    void handleOutput() {
        this.setWriteIOMark(true);
        this.IOMarkMutex.release();
        while (true) {
            MessageBlock mb;
            try {
                mb = this.getq(null);
            }
            catch (InterruptedException e) {
                DCDebugTracer.trace(e);
                continue;
            }
            if (mb == null) continue;
            TKCmdMSG msgObj = (TKCmdMSG)mb.obj();
            try {
                byte[] data = msgObj.toByte();
                int MaxBlockLength = 512;
                byte[] dataEve = new byte[MaxBlockLength];
                int nMsgDataLen = msgObj.toByte().length;
                TKLogManager.writeToFile("msgObj.toByte().length: " + msgObj.toByte().length);
                int blockNumber = nMsgDataLen / MaxBlockLength;
                int lastBlockLength = nMsgDataLen % MaxBlockLength;
                if (lastBlockLength > 0) {
                    ++blockNumber;
                } else {
                    lastBlockLength = MaxBlockLength;
                }
                TKLogManager.writeToFile("blockNumber :" + blockNumber);
                for (int i = 0; i < blockNumber; ++i) {
                    int length = dataEve.length;
                    if (i >= blockNumber - 1) {
                        length = lastBlockLength;
                    }
                    System.arraycopy(data, MaxBlockLength * i, dataEve, 0, length);
                    this.stream_.sendN(dataEve, 0, length);
                }
                TKLogManager.writeToFile("blockNumber :" + blockNumber + "send over");
                if (msgObj.msgHead.msgType == '\u0005') {
                    TKLogManager.writeToDebug("Cntr wc -" + this.getConnectState());
                    if (this.getConnectState() == 1) {
                        TKLogManager.writeToDebug("Cntr clsd.");
                        this.close();
                    }
                    this.setWriteIOMark(false);
                    return;
                }
                if (msgObj.msgHead.msgType != '\u0004') continue;
                TKLogManager.writeToDebug("Cntr rg - " + msgObj);
            }
            catch (IOException e) {
                TKLogManager.writeToDebug("Cntr: send failed with IOException");
                DCDebugTracer.trace(e);
                try {
                    this.ungetq(mb, null);
                }
                catch (InterruptedException exception) {
                    DCDebugTracer.trace(exception);
                }
                this.setWriteIOMark(false);
                this.ExceptionHandle(e);
                return;
            }
            catch (Exception e) {
                TKLogManager.writeToDebug("Cntr: send failed with exception");
                DCDebugTracer.trace(e);
                this.setWriteIOMark(false);
                this.ExceptionHandle(e);
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ExceptionHandle(Exception exception) {
        TKLogManager.writeToDebug(Thread.currentThread().getName() + " Cntr st:" + this.getConnectState());
        TKCommUtility.isStartLocalServer = false;
        if (this.getConnectState() == 1) {
            TKLogManager.writeToDebug(" ExceptionHandle synchronized ");
            Synchronizor synchronizor = this.reConnectMutex;
            synchronized (synchronizor) {
                TKLogManager.writeToDebug("Cntr excpt:" + exception.toString());
                this.reConnectMutex.setName("Exception");
                TKLogManager.writeToDebug("exc-setting 1:removeConnectTimer");
                this.removeConnectTimer();
                TKLogManager.writeToDebug("exc-setting 2:setConnectState");
                this.setConnectState((byte)0);
                TKLogManager.writeToDebug("exc-setting 3:notify");
                this.notifyConnectState((byte)0);
                TKLogManager.writeToDebug("exc-setting 4:getExitMark");
                if (this.getExitMark()) {
                    return;
                }
                TKLogManager.writeToDebug("TClt re-cnt excpt.");
                TKLogManager.writeToDebug("exc-setting 5:cls");
                this.close();
                TKLogManager.writeToDebug("exc-setting 6: OK");
                TKCommUtility.notifyCommunication(false);
            }
        }
    }

    void addReConnectTimer() {
        if (this.reconnectTimerID == -1) {
            class ReConnectWatcher
            implements EventHandler {
                ReConnectWatcher() {
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public int handleTimeout(TimeValue tv, Object obj) {
                    Synchronizor synchronizor = TKConnector.this.reConnectMutex;
                    synchronized (synchronizor) {
                        TKConnector.this.reConnectMutex.setName("ReConnectWatcher");
                        if (TKConnector.this.taskManager.getRegisterState() != 1 || TKConnector.this.getConnectState() == 0) {
                            TKLogManager.writeToDebug("ReCnt........");
                            TKConnector.this.connect();
                        }
                    }
                    return 0;
                }
            }
            ReConnectWatcher reconnectWatcherInstance = new ReConnectWatcher();
            this.reconnectTimerID = this.timerQueue.scheduleTimer((EventHandler)reconnectWatcherInstance, null, new TimeValue(10L), new TimeValue(10L));
        }
    }

    void removeReConnectTimer() {
        try {
            new Thread(){

                @Override
                public void run() {
                    if (TKConnector.this.reconnectTimerID != -1) {
                        TKLogManager.writeToDebug(" timerQueue removeReConnectTimer  1 ");
                        TKConnector.this.timerQueue.cancelTimer(TKConnector.this.reconnectTimerID);
                        TKLogManager.writeToDebug(" timerQueue removeReConnectTimer  2 ");
                        TKConnector.this.reconnectTimerID = -1;
                    }
                }
            }.start();
        }
        catch (Exception ex) {
            DCDebugTracer.trace(ex);
        }
    }

    private void notifyConnectState(byte state) {
        TKCmdMSG message = new TKCmdMSG();
        message.msgHead.msgType = (char)3;
        switch (state) {
            case 0: {
                TKDebug.trace("TKConnector:notify UNCONNECT....");
                message.msgHead.cmdCode = '\u0001';
                break;
            }
            case 1: {
                TKDebug.trace("TKConnector:notify CONNECTED....");
                message.msgHead.cmdCode = (char)2;
                break;
            }
            case 2: {
                TKDebug.trace("TKConnector:notify CONNECTING....");
                message.msgHead.cmdCode = (char)3;
                break;
            }
        }
        try {
            MessageBlock mb = new MessageBlock((Object)message);
            this.taskManager.putHead(mb, null);
        }
        catch (Exception e) {
            DCDebugTracer.trace(e);
        }
    }

    void addConnectTimer() {
        TKLogManager.writeToDebug(" timerQueue addConnectTimer 1 ");
        this.connectTimerID = this.timerQueue.scheduleTimer((EventHandler)this.connectWatcherInstance, null, new TimeValue(540L), new TimeValue(540L));
        TKLogManager.writeToDebug(" timerQueue addConnectTimer  2 ");
    }

    void removeConnectTimer() {
        try {
            new Thread(){

                @Override
                public void run() {
                    try {
                        TKLogManager.writeToDebug(" timerQueue removeConnectTimer  1 ");
                        TKConnector.this.timerQueue.cancelTimer((EventHandler)TKConnector.this.connectWatcherInstance);
                        TKLogManager.writeToDebug(" timerQueue removeConnectTimer  2 ");
                    }
                    catch (Exception ex) {
                        TKLogManager.writeToDebug(" timerQueue removeConnectTimer 3 " + ex);
                        DCDebugTracer.trace(ex);
                    }
                }
            }.start();
        }
        catch (Exception ex) {
            DCDebugTracer.trace(ex);
        }
    }

    @Override
    public void eludeFindBugs() {
    }

    class ConnectWatcher
    implements EventHandler {
        ConnectWatcher() {
        }

        public int handleTimeout(TimeValue tv, Object obj) {
            if (TKConnector.this.getConnectMark() == 1) {
                TKConnector.this.setConnectMark((byte)0);
                return 0;
            }
            if (TKConnector.this.getConnectState() == 1) {
                TKConnector.this.close();
            }
            return -1;
        }
    }

    class Synchronizor {
        String toString_ = "";

        public Synchronizor(String name) {
            this.toString_ = name;
        }

        public String toString() {
            return this.toString_;
        }

        public void setName(String name) {
            this.toString_ = name;
        }
    }
}

